const mix = require("laravel-mix");

/*
 |--------------------------------------------------------------------------
 | Mix Asset Management
 |--------------------------------------------------------------------------
 |
 | Mix provides a clean, fluent API for defining some Webpack build steps
 | for your Laravel applications. By default, we are compiling the CSS
 | file for the application as well as bundling up all the JS files.
 |
 */

// Compile JavaScript
mix.js("resources/js/app.js", "public/js")
   .js("resources/js/flight-booking.js", "public/js");

// Compile CSS (includes Tailwind CSS for local compilation)
mix.css("resources/css/app.css", "public/css")
   .css("resources/css/flight-booking.css", "public/css");

// Options for production optimization
mix.options({
    processCssUrls: false,
    postCss: [
        require('autoprefixer'),
    ]
});

// Enable versioning in production for cache busting
if (mix.inProduction()) {
    mix.version();
} else {
    // Enable source maps for development
    mix.sourceMaps();
}
