<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1">Manage Email Transactions</h1>
                </div>

                
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.bootstrap-alerts','data' => []]); ?>
<?php $component->withName('bootstrap-alerts'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                <!-- Statistics Cards -->
                <div class="row mb-4">
                    <div class="col-md-3 col-sm-6">
                        <div class="card card-stats card-round">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-icon">
                                        <div class="icon-big text-center icon-primary bubble-shadow-small">
                                            <i class="fas fa-envelope"></i>
                                        </div>
                                    </div>
                                    <div class="col col-stats ml-3 ml-sm-0">
                                        <div class="numbers">
                                            <p class="card-category">Total Emails</p>
                                            <h4 class="card-title"><?php echo e($stats['total']); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6">
                        <div class="card card-stats card-round">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-icon">
                                        <div class="icon-big text-center icon-success bubble-shadow-small">
                                            <i class="fas fa-check-circle"></i>
                                        </div>
                                    </div>
                                    <div class="col col-stats ml-3 ml-sm-0">
                                        <div class="numbers">
                                            <p class="card-category">Sent Successfully</p>
                                            <h4 class="card-title"><?php echo e($stats['sent']); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6">
                        <div class="card card-stats card-round">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-icon">
                                        <div class="icon-big text-center icon-warning bubble-shadow-small">
                                            <i class="fas fa-clock"></i>
                                        </div>
                                    </div>
                                    <div class="col col-stats ml-3 ml-sm-0">
                                        <div class="numbers">
                                            <p class="card-category">Pending</p>
                                            <h4 class="card-title"><?php echo e($stats['pending']); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6">
                        <div class="card card-stats card-round">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-icon">
                                        <div class="icon-big text-center icon-danger bubble-shadow-small">
                                            <i class="fas fa-times-circle"></i>
                                        </div>
                                    </div>
                                    <div class="col col-stats ml-3 ml-sm-0">
                                        <div class="numbers">
                                            <p class="card-category">Failed</p>
                                            <h4 class="card-title"><?php echo e($stats['failed']); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Main Content -->
                <div class="mb-5 row">
                    <div class="col card p-3 shadow">
                        <div class="bs-example widget-shadow table-responsive" data-example-id="hoverable-table">
                            <span style="margin:3px;">
                                <table id="EmailTransactionTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>User</th>
                                            <th>Exchange</th>
                                            <th>Recipient Email</th>
                                            <th>Amount</th>
                                            <th>Currency</th>
                                            <th>Status</th>
                                            <th>Date Created</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $emailTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <strong>#<?php echo e(str_pad($transaction->id, 6, '0', STR_PAD_LEFT)); ?></strong>
                                                    <br>
                                                    <small class="text-muted"><?php echo e($transaction->transaction_id); ?></small>
                                                </td>
                                                <td>
                                                    <strong><?php echo e($transaction->user->name); ?></strong>
                                                    <br>
                                                    <small class="text-muted"><?php echo e($transaction->user->email); ?></small>
                                                </td>
                                                <td>
                                                    <strong><?php echo e($transaction->exchange_name); ?></strong>
                                                    <?php if($transaction->template_used): ?>
                                                    <br>
                                                    <small class="text-muted"><?php echo e(ucwords(str_replace('-', ' ', $transaction->template_used))); ?></small>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($transaction->receiver_email); ?></td>
                                                <td>
                                                    <strong><?php echo e($settings->currency); ?><?php echo e(number_format($transaction->amount, 2)); ?></strong>
                                                    <?php if($transaction->transaction_fee > 0): ?>
                                                    <br>
                                                    <small class="text-muted">Fee: <?php echo e($settings->currency); ?><?php echo e(number_format($transaction->transaction_fee, 2)); ?></small>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <span class="badge badge-info"><?php echo e($transaction->coin_symbol); ?>/<?php echo e($transaction->currency); ?></span>
                                                </td>
                                                <td>
                                                    <?php if($transaction->status == 'sent'): ?>
                                                        <span class="badge badge-success">
                                                            <i class="fas fa-check"></i> Sent
                                                        </span>
                                                    <?php elseif($transaction->status == 'pending'): ?>
                                                        <span class="badge badge-warning">
                                                            <i class="fas fa-clock"></i> Pending
                                                        </span>
                                                    <?php else: ?>
                                                        <span class="badge badge-danger">
                                                            <i class="fas fa-times"></i> Failed
                                                        </span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php echo e(\Carbon\Carbon::parse($transaction->created_at)->toDayDateTimeString()); ?>

                                                    <?php if($transaction->sent_at): ?>
                                                    <br>
                                                    <small class="text-success">Sent: <?php echo e(\Carbon\Carbon::parse($transaction->sent_at)->format('M j, g:i A')); ?></small>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <div class="btn-group" role="group">
                                                        <a href="<?php echo e(route('admin.email-transaction.show', $transaction->id)); ?>"
                                                           class="btn btn-info btn-sm" title="View Details">
                                                            <i class="fa fa-eye"></i>
                                                        </a>

                                                        <?php if($transaction->status === 'failed' || $transaction->status === 'pending'): ?>
                                                        <form action="<?php echo e(route('admin.email-transaction.resend', $transaction->id)); ?>"
                                                              method="POST" style="display: inline;">
                                                            <?php echo csrf_field(); ?>
                                                            <button type="submit" class="btn btn-warning btn-sm"
                                                                    title="Resend Email"
                                                                    onclick="return confirm('Are you sure you want to resend this email?')">
                                                                <i class="fa fa-redo"></i>
                                                            </button>
                                                        </form>
                                                        <?php endif; ?>

                                                        <form action="<?php echo e(route('admin.email-transaction.destroy', $transaction->id)); ?>"
                                                              method="POST" style="display: inline;">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                            <button type="submit" class="btn btn-danger btn-sm"
                                                                    title="Delete Transaction"
                                                                    onclick="return confirm('Are you sure you want to delete this email transaction?')">
                                                                <i class="fa fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </span>
                        </div>

                        <!-- Pagination -->
                        <?php if($emailTransactions->hasPages()): ?>
                        <div class="mt-3 d-flex justify-content-center">
                            <?php echo e($emailTransactions->links()); ?>

                        </div>
                        <?php endif; ?>

                        <?php if($emailTransactions->count() == 0): ?>
                        <div class="text-center py-5">
                            <i class="fas fa-envelope fa-3x text-muted mb-3"></i>
                            <h4 class="text-muted">No Email Transactions Found</h4>
                            <p class="text-muted">No users have sent any flash emails yet.</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- DataTables Script -->
    <script>
        $(document).ready(function() {
            $('#EmailTransactionTable').DataTable({
                "pageLength": 25,
                "order": [[ 7, "desc" ]],
                "columnDefs": [
                    { "orderable": false, "targets": 8 }
                ]
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\flight\resources\views/admin/EmailTransactions/email-transactions.blade.php ENDPATH**/ ?>