

<?php $__env->startSection('title', 'Flight Results - ' . config('app.name')); ?>

<?php $__env->startSection('content'); ?>
<!-- Search Summary -->
<section class="bg-primary-600 text-white py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex flex-wrap items-center justify-between">
            <div class="flex items-center space-x-6 text-lg">
                <div class="flex items-center">
                    <i class="fas fa-plane-departure mr-2"></i>
                    <span class="font-semibold"><?php echo e($searchParams['origin']); ?></span>
                </div>
                <i class="fas fa-arrow-right"></i>
                <div class="flex items-center">
                    <i class="fas fa-plane-arrival mr-2"></i>
                    <span class="font-semibold"><?php echo e($searchParams['destination']); ?></span>
                </div>
                <div class="flex items-center">
                    <i class="fas fa-calendar-alt mr-2"></i>
                    <span><?php echo e(\Carbon\Carbon::parse($searchParams['departure_date'])->format('M d, Y')); ?></span>
                </div>
                <div class="flex items-center">
                    <i class="fas fa-users mr-2"></i>
                    <span><?php echo e($searchParams['passengers']); ?> <?php echo e($searchParams['passengers'] == 1 ? 'Passenger' : 'Passengers'); ?></span>
                </div>
            </div>
            <a href="<?php echo e(route('flights.search')); ?>" class="bg-primary-700 hover:bg-primary-800 text-white px-4 py-2 rounded-lg transition-colors">
                <i class="fas fa-edit mr-1"></i> Modify Search
            </a>
        </div>
    </div>
</section>

<!-- Results Section -->
<section class="py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex flex-col lg:flex-row gap-8">
            <!-- Filters Sidebar -->
            <div class="lg:w-1/4">
                <div class="bg-white rounded-xl shadow-lg p-6 sticky top-24" x-data="flightFilters()">
                    <h3 class="text-lg font-semibold text-slate-800 mb-6">
                        <i class="fas fa-filter mr-2"></i> Filters
                    </h3>

                    <!-- Price Range -->
                    <div class="mb-6">
                        <h4 class="font-medium text-slate-700 mb-3">Price Range</h4>
                        <div class="space-y-2">
                            <input type="range" 
                                   x-model="priceRange" 
                                   min="0" 
                                   max="<?php echo e($maxPrice); ?>" 
                                   class="w-full h-2 bg-slate-200 rounded-lg appearance-none cursor-pointer">
                            <div class="flex justify-between text-sm text-slate-600">
                                <span>$0</span>
                                <span x-text="'$' + priceRange"></span>
                            </div>
                        </div>
                    </div>

                    <!-- Departure Time -->
                    <div class="mb-6">
                        <h4 class="font-medium text-slate-700 mb-3">Departure Time</h4>
                        <div class="space-y-2">
                            <label class="flex items-center space-x-2">
                                <input type="checkbox" x-model="timeFilters" value="morning" class="text-primary-600">
                                <span class="text-sm">Morning (6AM - 12PM)</span>
                            </label>
                            <label class="flex items-center space-x-2">
                                <input type="checkbox" x-model="timeFilters" value="afternoon" class="text-primary-600">
                                <span class="text-sm">Afternoon (12PM - 6PM)</span>
                            </label>
                            <label class="flex items-center space-x-2">
                                <input type="checkbox" x-model="timeFilters" value="evening" class="text-primary-600">
                                <span class="text-sm">Evening (6PM - 12AM)</span>
                            </label>
                            <label class="flex items-center space-x-2">
                                <input type="checkbox" x-model="timeFilters" value="night" class="text-primary-600">
                                <span class="text-sm">Night (12AM - 6AM)</span>
                            </label>
                        </div>
                    </div>

                    <!-- Stops -->
                    <div class="mb-6">
                        <h4 class="font-medium text-slate-700 mb-3">Stops</h4>
                        <div class="space-y-2">
                            <label class="flex items-center space-x-2">
                                <input type="radio" name="stops" x-model="stopsFilter" value="any" class="text-primary-600">
                                <span class="text-sm">Any number of stops</span>
                            </label>
                            <label class="flex items-center space-x-2">
                                <input type="radio" name="stops" x-model="stopsFilter" value="direct" class="text-primary-600">
                                <span class="text-sm">Direct flights only</span>
                            </label>
                        </div>
                    </div>

                    <!-- Airlines -->
                    <div class="mb-6">
                        <h4 class="font-medium text-slate-700 mb-3">Airlines</h4>
                        <div class="space-y-2">
                            <?php $__currentLoopData = $airlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $airline): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label class="flex items-center space-x-2">
                                <input type="checkbox" x-model="airlineFilters" value="<?php echo e($airline); ?>" class="text-primary-600">
                                <span class="text-sm"><?php echo e($airline); ?></span>
                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <button @click="applyFilters()" class="w-full bg-primary-600 hover:bg-primary-700 text-white py-2 rounded-lg transition-colors">
                        Apply Filters
                    </button>
                </div>
            </div>

            <!-- Flight Results -->
            <div class="lg:w-3/4">
                <!-- Sorting -->
                <div class="bg-white rounded-xl shadow-sm p-4 mb-6">
                    <div class="flex flex-wrap items-center justify-between gap-4">
                        <div class="text-slate-600">
                            <span class="font-medium"><?php echo e($flights->total()); ?></span> flights found
                        </div>
                        <div class="flex items-center space-x-4">
                            <span class="text-sm text-slate-600">Sort by:</span>
                            <select onchange="window.location.href=this.value" class="border border-slate-300 rounded-lg px-3 py-1 text-sm">
                                <option value="<?php echo e(request()->fullUrlWithQuery(['sort' => 'price'])); ?>" 
                                        <?php echo e(request('sort') === 'price' ? 'selected' : ''); ?>>Price (Low to High)</option>
                                <option value="<?php echo e(request()->fullUrlWithQuery(['sort' => 'departure'])); ?>" 
                                        <?php echo e(request('sort') === 'departure' ? 'selected' : ''); ?>>Departure Time</option>
                                <option value="<?php echo e(request()->fullUrlWithQuery(['sort' => 'duration'])); ?>" 
                                        <?php echo e(request('sort') === 'duration' ? 'selected' : ''); ?>>Duration</option>
                                <option value="<?php echo e(request()->fullUrlWithQuery(['sort' => 'airline'])); ?>" 
                                        <?php echo e(request('sort') === 'airline' ? 'selected' : ''); ?>>Airline</option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Flight Cards -->
                <div class="space-y-4">
                    <?php $__empty_1 = true; $__currentLoopData = $flights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="bg-white rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden" 
                         x-data="{ showDetails: false }">
                        <div class="p-6">
                            <div class="grid grid-cols-1 lg:grid-cols-4 gap-4 items-center">
                                <!-- Flight Info -->
                                <div class="lg:col-span-2">
                                    <div class="flex items-center justify-between mb-4">
                                        <div class="flex items-center space-x-4">
                                            <?php if($flight->airline_logo): ?>
                                                <div class="w-12 h-12 rounded-full overflow-hidden bg-white border border-slate-200 flex items-center justify-center p-1">
                                                    <img src="<?php echo e(asset('storage/app/public/' . $flight->airline_logo)); ?>" alt="<?php echo e($flight->airline); ?>" class="w-full h-full object-contain">
                                                </div>
                                            <?php else: ?>
                                                <div class="w-12 h-12 bg-primary-100 rounded-full flex items-center justify-center">
                                                    <i class="fas fa-plane text-primary-600"></i>
                                                </div>
                                            <?php endif; ?>
                                            <div>
                                                <p class="font-semibold text-slate-800"><?php echo e($flight->airline); ?></p>
                                                <p class="text-sm text-slate-500"><?php echo e($flight->flight_number); ?></p>
                                            </div>
                                        </div>
                                        <div class="text-right">
                                            <span class="px-3 py-1 bg-emerald-100 text-emerald-700 rounded-full text-sm font-medium">
                                                <?php echo e($flight->available_seats); ?> seats left
                                            </span>
                                        </div>
                                    </div>

                                    <div class="grid grid-cols-3 gap-4 items-center">
                                        <!-- Departure -->
                                        <div class="text-center">
                                            <p class="text-2xl font-bold text-slate-800">
                                                <?php echo e($flight->departure_time->format('H:i')); ?>

                                            </p>
                                            <p class="text-sm text-slate-500"><?php echo e($flight->originAirport->iata_code); ?></p>
                                            <p class="text-xs text-slate-400"><?php echo e($flight->originAirport->city); ?></p>
                                        </div>

                                        <!-- Duration & Route -->
                                        <div class="text-center">
                                            <div class="flex items-center justify-center mb-1">
                                                <div class="flex-1 h-px bg-slate-300"></div>
                                                <i class="fas fa-plane text-slate-400 mx-2"></i>
                                                <div class="flex-1 h-px bg-slate-300"></div>
                                            </div>
                                            <p class="text-sm font-medium text-slate-600">
                                                <?php echo e($flight->duration); ?>

                                            </p>
                                            <p class="text-xs text-slate-400">Direct</p>
                                        </div>

                                        <!-- Arrival -->
                                        <div class="text-center">
                                            <p class="text-2xl font-bold text-slate-800">
                                                <?php echo e($flight->arrival_time->format('H:i')); ?>

                                            </p>
                                            <p class="text-sm text-slate-500"><?php echo e($flight->destinationAirport->iata_code); ?></p>
                                            <p class="text-xs text-slate-400"><?php echo e($flight->destinationAirport->city); ?></p>
                                        </div>
                                    </div>
                                </div>

                                <!-- Price & Booking -->
                                <div class="lg:col-span-2 text-center lg:text-right">
                                    <div class="flex flex-col items-center lg:items-end space-y-4">
                                        <div>
                                            <p class="text-3xl font-bold text-primary-600"><?php echo e($settings->currency); ?><?php echo e(number_format($flight->price, 0)); ?></p>
                                            <p class="text-sm text-slate-500">per person</p>
                                        </div>
                                        
                                        <div class="flex flex-col sm:flex-row gap-2">
                                            <button @click="showDetails = !showDetails" 
                                                    class="px-4 py-2 border border-slate-300 text-slate-600 rounded-lg hover:bg-slate-50 transition-colors">
                                                <span x-text="showDetails ? 'Hide Details' : 'View Details'"></span>
                                                <i class="fas fa-chevron-down ml-1" :class="{ 'rotate-180': showDetails }"></i>
                                            </button>
                                            
                                            <?php if($flight->available_seats > 0): ?>
                                            <a href="<?php echo e(route('flights.booking', $flight)); ?>" 
                                               class="px-6 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-lg transition-colors font-medium">
                                                <i class="fas fa-shopping-cart mr-1"></i> Book Now
                                            </a>
                                            <?php else: ?>
                                            <button disabled class="px-6 py-2 bg-slate-300 text-slate-500 rounded-lg cursor-not-allowed">
                                                Fully Booked
                                            </button>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Flight Details -->
                            <div x-show="showDetails" x-transition class="mt-6 pt-6 border-t border-slate-200">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <h4 class="font-semibold text-slate-800 mb-3">Flight Details</h4>
                                        <div class="space-y-2 text-sm">
                                            <div class="flex justify-between">
                                                <span class="text-slate-500">Aircraft:</span>
                                                <span class="text-slate-700"><?php echo e($flight->aircraft_type ?? 'Boeing 737'); ?></span>
                                            </div>
                                            <div class="flex justify-between">
                                                <span class="text-slate-500">Flight Duration:</span>
                                                <span class="text-slate-700"><?php echo e($flight->duration); ?></span>
                                            </div>
                                            <div class="flex justify-between">
                                                <span class="text-slate-500">Distance:</span>
                                                <span class="text-slate-700"><?php echo e(number_format($flight->distance ?? 1200)); ?> km</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div>
                                        <h4 class="font-semibold text-slate-800 mb-3">Baggage Policy</h4>
                                        <div class="space-y-2 text-sm">
                                            <div class="flex justify-between">
                                                <span class="text-slate-500">Carry-on:</span>
                                                <span class="text-slate-700">1 x 8kg included</span>
                                            </div>
                                            <div class="flex justify-between">
                                                <span class="text-slate-500">Checked baggage:</span>
                                                <span class="text-slate-700">1 x 20kg included</span>
                                            </div>
                                            <div class="flex justify-between">
                                                <span class="text-slate-500">Extra baggage:</span>
                                                <span class="text-slate-700">$25 per additional bag</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="bg-white rounded-xl shadow-lg p-12 text-center">
                        <i class="fas fa-plane-slash text-6xl text-slate-300 mb-4"></i>
                        <h3 class="text-xl font-semibold text-slate-700 mb-2">No flights found</h3>
                        <p class="text-slate-500 mb-6">Try adjusting your search criteria or selecting different dates.</p>
                        <a href="<?php echo e(route('flights.search')); ?>" class="bg-primary-600 hover:bg-primary-700 text-white px-6 py-2 rounded-lg transition-colors">
                            <i class="fas fa-search mr-1"></i> New Search
                        </a>
                    </div>
                    <?php endif; ?>
                </div>

                <!-- Pagination -->
                <?php if($flights->hasPages()): ?>
                <div class="mt-8">
                    <?php echo e($flights->appends(request()->query())->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function flightFilters() {
    return {
        priceRange: <?php echo e($maxPrice ?? 1000); ?>,
        timeFilters: [],
        stopsFilter: 'any',
        airlineFilters: [],
        
        applyFilters() {
            const params = new URLSearchParams(window.location.search);
            
            // Update price filter
            params.set('max_price', this.priceRange);
            
            // Update time filters
            if (this.timeFilters.length > 0) {
                params.set('times', this.timeFilters.join(','));
            } else {
                params.delete('times');
            }
            
            // Update stops filter
            if (this.stopsFilter !== 'any') {
                params.set('stops', this.stopsFilter);
            } else {
                params.delete('stops');
            }
            
            // Update airline filters
            if (this.airlineFilters.length > 0) {
                params.set('airlines', this.airlineFilters.join(','));
            } else {
                params.delete('airlines');
            }
            
            // Redirect with new filters
            window.location.href = window.location.pathname + '?' + params.toString();
        }
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.flight', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\flight\resources\views/user/flights/results.blade.php ENDPATH**/ ?>