<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('themes/softui/assets/img/apple-icon.png')); ?>">
  <link rel="icon" type="image/png" href="<?php echo e(asset('themes/softui/assets/img/favicon.png')); ?>">
  <title><?php echo e($settings->site_name); ?> - Flight Booking & Travel</title>

  <!-- Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>

  <!-- Alpine.js -->
  <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>

  <!-- Custom Styles -->
  <style>
    :root {
      /* Flight-Themed Professional Blue Color System */
      --primary-50: #eff6ff;
      --primary-100: #dbeafe;
      --primary-200: #bfdbfe;
      --primary-300: #93c5fd;
      --primary-400: #60a5fa;
      --primary-500: #3b82f6;
      --primary-600: #2563eb;
      --primary-700: #1d4ed8;
      --primary-800: #1e40af;
      --primary-900: #1e3a8a;
      --primary-950: #172554;

      /* Sky Blue Accents for Flight Theme */
      --sky-50: #f0f9ff;
      --sky-100: #e0f2fe;
      --sky-200: #bae6fd;
      --sky-300: #7dd3fc;
      --sky-400: #38bdf8;
      --sky-500: #0ea5e9;
      --sky-600: #0284c7;
      --sky-700: #0369a1;
      --sky-800: #075985;
      --sky-900: #0c4a6e;

      /* Neutral Grays */
      --gray-50: #f9fafb;
      --gray-100: #f3f4f6;
      --gray-200: #e5e7eb;
      --gray-300: #d1d5db;
      --gray-400: #9ca3af;
      --gray-500: #6b7280;
      --gray-600: #4b5563;
      --gray-700: #374151;
      --gray-800: #1f2937;
      --gray-900: #111827;
      --gray-950: #030712;

      /* Status Colors */
      --success: #10b981;
      --warning: #f59e0b;
      --error: #ef4444;
      --info: #3b82f6;
    }

    .font-inter { font-family: 'Inter', sans-serif; }

    .sidebar-gradient {
      background: linear-gradient(180deg, #1e40af 0%, #1e3a8a 50%, #172554 100%);
    }

    .glass-effect {
      backdrop-filter: blur(16px) saturate(180%);
      background: rgba(255, 255, 255, 0.75);
      border: 1px solid rgba(255, 255, 255, 0.3);
    }

    .nav-item-active {
      background: linear-gradient(90deg, rgba(59, 130, 246, 0.15) 0%, rgba(59, 130, 246, 0.05) 100%);
      border-left: 4px solid #3b82f6;
      font-weight: 600;
    }

    .nav-item-hover:hover {
      background: rgba(255, 255, 255, 0.08);
      transform: translateX(4px);
    }

    .card-shadow {
      box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    }

    .card-shadow-lg {
      box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    }

    .animate-fade-in {
      animation: fadeIn 0.5s ease-in-out;
    }

    @keyframes  fadeIn {
      from { opacity: 0; transform: translateY(10px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .flight-pattern {
      background-image: 
        linear-gradient(135deg, rgba(59, 130, 246, 0.03) 25%, transparent 25%),
        linear-gradient(225deg, rgba(59, 130, 246, 0.03) 25%, transparent 25%),
        linear-gradient(45deg, rgba(59, 130, 246, 0.03) 25%, transparent 25%),
        linear-gradient(315deg, rgba(59, 130, 246, 0.03) 25%, transparent 25%);
      background-position: 10px 0, 10px 0, 0 0, 0 0;
      background-size: 20px 20px;
      background-repeat: repeat;
    }

    /* Smooth transitions */
    * {
      transition: background-color 0.2s ease, transform 0.2s ease, box-shadow 0.2s ease;
    }

    /* Scrollbar styling */
    ::-webkit-scrollbar {
      width: 8px;
    }

    ::-webkit-scrollbar-track {
      background: var(--gray-100);
    }

    ::-webkit-scrollbar-thumb {
      background: var(--primary-400);
      border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb:hover {
      background: var(--primary-600);
    }
  </style>

  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: {
            primary: {
              50: '#eff6ff',
              100: '#dbeafe',
              200: '#bfdbfe',
              300: '#93c5fd',
              400: '#60a5fa',
              500: '#3b82f6',
              600: '#2563eb',
              700: '#1d4ed8',
              800: '#1e40af',
              900: '#1e3a8a',
              950: '#172554'
            },
            sky: {
              50: '#f0f9ff',
              100: '#e0f2fe',
              200: '#bae6fd',
              300: '#7dd3fc',
              400: '#38bdf8',
              500: '#0ea5e9',
              600: '#0284c7',
              700: '#0369a1',
              800: '#075985',
              900: '#0c4a6e'
            }
          },
          fontFamily: {
            'inter': ['Inter', 'sans-serif'],
          },
          animation: {
            'fade-in': 'fadeIn 0.5s ease-in-out',
            'slide-in': 'slideIn 0.3s ease-out',
          },
          keyframes: {
            fadeIn: {
              '0%': { opacity: '0', transform: 'translateY(10px)' },
              '100%': { opacity: '1', transform: 'translateY(0)' },
            },
            slideIn: {
              '0%': { transform: 'translateX(-100%)' },
              '100%': { transform: 'translateX(0)' },
            }
          }
        }
      }
    }
  </script>
</head>

<body class="font-inter bg-gradient-to-br from-gray-50 via-blue-50/30 to-gray-50 antialiased min-h-screen" x-data="{ sidebarOpen: false, userDropdownOpen: false }">
  
  <!-- Mobile Sidebar Overlay -->
  <div 
    x-show="sidebarOpen" 
    @click="sidebarOpen = false"
    x-transition:enter="transition-opacity ease-linear duration-300"
    x-transition:enter-start="opacity-0"
    x-transition:enter-end="opacity-100"
    x-transition:leave="transition-opacity ease-linear duration-300"
    x-transition:leave-start="opacity-100"
    x-transition:leave-end="opacity-0"
    class="fixed inset-0 bg-gray-900 bg-opacity-75 z-40 lg:hidden"
    x-cloak
  ></div>

  <!-- Sidebar -->
  <aside
    class="fixed inset-y-0 left-0 z-50 w-64 sidebar-gradient transform transition-transform duration-300 ease-in-out lg:translate-x-0"
    :class="{ '-translate-x-full': !sidebarOpen, 'translate-x-0': sidebarOpen }"
    x-cloak
  >
    <!-- Logo Section -->
    <div class="flex items-center justify-between px-6 py-6 border-b border-white/10">
      <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center space-x-3 group">
        <div class="w-12 h-12 bg-white/10 rounded-xl flex items-center justify-center group-hover:bg-white/20 transition-all">
          <i class="fas fa-plane-departure text-2xl text-white"></i>
        </div>
        <div>
          <h1 class="text-white font-bold text-xl tracking-tight"><?php echo e($settings->site_name); ?></h1>
          <p class="text-blue-200 text-xs font-medium">Your Travel Companion</p>
        </div>
      </a>
      <!-- Mobile close button -->
      <button
        @click="sidebarOpen = false"
        class="lg:hidden text-white/70 hover:text-white transition-colors p-2 rounded-lg hover:bg-white/10"
      >
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
        </svg>
      </button>
    </div>

    <!-- Navigation -->
    <nav class="mt-8 px-4 pb-8 overflow-y-auto">
      <div class="space-y-1">

        <!-- Dashboard -->
        <a href="<?php echo e(route('dashboard')); ?>"
           class="flex items-center px-4 py-3 text-white/90 rounded-xl nav-item-hover transition-all duration-200 group <?php echo e(request()->routeIs('dashboard') ? 'nav-item-active' : ''); ?>">
          <div class="flex-shrink-0 w-5 h-5 mr-3">
            <i class="fas fa-home text-lg"></i>
          </div>
          <span class="font-medium">Dashboard</span>
        </a>

        <!-- Search Flights -->
        <a href="<?php echo e(route('flights.search')); ?>"
           class="flex items-center px-4 py-3 text-white/90 rounded-xl nav-item-hover transition-all duration-200 group <?php echo e(request()->routeIs('flights.search') || request()->routeIs('flights.results') ? 'nav-item-active' : ''); ?>">
          <div class="flex-shrink-0 w-5 h-5 mr-3">
            <i class="fas fa-plane-departure text-lg"></i>
          </div>
          <span class="font-medium">Search Flights</span>
        </a>

        <!-- My Bookings -->
        <a href="<?php echo e(route('my.bookings')); ?>"
           class="flex items-center px-4 py-3 text-white/90 rounded-xl nav-item-hover transition-all duration-200 group <?php echo e(request()->routeIs('my.bookings') || request()->routeIs('booking.details') ? 'nav-item-active' : ''); ?>">
          <div class="flex-shrink-0 w-5 h-5 mr-3">
            <i class="fas fa-ticket-alt text-lg"></i>
          </div>
          <span class="font-medium">My Bookings</span>
          <?php if(isset($email_stats) && $email_stats['upcoming'] > 0): ?>
            <span class="ml-auto px-2 py-0.5 text-xs font-bold text-blue-800 bg-blue-200 rounded-full"><?php echo e($email_stats['upcoming']); ?></span>
          <?php endif; ?>
        </a>

        <!-- Wallet / Account Balance -->
        

        

        <!-- Transaction History (removed email-specific ones) -->
        

        <!-- Settings Section -->
        <div class="pt-4 pb-2">
          <p class="px-4 text-xs font-semibold text-blue-200 uppercase tracking-wider">Settings</p>
        </div>

        <!-- Profile -->
        <a href="<?php echo e(route('profile')); ?>"
           class="flex items-center px-4 py-3 text-white/90 rounded-xl nav-item-hover transition-all duration-200 group <?php echo e(request()->routeIs('profile') ? 'nav-item-active' : ''); ?>">
          <div class="flex-shrink-0 w-5 h-5 mr-3">
            <i class="fas fa-user-circle text-lg"></i>
          </div>
          <span class="font-medium">Profile Settings</span>
        </a>

      </div>

      <!-- Account Balance Card -->
      

      <!-- Support Section -->
      <div class="mt-6 mx-2">
        <div class="bg-white/5 rounded-2xl p-5 border border-white/10 hover:bg-white/10 transition-all">
          <div class="flex items-center justify-center w-12 h-12 bg-gradient-to-br from-emerald-400 to-emerald-500 rounded-xl mb-4 mx-auto shadow-lg">
            <i class="fas fa-headset text-white text-xl"></i>
          </div>
          <h3 class="text-white font-semibold text-center mb-2">Need Help?</h3>
          <p class="text-blue-200 text-sm text-center mb-4">Our support team is here 24/7</p>
          <a href="<?php echo e(route('support')); ?>" class="block w-full bg-white text-primary-700 font-semibold py-2.5 px-4 rounded-lg text-center hover:bg-blue-50 transition-all shadow-md hover:shadow-lg text-sm">
            <i class="fas fa-comment-dots mr-2"></i>Contact Support
          </a>
        </div>
      </div>

    </nav>
  </aside>

  <!-- Main Content -->
  <div class="lg:ml-64">

    <!-- Top Navigation -->
    <header class="bg-white/95 backdrop-blur-md border-b border-gray-200/80 sticky top-0 z-30 shadow-sm">
      <div class="flex items-center justify-between px-6 py-4">

        <!-- Mobile Menu Button -->
        <button
          @click="sidebarOpen = true"
          class="lg:hidden p-2.5 rounded-xl text-gray-600 hover:text-gray-900 hover:bg-gray-100 transition-all"
        >
          <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
          </svg>
        </button>

        <!-- Breadcrumb -->
        <div class="hidden lg:block">
          <nav class="flex items-center space-x-2" aria-label="Breadcrumb">
            <a href="<?php echo e(route('dashboard')); ?>" class="text-gray-500 hover:text-primary-600 transition-colors">
              <i class="fas fa-home text-lg"></i>
            </a>
            <svg class="w-4 h-4 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" />
            </svg>
            <span class="text-gray-700 font-semibold"><?php echo e($title ?? 'Dashboard'); ?></span>
          </nav>
        </div>

        <!-- Right Side -->
        <div class="flex items-center space-x-4">

          <!-- Quick Actions - Desktop Only -->
          <div class="hidden md:flex items-center space-x-2">
            <a href="<?php echo e(route('flights.search')); ?>" 
               class="inline-flex items-center px-4 py-2 bg-primary-600 text-white rounded-xl hover:bg-primary-700 transition-all shadow-sm hover:shadow-md font-medium text-sm">
              <i class="fas fa-search mr-2"></i>
              <span>Search Flights</span>
            </a>
          </div>

          <!-- Notifications -->
          <div class="relative" x-data="{ open: false }">
            <button @click="open = !open" class="relative p-2.5 rounded-xl text-gray-600 hover:text-gray-900 hover:bg-gray-100 transition-all">
              <i class="fas fa-bell text-xl"></i>
              <?php if(isset($email_stats) && $email_stats['upcoming'] > 0): ?>
                <span class="absolute top-1 right-1 w-2 h-2 bg-red-500 rounded-full ring-2 ring-white"></span>
              <?php endif; ?>
            </button>
            
            <!-- Notification Dropdown -->
            <div x-show="open" @click.away="open = false" 
                 x-transition:enter="transition ease-out duration-200"
                 x-transition:enter-start="opacity-0 scale-95"
                 x-transition:enter-end="opacity-100 scale-100"
                 x-transition:leave="transition ease-in duration-75"
                 x-transition:leave-start="opacity-100 scale-100"
                 x-transition:leave-end="opacity-0 scale-95"
                 class="absolute right-0 mt-2 w-80 rounded-2xl shadow-xl bg-white ring-1 ring-black ring-opacity-5 z-50">
              <div class="p-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Notifications</h3>
              </div>
              <div class="p-4 text-center text-gray-500 text-sm">
                <?php if(isset($email_stats) && $email_stats['upcoming'] > 0): ?>
                  <p>You have <?php echo e($email_stats['upcoming']); ?> upcoming flight<?php echo e($email_stats['upcoming'] > 1 ? 's' : ''); ?></p>
                  <a href="<?php echo e(route('my.bookings')); ?>" class="text-primary-600 hover:text-primary-700 font-medium mt-2 inline-block">View Bookings</a>
                <?php else: ?>
                  <p>No new notifications</p>
                <?php endif; ?>
              </div>
            </div>
          </div>

          <!-- User Dropdown -->
          <div class="relative" x-data="{ open: false }">
            <button
              @click="open = !open"
              class="flex items-center space-x-3 p-2 rounded-xl text-gray-700 hover:bg-gray-100 transition-all"
            >
              <div class="w-10 h-10 bg-gradient-to-br from-primary-500 to-primary-600 rounded-xl flex items-center justify-center shadow-md">
                <span class="text-white font-bold text-sm"><?php echo e(strtoupper(substr(Auth::user()->name, 0, 1))); ?></span>
              </div>
              <div class="hidden md:block text-left">
                <p class="text-sm font-semibold text-gray-900"><?php echo e(Auth::user()->name); ?></p>
                <p class="text-xs text-gray-500"><?php echo e(Auth::user()->email); ?></p>
              </div>
              <i class="fas fa-chevron-down text-sm text-gray-400"></i>
            </button>

            <!-- Dropdown Menu -->
            <div
              x-show="open"
              @click.away="open = false"
              x-transition:enter="transition ease-out duration-200"
              x-transition:enter-start="opacity-0 scale-95"
              x-transition:enter-end="opacity-100 scale-100"
              x-transition:leave="transition ease-in duration-75"
              x-transition:leave-start="opacity-100 scale-100"
              x-transition:leave-end="opacity-0 scale-95"
              class="absolute right-0 mt-2 w-64 rounded-2xl shadow-xl bg-white ring-1 ring-black ring-opacity-5 focus:outline-none z-50"
            >
              <div class="p-4 border-b border-gray-100">
                <p class="text-sm font-semibold text-gray-900"><?php echo e(Auth::user()->name); ?></p>
                <p class="text-xs text-gray-500 mt-1"><?php echo e(Auth::user()->email); ?></p>
              </div>
              <div class="py-2">
                <a href="<?php echo e(route('profile')); ?>" class="flex items-center px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 transition-colors">
                  <i class="fas fa-user-circle w-5 mr-3 text-gray-400"></i>
                  Profile Settings
                </a>
                <a href="<?php echo e(route('my.bookings')); ?>" class="flex items-center px-4 py-3 text-sm text-gray-700 hover:bg-gray-50 transition-colors">
                  <i class="fas fa-ticket-alt w-5 mr-3 text-gray-400"></i>
                  My Bookings
                </a>
                
                <div class="border-t border-gray-100 my-2"></div>
                <a href="<?php echo e(route('logout')); ?>"
                   onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                   class="flex items-center px-4 py-3 text-sm text-red-600 hover:bg-red-50 transition-colors rounded-b-2xl">
                  <i class="fas fa-sign-out-alt w-5 mr-3"></i>
                  Sign Out
                </a>
                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="hidden">
                  <?php echo csrf_field(); ?>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </header>

    <!-- Main Content Area -->
    <main class="p-4 md:p-6 lg:p-8 min-h-screen flight-pattern">
      <div class="max-w-7xl mx-auto animate-fade-in">
        <?php echo $__env->yieldContent('content'); ?>
      </div>
    </main>

    <!-- Footer -->
    <footer class="bg-white border-t border-gray-200 mt-12">
      <div class="px-6 py-8">
        <div class="flex flex-col md:flex-row justify-between items-center space-y-4 md:space-y-0">
          <div class="text-center md:text-left">
            <p class="text-gray-600 text-sm flex items-center justify-center md:justify-start">
              © <span id="current-year"></span> <?php echo e($settings->site_name); ?>. 
              <span class="mx-2">•</span>
              <span class="flex items-center">
                <i class="fas fa-plane text-primary-600 mr-2"></i>
                Your trusted travel partner
              </span>
            </p>
          </div>
          <div class="flex items-center space-x-6">
            <a href="<?php echo e(route('support')); ?>" class="text-gray-500 hover:text-primary-600 transition-colors text-sm font-medium flex items-center">
              <i class="fas fa-headset mr-2"></i>
              Support
            </a>
            <a href="#" class="text-gray-500 hover:text-primary-600 transition-colors text-sm font-medium flex items-center">
              <i class="fas fa-shield-alt mr-2"></i>
              Privacy
            </a>
            <a href="#" class="text-gray-500 hover:text-primary-600 transition-colors text-sm font-medium flex items-center">
              <i class="fas fa-file-contract mr-2"></i>
              Terms
            </a>
          </div>
        </div>
      </div>
    </footer>

  </div>

  <!-- Scripts -->
  <script>
    // Set current year
    document.getElementById('current-year').textContent = new Date().getFullYear();

    // Mobile sidebar overlay
    document.addEventListener('alpine:init', () => {
      Alpine.data('sidebar', () => ({
        open: false
      }))
    })
  </script>
 <?php echo $__env->make('layouts.livechat', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>

<?php /**PATH C:\xampp\htdocs\flight\resources\views/layouts/softui.blade.php ENDPATH**/ ?>