<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-panel">
        <div class="content ">
            <div class="panel-header bg-<?php echo e($gradient); ?>-gradient">
                <div class="py-5 page-inner">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div>
                            <h2 class="pb-2 text-white fw-bold">Flight Management</h2>
                            <h5 class="mb-2 text-white op-7">Manage flights, schedules, and tracking</h5>
                        </div>
                        <div class="py-2 ml-md-auto py-md-0">
                            <a href="<?php echo e(route('admin.flights.create')); ?>" class="mr-2 btn btn-success btn-border">
                                <i class="fas fa-plus"></i> Add Flight
                            </a>
                            <a href="<?php echo e(route('admin.airports.index')); ?>" class="btn btn-info btn-border">
                                <i class="fas fa-map-marker-alt"></i> Airports
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="page-inner mt--5">
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> <?php echo e(session('success')); ?>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                
                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> <?php echo e(session('error')); ?>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Validation Error!</strong> Please check the form for errors.
                        <ul class="mb-0 mt-2">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
            </div>
            
            <div class="page-inner mt--5">
                <!-- Flight Filters -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-filter"></i> Filter Flights
                                </h4>
                            </div>
                            <div class="card-body">
                                <form method="GET" action="<?php echo e(route('admin.flights.index')); ?>">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Status</label>
                                                <select name="status" class="form-control">
                                                    <option value="">All Statuses</option>
                                                    <option value="scheduled" <?php echo e(request('status') == 'scheduled' ? 'selected' : ''); ?>>Scheduled</option>
                                                    <option value="boarding" <?php echo e(request('status') == 'boarding' ? 'selected' : ''); ?>>Boarding</option>
                                                    <option value="departed" <?php echo e(request('status') == 'departed' ? 'selected' : ''); ?>>Departed</option>
                                                    <option value="airborne" <?php echo e(request('status') == 'airborne' ? 'selected' : ''); ?>>Airborne</option>
                                                    <option value="delayed" <?php echo e(request('status') == 'delayed' ? 'selected' : ''); ?>>Delayed</option>
                                                    <option value="landed" <?php echo e(request('status') == 'landed' ? 'selected' : ''); ?>>Landed</option>
                                                    <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>From Date</label>
                                                <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>To Date</label>
                                                <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Search</label>
                                                <input type="text" name="search" class="form-control" placeholder="Flight number or airline" value="<?php echo e(request('search')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-search"></i> Filter
                                            </button>
                                            <a href="<?php echo e(route('admin.flights.index')); ?>" class="btn btn-secondary">
                                                <i class="fas fa-times"></i> Clear
                                            </a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Flights Table -->
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-plane"></i> Flights 
                                    <span class="badge badge-primary"><?php echo e($flights->total()); ?></span>
                                </h4>
                            </div>
                            <div class="card-body">
                                <?php if($flights->count() > 0): ?>
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Flight</th>
                                                    <th>Route</th>
                                                    <th>Departure</th>
                                                    <th>Arrival</th>
                                                    <th>Status</th>
                                                    <th>Gate</th>
                                                    <th>Seats</th>
                                                    <th>Price</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $flights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td>
                                                            <strong><?php echo e($flight->airline); ?></strong><br>
                                                            <small class="text-muted"><?php echo e($flight->flight_number); ?></small>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo e($flight->originAirport->iata_code); ?></strong> 
                                                            <i class="fas fa-arrow-right text-muted"></i> 
                                                            <strong><?php echo e($flight->destinationAirport->iata_code); ?></strong><br>
                                                            <small class="text-muted">
                                                                <?php echo e($flight->originAirport->city); ?> → <?php echo e($flight->destinationAirport->city); ?>

                                                            </small>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo e($flight->departure_time->format('H:i')); ?></strong><br>
                                                            <small class="text-muted"><?php echo e($flight->departure_time->format('M j')); ?></small>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo e($flight->arrival_time->format('H:i')); ?></strong><br>
                                                            <small class="text-muted"><?php echo e($flight->arrival_time->format('M j')); ?></small>
                                                        </td>
                                                        <td>
                                                            <span class="badge badge-<?php echo e($flight->status == 'scheduled' ? 'primary' : ($flight->status == 'boarding' ? 'warning' : ($flight->status == 'departed' || $flight->status == 'airborne' ? 'success' : ($flight->status == 'delayed' ? 'info' : ($flight->status == 'landed' ? 'secondary' : 'danger'))))); ?>">
                                                                <?php echo e(ucfirst($flight->status)); ?>

                                                            </span>
                                                        </td>
                                                        <td>
                                                            <?php if($flight->terminal || $flight->gate): ?>
                                                                <small>
                                                                    <?php if($flight->terminal): ?>
                                                                        T<?php echo e($flight->terminal); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($flight->gate): ?>
                                                                        <br>Gate <?php echo e($flight->gate); ?>

                                                                    <?php endif; ?>
                                                                </small>
                                                            <?php else: ?>
                                                                <span class="text-muted">TBA</span>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo e($flight->seats_available); ?></strong> / <?php echo e($flight->seats_total); ?><br>
                                                            <small class="text-muted">
                                                                <?php echo e(round(($flight->seats_total - $flight->seats_available) / $flight->seats_total * 100)); ?>% booked
                                                            </small>
                                                        </td>
                                                        <td>
                                                            <strong>$<?php echo e(number_format($flight->price, 2)); ?></strong>
                                                        </td>
                                                        <td>
                                                            <div class="btn-group">
                                                                <a href="<?php echo e(route('admin.flights.show', $flight)); ?>" class="btn btn-sm btn-info" title="View">
                                                                    <i class="fas fa-eye"></i>
                                                                </a>
                                                                <a href="<?php echo e(route('admin.flights.edit', $flight)); ?>" class="btn btn-sm btn-warning" title="Edit">
                                                                    <i class="fas fa-edit"></i>
                                                                </a>
                                                                <?php if(!$flight->bookings()->where('status', '!=', 'cancelled')->count()): ?>
                                                                    <form method="POST" action="<?php echo e(route('admin.flights.destroy', $flight)); ?>" style="display: inline;" onsubmit="return confirm('Are you sure?')">
                                                                        <?php echo csrf_field(); ?>
                                                                        <?php echo method_field('DELETE'); ?>
                                                                        <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                                                            <i class="fas fa-trash"></i>
                                                                        </button>
                                                                    </form>
                                                                <?php endif; ?>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>

                                    <!-- Pagination -->
                                    <div class="d-flex justify-content-center">
                                        <?php echo e($flights->links()); ?>

                                    </div>
                                <?php else: ?>
                                    <div class="text-center py-5">
                                        <i class="fas fa-plane-slash fa-3x text-muted mb-3"></i>
                                        <h4>No flights found</h4>
                                        <p class="text-muted">Start by adding your first flight.</p>
                                        <a href="<?php echo e(route('admin.flights.create')); ?>" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Add Flight
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        // Auto-refresh every 30 seconds for real-time updates
        setTimeout(function(){
            location.reload();
        }, 30000);
    </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\flight\resources\views/admin/flights/index.blade.php ENDPATH**/ ?>