



<?php if(Session::has('success')): ?>
<div class="alert alert-success alert-dismissible fade show mb-3" role="alert">
    <div class="d-flex align-items-center">
        <div class="mr-3">
            <i class="fas fa-check-circle fa-lg text-success"></i>
        </div>
        <div class="flex-grow-1">
            <strong>Success!</strong>
            <span class="ml-2"><?php echo e(Session::get('success')); ?></span>
        </div>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
</div>
<?php endif; ?>


<?php if(Session::has('error') || Session::has('message') || $errors->any()): ?>
<div class="alert alert-danger alert-dismissible fade show mb-3" role="alert">
    <div class="d-flex align-items-start">
        <div class="mr-3">
            <i class="fas fa-exclamation-triangle fa-lg text-danger"></i>
        </div>
        <div class="flex-grow-1">
            <strong>Error!</strong>
            <div class="mt-1">
                <?php if(Session::has('error')): ?>
                    <div><?php echo e(Session::get('error')); ?></div>
                <?php endif; ?>

                <?php if(Session::has('message')): ?>
                    <div><?php echo e(Session::get('message')); ?></div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <?php if($errors->count() > 1): ?>
                        <ul class="mb-0 mt-2">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php else: ?>
                        <div><?php echo e($errors->first()); ?></div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
</div>
<?php endif; ?>


<?php if(Session::has('warning')): ?>
<div class="alert alert-warning alert-dismissible fade show mb-3" role="alert">
    <div class="d-flex align-items-center">
        <div class="mr-3">
            <i class="fas fa-exclamation-circle fa-lg text-warning"></i>
        </div>
        <div class="flex-grow-1">
            <strong>Warning!</strong>
            <span class="ml-2"><?php echo e(Session::get('warning')); ?></span>
        </div>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
</div>
<?php endif; ?>


<?php if(Session::has('info')): ?>
<div class="alert alert-info alert-dismissible fade show mb-3" role="alert">
    <div class="d-flex align-items-center">
        <div class="mr-3">
            <i class="fas fa-info-circle fa-lg text-info"></i>
        </div>
        <div class="flex-grow-1">
            <strong>Info!</strong>
            <span class="ml-2"><?php echo e(Session::get('info')); ?></span>
        </div>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
</div>
<?php endif; ?>


<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Function to auto-hide alerts
        function autoHideAlert(selector, delay) {
            setTimeout(function() {
                var alertElement = document.querySelector(selector);
                if (alertElement) {
                    // For Bootstrap 4 compatibility
                    if (typeof bootstrap !== 'undefined' && bootstrap.Alert) {
                        var alert = new bootstrap.Alert(alertElement);
                        alert.close();
                    } else if (typeof $ !== 'undefined' && $.fn.alert) {
                        $(alertElement).alert('close');
                    } else {
                        // Fallback manual hide
                        alertElement.style.display = 'none';
                    }
                }
            }, delay);
        }

        // Auto-hide different alert types with different timings
        autoHideAlert('.alert-success', 5000);  // Success: 5 seconds
        autoHideAlert('.alert-info', 5000);     // Info: 5 seconds
        autoHideAlert('.alert-warning', 6000);  // Warning: 6 seconds
        autoHideAlert('.alert-danger', 8000);   // Error: 8 seconds (longer for errors)
    });
</script>


<style>
    .alert {
        border-radius: 8px;
        border: none;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }

    .alert-success {
        background-color: #d4edda;
        color: #155724;
    }

    .alert-danger {
        background-color: #f8d7da;
        color: #721c24;
    }

    .alert-warning {
        background-color: #fff3cd;
        color: #856404;
    }

    .alert-info {
        background-color: #d1ecf1;
        color: #0c5460;
    }

    .alert .fas {
        margin-top: 2px;
    }
</style>
<?php /**PATH C:\xampp\htdocs\flight\resources\views/components/bootstrap-alerts.blade.php ENDPATH**/ ?>