<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-panel">
        <div class="content ">
            <div class="panel-header bg-<?php echo e($gradient); ?>-gradient">
                <div class="py-5 page-inner">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div>
                            <h2 class="pb-2 text-white fw-bold">Flight <?php echo e($flight->flight_number); ?></h2>
                            <h5 class="mb-2 text-white op-7"><?php echo e($flight->originAirport->city); ?> to <?php echo e($flight->destinationAirport->city); ?></h5>
                        </div>
                        <div class="py-2 ml-md-auto py-md-0">
                            <a href="<?php echo e(route('admin.flights.index')); ?>" class="mr-2 btn btn-secondary btn-border">
                                <i class="fas fa-arrow-left"></i> Back
                            </a>
                            <a href="<?php echo e(route('admin.flights.edit', $flight)); ?>" class="btn btn-warning btn-border">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                        </div>
                    </div>
                </div>
            </div>
             <div class="page-inner mt--5">
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> <?php echo e(session('success')); ?>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                
                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> <?php echo e(session('error')); ?>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Validation Error!</strong> Please check the form for errors.
                        <ul class="mb-0 mt-2">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
            </div>
            
            <div class="page-inner mt--5">
                <div class="row">
                    <!-- Flight Details -->
                    <div class="col-md-8">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-plane"></i> Flight Details
                                    <span class="badge badge-<?php echo e($flight->status == 'scheduled' ? 'primary' : ($flight->status == 'boarding' ? 'warning' : ($flight->status == 'departed' || $flight->status == 'airborne' ? 'success' : ($flight->status == 'delayed' ? 'info' : ($flight->status == 'landed' ? 'secondary' : 'danger'))))); ?> ml-2">
                                        <?php echo e(ucfirst($flight->status)); ?>

                                    </span>
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h5><i class="fas fa-plane-departure"></i> Departure</h5>
                                        <p><strong><?php echo e($flight->originAirport->name); ?></strong></p>
                                        <p class="text-muted"><?php echo e($flight->originAirport->city); ?>, <?php echo e($flight->originAirport->country); ?></p>
                                        <p><strong><?php echo e($flight->departure_time->format('M j, Y H:i')); ?></strong></p>
                                        <?php if($flight->terminal): ?>
                                            <p>Terminal: <strong><?php echo e($flight->terminal); ?></strong></p>
                                        <?php endif; ?>
                                        <?php if($flight->gate): ?>
                                            <p>Gate: <strong><?php echo e($flight->gate); ?></strong></p>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-md-6">
                                        <h5><i class="fas fa-plane-arrival"></i> Arrival</h5>
                                        <p><strong><?php echo e($flight->destinationAirport->name); ?></strong></p>
                                        <p class="text-muted"><?php echo e($flight->destinationAirport->city); ?>, <?php echo e($flight->destinationAirport->country); ?></p>
                                        <p><strong><?php echo e($flight->arrival_time->format('M j, Y H:i')); ?></strong></p>
                                        <p>Duration: <strong><?php echo e($flight->departure_time->diffForHumans($flight->arrival_time, true)); ?></strong></p>
                                    </div>
                                </div>
                                
                                <hr>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>Flight Information</h6>
                                        <p>Airline: <strong><?php echo e($flight->airline); ?></strong></p>
                                        <p>Flight Number: <strong><?php echo e($flight->flight_number); ?></strong></p>
                                        <?php if($flight->aircraft_type): ?>
                                            <p>Aircraft: <strong><?php echo e($flight->aircraft_type); ?></strong></p>
                                        <?php endif; ?>
                                        <p>Price: <strong>$<?php echo e(number_format($flight->price, 2)); ?></strong></p>
                                    </div>
                                    <div class="col-md-6">
                                        <h6>Capacity</h6>
                                        <p>Total Seats: <strong><?php echo e($flight->seats_total); ?></strong></p>
                                        <p>Available: <strong><?php echo e($flight->seats_available); ?></strong></p>
                                        <p>Booked: <strong><?php echo e($flight->seats_total - $flight->seats_available); ?></strong></p>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: <?php echo e(($flight->seats_total - $flight->seats_available) / $flight->seats_total * 100); ?>%"></div>
                                        </div>
                                        <small class="text-muted"><?php echo e(round(($flight->seats_total - $flight->seats_available) / $flight->seats_total * 100)); ?>% booked</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Bookings -->
                        <?php if($flight->bookings->count() > 0): ?>
                            <div class="card shadow-lg mt-4">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-users"></i> Bookings
                                        <span class="badge badge-primary"><?php echo e($flight->bookings->count()); ?></span>
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>Reference</th>
                                                    <th>Passenger</th>
                                                    <th>Seat</th>
                                                    <th>Status</th>
                                                    <th>Payment</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $flight->bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><strong><?php echo e($booking->booking_reference); ?></strong></td>
                                                        <td>
                                                            <?php echo e($booking->passenger_name); ?>

                                                            <?php if($booking->user): ?>
                                                                <br><small class="text-muted"><?php echo e($booking->user->email); ?></small>
                                                            <?php else: ?>
                                                                <br><small class="text-muted"><?php echo e($booking->passenger_email); ?></small>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td><?php echo e($booking->seat_number ?: 'TBA'); ?></td>
                                                        <td>
                                                            <span class="badge badge-<?php echo e($booking->status == 'confirmed' ? 'success' : ($booking->status == 'checked_in' ? 'info' : ($booking->status == 'cancelled' ? 'danger' : 'secondary'))); ?>">
                                                                <?php echo e(ucfirst($booking->status)); ?>

                                                            </span>
                                                        </td>
                                                        <td>
                                                            <span class="badge badge-<?php echo e($booking->payment_status == 'paid' ? 'success' : ($booking->payment_status == 'pending' ? 'warning' : 'danger')); ?>">
                                                                <?php echo e(ucfirst($booking->payment_status)); ?>

                                                            </span>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Tracking -->
                    <div class="col-md-4">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-map-marked-alt"></i> Flight Tracking
                                </h4>
                            </div>
                            <div class="card-body">
                                <?php if($flight->tracking_lat && $flight->tracking_lng): ?>
                                    <p><strong>Current Position:</strong></p>
                                    <p>Latitude: <?php echo e($flight->tracking_lat); ?></p>
                                    <p>Longitude: <?php echo e($flight->tracking_lng); ?></p>
                                    
                                    <?php if($flight->altitude): ?>
                                        <p>Altitude: <strong><?php echo e(number_format($flight->altitude)); ?> ft</strong></p>
                                    <?php endif; ?>
                                    
                                    <?php if($flight->speed): ?>
                                        <p>Speed: <strong><?php echo e($flight->speed); ?> knots</strong></p>
                                    <?php endif; ?>
                                    
                                    <?php if($flight->last_position_updated_at): ?>
                                        <p><small class="text-muted">Updated: <?php echo e($flight->last_position_updated_at->diffForHumans()); ?></small></p>
                                    <?php endif; ?>

                                    <!-- Quick Update Form -->
                                    <hr>
                                    <form id="tracking-form">
                                        <?php echo csrf_field(); ?>
                                        <h6>Update Position</h6>
                                        <div class="form-group">
                                            <input type="number" class="form-control form-control-sm" id="lat" placeholder="Latitude" step="0.000001" value="<?php echo e($flight->tracking_lat); ?>">
                                        </div>
                                        <div class="form-group">
                                            <input type="number" class="form-control form-control-sm" id="lng" placeholder="Longitude" step="0.000001" value="<?php echo e($flight->tracking_lng); ?>">
                                        </div>
                                        <div class="form-group">
                                            <input type="number" class="form-control form-control-sm" id="altitude" placeholder="Altitude (ft)" value="<?php echo e($flight->altitude); ?>">
                                        </div>
                                        <div class="form-group">
                                            <input type="number" class="form-control form-control-sm" id="speed" placeholder="Speed (knots)" value="<?php echo e($flight->speed); ?>">
                                        </div>
                                        <button type="button" class="btn btn-primary btn-sm" onclick="updatePosition()">
                                            <i class="fas fa-map-pin"></i> Update Position
                                        </button>
                                    </form>
                                <?php else: ?>
                                    <p class="text-muted">No tracking data available.</p>
                                    <a href="<?php echo e(route('admin.flights.edit', $flight)); ?>" class="btn btn-primary btn-sm">
                                        <i class="fas fa-edit"></i> Add Tracking Info
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Status Update -->
                        <div class="card shadow-lg mt-4">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-info-circle"></i> Quick Status Update
                                </h4>
                            </div>
                            <div class="card-body">
                                <form id="status-form">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <label>Status</label>
                                        <select class="form-control" id="status">
                                            <option value="scheduled" <?php echo e($flight->status == 'scheduled' ? 'selected' : ''); ?>>Scheduled</option>
                                            <option value="boarding" <?php echo e($flight->status == 'boarding' ? 'selected' : ''); ?>>Boarding</option>
                                            <option value="departed" <?php echo e($flight->status == 'departed' ? 'selected' : ''); ?>>Departed</option>
                                            <option value="airborne" <?php echo e($flight->status == 'airborne' ? 'selected' : ''); ?>>Airborne</option>
                                            <option value="delayed" <?php echo e($flight->status == 'delayed' ? 'selected' : ''); ?>>Delayed</option>
                                            <option value="landed" <?php echo e($flight->status == 'landed' ? 'selected' : ''); ?>>Landed</option>
                                            <option value="cancelled" <?php echo e($flight->status == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Terminal</label>
                                        <input type="text" class="form-control" id="terminal" value="<?php echo e($flight->terminal); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Gate</label>
                                        <input type="text" class="form-control" id="gate" value="<?php echo e($flight->gate); ?>">
                                    </div>
                                    <button type="button" class="btn btn-success btn-sm" onclick="updateStatus()">
                                        <i class="fas fa-save"></i> Update Status
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        function updatePosition() {
            const lat = document.getElementById('lat').value;
            const lng = document.getElementById('lng').value;
            const altitude = document.getElementById('altitude').value;
            const speed = document.getElementById('speed').value;

            fetch('<?php echo e(route("admin.flights.update-position", $flight)); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('[name="_token"]').value
                },
                body: JSON.stringify({ lat, lng, altitude, speed })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Position updated successfully!');
                    location.reload();
                } else {
                    alert('Error updating position');
                }
            });
        }

        function updateStatus() {
            const status = document.getElementById('status').value;
            const terminal = document.getElementById('terminal').value;
            const gate = document.getElementById('gate').value;

            fetch('<?php echo e(route("admin.flights.update-status", $flight)); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('[name="_token"]').value
                },
                body: JSON.stringify({ status, terminal, gate })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Status updated successfully!');
                    location.reload();
                } else {
                    alert('Error updating status');
                }
            });
        }
    </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\flight\resources\views/admin/flights/show.blade.php ENDPATH**/ ?>