<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="main-panel">
        <div class="content">
            <div class="panel-header bg-<?php echo e($gradient); ?>-gradient">
                <div class="py-5 page-inner">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div>
                            <h2 class="pb-2 text-white fw-bold">Booking Details</h2>
                            <h5 class="mb-2 text-white op-7"><?php echo e($booking->booking_reference); ?></h5>
                        </div>
                        <div class="py-2 ml-md-auto py-md-0">
                            <a href="<?php echo e(route('admin.bookings.index')); ?>" class="btn btn-secondary btn-border">
                                <i class="fas fa-arrow-left"></i> Back to Bookings
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <?php if(session('success')): ?>
                <div class="page-inner mt--5">
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> <?php echo e(session('success')); ?>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="page-inner mt--5">
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> <?php echo e(session('error')); ?>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
            <?php endif; ?>

            <div class="page-inner mt--5">
                <div class="row">
                    <!-- Left Column - Booking Details -->
                    <div class="col-md-8">
                        <!-- Flight Information -->
                        <div class="mb-3 card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-plane"></i> Flight Information
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <table class="table table-borderless">
                                            <tr>
                                                <th width="140">Flight Number</th>
                                                <td><strong><?php echo e($booking->flight->airline); ?> <?php echo e($booking->flight->flight_number); ?></strong></td>
                                            </tr>
                                            <tr>
                                                <th>Route</th>
                                                <td>
                                                    <?php echo e($booking->flight->originAirport->name); ?> (<?php echo e($booking->flight->originAirport->iata_code); ?>)
                                                    <i class="fas fa-arrow-right mx-2"></i>
                                                    <?php echo e($booking->flight->destinationAirport->name); ?> (<?php echo e($booking->flight->destinationAirport->iata_code); ?>)
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Departure</th>
                                                <td><?php echo e($booking->flight->departure_time->format('M d, Y H:i')); ?></td>
                                            </tr>
                                            <tr>
                                                <th>Arrival</th>
                                                <td><?php echo e($booking->flight->arrival_time->format('M d, Y H:i')); ?></td>
                                            </tr>
                                        </table>
                                    </div>
                                    <div class="col-md-6">
                                        <table class="table table-borderless">
                                            <tr>
                                                <th width="140">Duration</th>
                                                <td><?php echo e($booking->flight->duration); ?></td>
                                            </tr>
                                            <tr>
                                                <th>Aircraft</th>
                                                <td><?php echo e($booking->flight->aircraft_type ?? 'N/A'); ?></td>
                                            </tr>
                                            <tr>
                                                <th>Terminal</th>
                                                <td><?php echo e($booking->flight->terminal ?? 'N/A'); ?></td>
                                            </tr>
                                            <tr>
                                                <th>Gate</th>
                                                <td><?php echo e($booking->flight->gate ?? 'N/A'); ?></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Passenger Information -->
                        <div class="mb-3 card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-user"></i> Passenger Information
                                </h4>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="200">Passenger Name</th>
                                        <td><strong><?php echo e($booking->passenger_name); ?></strong></td>
                                    </tr>
                                    <tr>
                                        <th>Email</th>
                                        <td><?php echo e($booking->passenger_email); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Phone</th>
                                        <td><?php echo e($booking->passenger_phone ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Booking Type</th>
                                        <td>
                                            <?php if($booking->user_id): ?>
                                                <span class="badge badge-primary">Registered User</span>
                                                <a href="#" class="ml-2">View User</a>
                                            <?php else: ?>
                                                <span class="badge badge-info">Guest</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php if($booking->seat_number): ?>
                                    <tr>
                                        <th>Seat Number</th>
                                        <td><strong><?php echo e($booking->seat_number); ?></strong></td>
                                    </tr>
                                    <?php endif; ?>
                                </table>
                            </div>
                        </div>

                        <!-- Payment Information -->
                        <div class="mb-3 card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-credit-card"></i> Payment Information
                                </h4>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="200">Payment Method</th>
                                        <td>
                                            <?php if($booking->paymentMethod): ?>
                                                <span class="badge badge-info"><?php echo e($booking->paymentMethod->name); ?></span>
                                            <?php else: ?>
                                                <?php echo e($booking->wdmethod_type ?? 'N/A'); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Amount Paid</th>
                                        <td><strong class="text-success">$<?php echo e(number_format($booking->price_paid, 2)); ?></strong></td>
                                    </tr>
                                    <tr>
                                        <th>Payment Status</th>
                                        <td>
                                            <?php if($booking->payment_status === 'pending'): ?>
                                                <span class="badge badge-warning">Pending</span>
                                            <?php elseif($booking->payment_status === 'paid'): ?>
                                                <span class="badge badge-success">Paid</span>
                                            <?php elseif($booking->payment_status === 'failed'): ?>
                                                <span class="badge badge-danger">Failed</span>
                                            <?php elseif($booking->payment_status === 'refunded'): ?>
                                                <span class="badge badge-info">Refunded</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php if($booking->transaction_id): ?>
                                    <tr>
                                        <th>Transaction ID</th>
                                        <td><code><?php echo e($booking->transaction_id); ?></code></td>
                                    </tr>
                                    <?php endif; ?>
                                    <?php if($booking->payment_proof): ?>
                                    <tr>
                                        <th>Payment Proof</th>
                                        <td>
                                            <a href="<?php echo e(asset('storage/app/public/' . $booking->payment_proof)); ?>" 
                                               target="_blank" 
                                               class="btn btn-sm btn-primary">
                                                <i class="fas fa-file-image"></i> View Payment Proof
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <th>Payment Initiated</th>
                                        <td><?php echo e($booking->payment_initiated_at ? $booking->payment_initiated_at->format('M d, Y H:i') : 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Payment Completed</th>
                                        <td><?php echo e($booking->payment_completed_at ? $booking->payment_completed_at->format('M d, Y H:i') : 'N/A'); ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>

                        <?php if($booking->referred_by): ?>
                        <!-- Referral Information -->
                        <div class="mb-3 card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-gift"></i> Referral Information
                                </h4>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="200">Referred By</th>
                                        <td><?php echo e($booking->referrer->name ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Commission Amount</th>
                                        <td><strong>$<?php echo e(number_format($booking->commission_amount, 2)); ?></strong></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>

                    <!-- Right Column - Status & Actions -->
                    <div class="col-md-4">
                        <!-- Booking Status -->
                        <div class="mb-3 card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-info-circle"></i> Booking Status
                                </h4>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <th>Reference</th>
                                        <td><strong><?php echo e($booking->booking_reference); ?></strong></td>
                                    </tr>
                                    <tr>
                                        <th>Status</th>
                                        <td>
                                            <?php if($booking->status === 'confirmed'): ?>
                                                <span class="badge badge-success badge-lg">Confirmed</span>
                                            <?php elseif($booking->status === 'cancelled'): ?>
                                                <span class="badge badge-danger badge-lg">Cancelled</span>
                                            <?php elseif($booking->status === 'checked_in'): ?>
                                                <span class="badge badge-primary badge-lg">Checked In</span>
                                            <?php elseif($booking->status === 'completed'): ?>
                                                <span class="badge badge-secondary badge-lg">Completed</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Booked At</th>
                                        <td><?php echo e($booking->created_at->format('M d, Y H:i')); ?></td>
                                    </tr>
                                    <?php if($booking->checked_in_at): ?>
                                    <tr>
                                        <th>Checked In At</th>
                                        <td><?php echo e($booking->checked_in_at->format('M d, Y H:i')); ?></td>
                                    </tr>
                                    <?php endif; ?>
                                </table>
                            </div>
                        </div>

                        <!-- Quick Actions -->
                        <div class="mb-3 card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-cog"></i> Actions
                                </h4>
                            </div>
                            <div class="card-body">
                                <?php if($booking->payment_status === 'pending' && $booking->payment_proof): ?>
                                    <button type="button" 
                                            class="mb-2 btn btn-success btn-block" 
                                            data-toggle="modal" 
                                            data-target="#approveModal">
                                        <i class="fas fa-check"></i> Approve Payment
                                    </button>
                                    <button type="button" 
                                            class="mb-2 btn btn-danger btn-block" 
                                            data-toggle="modal" 
                                            data-target="#rejectModal">
                                        <i class="fas fa-times"></i> Reject Payment
                                    </button>
                                <?php endif; ?>

                                <?php if($booking->status !== 'cancelled'): ?>
                                    <form action="<?php echo e(route('admin.bookings.cancel', $booking)); ?>" 
                                          method="POST" 
                                          onsubmit="return confirm('Are you sure you want to cancel this booking?')">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="mb-2 btn btn-warning btn-block">
                                            <i class="fas fa-ban"></i> Cancel Booking
                                        </button>
                                    </form>
                                <?php endif; ?>

                                <a href="<?php echo e(route('admin.bookings.index')); ?>" class="btn btn-secondary btn-block">
                                    <i class="fas fa-list"></i> All Bookings
                                </a>
                            </div>
                        </div>

                        <!-- Additional Information -->
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-info"></i> Additional Info
                                </h4>
                            </div>
                            <div class="card-body">
                                <p class="mb-2"><strong>IP Address:</strong></p>
                                <p class="text-muted"><?php echo e($booking->payment_details['ip_address'] ?? 'N/A'); ?></p>
                                
                                <p class="mt-3 mb-2"><strong>User Agent:</strong></p>
                                <p class="text-muted" style="font-size: 11px; word-break: break-all;">
                                    <?php echo e($booking->payment_details['user_agent'] ?? 'N/A'); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Approve Payment Modal -->
    <div class="modal fade" id="approveModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Approve Payment</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="POST" action="<?php echo e(route('admin.bookings.approve-payment', $booking)); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <p>Are you sure you want to approve this payment?</p>
                        <div class="alert alert-info">
                            <strong>Booking:</strong> <?php echo e($booking->booking_reference); ?><br>
                            <strong>Passenger:</strong> <?php echo e($booking->passenger_name); ?><br>
                            <strong>Amount:</strong> $<?php echo e(number_format($booking->price_paid, 2)); ?>

                        </div>
                        <p class="text-success">
                            <i class="fas fa-check-circle"></i> The booking will be confirmed and a confirmation email will be sent to the passenger.
                        </p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-check"></i> Approve Payment
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Reject Payment Modal -->
    <div class="modal fade" id="rejectModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Reject Payment</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="POST" action="<?php echo e(route('admin.bookings.reject-payment', $booking)); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <p>Please provide a reason for rejecting this payment:</p>
                        <div class="alert alert-warning">
                            <strong>Booking:</strong> <?php echo e($booking->booking_reference); ?><br>
                            <strong>Passenger:</strong> <?php echo e($booking->passenger_name); ?><br>
                            <strong>Amount:</strong> $<?php echo e(number_format($booking->price_paid, 2)); ?>

                        </div>
                        <div class="form-group">
                            <label for="rejection_reason">Rejection Reason <span class="text-danger">*</span></label>
                            <textarea class="form-control" 
                                      id="rejection_reason" 
                                      name="rejection_reason" 
                                      rows="4" 
                                      placeholder="e.g., Payment proof is unclear, Amount doesn't match, Invalid payment method..."
                                      required></textarea>
                        </div>
                        <p class="text-danger">
                            <i class="fas fa-exclamation-triangle"></i> The passenger will be notified with this reason.
                        </p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-times"></i> Reject Payment
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\flight\resources\views/admin/bookings/show.blade.php ENDPATH**/ ?>