
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="main-panel">
        <div class="content bg-light">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1 text-dark"><i class="fas fa-ticket-alt"></i> Flight Bookings</h1>
                </div>

                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> <?php echo e(session('success')); ?>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> <?php echo e(session('error')); ?>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <!-- Statistics Cards -->
                <div class="row mb-4">
                    <div class="col-md-3">
                        <div class="card card-stats card-primary">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-5">
                                        <div class="icon-big text-center">
                                            <i class="fas fa-ticket-alt"></i>
                                        </div>
                                    </div>
                                    <div class="col-7 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Total Bookings</p>
                                            <h4 class="card-title"><?php echo e($stats['total']); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="card card-stats card-warning">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-5">
                                        <div class="icon-big text-center">
                                            <i class="fas fa-clock"></i>
                                        </div>
                                    </div>
                                    <div class="col-7 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Pending</p>
                                            <h4 class="card-title"><?php echo e($stats['pending']); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="card card-stats card-success">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-5">
                                        <div class="icon-big text-center">
                                            <i class="fas fa-check-circle"></i>
                                        </div>
                                    </div>
                                    <div class="col-7 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Confirmed</p>
                                            <h4 class="card-title"><?php echo e($stats['paid']); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="card card-stats card-info">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-5">
                                        <div class="icon-big text-center">
                                            <i class="fas fa-dollar-sign"></i>
                                        </div>
                                    </div>
                                    <div class="col-7 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Total Revenue</p>
                                            <h4 class="card-title">$<?php echo e(number_format($stats['revenue'], 2)); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Filters -->
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Filter Bookings</h4>
                    </div>
                    <div class="card-body">
                        <form method="GET" action="<?php echo e(route('admin.bookings.index')); ?>">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Payment Status</label>
                                        <select name="payment_status" class="form-control">
                                            <option value="">All Payments</option>
                                            <option value="pending" <?php echo e(request('payment_status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                                            <option value="paid" <?php echo e(request('payment_status') === 'paid' ? 'selected' : ''); ?>>Paid</option>
                                            <option value="failed" <?php echo e(request('payment_status') === 'failed' ? 'selected' : ''); ?>>Failed</option>
                                            <option value="refunded" <?php echo e(request('payment_status') === 'refunded' ? 'selected' : ''); ?>>Refunded</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Booking Status</label>
                                        <select name="status" class="form-control">
                                            <option value="">All Statuses</option>
                                            <option value="confirmed" <?php echo e(request('status') === 'confirmed' ? 'selected' : ''); ?>>Confirmed</option>
                                            <option value="cancelled" <?php echo e(request('status') === 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                                            <option value="checked_in" <?php echo e(request('status') === 'checked_in' ? 'selected' : ''); ?>>Checked In</option>
                                            <option value="completed" <?php echo e(request('status') === 'completed' ? 'selected' : ''); ?>>Completed</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Date From</label>
                                        <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from')); ?>">
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Date To</label>
                                        <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to')); ?>">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Search</label>
                                        <input type="text" name="search" class="form-control" placeholder="Booking reference, passenger name, or email..." value="<?php echo e(request('search')); ?>">
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <div>
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-search"></i> Filter
                                            </button>
                                            <a href="<?php echo e(route('admin.bookings.index')); ?>" class="btn btn-secondary">
                                                <i class="fas fa-times"></i> Clear
                                            </a>
                                            <a href="<?php echo e(route('admin.bookings.export')); ?><?php echo e(request()->getQueryString() ? '?' . request()->getQueryString() : ''); ?>" class="btn btn-success">
                                                <i class="fas fa-file-excel"></i> Export CSV
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Bookings Table -->
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">All Flight Bookings</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Booking Ref</th>
                                        <th>Passenger</th>
                                        <th>Flight</th>
                                        <th>Route</th>
                                        <th>Date</th>
                                        <th>Price</th>
                                        <th>Payment</th>
                                        <th>Status</th>
                                        <th>Booked</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td>
                                                <strong><?php echo e($booking->booking_reference); ?></strong>
                                            </td>
                                            <td>
                                                <?php echo e($booking->passenger_name); ?><br>
                                                <small class="text-muted"><?php echo e($booking->passenger_email); ?></small>
                                            </td>
                                            <td>
                                                <strong><?php echo e($booking->flight->airline); ?></strong><br>
                                                <small><?php echo e($booking->flight->flight_number); ?></small>
                                            </td>
                                            <td>
                                                <?php echo e($booking->flight->originAirport->iata_code); ?> → <?php echo e($booking->flight->destinationAirport->iata_code); ?>

                                            </td>
                                            <td><?php echo e($booking->flight->departure_time->format('M d, Y')); ?></td>
                                            <td>$<?php echo e(number_format($booking->price_paid, 2)); ?></td>
                                            <td>
                                                <?php if($booking->payment_status === 'pending'): ?>
                                                    <span class="badge badge-warning">Pending</span>
                                                <?php elseif($booking->payment_status === 'paid'): ?>
                                                    <span class="badge badge-success">Paid</span>
                                                <?php elseif($booking->payment_status === 'failed'): ?>
                                                    <span class="badge badge-danger">Failed</span>
                                                <?php elseif($booking->payment_status === 'refunded'): ?>
                                                    <span class="badge badge-info">Refunded</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($booking->status === 'confirmed'): ?>
                                                    <span class="badge badge-success">Confirmed</span>
                                                <?php elseif($booking->status === 'cancelled'): ?>
                                                    <span class="badge badge-danger">Cancelled</span>
                                                <?php elseif($booking->status === 'checked_in'): ?>
                                                    <span class="badge badge-primary">Checked In</span>
                                                <?php elseif($booking->status === 'completed'): ?>
                                                    <span class="badge badge-secondary">Completed</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($booking->created_at->format('M d, H:i')); ?></td>
                                            <td>
                                                <a href="<?php echo e(route('admin.bookings.show', $booking)); ?>" class="btn btn-sm btn-info" title="View Details">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <?php if($booking->status !== 'cancelled'): ?>
                                                    <form action="<?php echo e(route('admin.bookings.cancel', $booking)); ?>" method="POST" style="display:inline;">
                                                        <?php echo csrf_field(); ?>
                                                        <button type="submit" class="btn btn-sm btn-danger" 
                                                                onclick="return confirm('Are you sure you want to cancel this booking?')" 
                                                                title="Cancel Booking">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                    </form>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="10" class="text-center">No bookings found</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="mt-3">
                            <?php echo e($bookings->appends(request()->query())->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>

       
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\flight\resources\views/admin/bookings/index.blade.php ENDPATH**/ ?>