

<?php $__env->startSection('title', 'Search Flights - ' . config('app.name')); ?>

<?php $__env->startSection('content'); ?>
<!-- Hero Section with Search -->
<section class="relative text-white py-16 bg-cover bg-center" style="background-image: url('<?php echo e(asset('temp/bg.png')); ?>');">
    <div class="absolute inset-0 bg-black/50"></div>
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h1 class="text-4xl md:text-6xl font-bold mb-4">Find Your Perfect Flight</h1>
            <p class="text-xl text-primary-100 max-w-2xl mx-auto">Search and book flights to destinations worldwide with our easy-to-use platform</p>
        </div>

        <!-- Search Form -->
        <div class="bg-white rounded-2xl shadow-2xl max-w-6xl mx-auto overflow-hidden" x-data="flightSearch()">
            <form action="<?php echo e(route('flights.results')); ?>" method="GET">
                <!-- Trip Type Tabs -->
                <div class="px-8 pt-6 pb-4">
                    <div class="flex gap-2">
                        <label class="cursor-pointer">
                            <input type="radio" name="trip_type" value="round_trip" x-model="tripType" class="peer sr-only" checked>
                            <div class="peer-checked:bg-primary-600 peer-checked:text-white bg-slate-100 text-slate-600 font-semibold py-2.5 px-6 rounded-full transition-all hover:bg-slate-200 peer-checked:hover:bg-primary-700">
                                <i class="fas fa-exchange-alt mr-2"></i>Round Trip
                            </div>
                        </label>
                        <label class="cursor-pointer">
                            <input type="radio" name="trip_type" value="one_way" x-model="tripType" class="peer sr-only">
                            <div class="peer-checked:bg-primary-600 peer-checked:text-white bg-slate-100 text-slate-600 font-semibold py-2.5 px-6 rounded-full transition-all hover:bg-slate-200 peer-checked:hover:bg-primary-700">
                                <i class="fas fa-arrow-right mr-2"></i>One Way
                            </div>
                        </label>
                    </div>
                </div>

                <!-- Main Search Fields -->
                <div class="px-8 pb-8">
                    <!-- Flight Route Row -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                        <!-- From -->
                        <div class="relative group bg-slate-50 rounded-xl p-4 hover:bg-slate-100 transition-all border-2 border-transparent focus-within:border-primary-500 focus-within:bg-white">
                            <div class="flex items-start gap-3">
                                <div class="text-primary-600 mt-1">
                                    <i class="fas fa-plane-departure text-2xl"></i>
                                </div>
                                <div class="flex-1">
                                    <label class="block text-xs font-bold text-slate-500 uppercase tracking-wide mb-2">From</label>
                                    <select name="origin" required class="w-full text-base font-medium text-slate-900 bg-transparent border-0 focus:ring-0 p-0 cursor-pointer">
                                        <option value="">Select departure city</option>
                                        <?php $__currentLoopData = $airports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $airport): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($airport->iata_code); ?>" <?php echo e(request('origin') === $airport->iata_code ? 'selected' : ''); ?>>
                                                <?php echo e($airport->city); ?> (<?php echo e($airport->iata_code); ?>)
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- To -->
                        <div class="relative group bg-slate-50 rounded-xl p-4 hover:bg-slate-100 transition-all border-2 border-transparent focus-within:border-primary-500 focus-within:bg-white">
                            <div class="flex items-start gap-3">
                                <div class="text-primary-600 mt-1">
                                    <i class="fas fa-plane-arrival text-2xl"></i>
                                </div>
                                <div class="flex-1">
                                    <label class="block text-xs font-bold text-slate-500 uppercase tracking-wide mb-2">To</label>
                                    <select name="destination" required class="w-full text-base font-medium text-slate-900 bg-transparent border-0 focus:ring-0 p-0 cursor-pointer">
                                        <option value="">Select arrival city</option>
                                        <?php $__currentLoopData = $airports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $airport): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($airport->iata_code); ?>" <?php echo e(request('destination') === $airport->iata_code ? 'selected' : ''); ?>>
                                                <?php echo e($airport->city); ?> (<?php echo e($airport->iata_code); ?>)
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Dates and Details Row -->
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                        <!-- Departure Date -->
                        <div class="relative group bg-slate-50 rounded-xl p-4 hover:bg-slate-100 transition-all border-2 border-transparent focus-within:border-primary-500 focus-within:bg-white">
                            <div class="flex items-start gap-3">
                                <div class="text-primary-600 mt-1">
                                    <i class="fas fa-calendar-alt text-xl"></i>
                                </div>
                                <div class="flex-1">
                                    <label class="block text-xs font-bold text-slate-500 uppercase tracking-wide mb-2">Departure</label>
                                    <input type="date" name="departure_date" required 
                                           min="<?php echo e(date('Y-m-d')); ?>" 
                                           value="<?php echo e(request('departure_date', date('Y-m-d'))); ?>"
                                           class="w-full text-base font-medium text-slate-900 bg-transparent border-0 focus:ring-0 p-0 cursor-pointer">
                                </div>
                            </div>
                        </div>

                        <!-- Return Date -->
                        <div class="relative group bg-slate-50 rounded-xl p-4 hover:bg-slate-100 transition-all border-2 border-transparent focus-within:border-primary-500 focus-within:bg-white" x-show="tripType === 'round_trip'">
                            <div class="flex items-start gap-3">
                                <div class="text-primary-600 mt-1">
                                    <i class="fas fa-calendar-alt text-xl"></i>
                                </div>
                                <div class="flex-1">
                                    <label class="block text-xs font-bold text-slate-500 uppercase tracking-wide mb-2">Return</label>
                                    <input type="date" name="return_date" 
                                           min="<?php echo e(date('Y-m-d', strtotime('+1 day'))); ?>" 
                                           value="<?php echo e(request('return_date')); ?>"
                                           class="w-full text-base font-medium text-slate-900 bg-transparent border-0 focus:ring-0 p-0 cursor-pointer">
                                </div>
                            </div>
                        </div>

                        <!-- Passengers -->
                        <div class="relative group bg-slate-50 rounded-xl p-4 hover:bg-slate-100 transition-all border-2 border-transparent focus-within:border-primary-500 focus-within:bg-white">
                            <div class="flex items-start gap-3">
                                <div class="text-primary-600 mt-1">
                                    <i class="fas fa-users text-xl"></i>
                                </div>
                                <div class="flex-1">
                                    <label class="block text-xs font-bold text-slate-500 uppercase tracking-wide mb-2">Passengers</label>
                                    <select name="passengers" class="w-full text-base font-medium text-slate-900 bg-transparent border-0 focus:ring-0 p-0 cursor-pointer">
                                        <?php for($i = 1; $i <= 9; $i++): ?>
                                            <option value="<?php echo e($i); ?>" <?php echo e(request('passengers', 1) == $i ? 'selected' : ''); ?>>
                                                <?php echo e($i); ?> <?php echo e($i == 1 ? 'Adult' : 'Adults'); ?>

                                            </option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Class -->
                        <div class="relative group bg-slate-50 rounded-xl p-4 hover:bg-slate-100 transition-all border-2 border-transparent focus-within:border-primary-500 focus-within:bg-white">
                            <div class="flex items-start gap-3">
                                <div class="text-primary-600 mt-1">
                                    <i class="fas fa-chair text-xl"></i>
                                </div>
                                <div class="flex-1">
                                    <label class="block text-xs font-bold text-slate-500 uppercase tracking-wide mb-2">Class</label>
                                    <select name="class" class="w-full text-base font-medium text-slate-900 bg-transparent border-0 focus:ring-0 p-0 cursor-pointer">
                                        <option value="economy" <?php echo e(request('class', 'economy') === 'economy' ? 'selected' : ''); ?>>Economy</option>
                                        <option value="business" <?php echo e(request('class') === 'business' ? 'selected' : ''); ?>>Business</option>
                                        <option value="first" <?php echo e(request('class') === 'first' ? 'selected' : ''); ?>>First</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Search Button -->
                    <button type="submit" class="w-full bg-gradient-to-r from-primary-600 to-primary-700 hover:from-primary-700 hover:to-primary-800 text-white font-bold py-5 px-8 rounded-xl transition-all transform hover:scale-[1.01] text-xl shadow-xl hover:shadow-2xl">
                        <i class="fas fa-search mr-3"></i>Search Flights
                    </button>
                </div>
            </form>
        </div>
    </div>
    </div>
</section>

<!-- Available Flights Section -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl md:text-4xl font-bold text-slate-800 mb-4">
                <i class="fas fa-plane text-primary-600 mr-3"></i>Featured Flights
            </h2>
            <p class="text-xl text-slate-600">Explore today's featured flights</p>
        </div>

        <?php if(isset($availableFlights) && $availableFlights->count() > 0): ?>
        <div class="flex flex-col lg:flex-row gap-8 items-start">
            <!-- Flights List - Shows first on mobile -->
            <div class="flex-1 space-y-6 w-full lg:w-auto lg:order-2">
            <?php $__currentLoopData = $availableFlights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white border border-slate-200 rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                <div class="flex flex-col lg:flex-row items-center justify-between">
                    <!-- Flight Info -->
                    <div class="flex-1 flex flex-col lg:flex-row items-center space-y-4 lg:space-y-0 lg:space-x-6">
                        <!-- Airline -->
                        <div class="flex items-center space-x-3">
                            <?php if($flight->airline_logo): ?>
                                <div class="w-12 h-12 rounded-full overflow-hidden bg-white border border-slate-200 flex items-center justify-center p-1">
                                    <img src="<?php echo e(asset('storage/app/public/' . $flight->airline_logo)); ?>" alt="<?php echo e($flight->airline); ?>" class="w-full h-full object-contain">
                                </div>
                            <?php else: ?>
                                <div class="w-12 h-12 bg-primary-100 rounded-full flex items-center justify-center">
                                    <i class="fas fa-plane text-primary-600"></i>
                                </div>
                            <?php endif; ?>
                            <div>
                                <div class="font-semibold text-slate-800"><?php echo e($flight->airline); ?></div>
                                <div class="text-sm text-slate-500"><?php echo e($flight->flight_number); ?></div>
                            </div>
                        </div>

                        <!-- Route -->
                        <div class="flex-1 flex items-center justify-center space-x-4 min-w-0">
                            <!-- Departure -->
                            <div class="text-center">
                                <div class="text-2xl font-bold text-slate-800"><?php echo e($flight->departure_time->format('H:i')); ?></div>
                                <div class="text-sm text-slate-500"><?php echo e($flight->originAirport->iata_code); ?></div>
                                <div class="text-xs text-slate-400"><?php echo e($flight->originAirport->city); ?></div>
                            </div>

                            <!-- Flight Path -->
                            <div class="flex-1 flex flex-col items-center min-w-0">
                                <div class="text-xs text-slate-500 mb-1">
                                    <?php echo e($flight->departure_time->diffForHumans($flight->arrival_time, true)); ?>

                                </div>
                                <div class="w-full flex items-center">
                                    <div class="w-3 h-3 bg-primary-500 rounded-full"></div>
                                    <div class="flex-1 h-0.5 bg-primary-200 relative">
                                        <i class="fas fa-plane absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 text-primary-500 text-sm bg-white px-1"></i>
                                    </div>
                                    <div class="w-3 h-3 bg-primary-500 rounded-full"></div>
                                </div>
                                <div class="text-xs text-slate-500 mt-1">Direct</div>
                            </div>

                            <!-- Arrival -->
                            <div class="text-center">
                                <div class="text-2xl font-bold text-slate-800"><?php echo e($flight->arrival_time->format('H:i')); ?></div>
                                <div class="text-sm text-slate-500"><?php echo e($flight->destinationAirport->iata_code); ?></div>
                                <div class="text-xs text-slate-400"><?php echo e($flight->destinationAirport->city); ?></div>
                            </div>
                        </div>

                        <!-- Flight Details -->
                        <div class="text-center lg:text-left">
                            <div class="text-xs text-slate-500">Gate: <?php echo e($flight->gate ?? 'A32'); ?></div>
                            <div class="text-xs text-slate-500">Terminal: <?php echo e($flight->terminal ?? '3'); ?></div>
                            <div class="text-xs text-slate-500 flex items-center mt-1">
                                <i class="fas fa-calendar mr-1"></i>
                                <?php echo e($flight->departure_time->format('M d, Y')); ?>

                            </div>
                        </div>
                    </div>

                    <!-- Price & Book -->
                    <div class="mt-6 lg:mt-0 flex flex-col items-center lg:items-end space-y-3">
                        <div class="text-center lg:text-right">
                            <div class="text-3xl font-bold text-primary-600">$<?php echo e(number_format($flight->price, 0)); ?></div>
                            <div class="text-sm text-slate-500">per person</div>
                        </div>
                        
                        <div class="flex items-center space-x-2 text-sm">
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium <?php echo e($flight->status_badge); ?>">
                                <?php echo e(ucfirst($flight->status)); ?>

                            </span>
                            <span class="text-slate-500"><?php echo e($flight->seats_available); ?> seats</span>
                        </div>

                        <a href="<?php echo e(route('flights.booking', $flight)); ?>" class="bg-primary-600 hover:bg-primary-700 text-white font-semibold py-3 px-6 rounded-xl transition-colors transform hover:scale-105 shadow-lg inline-block text-center">
                            Select Flight
                        </a>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <!-- Featured Flights Image - Left Side on desktop, after flights on mobile -->
            <div class="lg:sticky lg:top-8 flex-shrink-0 lg:order-1">
                <img src="<?php echo e(asset('temp/featured_flights.png')); ?>" 
                     alt="Featured Flights" 
                     class="w-full lg:w-80 h-auto rounded-2xl shadow-lg">
            </div>
        </div>
        <?php else: ?>
        <div class="text-center py-12">
            <div class="w-24 h-24 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="fas fa-plane text-slate-400 text-3xl"></i>
            </div>
            <h3 class="text-xl font-semibold text-slate-600 mb-2">No flights available at the moment</h3>
            <p class="text-slate-500">Please check back later or search for specific routes above.</p>
        </div>
        <?php endif; ?>
    </div>
</section>

<!-- Popular Destinations -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl md:text-4xl font-bold text-slate-800 mb-4">Popular Destinations</h2>
            <p class="text-xl text-slate-600">Discover amazing places around the world</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php $__currentLoopData = $popularDestinations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $destination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="group relative overflow-hidden rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 h-64 bg-slate-800">
                <!-- Background Image -->
                <img src="<?php echo e(asset('temp/destinations/' . strtolower(str_replace(' ', '-', $destination->city)) . '.jpg')); ?>" 
                     alt="<?php echo e($destination->city); ?>" 
                     class="w-full h-full object-cover"
                     onerror="this.style.display='none'; this.parentElement.style.background='linear-gradient(135deg, #2563eb 0%, #1e40af 100%)';">
                
                <!-- Overlay with city info -->
                <div class="absolute inset-0 bg-gradient-to-t from-black/70 via-black/30 to-transparent flex items-end">
                    <div class="p-6 text-white w-full">
                        <h3 class="text-3xl font-bold mb-2"><?php echo e($destination->city); ?></h3>
                        <p class="text-lg text-slate-200 mb-2"><?php echo e($destination->iata_code); ?></p>
                    </div>
                </div>
                
                <!-- Hover overlay with price -->
                <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex items-end">
                    <div class="p-6 text-white w-full">
                        <h3 class="text-2xl font-bold mb-2"><?php echo e($destination->city); ?></h3>
                        <p class="text-sm mb-1">Starting from</p>
                        <p class="text-3xl font-bold"> <?php echo e($settings->currency_symbol); ?><?php echo e(number_format($destination->min_price ?? 299, 0)); ?></p>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Features Section -->
<section class="py-16 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl md:text-4xl font-bold text-slate-800 mb-4">Why Choose Us</h2>
            <p class="text-xl text-slate-600">Experience the best in flight booking and travel services</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="text-center p-8 bg-white rounded-2xl shadow-lg hover:shadow-xl transition-shadow">
                <div class="w-16 h-16 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-bolt text-slate-600 text-2xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-slate-800 mb-4">Instant Booking</h3>
                <p class="text-slate-600">Book your flights in seconds with our streamlined booking process and instant confirmation.</p>
            </div>

            <div class="text-center p-8 bg-white rounded-2xl shadow-lg hover:shadow-xl transition-shadow">
                <div class="w-16 h-16 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-shield-alt text-slate-800 text-2xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-slate-800 mb-4">Secure Payment</h3>
                <p class="text-slate-600">Your transactions are protected with bank-level security and multiple payment options.</p>
            </div>

            <div class="text-center p-8 bg-white rounded-2xl shadow-lg hover:shadow-xl transition-shadow">
                <div class="w-16 h-16 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-headset text-slate-800 text-2xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-slate-800 mb-4">24/7 Support</h3>
                <p class="text-slate-600">Get help whenever you need it with our round-the-clock customer support team.</p>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function flightSearch() {
    return {
        tripType: 'round_trip',
        init() {
            // Set minimum return date based on departure date
            const departureInput = document.querySelector('input[name="departure_date"]');
            const returnInput = document.querySelector('input[name="return_date"]');
            
            if (departureInput && returnInput) {
                departureInput.addEventListener('change', function() {
                    const departureDate = new Date(this.value);
                    const nextDay = new Date(departureDate);
                    nextDay.setDate(nextDay.getDate() + 1);
                    returnInput.min = nextDay.toISOString().split('T')[0];
                    
                    // Update return date if it's before departure
                    if (returnInput.value && new Date(returnInput.value) <= departureDate) {
                        returnInput.value = nextDay.toISOString().split('T')[0];
                    }
                });
            }
        }
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.flight', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vectoranalysis/flight.gradefx.market/resources/views/user/flights/search.blade.php ENDPATH**/ ?>