
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo e($settings->site_name); ?></title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <style>
        :root {
            /* Primary Color Palette - Professional Blue Theme */
            --color-primary: #1e40af;
            --color-primary-light: #3b82f6;
            --color-primary-dark: #1e3a8a;
            --color-primary-50: #eff6ff;
            --color-primary-100: #dbeafe;
            
            /* Neutral Colors */
            --color-neutral-50: #f9fafb;
            --color-neutral-100: #f3f4f6;
            --color-neutral-200: #e5e7eb;
            --color-neutral-300: #d1d5db;
            --color-neutral-500: #6b7280;
            --color-neutral-600: #4b5563;
            --color-neutral-700: #374151;
            --color-neutral-800: #1f2937;
            --color-neutral-900: #111827;
            
            /* Spacing */
            --spacing-sm: 0.75rem;
            --spacing-md: 1rem;
            --spacing-lg: 1.5rem;
            --spacing-xl: 2rem;
            --spacing-2xl: 3rem;
            
            /* Border Radius */
            --radius-md: 0.5rem;
            --radius-lg: 0.75rem;
            --radius-xl: 1rem;
            
            /* Shadows */
            --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
            --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
            --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            background: linear-gradient(135deg, var(--color-primary-50) 0%, var(--color-neutral-50) 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: var(--spacing-lg);
            position: relative;
            overflow-x: hidden;
        }

        /* Animated background pattern */
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: 
                radial-gradient(circle at 20% 50%, rgba(30, 64, 175, 0.03) 0%, transparent 50%),
                radial-gradient(circle at 80% 80%, rgba(30, 64, 175, 0.03) 0%, transparent 50%);
            animation: float 20s ease-in-out infinite;
            z-index: 0;
        }

        @keyframes  float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-20px); }
        }

        #notfound {
            position: relative;
            z-index: 1;
            max-width: 600px;
            width: 100%;
        }

        .notfound {
            background: white;
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-xl);
            padding: var(--spacing-2xl);
            text-align: center;
            position: relative;
            overflow: hidden;
            animation: fadeInUp 0.6s ease-out;
        }

        @keyframes  fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Top accent bar */
        .notfound::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--color-primary), var(--color-primary-light));
        }

        .notfound-404 {
            margin-bottom: var(--spacing-xl);
            position: relative;
        }

        .notfound-404 h1 {
            font-size: clamp(5rem, 15vw, 10rem);
            font-weight: 800;
            line-height: 1;
            background: linear-gradient(135deg, var(--color-primary), var(--color-primary-light));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin: 0;
            position: relative;
            display: inline-block;
        }

        /* Animated glow effect behind error code */
        .notfound-404::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 200px;
            height: 200px;
            background: radial-gradient(circle, var(--color-primary-50) 0%, transparent 70%);
            animation: pulse 3s ease-in-out infinite;
            z-index: -1;
        }

        @keyframes  pulse {
            0%, 100% { transform: translate(-50%, -50%) scale(1); opacity: 0.5; }
            50% { transform: translate(-50%, -50%) scale(1.2); opacity: 0.8; }
        }

        /* Divider */
        .divider {
            height: 3px;
            width: 80px;
            background: linear-gradient(90deg, var(--color-primary), var(--color-primary-light));
            border-radius: 2px;
            margin: var(--spacing-lg) auto;
        }

        .notfound h2 {
            font-size: clamp(1.25rem, 4vw, 1.75rem);
            font-weight: 600;
            color: var(--color-neutral-900);
            margin-bottom: var(--spacing-md);
            line-height: 1.4;
        }

        .notfound p {
            font-size: 1.125rem;
            color: var(--color-neutral-600);
            line-height: 1.7;
            margin-bottom: var(--spacing-xl);
        }

        .btn-group {
            display: flex;
            flex-wrap: wrap;
            gap: var(--spacing-md);
            justify-content: center;
        }

        .home-btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            padding: 0.875rem 1.75rem;
            font-size: 1rem;
            font-weight: 600;
            color: white;
            background: linear-gradient(135deg, var(--color-primary), var(--color-primary-light));
            border: none;
            border-radius: var(--radius-lg);
            text-decoration: none;
            transition: all 0.2s ease;
            cursor: pointer;
            box-shadow: var(--shadow-md);
        }

        .home-btn:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
        }

        .home-btn:focus-visible {
            outline: 3px solid var(--color-primary-100);
            outline-offset: 2px;
        }

        .btn-secondary {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            padding: 0.875rem 1.75rem;
            font-size: 1rem;
            font-weight: 600;
            color: var(--color-neutral-700);
            background: white;
            border: 2px solid var(--color-neutral-200);
            border-radius: var(--radius-lg);
            text-decoration: none;
            transition: all 0.2s ease;
            cursor: pointer;
        }

        .btn-secondary:hover {
            background: var(--color-neutral-50);
            border-color: var(--color-neutral-300);
        }

        .icon {
            width: 20px;
            height: 20px;
        }

        /* Icon wrapper at top */
        .icon-wrapper {
            width: 100px;
            height: 100px;
            background: linear-gradient(135deg, var(--color-primary-50), var(--color-primary-100));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto var(--spacing-xl);
            position: relative;
        }

        .icon-wrapper::before {
            content: '';
            position: absolute;
            width: 120%;
            height: 120%;
            background: var(--color-primary-50);
            border-radius: 50%;
            opacity: 0.4;
            animation: ripple 2s ease-in-out infinite;
        }

        @keyframes  ripple {
            0%, 100% { transform: scale(1); opacity: 0.3; }
            50% { transform: scale(1.15); opacity: 0.5; }
        }

        .icon-wrapper svg {
            width: 56px;
            height: 56px;
            position: relative;
            z-index: 1;
        }

        /* Mobile responsiveness */
        @media (max-width: 640px) {
            .notfound {
                padding: var(--spacing-xl) var(--spacing-lg);
            }
            
            .btn-group {
                flex-direction: column;
                width: 100%;
            }
            
            .home-btn,
            .btn-secondary {
                width: 100%;
            }

            .icon-wrapper {
                width: 80px;
                height: 80px;
            }

            .icon-wrapper svg {
                width: 44px;
                height: 44px;
            }
        }

        /* Loading state */
        .home-btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
    </style>
</head>

<body>
    <div id="notfound" x-data="{ loading: false }">
        <div class="notfound">
            <!-- Icon -->
            <div class="icon-wrapper">
                <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" stroke="var(--color-primary)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M12 8V12" stroke="var(--color-primary)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M12 16H12.01" stroke="var(--color-primary)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </div>

            <!-- Error Code -->
            <div class="notfound-404">
                <h1><?php echo $__env->yieldContent('code'); ?></h1>
            </div>

            <!-- Divider -->
            <div class="divider"></div>

            <!-- Error Message -->
            <h2><?php echo $__env->yieldContent('message'); ?></h2>

            <!-- Additional Description (optional) -->
            <?php if (! empty(trim($__env->yieldContent('description')))): ?>
                <p><?php echo $__env->yieldContent('description'); ?></p>
            <?php endif; ?>

            <!-- Action Buttons -->
            <div class="btn-group">
                <a href="<?php echo e(app('router')->has('home') ? route('home') : url('/')); ?>" 
                   class="home-btn"
                   @click="loading = true"
                   :disabled="loading">
                    <svg class="icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M3 9L12 2L21 9V20C21 20.5304 20.7893 21.0391 20.4142 21.4142C20.0391 21.7893 19.5304 22 19 22H5C4.46957 22 3.96086 21.7893 3.58579 21.4142C3.21071 21.0391 3 20.5304 3 20V9Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M9 22V12H15V22" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    <span x-text="loading ? 'Loading...' : 'Go Home'">Go Home</span>
                </a>

                <a href="<?php echo e(url()->previous()); ?>" class="btn-secondary">
                    <svg class="icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19 12H5M5 12L12 19M5 12L12 5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    Go Back
                </a>
            </div>
        </div>
    </div>
</body>
</html>

<?php /**PATH /home/vectoranalysis/flight.gradefx.market/resources/views/errors/minimal.blade.php ENDPATH**/ ?>