<!-- Personal Information Section -->
<div class="space-y-8">
    <!-- Header -->
    
    <!-- Form -->
    <form method="POST" action="<?php echo e(route('profile.update')); ?>" id="updateprofileform" class="space-y-6" onsubmit="return handleFormSubmit(event)">
        <?php echo csrf_field(); ?>

        

    

       

        <!-- Passenger Information Section -->
        <div class="border-t border-gray-200 pt-8 mt-8">
            <div class="flex items-center space-x-3 mb-6">
                <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M21 16v-2l-8-5V3.5c0-.83-.67-1.5-1.5-1.5S10 2.67 10 3.5V9l-8 5v2l8-2.5V19l-2 1.5V22l3.5-1 3.5 1v-1.5L13 19v-5.5l8 2.5z"/>
                    </svg>
                </div>
                <div>
                    <h3 class="text-xl font-semibold text-gray-900">Passenger Information</h3>
                    <p class="text-gray-600 mt-1">Information used for flight bookings</p>
                </div>
            </div>
        </div>

        <!-- Passenger Name -->
        <div class="grid md:grid-cols-3 gap-6 items-start">
            <div class="md:pt-3">
                <label for="passenger_name" class="block text-sm font-semibold text-gray-900">Passenger Name</label>
                <p class="text-sm text-gray-600 mt-1">Name as it appears on your ID/Passport</p>
            </div>
            <div class="md:col-span-2">
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <i class="fas fa-user text-gray-400"></i>
                    </div>
                    <input type="text"
                           class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200"
                           id="passenger_name"
                           value="<?php echo e(Auth::user()->passenger_name); ?>"
                           name="passenger_name"
                           placeholder="Full name as on travel document">
                </div>
            </div>
        </div>

        <!-- Passenger Email -->
        <div class="grid md:grid-cols-3 gap-6 items-start">
            <div class="md:pt-3">
                <label for="passenger_email" class="block text-sm font-semibold text-gray-900">Passenger Email</label>
                <p class="text-sm text-gray-600 mt-1">Email for booking confirmations</p>
            </div>
            <div class="md:col-span-2">
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <i class="fas fa-envelope text-gray-400"></i>
                    </div>
                    <input type="email"
                           class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200"
                           id="passenger_email"
                           value="<?php echo e(Auth::user()->passenger_email); ?>"
                           name="passenger_email"
                           placeholder="passenger@example.com">
                </div>
            </div>
        </div>

        <!-- Passenger Phone -->
        <div class="grid md:grid-cols-3 gap-6 items-start">
            <div class="md:pt-3">
                <label for="passenger_phone" class="block text-sm font-semibold text-gray-900">Passenger Phone</label>
                <p class="text-sm text-gray-600 mt-1">Contact number for travel updates</p>
            </div>
            <div class="md:col-span-2">
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <i class="fas fa-phone text-gray-400"></i>
                    </div>
                    <input type="tel"
                           class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200"
                           id="passenger_phone"
                           value="<?php echo e(Auth::user()->passenger_phone); ?>"
                           name="passenger_phone"
                           placeholder="+1 234 567 8900">
                </div>
            </div>
        </div>

        <!-- Date of Birth -->
        <div class="grid md:grid-cols-3 gap-6 items-start">
            <div class="md:pt-3">
                <label for="passenger_dob" class="block text-sm font-semibold text-gray-900">Date of Birth</label>
                <p class="text-sm text-gray-600 mt-1">Required for international flights</p>
            </div>
            <div class="md:col-span-2">
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <i class="fas fa-calendar text-gray-400"></i>
                    </div>
                    <input type="date"
                           class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200"
                           id="passenger_dob"
                           value="<?php echo e(Auth::user()->passenger_dob ? Auth::user()->passenger_dob->format('Y-m-d') : ''); ?>"
                           name="passenger_dob"
                           max="<?php echo e(date('Y-m-d')); ?>">
                </div>
            </div>
        </div>

        <!-- Nationality -->
        <div class="grid md:grid-cols-3 gap-6 items-start">
            <div class="md:pt-3">
                <label for="nationality" class="block text-sm font-semibold text-gray-900">Nationality</label>
                <p class="text-sm text-gray-600 mt-1">Country of citizenship</p>
            </div>
            <div class="md:col-span-2">
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none z-10">
                        <i class="fas fa-flag text-gray-400"></i>
                    </div>
                    <input type="text"
                           class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200"
                           id="nationality"
                           value="<?php echo e(Auth::user()->nationality); ?>"
                           name="nationality"
                           placeholder="e.g., American, British, Canadian">
                </div>
            </div>
        </div>

        <!-- Passport Section Header -->
        <div class="border-t border-gray-200 pt-6 mt-6">
            <div class="flex items-center space-x-2 mb-6">
                <i class="fas fa-passport text-blue-600 text-xl"></i>
                <h4 class="text-lg font-semibold text-gray-900">Passport Details</h4>
            </div>
        </div>

        <!-- Passport Number -->
        <div class="grid md:grid-cols-3 gap-6 items-start">
            <div class="md:pt-3">
                <label for="passport_number" class="block text-sm font-semibold text-gray-900">Passport Number</label>
                <p class="text-sm text-gray-600 mt-1">Your travel document number</p>
            </div>
            <div class="md:col-span-2">
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <i class="fas fa-id-card text-gray-400"></i>
                    </div>
                    <input type="text"
                           class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200"
                           id="passport_number"
                           value="<?php echo e(Auth::user()->passport_number); ?>"
                           name="passport_number"
                           placeholder="e.g., A12345678">
                </div>
            </div>
        </div>

        <!-- Passport Country -->
        <div class="grid md:grid-cols-3 gap-6 items-start">
            <div class="md:pt-3">
                <label for="passport_country" class="block text-sm font-semibold text-gray-900">Issuing Country</label>
                <p class="text-sm text-gray-600 mt-1">Country that issued your passport</p>
            </div>
            <div class="md:col-span-2">
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none z-10">
                        <i class="fas fa-globe text-gray-400"></i>
                    </div>
                    <input type="text"
                           class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200"
                           id="passport_country"
                           value="<?php echo e(Auth::user()->passport_country); ?>"
                           name="passport_country"
                           placeholder="e.g., United States">
                </div>
            </div>
        </div>

        <!-- Passport Expiry -->
        <div class="grid md:grid-cols-3 gap-6 items-start">
            <div class="md:pt-3">
                <label for="passport_expiry" class="block text-sm font-semibold text-gray-900">Expiry Date</label>
                <p class="text-sm text-gray-600 mt-1">Make sure it's valid for travel</p>
            </div>
            <div class="md:col-span-2">
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <i class="fas fa-calendar-times text-gray-400"></i>
                    </div>
                    <input type="date"
                           class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors duration-200"
                           id="passport_expiry"
                           value="<?php echo e(Auth::user()->passport_expiry ? Auth::user()->passport_expiry->format('Y-m-d') : ''); ?>"
                           name="passport_expiry"
                           min="<?php echo e(date('Y-m-d')); ?>">
                </div>
                <?php if(Auth::user()->passport_expiry && Auth::user()->passport_expiry->isPast()): ?>
                    <div class="mt-2 flex items-center space-x-2 text-sm text-red-600">
                        <i class="fas fa-exclamation-triangle"></i>
                        <span>Your passport has expired. Please renew it before booking.</span>
                    </div>
                <?php elseif(Auth::user()->passport_expiry && Auth::user()->passport_expiry->diffInMonths(now()) < 6): ?>
                    <div class="mt-2 flex items-center space-x-2 text-sm text-amber-600">
                        <i class="fas fa-exclamation-circle"></i>
                        <span>Your passport expires soon. Many countries require 6 months validity.</span>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Save Button -->
        <div class="border-t border-gray-200 pt-6">
            <div class="flex justify-end">
                <button type="submit"
                        class="inline-flex items-center px-8 py-3 bg-gradient-to-r from-primary-600 to-primary-700 text-white font-semibold rounded-xl hover:from-primary-700 hover:to-primary-800 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500 transition-all duration-200 shadow-lg hover:shadow-xl">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12" />
                    </svg>
                    Save Changes
                </button>
            </div>
        </div>
    </form>
</div>


<script>
document.addEventListener('DOMContentLoaded', function() {
    const countrySelect = document.querySelector('select[name="country"]');

    // Set the selected country value
    if (countrySelect) {
        const userCountry = "<?php echo e(Auth::user()->country); ?>";
        if (userCountry) {
            countrySelect.value = userCountry;
        }
    }
});

function handleFormSubmit(event) {
    event.preventDefault();

    const form = event.target;
    const submitButton = form.querySelector('button[type="submit"]');
    const formData = new FormData(form);

    // Show loading state
    submitButton.disabled = true;
    const originalText = submitButton.innerHTML;
    submitButton.innerHTML = `
        <svg class="animate-spin -ml-1 mr-3 h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
        </svg>
        Saving...
    `;

    // Submit form via fetch
    fetch(form.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        // Reset button
        submitButton.disabled = false;
        submitButton.innerHTML = originalText;

        if (data.status === 200) {
            showNotification('Success!', data.success, 'success');
        } else {
            showNotification('Error!', data.message || 'Something went wrong.', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        submitButton.disabled = false;
        submitButton.innerHTML = originalText;
        showNotification('Error!', 'An error occurred while updating your profile.', 'error');
    });

    return false;
}

function showNotification(title, message, type) {
    // Remove any existing notifications
    const existingNotifications = document.querySelectorAll('.notification-toast');
    existingNotifications.forEach(notif => notif.remove());

    // Create notification
    const notification = document.createElement('div');
    notification.className = 'notification-toast fixed top-4 right-4 z-50 max-w-sm w-full transform transition-all duration-300 ease-in-out translate-x-full';

    const bgColor = type === 'success' ? 'bg-green-50 border-green-200' : 'bg-red-50 border-red-200';
    const iconColor = type === 'success' ? 'text-green-500' : 'text-red-500';
    const textColor = type === 'success' ? 'text-green-800' : 'text-red-800';
    const icon = type === 'success'
        ? '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>'
        : '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>';

    notification.innerHTML = `
        <div class="${bgColor} border rounded-lg shadow-lg p-4">
            <div class="flex items-start">
                <div class="flex-shrink-0">
                    <svg class="w-6 h-6 ${iconColor}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        ${icon}
                    </svg>
                </div>
                <div class="ml-3 w-0 flex-1">
                    <p class="text-sm font-medium ${textColor}">${title}</p>
                    <p class="mt-1 text-sm text-gray-600">${message}</p>
                </div>
                <div class="ml-4 flex-shrink-0 flex">
                    <button class="inline-flex text-gray-400 hover:text-gray-500 focus:outline-none" onclick="this.closest('.notification-toast').remove()">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
            </div>
        </div>
    `;

    document.body.appendChild(notification);

    // Animate in
    setTimeout(() => {
        notification.classList.remove('translate-x-full');
    }, 100);

    // Auto remove after 5 seconds
    setTimeout(() => {
        notification.classList.add('translate-x-full');
        setTimeout(() => {
            if (notification.parentNode) {
                notification.remove();
            }
        }, 300);
    }, 5000);
}
</script>
<?php /**PATH C:\xampp\htdocs\flight\resources\views/profile/update-profile-information-form.blade.php ENDPATH**/ ?>