<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $bg = 'light';
    $text = 'dark';
    $gradient = 'primary';
} else {
    $bg = 'dark';
    $text = 'light';
    $gradient = 'dark';
}

?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-panel">
        <div class="content ">
            <div class="panel-header bg-<?php echo e($gradient); ?>-gradient">
                <div class="py-5 page-inner">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div>
                            <h2 class="pb-2 text-white fw-bold">Dashboard</h2>
                            <h5 class="mb-2 text-white op-7">Welcome, <?php echo e(Auth('admin')->User()->firstName); ?>

                                <?php echo e(Auth('admin')->User()->lastName); ?>!</h5>
                        </div>
                        <?php if(Auth('admin')->User()->type == 'Super Admin' || Auth('admin')->User()->type == 'Admin'): ?>
                            <div class="py-2 ml-md-auto py-md-0">
                                <a href="<?php echo e(route('mdeposits')); ?>" class="mr-2 btn btn-success btn-border ">Deposits</a>
                               
                                <a href="<?php echo e(route('admin.bookings.index')); ?>" class="mr-2 btn btn-info btn-border ">Flight Bookings</a>
                                <a href="<?php echo e(route('manageusers')); ?>" class="btn btn-secondary ">Users</a>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
            <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
            <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
            <div class="page-inner mt--5">
                <!-- Beginning of  Dashboard Stats  -->
                <div class="row row-card-no-pd  shadow-lg mt--2">
                    <div class="col-sm-6 col-md-3">
                        <div class="card card-stats card-round  full-height">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-4">
                                        <div class="text-center icon-big">
                                            <i class="fas fa-plane text-primary"></i>
                                        </div>
                                    </div>
                                    <div class="col-8 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Total Bookings</p>
                                            <h4 class="card-title"><?php echo e(number_format($total_bookings)); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-md-3">
                        <div class="card card-stats card-round  full-height">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-4">
                                        <div class="text-center icon-big">
                                            <i class="fas fa-plane-departure text-success"></i>
                                        </div>
                                    </div>
                                    <div class="col-8 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Confirmed Bookings</p>
                                            <h4 class="card-title"><?php echo e(number_format($confirmed_bookings)); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-md-3">
                        <div class="card card-stats card-round ">
                            <div class="card-body ">
                                <div class="row">
                                    <div class="col-4">
                                        <div class="text-center icon-big">
                                            <i class="flaticon-users text-success"></i>
                                        </div>
                                    </div>
                                    <div class="col-8 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Total Users</p>
                                            <h4 class="card-title "><?php echo e(number_format($user_count)); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-md-3">
                        <div class="card card-stats card-round ">
                            <div class="card-body ">
                                <div class="row">
                                    <div class="col-4">
                                        <div class="text-center icon-big">
                                            <i class="flaticon-remove-user text-danger"></i>
                                        </div>
                                    </div>
                                    <div class="col-8 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Block Users</p>
                                            <h4 class="card-title "><?php echo e($blockeusers); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-md-3">
                        <div class="card card-stats card-round ">
                            <div class="card-body ">
                                <div class="row">
                                    <div class="col-4">
                                        <div class="text-center icon-big">
                                            <i class="flaticon-user-2 text-success"></i>
                                        </div>
                                    </div>
                                    <div class="col-8 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Active Users</p>
                                            <h4 class="card-title "><?php echo e($activeusers); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-6 col-md-3">
                        <div class="card card-stats card-round ">
                            <div class="card-body ">
                                <div class="row">
                                    <div class="col-4">
                                        <div class="text-center icon-big">
                                            <i class="fas fa-ban text-danger"></i>
                                        </div>
                                    </div>
                                    <div class="col-8 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Cancelled Bookings</p>s</p>
                                            <h4 class="card-title "><?php echo e(number_format($cancelled_bookings)); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-6 col-md-3">
                        <div class="card card-stats card-round ">
                            <div class="card-body ">
                                <div class="row">
                                    <div class="col-4">
                                        <div class="text-center icon-big">
                                            <i class="fas fa-hourglass-half text-warning"></i>
                                        </div>
                                    </div>
                                    <div class="col-8 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Pending Bookings</p>p>
                                            <h4 class="card-title "><?php echo e(number_format($pending_bookings)); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Recent Email Transactions -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex align-items-center">
                                    <h4 class="card-title">Recent Flight Bookings</h4>
                                    <a href="<?php echo e(route('admin.bookings.index')); ?>" class="btn btn-primary btn-round ml-auto">
                                        <i class="fa fa-plus"></i>
                                        View All
                                    </a>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Booking ID</th>
                                                <th>User</th>
                                                <th>Flight Details</th>
                                                <th>Passenger Name</th>
                                                <th>Amount</th>
                                                <th>Status</th>
                                                <th>Booking Date</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <strong><?php echo e($booking->booking_reference); ?></strong>
                                                        <br>
                                                        <small class="text-muted">#<?php echo e(str_pad($booking->id, 6, '0', STR_PAD_LEFT)); ?></small>
                                                    </td>
                                                    <td>
                                                        <strong><?php echo e($booking->user->name); ?></strong>
                                                        <br>
                                                        <small class="text-muted"><?php echo e($booking->user->email); ?></small>
                                                    </td>
                                                    <td>
                                                        <strong><?php echo e($booking->flight->airline); ?></strong>
                                                        <br>
                                                        <small class="text-muted"><?php echo e($booking->flight->flight_number); ?></small>
                                                        <br>
                                                        <small class="text-muted"><?php echo e($booking->flight->originAirport->iata_code); ?> → <?php echo e($booking->flight->destinationAirport->iata_code); ?></small>
                                                    </td>
                                                    <td><?php echo e($booking->passenger_name); ?></td>
                                                    <td>
                                                        <strong><?php echo e($settings->currency); ?><?php echo e(number_format($booking->price_paid, 2)); ?></strong>
                                                    </td>
                                                    <td>
                                                        <?php if($booking->payment_status == 'paid'): ?>
                                                            <span class="badge badge-success">
                                                                <i class="fas fa-check"></i> Paid
                                                            </span>
                                                        <?php elseif($booking->payment_status == 'pending'): ?>
                                                            <span class="badge badge-warning">
                                                                <i class="fas fa-clock"></i> Pending
                                                            </span>
                                                        <?php elseif($booking->payment_status == 'failed'): ?>
                                                            <span class="badge badge-danger">
                                                                <i class="fas fa-times"></i> Failed
                                                            </span>
                                                        <?php else: ?>
                                                            <span class="badge badge-info">
                                                                <i class="fas fa-undo"></i> Refunded
                                                            </span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php echo e(\Carbon\Carbon::parse($booking->created_at)->format('M j, Y g:i A')); ?>

                                                        <br>
                                                        <small class="text-muted">Flight: <?php echo e($booking->flight->departure_time->format('M j, Y')); ?></small>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group" role="group">
                                                            <a href="<?php echo e(route('admin.bookings.show', $booking->id)); ?>"
                                                               class="btn btn-info btn-sm" title="View Details">
                                                                <i class="fa fa-eye"></i>
                                                            </a>

                                                            <?php if($booking->status !== 'cancelled'): ?>
                                                            <form action="<?php echo e(route('admin.bookings.cancel', $booking->id)); ?>"
                                                                  method="POST" style="display: inline;">
                                                                <?php echo csrf_field(); ?>
                                                                <button type="submit" class="btn btn-danger btn-sm"
                                                                        title="Cancel Booking"
                                                                        onclick="return confirm('Are you sure you want to cancel this booking?')">
                                                                    <i class="fa fa-times"></i>
                                                                </button>
                                                            </form>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>

                                    <?php if(count($bookings) == 0): ?>
                                    <div class="text-center py-5">
                                        <i class="fas fa-plane fa-3x text-muted mb-3"></i>
                                        <h4 class="text-muted">No Flight Bookings Found</h4>
                                        <p class="text-muted">No users have made any flight bookings yet.</p>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\flight\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>