<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
    $bg = 'light';
} else {
    $text = 'light';
    $bg = 'dark';
}
?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-panel">
        <div class="content ">
            <div class="page-inner">

                <!-- Alert Messages Section -->
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fa fa-exclamation-triangle mr-2"></i>
                            <div>
                                <strong>Validation Error!</strong>
                                <ul class="mb-0 mt-2">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fa fa-check-circle mr-2"></i>
                            <div>
                                <strong>Success!</strong>
                                <p class="mb-0 mt-1"><?php echo e(session('success')); ?></p>
                            </div>
                        </div>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fa fa-times-circle mr-2"></i>
                            <div>
                                <strong>Error!</strong>
                                <p class="mb-0 mt-1"><?php echo e(session('error')); ?></p>
                            </div>
                        </div>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if(session('message')): ?>
                    <?php
                        $status = session('status', 'info');
                        $alertClass = [
                            'success' => 'alert-success',
                            'error' => 'alert-danger',
                            'warning' => 'alert-warning',
                            'info' => 'alert-info'
                        ][$status] ?? 'alert-info';

                        $iconClass = [
                            'success' => 'fa-check-circle',
                            'error' => 'fa-times-circle',
                            'warning' => 'fa-exclamation-triangle',
                            'info' => 'fa-info-circle'
                        ][$status] ?? 'fa-info-circle';
                    ?>
                    <div class="alert <?php echo e($alertClass); ?> alert-dismissible fade show" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fa <?php echo e($iconClass); ?> mr-2"></i>
                            <div>
                                <strong><?php echo e(ucfirst($status)); ?>!</strong>
                                <p class="mb-0 mt-1"><?php echo e(session('message')); ?></p>
                            </div>
                        </div>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if(session('warning')): ?>
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fa fa-exclamation-triangle mr-2"></i>
                            <div>
                                <strong>Warning!</strong>
                                <p class="mb-0 mt-1"><?php echo e(session('warning')); ?></p>
                            </div>
                        </div>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if(session('info')): ?>
                    <div class="alert alert-info alert-dismissible fade show" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fa fa-info-circle mr-2"></i>
                            <div>
                                <strong>Information!</strong>
                                <p class="mb-0 mt-1"><?php echo e(session('info')); ?></p>
                            </div>
                        </div>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <!-- Beginning of  Dashboard Stats  -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="p-3 card ">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-12 ">
                                        <h1 class="d-inline text-primary"><?php echo e($user->name); ?></h1><span></span>
                                        <div class="d-inline">
                                            <div class="float-right btn-group">
                                                <a class="btn btn-primary btn-sm" href="<?php echo e(route('manageusers')); ?>"> <i
                                                        class="fa fa-arrow-left"></i> back</a> &nbsp;
                                                <button type="button" class="btn btn-secondary dropdown-toggle btn-sm"
                                                    data-toggle="dropdown" data-display="static" aria-haspopup="true"
                                                    aria-expanded="false">
                                                    Actions
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-lg-right">
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(route('loginactivity', $user->id)); ?>">Login Activity</a>
                                                    <?php if($user->status == null || $user->status == 'blocked'): ?>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(url('admin/dashboard/uunblock')); ?>/<?php echo e($user->id); ?>">Unblock</a>
                                                    <?php else: ?>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(url('admin/dashboard/uublock')); ?>/<?php echo e($user->id); ?>">Block</a>
                                                    <?php endif; ?>
                                                    <?php if($user->email_verified_at): ?>
                                                    <?php else: ?>
                                                        <a href="<?php echo e(url('admin/dashboard/email-verify')); ?>/<?php echo e($user->id); ?>"
                                                            class="dropdown-item">Verify Email</a>
                                                    <?php endif; ?>
                                                    <a href="#" data-toggle="modal" data-target="#topupModal"
                                                        class="dropdown-item">Credit/Debit</a>


                                                    <a href="#" data-toggle="modal" data-target="#resetpswdModal"
                                                        class="dropdown-item">Reset Password</a>
                                                    <a href="#" data-toggle="modal" data-target="#clearacctModal"
                                                        class="dropdown-item">Clear Account</a>
                                                    <a href="#" data-toggle="modal" data-target="#edituser"
                                                        class="dropdown-item">Edit</a>
                                                    <a href="<?php echo e(route('showusers', $user->id)); ?>" class="dropdown-item">Add
                                                        Referral</a>
                                                    <a href="#" data-toggle="modal"
                                                        data-target="#sendmailtooneuserModal" class="dropdown-item">Send
                                                        Email</a>
                                                    <a href="#" data-toggle="modal" data-target="#switchuserModal"
                                                        class="dropdown-item text-success">Login as <?php echo e($user->name); ?></a>
                                                    <a href="#" data-toggle="modal" data-target="#deleteModal"
                                                        class="dropdown-item text-danger">Delete <?php echo e($user->name); ?></a>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="p-3 mt-4 border rounded row ">
                                    
                                    <div class="col-md-3">
                                        <h5>Total Bookings</h5>
                                        <p class="text-primary font-weight-bold"><?php echo e($stats['total']); ?></p>
                                    </div>
                                    <div class="col-md-3">
                                        <h5>Confirmed Bookings</h5>
                                        <p class="text-success font-weight-bold"><?php echo e($stats['confirmed']); ?></p>
                                    </div>
                                    <div class="col-md-3">
                                        <h5>Pending Payment</h5>
                                        <p class="text-warning font-weight-bold"><?php echo e($stats['pending']); ?></p>
                                    </div>
                                    <div class="col-md-3">
                                        <h5>Completed Trips</h5>
                                        <p class="text-info font-weight-bold"><?php echo e($stats['completed']); ?></p>
                                    </div>
                                    <div class="col-md-3">
                                        <h5>Cancelled Bookings</h5>
                                        <p class="text-danger font-weight-bold"><?php echo e($stats['cancelled']); ?></p>
                                    </div>
                                    <div class="col-md-3">
                                        <h5>Total Spent</h5>
                                        <p class="text-success font-weight-bold"><?php echo e($settings->currency); ?><?php echo e(number_format($stats['total_spent'], 2)); ?></p>
                                    </div>
                                    <div class="col-md-3">
                                        <h5>User Account Status</h5>
                                        <?php if($user->status == 'blocked'): ?>
                                            <span class="badge badge-danger">Blocked</span>
                                        <?php else: ?>
                                            <span class="badge badge-success">Active</span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-md-3">
                                        <h5>Email Verified</h5>
                                        <?php if($user->email_verified_at): ?>
                                            <span class="badge badge-success">Verified</span>
                                        <?php else: ?>
                                            <span class="badge badge-danger">Not Verified</span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-md-3">
                                        <h5>Join Date</h5>
                                        <p><?php echo e(\Carbon\Carbon::parse($user->created_at)->format('M j, Y')); ?></p>
                                    </div>
                                </div>
                                <div class="mt-3 row ">
                                    <div class="col-md-12">
                                        <h5>USER INFORMATION</h5>
                                    </div>
                                </div>
                                <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Fullname</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5><?php echo e($user->passenger_namee); ?></h5>
                                    </div>
                                </div>
                                <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Email Address</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5><?php echo e($user->passenger_email); ?></h5>
                                    </div>
                                </div>
                                <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Mobile Number</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5><?php echo e($user->passenger_phone); ?></h5>
                                    </div>
                                </div>
                                <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Date of birth</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5><?php echo e($user->passenger_dob); ?></h5>
                                    </div>
                                </div>
                                <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Nationality</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5><?php echo e($user->passenger_country); ?></h5>
                                    </div>
                                </div>



                                 <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Passport Number</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5><?php echo e($user->passport_number); ?></h5>
                                    </div>
                                </div>
                                
                                <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Registered</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5><?php echo e(\Carbon\Carbon::parse($user->created_at)->toDayDateTimeString()); ?></h5>
                                    </div>
                                </div>

                                <!-- User Flight Bookings Section -->
                                <div class="mt-4 row">
                                    <div class="col-md-12">
                                        <h5><?php echo e($user->name); ?>'S FLIGHT BOOKINGS</h5>
                                    </div>
                                </div>

                                <?php if($bookings->count() > 0): ?>
                                <div class="table-responsive mt-3">
                                    <table class="table table-hover">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Booking Ref</th>
                                                <th>Flight Details</th>
                                                <th>Route</th>
                                                <th>Passenger</th>
                                                <th>Amount</th>
                                                <th>Payment</th>
                                                <th>Status</th>
                                                <th>Date</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <strong class="text-primary"><?php echo e($booking->booking_reference); ?></strong>
                                                        <br>
                                                        <small class="text-muted">#<?php echo e($booking->id); ?></small>
                                                    </td>
                                                    <td>
                                                        <strong><?php echo e($booking->flight->airline); ?></strong>
                                                        <br>
                                                        <small class="text-muted"><?php echo e($booking->flight->flight_number); ?></small>
                                                        <?php if($booking->seat_number): ?>
                                                        <br>
                                                        <small class="badge badge-info">Seat <?php echo e($booking->seat_number); ?></small>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <strong><?php echo e($booking->flight->originAirport->iata_code); ?></strong>
                                                        <i class="fas fa-arrow-right text-muted mx-1"></i>
                                                        <strong><?php echo e($booking->flight->destinationAirport->iata_code); ?></strong>
                                                        <br>
                                                        <small class="text-muted">
                                                            <?php echo e($booking->flight->departure_time->format('M j, g:i A')); ?>

                                                        </small>
                                                    </td>
                                                    <td>
                                                        <?php echo e($booking->passenger_name); ?>

                                                        <br>
                                                        <small class="text-muted"><?php echo e($booking->passenger_email); ?></small>
                                                    </td>
                                                    <td>
                                                        <strong><?php echo e($settings->currency); ?><?php echo e(number_format($booking->price_paid, 2)); ?></strong>
                                                    </td>
                                                    <td>
                                                        <?php if($booking->payment_status == 'paid'): ?>
                                                            <span class="badge badge-success">
                                                                <i class="fas fa-check"></i> Paid
                                                            </span>
                                                        <?php elseif($booking->payment_status == 'pending'): ?>
                                                            <span class="badge badge-warning">
                                                                <i class="fas fa-clock"></i> Pending
                                                            </span>
                                                        <?php elseif($booking->payment_status == 'refunded'): ?>
                                                            <span class="badge badge-info">
                                                                <i class="fas fa-undo"></i> Refunded
                                                            </span>
                                                        <?php else: ?>
                                                            <span class="badge badge-danger">
                                                                <i class="fas fa-times"></i> Failed
                                                            </span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if($booking->status == 'confirmed'): ?>
                                                            <span class="badge badge-success">
                                                                <i class="fas fa-check-circle"></i> Confirmed
                                                            </span>
                                                        <?php elseif($booking->status == 'cancelled'): ?>
                                                            <span class="badge badge-danger">
                                                                <i class="fas fa-times-circle"></i> Cancelled
                                                            </span>
                                                        <?php elseif($booking->status == 'checked_in'): ?>
                                                            <span class="badge badge-primary">
                                                                <i class="fas fa-plane"></i> Checked In
                                                            </span>
                                                        <?php else: ?>
                                                            <span class="badge badge-secondary">
                                                                <i class="fas fa-flag-checkered"></i> Completed
                                                            </span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php echo e(\Carbon\Carbon::parse($booking->created_at)->format('M j, Y')); ?>

                                                        <br>
                                                        <small class="text-muted"><?php echo e(\Carbon\Carbon::parse($booking->created_at)->format('g:i A')); ?></small>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group" role="group">
                                                            <a href="<?php echo e(route('admin.bookings.show', $booking->id)); ?>"
                                                               class="btn btn-info btn-sm" title="View Details">
                                                                <i class="fa fa-eye"></i>
                                                            </a>
                                                            <?php if($booking->payment_status === 'pending'): ?>
                                                            <form action="<?php echo e(route('admin.bookings.approve-payment', $booking->id)); ?>"
                                                                  method="POST" style="display: inline;">
                                                                <?php echo csrf_field(); ?>
                                                                <button type="submit" class="btn btn-success btn-sm"
                                                                        title="Approve Payment"
                                                                        onclick="return confirm('Approve this booking payment?')">
                                                                    <i class="fa fa-check"></i>
                                                                </button>
                                                            </form>
                                                            <?php endif; ?>
                                                            <?php if($booking->status === 'confirmed' && $booking->payment_status === 'paid'): ?>
                                                            <form action="<?php echo e(route('admin.bookings.cancel', $booking->id)); ?>"
                                                                  method="POST" style="display: inline;">
                                                                <?php echo csrf_field(); ?>
                                                                <button type="submit" class="btn btn-danger btn-sm"
                                                                        title="Cancel Booking"
                                                                        onclick="return confirm('Cancel this booking?')">
                                                                    <i class="fa fa-times"></i>
                                                                </button>
                                                            </form>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                                <?php else: ?>
                                <div class="text-center py-5">
                                    <i class="fas fa-plane fa-3x text-muted mb-3"></i>
                                    <h5 class="text-muted">No Flight Bookings Found</h5>
                                    <p class="text-muted"><?php echo e($user->name); ?> hasn't made any flight bookings yet.</p>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo $__env->make('admin.Users.users_actions', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\flight\resources\views/admin/Users/userdetails.blade.php ENDPATH**/ ?>