<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-panel">
        <div class="content ">
            <div class="panel-header bg-<?php echo e($gradient); ?>-gradient">
                <div class="py-5 page-inner">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div>
                            <h2 class="pb-2 text-white fw-bold">Airports Management</h2>
                            <h5 class="mb-2 text-white op-7">Manage airport information</h5>
                        </div>
                        <div class="py-2 ml-md-auto py-md-0">
                            <a href="<?php echo e(route('admin.flights.index')); ?>" class="mr-2 btn btn-info btn-border">
                                <i class="fas fa-plane"></i> Flights
                            </a>
                            <a href="<?php echo e(route('admin.airports.create')); ?>" class="btn btn-success btn-border">
                                <i class="fas fa-plus"></i> Add Airport
                            </a>
                        </div>
                    </div>
                </div>
            </div>
             <div class="page-inner mt--5">
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> <?php echo e(session('success')); ?>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                
                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> <?php echo e(session('error')); ?>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Validation Error!</strong> Please check the form for errors.
                        <ul class="mb-0 mt-2">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
            </div>
            
            <div class="page-inner mt--5">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-map-marker-alt"></i> Airports 
                                    <span class="badge badge-primary"><?php echo e($airports->total()); ?></span>
                                </h4>
                            </div>
                            <div class="card-body">
                                <?php if($airports->count() > 0): ?>
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Code</th>
                                                    <th>Airport Name</th>
                                                    <th>Location</th>
                                                    <th>Timezone</th>
                                                    <th>Status</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $airports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $airport): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td>
                                                            <strong><?php echo e($airport->iata_code); ?></strong>
                                                            <?php if($airport->icao_code): ?>
                                                                <br><small class="text-muted"><?php echo e($airport->icao_code); ?></small>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td>
                                                            <strong><?php echo e($airport->name); ?></strong>
                                                        </td>
                                                        <td>
                                                            <?php echo e($airport->city); ?>, <?php echo e($airport->country); ?>

                                                            <?php if($airport->latitude && $airport->longitude): ?>
                                                                <br><small class="text-muted"><?php echo e($airport->latitude); ?>, <?php echo e($airport->longitude); ?></small>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td>
                                                            <small><?php echo e($airport->timezone); ?></small>
                                                        </td>
                                                        <td>
                                                            <span class="badge badge-<?php echo e($airport->active ? 'success' : 'secondary'); ?>">
                                                                <?php echo e($airport->active ? 'Active' : 'Inactive'); ?>

                                                            </span>
                                                        </td>
                                                        <td>
                                                            <div class="btn-group">
                                                                <a href="<?php echo e(route('admin.airports.show', $airport)); ?>" class="btn btn-sm btn-info" title="View">
                                                                    <i class="fas fa-eye"></i>
                                                                </a>
                                                                <a href="<?php echo e(route('admin.airports.edit', $airport)); ?>" class="btn btn-sm btn-warning" title="Edit">
                                                                    <i class="fas fa-edit"></i>
                                                                </a>
                                                                <form method="POST" action="<?php echo e(route('admin.airports.destroy', $airport)); ?>" style="display: inline;" onsubmit="return confirm('Are you sure?')">
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php echo method_field('DELETE'); ?>
                                                                    <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                                                        <i class="fas fa-trash"></i>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                    <!-- Pagination -->
                                    <div class="d-flex justify-content-center">
                                        <?php echo e($airports->links()); ?>

                                    </div>
                                <?php else: ?>
                                    <div class="text-center py-5">
                                        <i class="fas fa-map-marker-alt fa-3x text-muted mb-3"></i>
                                        <h4>No airports found</h4>
                                        <p class="text-muted">Start by adding airport information.</p>
                                        <a href="<?php echo e(route('admin.airports.create')); ?>" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Add Airport
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\flash\resources\views/admin/airports/index.blade.php ENDPATH**/ ?>