<?php

use App\Http\Controllers\Admin\ClearCacheController;
use Illuminate\Support\Facades\Route;
use App\Models\Settings;
use Laravel\Fortify\Http\Controllers\NewPasswordController;
use App\Http\Controllers\AutoTaskController;
use App\Http\Controllers\HomePageController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

require __DIR__ . '/admin/web.php';
require __DIR__ . '/user/web.php';
require __DIR__ . '/botman.php';



//cron url
Route::get('/cron', [AutoTaskController::class, 'autotopup'])->name('cron');
//Front Pages Route
Route::get('/', 'App\Http\Controllers\User\FlightSearchController@index')->name('home');
Route::get('about', function () {
    return view('home.about');
})->name('about');
Route::get('contact', function () {
    return view('home.contact');
})->name('contact');
Route::get('faq', function () {
    return view('home.faq');
})->name('faq');
Route::get('terms', [HomePageController::class, 'terms'])->name('terms');
Route::get('privacy', [HomePageController::class, 'privacy'])->name('privacy');



// Route::get('pricing', [HomePageController::class, 'pricing'])->name('pricing');
// Route::get('licences', [HomePageController::class, 'licences'])->name('licences');
// Route::get('risk', [HomePageController::class, 'risk'])->name('risk');
// Route::get('safety', [HomePageController::class, 'safety'])->name('safety');
// Route::get('service', [HomePageController::class, 'service'])->name('service');
// Route::get('trading', [HomePageController::class, 'trading'])->name('trading');
