@extends('layouts.softui')
@section('title', $title)
@section('content')

<div class="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100 py-8" x-data="transactionSuccess()">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">

        <!-- Email Errors Alert -->
        @if (!empty($emailErrors))
            <div class="mb-8" x-data="{ show: true }" x-show="show" x-transition>
                <div class="bg-red-50 border border-red-200 rounded-xl p-6">
                    <div class="flex items-start">
                        <svg class="w-6 h-6 text-red-600 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16c-.77.833.192 2.5 1.732 2.5z" />
                        </svg>
                        <div class="ml-4 flex-1">
                            <h3 class="text-lg font-semibold text-red-800 mb-2">Email Delivery Issues</h3>
                            <div class="space-y-1">
                                @foreach ($emailErrors as $error)
                                    <p class="text-red-700">{{ $error }}</p>
                                @endforeach
                            </div>
                        </div>
                        <button @click="show = false" class="flex-shrink-0 ml-4 text-red-400 hover:text-red-600 transition-colors">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        @endif

        <!-- Success Header -->
        <div class="text-center mb-8">
            <div class="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-br from-green-500 to-green-600 rounded-full shadow-lg mb-6">
                <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                </svg>
            </div>
            <h1 class="text-4xl font-bold text-gray-900 mb-3">Transaction Successful! 🎉</h1>
            <p class="text-xl text-gray-600 mb-6">Your email flash transaction has been generated and processed successfully</p>

            <!-- Auto-redirect countdown -->
            <div class="inline-flex items-center space-x-2 bg-primary-50 text-primary-700 px-4 py-2 rounded-full text-sm font-medium">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <span>Redirecting to dashboard in <span x-text="countdown"></span> seconds</span>
            </div>
        </div>

        <!-- Transaction Receipt Card -->
        <div class="bg-white rounded-2xl shadow-xl border border-gray-100 overflow-hidden">
            <!-- Receipt Header -->
            <div class="bg-gradient-to-r from-primary-600 via-primary-700 to-primary-800 px-8 py-6">
                <div class="flex items-center justify-between text-white">
                    <div>
                        <h2 class="text-2xl font-bold mb-1">Transaction Receipt</h2>
                        <p class="text-primary-100">Email Flashing System</p>
                    </div>
                    <div class="text-right">
                        <div class="inline-flex items-center bg-green-500 text-white px-3 py-1 rounded-full text-sm font-semibold">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                            Completed
                        </div>
                    </div>
                </div>
            </div>

            <!-- Receipt Body -->
            <div class="p-8">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                    <!-- Transaction Details -->
                    <div class="space-y-6">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                                <svg class="w-5 h-5 mr-2 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                                </svg>
                                Transaction Details
                            </h3>
                            <div class="space-y-4">
                                <!-- Exchange -->
                                <div class="flex items-center justify-between py-3 border-b border-gray-100">
                                    <span class="text-sm font-medium text-gray-600">Exchange Platform</span>
                                    <div class="flex items-center space-x-2">
                                        <div class="w-8 h-8 bg-gradient-to-br from-primary-500 to-primary-600 rounded-lg flex items-center justify-center">
                                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                                            </svg>
                                        </div>
                                        <span class="font-semibold text-gray-900">{{ $emailData['exchange'] }}</span>
                                    </div>
                                </div>

                                <!-- Cryptocurrency -->
                                <div class="flex items-center justify-between py-3 border-b border-gray-100">
                                    <span class="text-sm font-medium text-gray-600">Cryptocurrency</span>
                                    <div class="text-right">
                                        <span class="font-semibold text-gray-900">{{ $emailData['coin'] }}</span>
                                        <span class="text-sm text-gray-500 block">({{ $emailData['currency'] ?? $emailData['coin'] }})</span>
                                    </div>
                                </div>

                                <!-- Amount -->
                                <div class="flex items-center justify-between py-3 border-b border-gray-100">
                                    <span class="text-sm font-medium text-gray-600">Transaction Amount</span>
                                    <div class="text-right">
                                        <span class="text-2xl font-bold text-primary-600">{{ number_format($emailData['amount'], 8) }}</span>
                                        <span class="text-sm text-gray-500 block">{{ $emailData['coin'] }}</span>
                                    </div>
                                </div>

                                <!-- Status -->
                                <div class="flex items-center justify-between py-3 border-b border-gray-100">
                                    <span class="text-sm font-medium text-gray-600">Status</span>
                                    <div class="inline-flex items-center bg-green-100 text-green-800 px-3 py-1 rounded-full text-sm font-semibold">
                                        <div class="w-2 h-2 bg-green-500 rounded-full mr-2"></div>
                                        Confirmed
                                    </div>
                                </div>

                                <!-- Timestamp -->
                                <div class="flex items-center justify-between py-3">
                                    <span class="text-sm font-medium text-gray-600">Generated At</span>
                                    <span class="font-semibold text-gray-900">{{ $emailData['timestamp'] }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- System Details -->
                    <div class="space-y-6">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                                <svg class="w-5 h-5 mr-2 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                System Information
                            </h3>
                            <div class="space-y-4">
                                <!-- Transaction Hash -->
                                <div class="py-3 border-b border-gray-100">
                                    <span class="text-sm font-medium text-gray-600 block mb-2">Transaction Hash</span>
                                    <div class="bg-gray-50 rounded-xl p-4 border border-gray-200">
                                        <code class="text-sm font-mono text-gray-800 break-all">{{ $emailData['transactionHash'] }}</code>
                                        <button onclick="copyToClipboard('{{ $emailData['transactionHash'] }}')"
                                                class="ml-2 text-primary-600 hover:text-primary-700 transition-colors">
                                            <svg class="w-4 h-4 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                                            </svg>
                                        </button>
                                    </div>
                                </div>

                                <!-- Email Delivery -->
                                <div class="py-3 border-b border-gray-100">
                                    <div class="flex items-center justify-between">
                                        <span class="text-sm font-medium text-gray-600">Email Delivery Status</span>
                                        <div class="text-right">
                                            <span class="text-lg font-bold text-gray-900">{{ $emailsSent }}/2</span>
                                            <span class="text-sm text-gray-500 block">emails sent</span>
                                        </div>
                                    </div>
                                    <div class="mt-3">
                                        <div class="w-full bg-gray-200 rounded-full h-2">
                                            <div class="bg-gradient-to-r from-green-500 to-green-600 h-2 rounded-full transition-all duration-300"
                                                 style="width: {{ ($emailsSent / 2) * 100 }}%"></div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Service Info -->
                                <div class="py-3">
                                    <div class="bg-primary-50 rounded-xl p-4 border border-primary-100">
                                        <div class="flex items-start space-x-3">
                                            <svg class="w-5 h-5 text-primary-600 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                            <div>
                                                <h4 class="font-semibold text-primary-800 text-sm">Email Flash Service</h4>
                                                <p class="text-sm text-primary-700 mt-1">Professional email templates generated for demonstration purposes.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Footer Actions -->
                <div class="mt-8 pt-6 border-t border-gray-200">
                    <div class="text-center space-y-4">
                        <div class="bg-green-50 rounded-xl p-6 border border-green-100">
                            <svg class="w-12 h-12 text-green-600 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                            </svg>
                            <h3 class="text-lg font-semibold text-green-800 mb-2">Emails Successfully Delivered</h3>
                            <p class="text-green-700">Confirmation emails have been sent to all parties involved in this transaction.</p>
                        </div>

                        <div class="flex flex-col sm:flex-row gap-4 justify-center">
                            <a href="{{ route('dashboard') }}"
                               class="inline-flex items-center px-6 py-3 bg-primary-600 text-white font-semibold rounded-xl hover:bg-primary-700 transition-colors shadow-lg">
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2H3z" />
                                </svg>
                                Return to Dashboard
                            </a>
                            <a href="{{ route('flashservice') }}"
                               class="inline-flex items-center px-6 py-3 bg-white text-primary-600 font-semibold rounded-xl border-2 border-primary-600 hover:bg-primary-50 transition-colors">
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                                </svg>
                                Create Another Transaction
                            </a>
                        </div>

                        <p class="text-sm text-gray-600 mt-6">
                            Thank you for using our Email Flashing System!
                            <span class="text-primary-600 font-medium">Professional • Secure • Reliable</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function transactionSuccess() {
    return {
        countdown: 9,
        init() {
            const timer = setInterval(() => {
                this.countdown--;
                if (this.countdown <= 0) {
                    clearInterval(timer);
                    window.location.href = "{{ route('dashboard') }}";
                }
            }, 1000);
        }
    }
}

function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(() => {
        // Show a subtle notification
        const button = event.target.closest('button');
        const originalColor = button.className;
        button.innerHTML = '<svg class="w-4 h-4 inline text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>';
        setTimeout(() => {
            button.innerHTML = '<svg class="w-4 h-4 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"></path></svg>';
        }, 2000);
    });
}
</script>

@endsection
