
@extends('layouts.softui')
@section('title', $title)
@section('content')
<div class="min-h-screen bg-gradient-to-br from-gray-50 to-primary-50" x-data="{ activeSection: 'contact' }">
    <!-- Modern Header Section -->
    <div class="bg-gradient-to-r from-primary-600 via-primary-700 to-primary-800 text-white py-12 px-6 sm:px-8">
        <div class="max-w-7xl mx-auto">
            <div class="text-center">
                <div class="w-20 h-20 bg-white bg-opacity-20 rounded-2xl flex items-center justify-center mx-auto mb-6 backdrop-blur-sm">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192L5.636 18.364M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z" />
                    </svg>
                </div>
                <h1 class="text-3xl sm:text-4xl lg:text-5xl font-bold mb-4">24/7 Customer Support</h1>
                <p class="text-xl text-primary-100 max-w-2xl mx-auto">We're here to help you with your Email Flashing System needs. Get in touch with our dedicated support team.</p>
                <div class="mt-8 flex items-center justify-center space-x-2 bg-white bg-opacity-10 rounded-lg px-4 py-3 backdrop-blur-sm max-w-sm mx-auto">
                    <svg class="w-6 h-6 text-green-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <span class="text-primary-100 font-medium">Response within 24 hours</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Alert Messages -->
    <div class="max-w-7xl mx-auto px-6 sm:px-8 pt-6">
        <x-danger-alert />
        <x-success-alert />
    </div>

    <!-- Main Content -->
    <div class="max-w-7xl mx-auto px-6 sm:px-8 py-12">
        <!-- Quick Contact Options -->
        <div class="grid md:grid-cols-3 gap-8 mb-12">
            <!-- Email Support -->
            <div class="bg-white rounded-2xl shadow-xl p-8 text-center hover:shadow-2xl transition-all duration-300 border border-gray-100">
                <div class="w-16 h-16 bg-gradient-to-br from-primary-500 to-primary-600 rounded-xl flex items-center justify-center mx-auto mb-6">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-3">Email Support</h3>
                <p class="text-gray-600 mb-6">Send us your questions and we'll respond within 24 hours</p>
                <a href="mailto:{{$settings->contact_email}}"
                   class="inline-flex items-center px-6 py-3 bg-primary-600 text-white font-semibold rounded-lg hover:bg-primary-700 transition-colors duration-200">
                    {{$settings->contact_email}}
                </a>
            </div>

            <!-- Live Chat -->
            <div class="bg-white rounded-2xl shadow-xl p-8 text-center hover:shadow-2xl transition-all duration-300 border border-gray-100">
                <div class="w-16 h-16 bg-gradient-to-br from-green-500 to-green-600 rounded-xl flex items-center justify-center mx-auto mb-6">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z" />
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-3">Quick Response</h3>
                <p class="text-gray-600 mb-6">Use our contact form below for faster response times</p>
                <button @click="activeSection = 'contact'"
                        class="inline-flex items-center px-6 py-3 bg-green-600 text-white font-semibold rounded-lg hover:bg-green-700 transition-colors duration-200">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                    </svg>
                    Send Message
                </button>
            </div>

            <!-- Help Resources -->
            <div class="bg-white rounded-2xl shadow-xl p-8 text-center hover:shadow-2xl transition-all duration-300 border border-gray-100">
                <div class="w-16 h-16 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center mx-auto mb-6">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z" />
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-3">Self Service</h3>
                <p class="text-gray-600 mb-6">Browse common questions and troubleshooting guides</p>
                <button @click="activeSection = 'faq'"
                        class="inline-flex items-center px-6 py-3 bg-blue-600 text-white font-semibold rounded-lg hover:bg-blue-700 transition-colors duration-200">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    View FAQ
                </button>
            </div>
        </div>

        <!-- Support Sections -->
        <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
            <!-- Section Navigation -->
            <div class="border-b border-gray-200 bg-gray-50">
                <nav class="flex space-x-8 px-8 py-6" aria-label="Tabs">
                    <button @click="activeSection = 'contact'"
                            :class="activeSection === 'contact' ? 'border-primary-500 text-primary-600 bg-primary-50' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                            class="whitespace-nowrap py-3 px-6 border-b-2 font-medium text-sm rounded-lg transition-all duration-200 flex items-center space-x-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                        </svg>
                        <span>Contact Form</span>
                    </button>
                    <button @click="activeSection = 'faq'"
                            :class="activeSection === 'faq' ? 'border-primary-500 text-primary-600 bg-primary-50' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                            class="whitespace-nowrap py-3 px-6 border-b-2 font-medium text-sm rounded-lg transition-all duration-200 flex items-center space-x-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <span>FAQ</span>
                    </button>
                </nav>
            </div>

            <!-- Section Content -->
            <div class="p-8">
                <!-- Contact Form Section -->
                <div x-show="activeSection === 'contact'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform translate-y-4" x-transition:enter-end="opacity-100 transform translate-y-0">
                    <div class="max-w-3xl mx-auto">
                        <!-- Form Header -->
                        <div class="text-center mb-8">
                            <div class="w-16 h-16 bg-gradient-to-br from-primary-500 to-primary-600 rounded-xl flex items-center justify-center mx-auto mb-4">
                                <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8" />
                                </svg>
                            </div>
                            <h2 class="text-2xl font-semibold text-gray-900 mb-2">Send us a Message</h2>
                            <p class="text-gray-600">Tell us about your inquiry, suggestion, or any issues you're experiencing</p>
                        </div>

                        <!-- Contact Form -->
                        <form method="post" action="{{route('enquiry')}}" class="space-y-6">
                            @csrf
                            <input type="hidden" name="name" value="{{Auth::user()->name}}" />
                            <input type="hidden" name="email" value="{{Auth::user()->email}}">

                            <!-- User Info Display -->
                            <div class="bg-primary-50 rounded-xl p-6 border border-primary-200">
                                <div class="flex items-center space-x-4">
                                    <div class="w-12 h-12 bg-gradient-to-br from-primary-500 to-primary-600 rounded-lg flex items-center justify-center">
                                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                        </svg>
                                    </div>
                                    <div>
                                        <p class="text-sm font-medium text-primary-800">Sending as:</p>
                                        <p class="text-primary-700">{{Auth::user()->name}} ({{Auth::user()->email}})</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Message Field -->
                            <div class="space-y-2">
                                <label for="message" class="block text-sm font-semibold text-gray-900">
                                    Your Message <span class="text-red-500">*</span>
                                </label>
                                <div class="relative">
                                    <textarea name="message"
                                              id="message"
                                              rows="6"
                                              class="block w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors duration-200 resize-none"
                                              placeholder="Please describe your inquiry, suggestion, or issue in detail. The more information you provide, the better we can assist you."
                                              required></textarea>
                                    <div class="absolute bottom-3 right-3 text-xs text-gray-400" x-data="{ count: 0 }">
                                        <span x-text="count"></span>/500 characters
                                        <script>
                                            document.getElementById('message').addEventListener('input', function() {
                                                document.querySelector('[x-data]').__x.$data.count = this.value.length;
                                            });
                                        </script>
                                    </div>
                                </div>
                                <p class="text-xs text-gray-500">Please be as detailed as possible to help us provide the best assistance.</p>
                            </div>

                            <!-- Submit Button -->
                            <div class="pt-4">
                                <button type="submit"
                                        class="w-full flex items-center justify-center gap-3 px-8 py-4 bg-gradient-to-r from-primary-600 to-primary-700 text-white font-semibold rounded-xl hover:from-primary-700 hover:to-primary-800 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500 transition-all duration-200 shadow-lg hover:shadow-xl">
                                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8" />
                                    </svg>
                                    Send Support Message
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                    </svg>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- FAQ Section -->
                <div x-show="activeSection === 'faq'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform translate-y-4" x-transition:enter-end="opacity-100 transform translate-y-0">
                    <div class="max-w-4xl mx-auto">
                        <!-- FAQ Header -->
                        <div class="text-center mb-8">
                            <div class="w-16 h-16 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center mx-auto mb-4">
                                <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                            </div>
                            <h2 class="text-2xl font-semibold text-gray-900 mb-2">Frequently Asked Questions</h2>
                            <p class="text-gray-600">Find quick answers to common questions about our Email Flashing System</p>
                        </div>

                        <!-- FAQ Items -->
                        <div class="space-y-4" x-data="{ openFaq: null }">
                            <div class="bg-gray-50 rounded-xl border border-gray-200">
                                <button @click="openFaq = openFaq === 1 ? null : 1"
                                        class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-primary-500 rounded-xl">
                                    <div class="flex items-center justify-between">
                                        <h3 class="text-lg font-semibold text-gray-900">How do I create an email flash transaction?</h3>
                                        <svg class="w-5 h-5 text-gray-500 transform transition-transform duration-200"
                                             :class="openFaq === 1 ? 'rotate-180' : ''"
                                             fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                                        </svg>
                                    </div>
                                </button>
                                <div x-show="openFaq === 1" x-transition class="px-6 pb-6">
                                    <p class="text-gray-600">Navigate to the Flash Service page, enter the recipient's email, amount, and select your preferred cryptocurrency. Follow the payment instructions to complete your transaction.</p>
                                </div>
                            </div>

                            <div class="bg-gray-50 rounded-xl border border-gray-200">
                                <button @click="openFaq = openFaq === 2 ? null : 2"
                                        class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-primary-500 rounded-xl">
                                    <div class="flex items-center justify-between">
                                        <h3 class="text-lg font-semibold text-gray-900">How long does it take to process transactions?</h3>
                                        <svg class="w-5 h-5 text-gray-500 transform transition-transform duration-200"
                                             :class="openFaq === 2 ? 'rotate-180' : ''"
                                             fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                                        </svg>
                                    </div>
                                </button>
                                <div x-show="openFaq === 2" x-transition class="px-6 pb-6">
                                    <p class="text-gray-600">Most email flash transactions are processed instantly. However, depending on network congestion and payment method, it may take up to 30 minutes for completion.</p>
                                </div>
                            </div>

                            <div class="bg-gray-50 rounded-xl border border-gray-200">
                                <button @click="openFaq = openFaq === 3 ? null : 3"
                                        class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-primary-500 rounded-xl">
                                    <div class="flex items-center justify-between">
                                        <h3 class="text-lg font-semibold text-gray-900">What payment methods do you accept?</h3>
                                        <svg class="w-5 h-5 text-gray-500 transform transition-transform duration-200"
                                             :class="openFaq === 3 ? 'rotate-180' : ''"
                                             fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                                        </svg>
                                    </div>
                                </button>
                                <div x-show="openFaq === 3" x-transition class="px-6 pb-6">
                                    <p class="text-gray-600">We accept major cryptocurrencies (Bitcoin, Ethereum, USDT), credit cards via Stripe, PayPal, bank transfers, and various other payment gateways for your convenience.</p>
                                </div>
                            </div>

                            <div class="bg-gray-50 rounded-xl border border-gray-200">
                                <button @click="openFaq = openFaq === 4 ? null : 4"
                                        class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-primary-500 rounded-xl">
                                    <div class="flex items-center justify-between">
                                        <h3 class="text-lg font-semibold text-gray-900">Is my personal information secure?</h3>
                                        <svg class="w-5 h-5 text-gray-500 transform transition-transform duration-200"
                                             :class="openFaq === 4 ? 'rotate-180' : ''"
                                             fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                                        </svg>
                                    </div>
                                </button>
                                <div x-show="openFaq === 4" x-transition class="px-6 pb-6">
                                    <p class="text-gray-600">Yes, we use industry-standard encryption and security measures to protect all user data. Your personal information is never shared with third parties without your consent.</p>
                                </div>
                            </div>
                        </div>

                        <!-- Still Need Help -->
                        <div class="mt-12 bg-gradient-to-br from-primary-50 to-primary-100 rounded-xl p-8 border border-primary-200 text-center">
                            <div class="w-12 h-12 bg-gradient-to-br from-primary-500 to-primary-600 rounded-lg flex items-center justify-center mx-auto mb-4">
                                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192L5.636 18.364M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z" />
                                </svg>
                            </div>
                            <h3 class="text-xl font-semibold text-primary-900 mb-2">Still need help?</h3>
                            <p class="text-primary-700 mb-6">Can't find what you're looking for? Our support team is here to help!</p>
                            <button @click="activeSection = 'contact'"
                                    class="inline-flex items-center px-6 py-3 bg-primary-600 text-white font-semibold rounded-lg hover:bg-primary-700 transition-colors duration-200">
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                </svg>
                                Contact Support Team
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
