@extends('layouts.softui')
@section('title', $title)
@section('content')
<div class="min-h-screen bg-gradient-to-br from-gray-50 to-primary-50" x-data="{ activeTab: 'personal' }">
    <!-- Modern Header Section -->
    <div class="bg-gradient-to-r from-primary-600 via-primary-700 to-primary-800 text-white py-8 px-6 sm:px-8">
        <div class="max-w-7xl mx-auto">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-4">
                    <div class="w-16 h-16 bg-white bg-opacity-20 rounded-xl flex items-center justify-center backdrop-blur-sm">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                        </svg>
                    </div>
                    <div>
                        <h1 class="text-2xl sm:text-3xl font-bold">Account Settings</h1>
                        <p class="text-primary-100 mt-1">Manage your flight booking profile and security settings</p>
                    </div>
                </div>
                <div class="hidden sm:flex items-center space-x-2 bg-white bg-opacity-10 rounded-lg px-3 py-2 backdrop-blur-sm">
                    <svg class="w-5 h-5 text-primary-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                    </svg>
                    <span class="text-primary-100 text-sm font-medium">Secure Profile</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Alert Messages -->
    <div class="max-w-7xl mx-auto px-6 sm:px-8 pt-6">
        <x-danger-alert />
        <x-success-alert />
        <x-error-alert />
    </div>

    <!-- Main Content -->
    <div class="max-w-7xl mx-auto px-6 sm:px-8 py-8">
        <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
            <!-- Tab Navigation -->
            <div class="border-b border-gray-200 bg-gray-50">
                <nav class="flex space-x-8 px-8 py-6" aria-label="Tabs">
                    <button @click="activeTab = 'personal'"
                            :class="activeTab === 'personal' ? 'border-primary-500 text-primary-600 bg-primary-50' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                            class="whitespace-nowrap py-3 px-6 border-b-2 font-medium text-sm rounded-lg transition-all duration-200 flex items-center space-x-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                        </svg>
                        <span>Personal Information</span>
                    </button>
                    <button @click="activeTab = 'security'"
                            :class="activeTab === 'security' ? 'border-primary-500 text-primary-600 bg-primary-50' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                            class="whitespace-nowrap py-3 px-6 border-b-2 font-medium text-sm rounded-lg transition-all duration-200 flex items-center space-x-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                        </svg>
                        <span>Security Settings</span>
                    </button>
                </nav>
            </div>

            <!-- Tab Content -->
            <div class="p-8">
                <!-- Personal Information Tab -->
                <div x-show="activeTab === 'personal'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform translate-y-4" x-transition:enter-end="opacity-100 transform translate-y-0">
                    @include('profile.update-profile-information-form')
                </div>

                <!-- Security Settings Tab -->
                <div x-show="activeTab === 'security'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform translate-y-4" x-transition:enter-end="opacity-100 transform translate-y-0">
                    @include('profile.update-password-form')
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
