@extends('layouts.softui')
@section('title', $title)
@section('content')

<div class="space-y-8" x-data="paymentHandler()">
    <!-- Header Section -->
    <div class="bg-gradient-to-r from-primary-600 via-primary-700 to-primary-800 rounded-2xl p-8 text-white shadow-xl">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
            <div class="mb-6 lg:mb-0">
                <h1 class="text-3xl lg:text-4xl font-bold mb-2">
                    Complete Payment 💳
                </h1>
                <p class="text-primary-100 text-lg">
                    Secure payment processing for your Email Flashing System account
                </p>
            </div>
            <div class="bg-white/20 backdrop-blur rounded-xl px-6 py-4">
                <div class="text-center">
                    <p class="text-primary-100 text-sm font-medium mb-1">Amount to Pay</p>
                    <p class="text-3xl font-bold text-white">{{ $settings->currency }}{{ number_format($amount) }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Alert Messages -->
    <x-danger-alert />
    <x-success-alert />
    <!-- Payment Method Info -->
    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden mb-8">
        <div class="bg-gradient-to-r from-gray-50 to-gray-100 px-8 py-6 border-b border-gray-200">
            <div class="flex items-center justify-between">
                <div>
                    <h2 class="text-2xl font-bold text-gray-900">Payment Method</h2>
                    <p class="text-gray-600 mt-1">Complete your payment using {{ $payment_mode->name }}</p>
                </div>
                <div class="flex items-center space-x-3">
                    <div class="w-12 h-12 bg-gradient-to-br from-primary-500 to-primary-600 rounded-xl flex items-center justify-center">
                        @if(str_contains(strtolower($payment_mode->name), 'bitcoin') || str_contains(strtolower($payment_mode->name), 'btc'))
                            <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M23.638 14.904c-1.602 6.43-8.113 10.34-14.542 8.736C2.67 22.05-1.244 15.525.362 9.105 1.962 2.67 8.475-1.243 14.9.358c6.43 1.605 10.342 8.115 8.738 14.546z"/>
                            </svg>
                        @elseif(str_contains(strtolower($payment_mode->name), 'ethereum') || str_contains(strtolower($payment_mode->name), 'eth'))
                            <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M11.944 17.97L4.58 13.62 11.943 24l7.37-10.38-7.372 4.35h.003zM12.056 0L4.69 12.223l7.365 4.354 7.365-4.35L12.056 0z"/>
                            </svg>
                        @elseif(str_contains(strtolower($payment_mode->name), 'credit') || str_contains(strtolower($payment_mode->name), 'card'))
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                            </svg>
                        @elseif(str_contains(strtolower($payment_mode->name), 'paypal'))
                            <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M7.076 21.337H2.47a.641.641 0 0 1-.633-.74L4.944.901C5.026.382 5.474 0 5.998 0h7.46c2.57 0 4.578.543 5.69 1.81 1.01 1.15 1.304 2.42 1.012 4.287-.023.143-.047.288-.077.434-.983 4.237-4.053 6.862-8.44 6.862H9.82a.641.641 0 0 0-.633.74l-.744 4.71a.568.568 0 0 1-.563.493zm2.15-13.298a.641.641 0 0 0-.633.74l-.744 4.71a.568.568 0 0 1-.562.493H4.696a.641.641 0 0 1-.633-.74l.744-4.71A.641.641 0 0 1 5.44 8.04h3.786z"/>
                            </svg>
                        @elseif(str_contains(strtolower($payment_mode->name), 'bank'))
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                            </svg>
                        @else
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                            </svg>
                        @endif
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-600">Selected Method</p>
                        <p class="font-semibold text-gray-900">{{ $payment_mode->name }}</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="p-8">
            @if ($title != 'Complete Payment')
                @php
                    if ($payment_mode->name == 'Bitcoin') {
                        $coin = 'BTC';
                    } elseif ($payment_mode->name == 'Litecoin') {
                        $coin = 'LTC';
                    } elseif ($payment_mode->name == 'Ethereum') {
                        $coin = 'ETH';
                    } elseif ($payment_mode->name == 'BUSD') {
                        $coin = 'BUSD';
                    } else {
                        $coin = 'USDT.TRC20';
                    }
                @endphp

                <!-- Payment Instructions -->
                <div class="mb-8">
                    <div class="bg-blue-50 border border-blue-200 rounded-xl p-6">
                        <div class="flex items-start space-x-3">
                            <svg class="w-6 h-6 text-blue-600 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            <div>
                                <h3 class="text-lg font-semibold text-blue-800 mb-2">Payment Instructions</h3>
                                <p class="text-blue-700">
                                    You are to make payment of <span class="font-bold">{{ $settings->currency }}{{ number_format($amount) }}</span> using {{ $payment_mode->name }}.
                                </p>
                            </div>
                        </div>
                    </div>

                    @if (!empty($payment_mode->barcode))
                    <div class="mt-6 text-center">
                        <div class="bg-white p-6 rounded-xl border border-gray-200 inline-block">
                            <img src="{{ $payment_mode->barcode }}" alt="Payment QR Code" class="max-w-xs mx-auto">
                            <p class="text-sm text-gray-600 mt-3">Scan QR code to pay</p>
                        </div>
                    </div>
                    @endif
                </div>

                <!-- Payment Processing Section -->
                <div class="space-y-8">
                    @if ($settings->deposit_option != 'manual')
                        @if (
                            $payment_mode->name == 'Bitcoin' or
                                $payment_mode->name == 'Litecoin' or
                                $payment_mode->name == 'Ethereum' or
                                $payment_mode->name == 'USDT' or
                                $payment_mode->name == 'BUSD')

                            <!-- Cryptocurrency Payment -->
                            <div class="bg-gradient-to-br from-primary-50 to-primary-100 rounded-xl p-6 border border-primary-200">
                                <div class="text-center">
                                    <div class="w-16 h-16 bg-gradient-to-br from-primary-500 to-primary-600 rounded-full flex items-center justify-center mx-auto mb-4">
                                        <svg class="w-8 h-8 text-white" fill="currentColor" viewBox="0 0 24 24">
                                            <path d="M23.638 14.904c-1.602 6.43-8.113 10.34-14.542 8.736C2.67 22.05-1.244 15.525.362 9.105 1.962 2.67 8.475-1.243 14.9.358c6.43 1.605 10.342 8.115 8.738 14.546z"/>
                                        </svg>
                                    </div>
                                    <h3 class="text-xl font-semibold text-primary-800 mb-2">{{ $payment_mode->name }} Payment</h3>
                                    <p class="text-primary-700 mb-6">Choose your preferred {{ $payment_mode->name }} payment method</p>

                                    @if ($payment_mode->name == 'USDT' and $settings->auto_merchant_option == 'Binance' and $settings->deposit_option == 'auto')
                                        <div class="bg-white rounded-lg p-4">
                                            <livewire:user.crypto-payment />
                                        </div>
                                    @else
                                        <a href="{{ url('dashboard/cpay') }}/{{ $amount }}/{{ $coin }}/{{ Auth::user()->id }}/new"
                                           class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-primary-600 to-primary-700 text-white font-semibold rounded-xl hover:from-primary-700 hover:to-primary-800 transition-all duration-200 shadow-lg hover:shadow-xl">
                                            <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                                            </svg>
                                            Pay Via Coinpayment
                                            <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                            </svg>
                                        </a>
                                    @endif
                                </div>
                            </div>
                        @else
                            @if ((!empty($payment_mode->barcode) or $payment_mode->barcode != null) and $payment_mode->methodtype != 'currency')
                                <div class="bg-white rounded-xl border border-gray-200 p-6">
                                    <div class="text-center">
                                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Payment QR Code</h3>
                                        <div class="inline-block bg-gray-50 p-6 rounded-xl">
                                            <img src="{{ asset('storage/' . $payment_mode->barcode) }}" alt="Payment QR Code" class="max-w-sm mx-auto">
                                        </div>
                                        <p class="text-sm text-gray-600 mt-4">Scan the QR code above to complete your payment</p>
                                    </div>
                                </div>
                            @endif
                        @endif
                    @endif
                    @if ($payment_mode->methodtype != 'currency')
                        @if (
                            ($payment_mode->name == 'Bitcoin' or
                                $payment_mode->name == 'Litecoin' or
                                $payment_mode->name == 'Ethereum' or
                                $payment_mode->name == 'USDT' or
                                $payment_mode->name == 'BUSD') and
                                $settings->deposit_option != 'manual')
                        @else
                            <!-- Wallet Address Section -->
                            <div class="bg-white rounded-xl border border-gray-200 p-6">
                                <h3 class="text-lg font-semibold text-gray-900 mb-4">{{ $payment_mode->name }} Wallet Address</h3>

                                <div class="space-y-4">
                                    <div>
                                        <label class="text-sm font-medium text-gray-700 block mb-2">Wallet Address</label>
                                        <div class="flex items-center bg-gray-50 rounded-lg border border-gray-200 overflow-hidden">
                                            <input type="text"
                                                   class="flex-1 px-4 py-3 bg-transparent text-gray-900 text-sm font-mono focus:outline-none"
                                                   value="{{ $payment_mode->wallet_address }}"
                                                   id="myInput"
                                                   readonly>
                                            <button class="px-4 py-3 bg-primary-600 text-white hover:bg-primary-700 transition-colors duration-200 flex items-center gap-2"
                                                    onclick="myFunction()"
                                                    type="button">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                                                </svg>
                                                Copy
                                            </button>
                                        </div>
                                    </div>

                                    <div class="bg-primary-50 rounded-lg p-4 border border-primary-200">
                                        <div class="flex items-start gap-3">
                                            <svg class="w-5 h-5 text-primary-600 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                            <div>
                                                <p class="text-sm font-medium text-primary-800">Network Type</p>
                                                <p class="text-sm text-primary-700">{{ $payment_mode->network }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    @else
                        <!-- Traditional Payment Methods -->
                        <div class="bg-white rounded-xl border border-gray-200 p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-6 flex items-center gap-3">
                                <div class="w-10 h-10 bg-gradient-to-br from-primary-500 to-primary-600 rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                                    </svg>
                                </div>
                                {{ $payment_mode->name }} Payment
                            </h3>

                            @if ($payment_mode->defaultpay == 'yes')
                                @if ($payment_mode->name == 'Credit Card' and $settings->credit_card_provider == 'Paystack')
                                    <?php $payamount = $amount * 100; ?>
                                    {{-- Paystack Payment Form --}}
                                    <div id="paystack" class="space-y-4">
                                        <div class="bg-primary-50 rounded-lg p-4 border border-primary-200">
                                            <div class="flex items-start gap-3">
                                                <svg class="w-5 h-5 text-primary-600 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                                                </svg>
                                                <div>
                                                    <p class="text-sm font-medium text-primary-800">Secure Payment</p>
                                                    <p class="text-sm text-primary-700">Your payment is processed securely through Paystack</p>
                                                </div>
                                            </div>
                                        </div>

                                        <form method="POST" action="{{ route('pay.paystack') }}" accept-charset="UTF-8" class="space-y-4">
                                            <input type="hidden" name="email" value="{{ Auth::user()->email }}">
                                            <input type="hidden" name="amount" value="{{ $payamount }}">
                                            <input type="hidden" name="currency" value="{{ $settings->s_currency }}">
                                            <input type="hidden" name="metadata" value="{{ json_encode($array = ['key_name' => 'value']) }}">
                                            <input type="hidden" name="reference" value="{{ Paystack::genTranxRef() }}">
                                            <input type="hidden" name="_token" value="{{ csrf_token() }}">

                                            <button type="submit"
                                                    class="w-full flex items-center justify-center gap-3 px-6 py-4 bg-gradient-to-r from-primary-600 to-primary-700 text-white font-semibold rounded-xl hover:from-primary-700 hover:to-primary-800 transition-all duration-200 shadow-lg hover:shadow-xl">
                                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                                                </svg>
                                                Pay with Credit Card
                                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                                </svg>
                                            </button>
                                        </form>
                                    </div>
                                @endif
                                @if ($payment_mode->name == 'Credit Card' and $settings->credit_card_provider == 'Flutterwave')
                                    {{-- Flutterwave Payment Form --}}
                                    <div class="space-y-4">
                                        <div class="bg-primary-50 rounded-lg p-4 border border-primary-200">
                                            <div class="flex items-start gap-3">
                                                <svg class="w-5 h-5 text-primary-600 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                                                </svg>
                                                <div>
                                                    <p class="text-sm font-medium text-primary-800">Secure Payment</p>
                                                    <p class="text-sm text-primary-700">Your payment is processed securely through Flutterwave</p>
                                                </div>
                                            </div>
                                        </div>

                                        <form method="POST" action="{{ route('paybyflutterwave') }}" class="space-y-4">
                                            {{ csrf_field() }}
                                            <input type="hidden" name="name" value="{{ Auth::user()->name }}" />
                                            <input name="email" type="hidden" value="{{ Auth::user()->email }}" />
                                            <input name="phone" type="hidden" value="{{ Auth::user()->phone }}" />
                                            <input name="amount" type="hidden" value="{{ $amount }}" />

                                            <button type="submit"
                                                    class="w-full flex items-center justify-center gap-3 px-6 py-4 bg-gradient-to-r from-primary-600 to-primary-700 text-white font-semibold rounded-xl hover:from-primary-700 hover:to-primary-800 transition-all duration-200 shadow-lg hover:shadow-xl">
                                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                                                </svg>
                                                Pay with Credit Card
                                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                                </svg>
                                            </button>
                                        </form>
                                    </div>
                                @endif
                                @if ($payment_mode->name == 'Credit Card' and $settings->credit_card_provider == 'Stripe')
                                    {{-- Stripe Payment Form --}}
                                    <div class="space-y-4">
                                        <div class="bg-primary-50 rounded-lg p-4 border border-primary-200">
                                            <div class="flex items-start gap-3">
                                                <svg class="w-5 h-5 text-primary-600 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                                                </svg>
                                                <div>
                                                    <p class="text-sm font-medium text-primary-800">Secure Payment</p>
                                                    <p class="text-sm text-primary-700">Your payment is processed securely through Stripe</p>
                                                </div>
                                            </div>
                                        </div>

                                        <form id="payment-form" class="sr-payment-form space-y-4">
                                            @csrf
                                            <div class="space-y-2">
                                                <label class="text-sm font-medium text-gray-700">Card Details</label>
                                                <div class="sr-combo-inputs-row">
                                                    <div class="sr-input sr-card-element bg-white border border-gray-300 rounded-lg p-4 focus-within:ring-2 focus-within:ring-primary-500 focus-within:border-primary-500" id="card-element">
                                                    </div>
                                                </div>
                                            </div>

                                            <button id="stripesubmit"
                                                    class="w-full flex items-center justify-center gap-3 px-6 py-4 bg-gradient-to-r from-primary-600 to-primary-700 text-white font-semibold rounded-xl hover:from-primary-700 hover:to-primary-800 transition-all duration-200 shadow-lg hover:shadow-xl disabled:opacity-50">
                                                <div class="spinner hidden animate-spin" id="spinner">
                                                    <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24">
                                                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                                    </svg>
                                                </div>
                                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                                                </svg>
                                                <span id="buttontext">Complete Payment</span>
                                            </button>
                                        </form>

                                        <div class="hidden" id="stripesuccess">
                                            <div class="bg-green-50 rounded-lg p-6 border border-green-200">
                                                <div class="flex items-center justify-center gap-3 text-green-800">
                                                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                    </svg>
                                                    <span class="font-medium">Payment Completed, redirecting...</span>
                                                </div>
                                            </div>
                                        </div>

                                        <form id="selectform" method="POST" action="javascript:void(0)" class="hidden">
                                            @csrf
                                            <input type="hidden" name="amount" value="{{ $amount }}">
                                        </form>
                                    </div>
                                @endif
                                @if ($payment_mode->name == 'Paypal')
                                    {{-- PayPal Payment Form --}}
                                    <div class="space-y-4">
                                        <div class="bg-primary-50 rounded-lg p-4 border border-primary-200">
                                            <div class="flex items-start gap-3">
                                                <svg class="w-5 h-5 text-primary-600 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                                                </svg>
                                                <div>
                                                    <p class="text-sm font-medium text-primary-800">PayPal Payment</p>
                                                    <p class="text-sm text-primary-700">Pay securely using your PayPal account or credit card</p>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="bg-white rounded-lg border border-gray-200 p-4">
                                            @include('includes.paypal')
                                        </div>
                                    </div>
                                @endif
                                @if ($payment_mode->name == 'Bank Transfer')
                                    {{-- Bank Transfer Details --}}
                                    <div class="space-y-6">
                                        <div class="bg-primary-50 rounded-lg p-4 border border-primary-200">
                                            <div class="flex items-start gap-3">
                                                <svg class="w-5 h-5 text-primary-600 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                                </svg>
                                                <div>
                                                    <p class="text-sm font-medium text-primary-800">Bank Transfer Instructions</p>
                                                    <p class="text-sm text-primary-700">Use the banking details below to complete your transfer</p>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="grid gap-4">
                                            @if (!empty($payment_mode->bankname))
                                                <div class="bg-white rounded-lg border border-gray-200 p-4">
                                                    <label class="text-sm font-medium text-gray-700 block mb-2">Bank Name</label>
                                                    <div class="flex items-center bg-gray-50 rounded-lg border border-gray-200 overflow-hidden">
                                                        <input type="text"
                                                               class="flex-1 px-4 py-3 bg-transparent text-gray-900 text-sm focus:outline-none"
                                                               value="{{ $payment_mode->bankname }}"
                                                               readonly>
                                                        <button class="px-4 py-3 bg-primary-600 text-white hover:bg-primary-700 transition-colors duration-200 flex items-center gap-2"
                                                                onclick="myFunction2()"
                                                                type="button">
                                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                                                            </svg>
                                                            Copy
                                                        </button>
                                                    </div>
                                                </div>
                                            @endif

                                            @if (!empty($payment_mode->account_name))
                                                <div class="bg-white rounded-lg border border-gray-200 p-4">
                                                    <label class="text-sm font-medium text-gray-700 block mb-2">Account Name</label>
                                                    <div class="flex items-center bg-gray-50 rounded-lg border border-gray-200 overflow-hidden">
                                                        <input type="text"
                                                               class="flex-1 px-4 py-3 bg-transparent text-gray-900 text-sm focus:outline-none"
                                                               value="{{ $payment_mode->account_name }}"
                                                               readonly>
                                                        <button class="px-4 py-3 bg-primary-600 text-white hover:bg-primary-700 transition-colors duration-200 flex items-center gap-2"
                                                                onclick="myFunction2()"
                                                                type="button">
                                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                                                            </svg>
                                                            Copy
                                                        </button>
                                                    </div>
                                                </div>
                                            @endif

                                            @if (!empty($payment_mode->account_number))
                                                <div class="bg-white rounded-lg border border-gray-200 p-4">
                                                    <label class="text-sm font-medium text-gray-700 block mb-2">Account Number</label>
                                                    <div class="flex items-center bg-gray-50 rounded-lg border border-gray-200 overflow-hidden">
                                                        <input type="text"
                                                               class="flex-1 px-4 py-3 bg-transparent text-gray-900 text-sm font-mono focus:outline-none"
                                                               value="{{ $payment_mode->account_number }}"
                                                               readonly>
                                                        <button class="px-4 py-3 bg-primary-600 text-white hover:bg-primary-700 transition-colors duration-200 flex items-center gap-2"
                                                                onclick="myFunction()"
                                                                type="button">
                                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                                                            </svg>
                                                            Copy
                                                        </button>
                                                    </div>
                                                </div>
                                            @endif

                                            @if (!empty($payment_mode->swift_code))
                                                <div class="bg-white rounded-lg border border-gray-200 p-4">
                                                    <label class="text-sm font-medium text-gray-700 block mb-2">Swift Code</label>
                                                    <div class="flex items-center bg-gray-50 rounded-lg border border-gray-200 overflow-hidden">
                                                        <input type="text"
                                                               class="flex-1 px-4 py-3 bg-transparent text-gray-900 text-sm font-mono focus:outline-none"
                                                               value="{{ $payment_mode->swift_code }}"
                                                               readonly>
                                                        <button class="px-4 py-3 bg-primary-600 text-white hover:bg-primary-700 transition-colors duration-200 flex items-center gap-2"
                                                                onclick="myFunction()"
                                                                type="button">
                                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                                                            </svg>
                                                            Copy
                                                        </button>
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endif
                            @else
                                {{-- Alternative payment details could go here --}}
                            @endif
                        @endif
                    </div>
                    @if (
                        $settings->deposit_option == 'auto' and $payment_mode->name == 'Bank Transfer' or
                            $settings->deposit_option == 'auto' and $payment_mode->defaultpay != 'yes')
                        <!-- Payment Proof Upload -->
                        <div class="bg-white rounded-xl border border-gray-200 p-6">
                            <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-3">
                                <div class="w-8 h-8 bg-gradient-to-br from-primary-500 to-primary-600 rounded-lg flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12" />
                                    </svg>
                                </div>
                                Upload Payment Proof
                            </h3>

                            <form method="post" action="{{ route('savedeposit') }}" enctype="multipart/form-data" class="space-y-6">
                                @csrf
                                <div class="bg-primary-50 rounded-lg p-4 border border-primary-200">
                                    <div class="flex items-start gap-3">
                                        <svg class="w-5 h-5 text-primary-600 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                        </svg>
                                        <div>
                                            <p class="text-sm font-medium text-primary-800">Upload Required</p>
                                            <p class="text-sm text-primary-700">Please upload your payment proof after completing the payment</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 block">Payment Proof Document</label>
                                    <input type="file"
                                           name="proof"
                                           accept="image/*,.pdf"
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors duration-200"
                                           required>
                                    <p class="text-xs text-gray-500">Accepted formats: JPG, PNG, PDF (max 5MB)</p>
                                </div>

                                <input type="hidden" name="amount" value="{{ $amount }}">
                                <input type="hidden" name="paymethd_method" value="{{ $payment_mode->name }}">

                                <button type="submit"
                                        class="w-full flex items-center justify-center gap-3 px-6 py-4 bg-gradient-to-r from-primary-600 to-primary-700 text-white font-semibold rounded-xl hover:from-primary-700 hover:to-primary-800 transition-all duration-200 shadow-lg hover:shadow-xl">
                                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12" />
                                    </svg>
                                    Submit Payment Proof
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                    </svg>
                                </button>
                            </form>
                        </div>
                    @endif
                    @if ($settings->deposit_option == 'manual' and $payment_mode->name != 'Credit Card' and $payment_mode->name != 'Paypal')
                        <!-- Manual Payment Completion -->
                        <div class="bg-white rounded-xl border border-gray-200 p-6">
                            <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-3">
                                <div class="w-8 h-8 bg-gradient-to-br from-green-500 to-green-600 rounded-lg flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>
                                Complete Payment
                            </h3>

                            <form method="post" action="{{ route('savedeposit') }}" enctype="multipart/form-data" class="space-y-6">
                                @csrf
                                <div class="bg-green-50 rounded-lg p-4 border border-green-200">
                                    <div class="flex items-start gap-3">
                                        <svg class="w-5 h-5 text-green-600 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                        </svg>
                                        <div>
                                            <p class="text-sm font-medium text-green-800">Payment Verification</p>
                                            <p class="text-sm text-green-700">Upload your payment proof to mark this transaction as completed</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 block">Payment Proof Document</label>
                                    <input type="file"
                                           name="proof"
                                           accept="image/*,.pdf"
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 transition-colors duration-200"
                                           required>
                                    <p class="text-xs text-gray-500">Accepted formats: JPG, PNG, PDF (max 5MB)</p>
                                </div>

                                <input type="hidden" name="amount" value="{{ $amount }}">
                                <input type="hidden" name="paymethd_method" value="{{ $payment_mode->name }}">

                                <button type="submit"
                                        class="w-full flex items-center justify-center gap-3 px-6 py-4 bg-gradient-to-r from-green-600 to-green-700 text-white font-semibold rounded-xl hover:from-green-700 hover:to-green-800 transition-all duration-200 shadow-lg hover:shadow-xl">
                                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    Mark as Completed
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                    </svg>
                                </button>
                            </form>
                        </div>
                    @endif
                @endif

                {{-- Automatic Cryptopayment QR Code --}}
                @if ($title == 'Complete Payment')
                    <div class="bg-white rounded-xl border border-gray-200 p-6">
                        <div class="text-center space-y-6">
                            <div class="w-16 h-16 bg-gradient-to-br from-primary-500 to-primary-600 rounded-full flex items-center justify-center mx-auto">
                                <svg class="w-8 h-8 text-white" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M23.638 14.904c-1.602 6.43-8.113 10.34-14.542 8.736C2.67 22.05-1.244 15.525.362 9.105 1.962 2.67 8.475-1.243 14.9.358c6.43 1.605 10.342 8.115 8.738 14.546z"/>
                                </svg>
                            </div>

                            <div>
                                <h3 class="text-xl font-semibold text-gray-900 mb-2">Complete Your Payment</h3>
                                <p class="text-gray-600 mb-4">Send <span class="font-semibold text-primary-600">{{ $amount }}</span> {{ $coin }} to the address below or scan the QR code</p>
                            </div>

                            <div class="bg-gray-50 rounded-lg p-4 max-w-md mx-auto">
                                <p class="text-xs text-gray-500 mb-2 uppercase tracking-wide">{{ $coin }} Address</p>
                                <p class="font-mono text-sm text-gray-900 break-all bg-white p-3 rounded border">{{ $p_address }}</p>
                            </div>

                            <div class="inline-block bg-white p-6 rounded-xl shadow-sm border">
                                <img width="220" height="220" alt="Payment QR Code" src="{{ $p_qrcode }}" class="mx-auto">
                            </div>

                            <div class="bg-primary-50 rounded-lg p-4 border border-primary-200 max-w-md mx-auto">
                                <div class="flex items-start gap-3">
                                    <svg class="w-5 h-5 text-primary-600 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    <div class="text-left">
                                        <p class="text-sm font-medium text-primary-800">Automatic Processing</p>
                                        <p class="text-sm text-primary-700">You can safely exit this page after completing payment. The system will automatically track and update your account.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>


<script>
				function myFunction2() {
					/* Get the text field */
					var copyText = document.getElementById("button-addon2");
					/* Select the text field */
					copyText.select();
					copyText.setSelectionRange(0, 99999); /* For mobile devices */
					/* Copy the text inside the text field */
					document.execCommand("copy");
					/* Alert the copied text */
					//alert("Copied the text: " + copyText.value);
					swal("Copied", copyText.value, "success");
					}
			</script>

<script>
				function myFunction() {
					/* Get the text field */
					var copyText = document.getElementById("myInput");
					/* Select the text field */
					copyText.select();
					copyText.setSelectionRange(0, 99999); /* For mobile devices */
					/* Copy the text inside the text field */
					document.execCommand("copy");
					/* Alert the copied text */
					//alert("Copied the text: " + copyText.value);
					swal("Copied", copyText.value, "success");
					}
			</script>
<script type="text/javascript">
    var stripe = Stripe("{{ $settings->s_p_k }}");
    var elements = stripe.elements();
    var style = {
        base: {
            color: "#32325d",
        }
    };
    const paybtn = document.querySelector('#stripesubmit');
    console.log(paybtn);
    paybtn.disabled = true;

    var card = elements.create("card", {
        style: style
    });
    card.mount("#card-element");

    function checkcardforerrors() {
        card.on('change', function(event) {
            if (event.error) {
                swal("Error", event.error.message, "error");
                paybtn.disabled = true;
            } else {
                paybtn.disabled = false;
            }
        });
    }
    checkcardforerrors();

    var form = document.getElementById('payment-form');

    form.addEventListener('submit', function(ev) {
        paybtn.disabled = true;
        ev.preventDefault();
        checkcardforerrors();
        document.getElementById('spinner').classList.remove('d-none');
        document.getElementById('buttontext').classList.add('d-none');

        // If the client secret was rendered server-side as a data-secret attribute
        // on the <form> element, you can retrieve it here by calling `form.dataset.secret`
        var clientSecret = "{{ $intent }}";
        stripe.confirmCardPayment(clientSecret, {
            payment_method: {
                card: card,
                billing_details: {
                    name: "{{ Auth::user()->name }}"
                }
            }
        }).then(function(result) {
            if (result.error) {
                swal("Error",
                    'There was an error processing your payment, Please try deposit again from deposit page',
                    "error");
                console.log(result.error.message);
            } else {
                // The payment has been processed!
                if (result.paymentIntent.status === 'succeeded') {
                    $.ajax({
                        url: "{{ url('/dashboard/submit-stripe-payment') }}",
                        type: 'POST',
                        data: $('#selectform').serialize(),
                        success: function(data) {
                            swal("Success", data.success, "success");
                            setTimeout(function() {
                                window.location.replace(
                                    "{{ route('accounthistory') }}");
                            }, 3000);
                        },
                        error: function(error) {
                            alert('Error Submiting Payment Data');
                            console.log(error);
                        },
                    });
                }
            }
        });

    });
</script>
@endsection
