@extends('layouts.flight')

@section('title', 'Complete Payment - ' . config('app.name'))

@section('content')
<!-- Booking Progress -->
<section class="bg-slate-100 py-4">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex items-center justify-center space-x-4">
            <div class="flex items-center">
                <div class="w-8 h-8 bg-emerald-500 text-white rounded-full flex items-center justify-center text-sm font-medium">
                    <i class="fas fa-check text-xs"></i>
                </div>
                <span class="ml-2 text-sm font-medium text-emerald-600">Flight Details</span>
            </div>
            <div class="w-16 h-px bg-emerald-300"></div>
            <div class="flex items-center">
                <div class="w-8 h-8 bg-primary-600 text-white rounded-full flex items-center justify-center text-sm font-medium">2</div>
                <span class="ml-2 text-sm font-medium text-primary-600">Payment</span>
            </div>
            <div class="w-16 h-px bg-slate-300"></div>
            <div class="flex items-center">
                <div class="w-8 h-8 bg-slate-300 text-slate-600 rounded-full flex items-center justify-center text-sm font-medium">3</div>
                <span class="ml-2 text-sm text-slate-500">Confirmation</span>
            </div>
        </div>
    </div>
</section>

<!-- Payment Header -->
<section class="py-6 bg-gradient-to-r from-primary-600 via-primary-700 to-primary-800 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            <h1 class="text-3xl lg:text-4xl font-bold mb-2">
                Complete Payment 💳
            </h1>
            <p class="text-primary-100 text-lg">
                Secure payment processing for your flight booking
            </p>
            <div class="mt-4 bg-white/20 backdrop-blur rounded-xl px-6 py-4 inline-block">
                <div class="text-center">
                    <p class="text-primary-100 text-sm font-medium mb-1">Amount to Pay</p>
                    <p class="text-3xl font-bold text-white">${{ number_format($booking->price_paid, 2) }}</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Alert Messages -->
@if($errors->any())
    <section class="py-4">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-red-50 border-l-4 border-red-400 p-6 rounded-xl shadow-md">
                <div class="flex items-start">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-circle text-red-400 text-xl"></i>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-semibold text-red-800">
                            There were some problems with your input
                        </h3>
                        <div class="mt-2">
                            <ul class="list-disc list-inside text-sm text-red-700 space-y-1">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endif

@if(session('message') || session('success') || session('error'))
    <section class="py-4">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            @php
                $status = 'info';
                $message = '';
                if(session('success')) {
                    $status = 'success';
                    $message = session('success');
                } elseif(session('error')) {
                    $status = 'error';
                    $message = session('error');
                } elseif(session('message')) {
                    $status = session('status', 'info');
                    $message = session('message');
                }
                
                $alertClasses = [
                    'success' => 'bg-green-50 border-green-400 text-green-800',
                    'error' => 'bg-red-50 border-red-400 text-red-800',
                    'warning' => 'bg-yellow-50 border-yellow-400 text-yellow-800',
                    'info' => 'bg-blue-50 border-blue-400 text-blue-800'
                ];
                $iconClasses = [
                    'success' => 'fas fa-check-circle text-green-400',
                    'error' => 'fas fa-times-circle text-red-400',
                    'warning' => 'fas fa-exclamation-triangle text-yellow-400',
                    'info' => 'fas fa-info-circle text-blue-400'
                ];
                $currentClass = $alertClasses[$status] ?? $alertClasses['info'];
                $currentIcon = $iconClasses[$status] ?? $iconClasses['info'];
            @endphp
            <div class="{{ $currentClass }} border-l-4 p-6 rounded-xl shadow-md">
                <div class="flex items-start">
                    <div class="flex-shrink-0">
                        <i class="{{ $currentIcon }} text-xl"></i>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-semibold">{{ ucfirst($status) }}</h3>
                        <p class="mt-1 text-sm">{{ $message }}</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endif

<!-- Payment Content -->
<section class="py-8">
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Payment Method Info -->
            <div class="lg:col-span-2">
                <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
                    <div class="bg-gradient-to-r from-gray-50 to-gray-100 px-8 py-6 border-b border-gray-200">
                        <div class="flex items-center justify-between">
                            <div>
                                <h2 class="text-2xl font-bold text-gray-900">Payment Method</h2>
                                <p class="text-gray-600 mt-1">Complete your payment using {{ $wdmethod->name }}</p>
                            </div>
                            <div class="flex items-center space-x-3">
                                @if(!empty($wdmethod->img_url))
                                    <div class="w-12 h-12 rounded-xl overflow-hidden flex items-center justify-center bg-white border border-gray-200">
                                        <img src="{{ $wdmethod->img_url }}" alt="{{ $wdmethod->name }}" class="w-full h-full object-contain">
                                    </div>
                                @else
                                    <div class="w-12 h-12 bg-gradient-to-br from-primary-500 to-primary-600 rounded-xl flex items-center justify-center">
                                        @if(str_contains(strtolower($wdmethod->name), 'bitcoin') || str_contains(strtolower($wdmethod->name), 'btc'))
                                            <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                                <path d="M23.638 14.904c-1.602 6.43-8.113 10.34-14.542 8.736C2.67 22.05-1.244 15.525.362 9.105 1.962 2.67 8.475-1.243 14.9.358c6.43 1.605 10.342 8.115 8.738 14.546z"/>
                                            </svg>
                                        @elseif(str_contains(strtolower($wdmethod->name), 'ethereum') || str_contains(strtolower($wdmethod->name), 'eth'))
                                            <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                                <path d="M11.944 17.97L4.58 13.62 11.943 24l7.37-10.38-7.372 4.35h.003zM12.056 0L4.69 12.223l7.365 4.354 7.365-4.35L12.056 0z"/>
                                            </svg>
                                        @elseif(str_contains(strtolower($wdmethod->name), 'credit') || str_contains(strtolower($wdmethod->name), 'card'))
                                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                                            </svg>
                                        @elseif(str_contains(strtolower($wdmethod->name), 'paypal'))
                                            <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                                <path d="M7.076 21.337H2.47a.641.641 0 0 1-.633-.74L4.944.901C5.026.382 5.474 0 5.998 0h7.46c2.57 0 4.578.543 5.69 1.81 1.01 1.15 1.304 2.42 1.012 4.287-.023.143-.047.288-.077.434-.983 4.237-4.053 6.862-8.44 6.862H9.82a.641.641 0 0 0-.633.74l-.744 4.71a.568.568 0 0 1-.563.493zm2.15-13.298a.641.641 0 0 0-.633.74l-.744 4.71a.568.568 0 0 1-.562.493H4.696a.641.641 0 0 1-.633-.74l.744-4.71A.641.641 0 0 1 5.44 8.04h3.786z"/>
                                            </svg>
                                        @elseif(str_contains(strtolower($wdmethod->name), 'bank'))
                                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                            </svg>
                                        @else
                                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                                            </svg>
                                        @endif
                                    </div>
                                @endif
                                <div>
                                    <p class="text-sm font-medium text-gray-600">Selected Method</p>
                                    <p class="font-semibold text-gray-900">{{ $wdmethod->name }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="p-8">
                        <!-- Payment Instructions -->
                        <div class="bg-blue-50 border border-blue-200 rounded-xl p-6 mb-6">
                            <div class="flex items-start space-x-3">
                                <svg class="w-6 h-6 text-blue-600 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                <div>
                                    <h3 class="text-lg font-semibold text-blue-800 mb-2">Payment Instructions</h3>
                                    <p class="text-blue-700">
                                        You are to make payment of <span class="font-bold">{{ $settings->currency }}{{ number_format($booking->price_paid, 2) }}</span> using {{ $wdmethod->name }}.
                                    </p>
                                </div>
                            </div>
                        </div>

                        @if(!empty($wdmethod->barcode))
                        <!-- QR Code -->
                        <div class="text-center mb-6">

                            
                            <div class="bg-white p-6 rounded-xl border border-gray-200 inline-block">
                                <img src="https://api.qrserver.com/v1/create-qr-code/?size=250x250&data={{ $wdmethod->wallet_address }}" alt="Payment QR Code" class="max-w-xs mx-auto">
                                <p class="text-sm text-gray-600 mt-3">Scan QR code to pay</p>
                            </div>
                        </div>
                        @endif

                        @if(!empty($wdmethod->wallet_address))
                        <!-- Wallet Address -->
                        <div class="bg-white rounded-xl border border-gray-200 p-6 mb-6">
                            <h3 class="text-lg font-semibold text-gray-900 mb-4">{{ $wdmethod->name }} Wallet Address</h3>
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Wallet Address</label>
                                    <div class="relative">
                                        <input type="text" 
                                               id="wallet_address" 
                                               value="{{ $wdmethod->wallet_address }}" 
                                               readonly 
                                               class="w-full px-4 py-3 bg-gray-50 border border-gray-300 rounded-lg font-mono text-sm">
                                        <button type="button" 
                                                onclick="copyToClipboard('wallet_address')" 
                                                class="absolute right-2 top-1/2 transform -translate-y-1/2 px-3 py-1 bg-primary-600 text-white text-sm rounded hover:bg-primary-700">
                                            Copy
                                        </button>
                                    </div>
                                </div>
                                @if(!empty($wdmethod->network))
                                <div class="bg-primary-50 rounded-lg p-4 border border-primary-200">
                                    <p class="text-sm text-primary-700">
                                        <strong>Network:</strong> {{ $wdmethod->network }}
                                    </p>
                                </div>
                                @endif
                            </div>
                        </div>
                        @endif

                        @if(!empty($wdmethod->account_name) || !empty($wdmethod->account_number))
                        <!-- Bank Details -->
                        <div class="bg-white rounded-xl border border-gray-200 p-6 mb-6">
                            <h3 class="text-lg font-semibold text-gray-900 mb-4">Bank Transfer Details</h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                @if(!empty($wdmethod->bankname))
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Bank Name</label>
                                    <p class="text-sm text-gray-900">{{ $wdmethod->bankname }}</p>
                                </div>
                                @endif
                                @if(!empty($wdmethod->account_name))
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Account Name</label>
                                    <p class="text-sm text-gray-900">{{ $wdmethod->account_name }}</p>
                                </div>
                                @endif
                                @if(!empty($wdmethod->account_number))
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Account Number</label>
                                    <div class="relative">
                                        <input type="text" 
                                               id="account_number" 
                                               value="{{ $wdmethod->account_number }}" 
                                               readonly 
                                               class="w-full px-3 py-2 bg-gray-50 border border-gray-300 rounded text-sm">
                                        <button type="button" 
                                                onclick="copyToClipboard('account_number')" 
                                                class="absolute right-1 top-1/2 transform -translate-y-1/2 px-2 py-1 bg-primary-600 text-white text-xs rounded hover:bg-primary-700">
                                            Copy
                                        </button>
                                    </div>
                                </div>
                                @endif
                                @if(!empty($wdmethod->swift_code))
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Swift Code</label>
                                    <p class="text-sm text-gray-900">{{ $wdmethod->swift_code }}</p>
                                </div>
                                @endif
                            </div>
                        </div>
                        @endif

                        <!-- Payment Proof Upload -->
                        <div class="bg-white rounded-xl border border-gray-200 p-6">
                            <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-3">
                                <div class="w-8 h-8 bg-gradient-to-br from-primary-500 to-primary-600 rounded-lg flex items-center justify-center">
                                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12" />
                                    </svg>
                                </div>
                                Upload Payment Proof
                            </h3>

                            <form method="post" action="{{ route('flights.booking.confirm-payment', $booking) }}" enctype="multipart/form-data" class="space-y-6">
                                @csrf
                                <div class="bg-primary-50 rounded-lg p-4 border border-primary-200">
                                    <div class="flex items-start space-x-3">
                                        <svg class="w-5 h-5 text-primary-600 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                        </svg>
                                        <div>
                                            <h4 class="font-semibold text-primary-800">Important</h4>
                                            <p class="text-primary-700 text-sm">Please upload a screenshot or receipt of your payment for verification purposes.</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="space-y-2">
                                    <label class="block text-sm font-medium text-gray-700">Payment Proof (Screenshot/Receipt)</label>
                                    <input type="file" 
                                           name="payment_proof" 
                                           accept="image/*" 
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent @error('payment_proof') border-red-500 @enderror">
                                    @error('payment_proof')
                                        <p class="text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="space-y-2">
                                    <label class="block text-sm font-medium text-gray-700">Transaction ID (Optional)</label>
                                    <input type="text" 
                                           name="transaction_id" 
                                           placeholder="Enter transaction ID if available" 
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent">
                                </div>

                                <button type="submit" 
                                        class="w-full bg-gradient-to-r from-primary-600 to-primary-700 text-white font-semibold py-4 px-8 rounded-xl hover:from-primary-700 hover:to-primary-800 focus:ring-4 focus:ring-primary-500/30 transition-all duration-200 shadow-lg hover:shadow-xl flex items-center justify-center space-x-3">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    <span>Confirm Payment</span>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Booking Summary -->
            <div class="lg:col-span-1">
                <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6 sticky top-24">
                    <h3 class="text-xl font-semibold text-gray-900 mb-6">
                        <i class="fas fa-receipt mr-2"></i> Booking Summary
                    </h3>

                    <!-- Flight Details -->
                    <div class="space-y-4 mb-6">
                        <div>
                            <h4 class="font-semibold text-gray-800">{{ $booking->flight->airline }}</h4>
                            <p class="text-sm text-gray-600">{{ $booking->flight->flight_number }}</p>
                        </div>

                        <div class="space-y-2 text-sm">
                            <div class="flex justify-between">
                                <span class="text-gray-600">From:</span>
                                <span>
                                    @if($booking->flight->originAirport)
                                        {{ $booking->flight->originAirport->city }} ({{ $booking->flight->originAirport->iata_code }})
                                    @else
                                        Unknown Airport
                                    @endif
                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">To:</span>
                                <span>
                                    @if($booking->flight->destinationAirport)
                                        {{ $booking->flight->destinationAirport->city }} ({{ $booking->flight->destinationAirport->iata_code }})
                                    @else
                                        Unknown Airport
                                    @endif
                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Departure:</span>
                                <span>{{ $booking->flight->departure_time->format('M d, Y H:i') }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Arrival:</span>
                                <span>{{ $booking->flight->arrival_time->format('M d, Y H:i') }}</span>
                            </div>
                        </div>
                    </div>

                    <!-- Passenger Details -->
                    <div class="border-t border-gray-200 pt-4 mb-6">
                        <h4 class="font-semibold text-gray-800 mb-3">Passenger</h4>
                        <div class="space-y-2 text-sm">
                            <div class="flex justify-between">
                                <span class="text-gray-600">Name:</span>
                                <span>{{ $booking->passenger_name }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Email:</span>
                                <span>{{ $booking->passenger_email }}</span>
                            </div>
                        </div>
                    </div>

                    <!-- Price Breakdown -->
                    <div class="border-t border-gray-200 pt-4">
                        <div class="space-y-2 mb-4">
                            <div class="flex justify-between">
                                <span class="text-gray-600">Base Price</span>
                                <span class="font-medium">${{ number_format($booking->price_paid / 1.1, 2) }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Taxes & Fees</span>
                                <span class="font-medium">${{ number_format($booking->price_paid * 0.1, 2) }}</span>
                            </div>
                            <div class="border-t border-gray-200 pt-2">
                                <div class="flex justify-between items-center">
                                    <span class="text-lg font-semibold text-gray-800">Total</span>
                                    <span class="text-2xl font-bold text-primary-600">${{ number_format($booking->price_paid, 2) }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Booking Reference -->
                    <div class="border-t border-gray-200 pt-4">
                        <div class="text-center">
                            <p class="text-sm text-gray-600 mb-2">Booking Reference</p>
                            <p class="font-bold text-lg text-primary-600">{{ $booking->booking_reference }}</p>
                        </div>
                    </div>

                    <!-- Support -->
                    <div class="border-t border-gray-200 pt-4 mt-6">
                        <div class="text-center">
                            <p class="text-sm text-gray-600 mb-2">Need help?</p>
                            <a href="#" class="text-primary-600 hover:text-primary-700 text-sm font-medium">
                                <i class="fas fa-phone mr-1"></i> Contact Support
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@push('scripts')
<script>
function copyToClipboard(elementId) {
    const element = document.getElementById(elementId);
    element.select();
    element.setSelectionRange(0, 99999);
    document.execCommand('copy');
    
    // Show success message
    const button = element.nextElementSibling;
    const originalText = button.textContent;
    button.textContent = 'Copied!';
    button.classList.add('bg-green-600');
    button.classList.remove('bg-primary-600');
    
    setTimeout(() => {
        button.textContent = originalText;
        button.classList.remove('bg-green-600');
        button.classList.add('bg-primary-600');
    }, 2000);
}
</script>
@endpush