@extends('layouts.flight')

@section('title', 'My Bookings - ' . config('app.name'))

@section('content')
<div class="min-h-screen bg-slate-50 py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Page Header -->
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-slate-900 mb-2">
                <i class="fas fa-ticket-alt text-primary-600 mr-3"></i>My Bookings
            </h1>
            <p class="text-slate-600">View and manage your flight bookings</p>
        </div>

        @auth
            <!-- Authenticated User Bookings -->
            @if($bookings->count() > 0)
                <div class="space-y-6">
                    @foreach($bookings as $booking)
                    <div class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden hover:shadow-xl transition-shadow">
                        <div class="p-6">
                            <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-6">
                                <!-- Booking Info -->
                                <div class="flex-1">
                                    <div class="flex items-center gap-3 mb-4">
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium {{ $booking->payment_status === 'paid' ? 'bg-emerald-100 text-emerald-800' : 'bg-amber-100 text-amber-800' }}">
                                            <i class="fas fa-circle text-xs mr-2"></i>
                                            {{ ucfirst($booking->payment_status) }}
                                        </span>
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium {{ $booking->status === 'confirmed' ? 'bg-blue-100 text-blue-800' : 'bg-slate-100 text-slate-800' }}">
                                            {{ ucfirst($booking->status) }}
                                        </span>
                                    </div>

                                    <div class="mb-4">
                                        <div class="text-sm text-slate-500 mb-1">Booking Reference</div>
                                        <div class="text-2xl font-bold text-primary-600">{{ $booking->booking_reference }}</div>
                                    </div>

                                    <!-- Flight Details -->
                                    <div class="flex items-center gap-4">
                                        <div class="flex items-center gap-3">
                                            @if($booking->flight->airline_logo)
                                                <div class="w-12 h-12 rounded-full overflow-hidden bg-white border border-slate-200 flex items-center justify-center p-1 flex-shrink-0">
                                                    <img src="{{ asset('storage/app/public/' . $booking->flight->airline_logo) }}" alt="{{ $booking->flight->airline }}" class="w-full h-full object-contain">
                                                </div>
                                            @else
                                                <div class="w-12 h-12 bg-primary-100 rounded-full flex items-center justify-center flex-shrink-0">
                                                    <i class="fas fa-plane text-primary-600"></i>
                                                </div>
                                            @endif
                                            <div>
                                                <div class="text-sm text-slate-500">{{ $booking->flight->airline }}</div>
                                                <div class="text-xs text-slate-400">{{ $booking->flight->flight_number }}</div>
                                            </div>
                                        </div>
                                        <div class="flex items-center gap-3">
                                            <div class="text-center">
                                                <div class="text-xl font-bold text-slate-900">{{ $booking->flight->departure_time->format('H:i') }}</div>
                                                <div class="text-sm text-slate-600">{{ $booking->flight->originAirport->iata_code }}</div>
                                                <div class="text-xs text-slate-400">{{ $booking->flight->originAirport->city }}</div>
                                            </div>
                                            <div class="flex-1 flex items-center px-4">
                                                <div class="w-3 h-3 bg-primary-500 rounded-full"></div>
                                                <div class="flex-1 h-0.5 bg-slate-200 relative">
                                                    <i class="fas fa-plane absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 text-primary-500 bg-white px-1"></i>
                                                </div>
                                                <div class="w-3 h-3 bg-primary-500 rounded-full"></div>
                                            </div>
                                            <div class="text-center">
                                                <div class="text-xl font-bold text-slate-900">{{ $booking->flight->arrival_time->format('H:i') }}</div>
                                                <div class="text-sm text-slate-600">{{ $booking->flight->destinationAirport->iata_code }}</div>
                                                <div class="text-xs text-slate-400">{{ $booking->flight->destinationAirport->city }}</div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mt-4 text-sm text-slate-500">
                                        <i class="fas fa-calendar mr-1"></i>
                                        {{ $booking->flight->departure_time->format('D, M d, Y') }}
                                    </div>
                                </div>

                                <!-- Booking Actions -->
                                <div class="flex flex-col gap-3 lg:items-end">
                                    <div class="text-right">
                                        <div class="text-sm text-slate-500">Total Paid</div>
                                        <div class="text-2xl font-bold text-slate-900">${{ number_format($booking->price_paid, 2) }}</div>
                                    </div>

                                    <div class="flex flex-col gap-2 w-full lg:w-auto">
                                        <a href="{{ route('flights.booking.success', $booking) }}" class="bg-primary-600 hover:bg-primary-700 text-white px-6 py-2 rounded-lg font-medium transition-colors text-center">
                                            <i class="fas fa-eye mr-2"></i>View Details
                                        </a>
                                        @if($booking->payment_status !== 'paid')
                                        <a href="{{ route('flights.booking.payment', $booking) }}" class="bg-emerald-600 hover:bg-emerald-700 text-white px-6 py-2 rounded-lg font-medium transition-colors text-center">
                                            <i class="fas fa-credit-card mr-2"></i>Complete Payment
                                        </a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach

                    <!-- Pagination -->
                    <div class="mt-8">
                        {{ $bookings->links() }}
                    </div>
                </div>
            @else
                <!-- No Bookings -->
                <div class="bg-white rounded-2xl shadow-lg p-12 text-center">
                    <div class="w-24 h-24 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <i class="fas fa-ticket-alt text-slate-400 text-4xl"></i>
                    </div>
                    <h3 class="text-2xl font-semibold text-slate-800 mb-4">No bookings yet</h3>
                    <p class="text-slate-600 mb-8">Start your journey by booking your first flight!</p>
                    <a href="{{ route('flights.search') }}" class="inline-block bg-primary-600 hover:bg-primary-700 text-white px-8 py-3 rounded-lg font-semibold transition-colors">
                        <i class="fas fa-search mr-2"></i>Search Flights
                    </a>
                </div>
            @endif
        @else
            <!-- Guest User - Search by Booking Reference -->
            <div class="bg-white rounded-2xl shadow-lg p-8 md:p-12 max-w-2xl mx-auto">
                <div class="text-center mb-8">
                    <div class="w-20 h-20 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <i class="fas fa-search text-primary-600 text-3xl"></i>
                    </div>
                    <h2 class="text-2xl font-bold text-slate-900 mb-2">Find Your Booking</h2>
                    <p class="text-slate-600">Enter your booking reference to view your flight details</p>
                </div>

                <form action="{{ route('booking.details', ['reference' => ':reference']) }}" method="GET" x-data="{ reference: '' }" @submit.prevent="if(reference) window.location.href = '{{ route('booking.details', ['reference' => ':reference']) }}'.replace(':reference', reference.toUpperCase())">
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="fas fa-ticket-alt mr-1"></i> Booking Reference
                        </label>
                        <input 
                            type="text" 
                            x-model="reference"
                            placeholder="e.g., AB7K9M" 
                            class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent text-slate-700 text-center text-lg font-semibold uppercase"
                            required
                            maxlength="6"
                            pattern="[A-Za-z0-9]{6}">
                        <p class="mt-2 text-sm text-slate-500">
                            <i class="fas fa-info-circle mr-1"></i>
                            Your 6-character booking reference (found in your confirmation email)
                        </p>
                    </div>

                    <button type="submit" class="w-full bg-primary-600 hover:bg-primary-700 text-white font-semibold py-4 rounded-lg transition-colors transform hover:scale-105 text-lg shadow-lg">
                        <i class="fas fa-search mr-2"></i> Find My Booking
                    </button>
                </form>

                <div class="mt-8 pt-8 border-t border-slate-200 text-center">
                    <p class="text-slate-600 mb-4">Have an account?</p>
                    <a href="{{ route('login') }}" class="text-primary-600 hover:text-primary-700 font-medium">
                        <i class="fas fa-sign-in-alt mr-1"></i> Login to view all your bookings
                    </a>
                </div>
            </div>
        @endauth
    </div>
</div>
@endsection
