@extends('layouts.flight')

@section('title', 'Book Flight - ' . config('app.name'))

@section('content')
<!-- Booking Progress -->
<section class="bg-slate-100 py-4">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex items-center justify-center space-x-4">
            <div class="flex items-center">
                <div class="w-8 h-8 bg-primary-600 text-white rounded-full flex items-center justify-center text-sm font-medium">1</div>
                <span class="ml-2 text-sm font-medium text-primary-600">Flight Details</span>
            </div>
            <div class="w-16 h-px bg-slate-300"></div>
            <div class="flex items-center">
                <div class="w-8 h-8 bg-slate-300 text-slate-600 rounded-full flex items-center justify-center text-sm font-medium">2</div>
                <span class="ml-2 text-sm text-slate-500">Payment</span>
            </div>
            <div class="w-16 h-px bg-slate-300"></div>
            <div class="flex items-center">
                <div class="w-8 h-8 bg-slate-300 text-slate-600 rounded-full flex items-center justify-center text-sm font-medium">3</div>
                <span class="ml-2 text-sm text-slate-500">Confirmation</span>
            </div>
        </div>
    </div>
</section>

<!-- Flight Summary -->
<section class="py-6 bg-primary-600 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-primary-700 rounded-xl p-6">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 items-center">
                <!-- Flight Route -->
                <div class="lg:col-span-2">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center space-x-3">
                            @if($flight->airline_logo)
                                <div class="w-12 h-12 rounded-full overflow-hidden bg-white border border-primary-200 flex items-center justify-center p-1 flex-shrink-0">
                                    <img src="{{ asset('storage/app/public/' . $flight->airline_logo) }}" alt="{{ $flight->airline }}" class="w-full h-full object-contain">
                                </div>
                            @else
                                <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center flex-shrink-0">
                                    <i class="fas fa-plane text-white"></i>
                                </div>
                            @endif
                            <div>
                                <p class="text-lg font-semibold">{{ $flight->airline }}</p>
                                <p class="text-sm text-primary-100">{{ $flight->flight_number }}</p>
                            </div>
                        </div>
                        <span class="px-3 py-1 bg-emerald-500 text-white rounded-full text-sm font-medium">
                            {{ $flight->available_seats }} seats available
                        </span>
                    </div>

                    <div class="grid grid-cols-3 gap-4 items-center">
                        <div class="text-center">
                            <p class="text-2xl font-bold">{{ $flight->departure_time->format('H:i') }}</p>
                            <p class="text-sm">{{ $flight->originAirport->iata_code }} - {{ $flight->originAirport->city }}</p>
                            <p class="text-xs text-primary-100">{{ $flight->departure_time->format('M d, Y') }}</p>
                        </div>
                        <div class="text-center">
                            <div class="flex items-center justify-center mb-1">
                                <div class="flex-1 h-px bg-primary-300"></div>
                                <i class="fas fa-plane text-primary-200 mx-2"></i>
                                <div class="flex-1 h-px bg-primary-300"></div>
                            </div>
                            <p class="text-sm">{{ $flight->duration }}</p>
                        </div>
                        <div class="text-center">
                            <p class="text-2xl font-bold">{{ $flight->arrival_time->format('H:i') }}</p>
                            <p class="text-sm">{{ $flight->destinationAirport->iata_code }} - {{ $flight->destinationAirport->city }}</p>
                            <p class="text-xs text-primary-100">{{ $flight->arrival_time->format('M d, Y') }}</p>
                        </div>
                    </div>
                </div>

                <!-- Price -->
                <div class="text-center lg:text-right">
                    <p class="text-3xl font-bold">${{ number_format($flight->price, 0) }}</p>
                    <p class="text-sm text-primary-100">per person</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Booking Form -->
<section class="py-8">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        @auth
        <!-- User Info Notice -->
        @if(Auth::user()->passenger_name || Auth::user()->passport_number)
        <div class="bg-blue-50 border border-blue-200 rounded-xl p-4 mb-6">
            <div class="flex items-start space-x-3">
                <svg class="w-6 h-6 text-blue-600 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <div class="flex-1">
                    <h4 class="text-sm font-semibold text-blue-900 mb-1">Your saved information has been pre-filled</h4>
                    <p class="text-sm text-blue-700">We've automatically filled in your details from your profile. Please review and update if needed.</p>
                </div>
            </div>
        </div>
        @endif
        @endauth

        <form action="{{ route('flights.booking.store', $flight) }}" method="POST" x-data="bookingForm()">
            @csrf
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Passenger Information -->
                <div class="lg:col-span-2 space-y-6">
                    <!-- Passenger Details -->
                    <div class="bg-white rounded-xl shadow-lg p-6">
                        <div class="flex items-center justify-between mb-6">
                            <h3 class="text-xl font-semibold text-slate-800">
                                <i class="fas fa-user mr-2"></i> Passenger Information
                            </h3>
                            @auth
                            <a href="{{ route('profile') }}" class="text-sm text-primary-600 hover:text-primary-700">
                                <i class="fas fa-edit mr-1"></i> Update Profile
                            </a>
                            @endauth
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-slate-700 mb-2">
                                    Full Name <span class="text-red-500">*</span>
                                </label>
                                <input type="text" 
                                       name="passenger_name" 
                                       value="{{ old('passenger_name', Auth::check() ? (Auth::user()->passenger_name ?? Auth::user()->name) : '') }}" 
                                       required
                                       class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent @error('passenger_name') border-red-500 @enderror">
                                @error('passenger_name')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-slate-700 mb-2">
                                    Email Address <span class="text-red-500">*</span>
                                </label>
                                <input type="email" 
                                       name="passenger_email" 
                                       value="{{ old('passenger_email', Auth::check() ? (Auth::user()->passenger_email ?? Auth::user()->email) : '') }}" 
                                       required
                                       class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent @error('passenger_email') border-red-500 @enderror">
                                @error('passenger_email')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-slate-700 mb-2">
                                    Phone Number
                                </label>
                                <input type="tel" 
                                       name="passenger_phone" 
                                       value="{{ old('passenger_phone', Auth::check() ? (Auth::user()->passenger_phone ?? Auth::user()->phone) : '') }}" 
                                       class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent @error('passenger_phone') border-red-500 @enderror">
                                @error('passenger_phone')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-slate-700 mb-2">
                                    Date of Birth
                                </label>
                                <input type="date" 
                                       name="passenger_dob" 
                                       value="{{ old('passenger_dob', Auth::check() && Auth::user()->passenger_dob ? Auth::user()->passenger_dob->format('Y-m-d') : '') }}" 
                                       class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-slate-700 mb-2">
                                    Nationality
                                </label>
                                <input type="text" 
                                       name="nationality" 
                                       value="{{ old('nationality', Auth::check() ? (Auth::user()->nationality ?? '') : '') }}" 
                                       class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
                                       placeholder="e.g., American, British">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-slate-700 mb-2">
                                    Passport Number
                                </label>
                                <input type="text" 
                                       name="passport_number" 
                                       value="{{ old('passport_number', Auth::check() ? (Auth::user()->passport_number ?? '') : '') }}" 
                                       class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
                                       placeholder="e.g., A12345678">
                            </div>
                        </div>

                        <div class="mt-4">
                            <label class="block text-sm font-medium text-slate-700 mb-2">
                                Special Requests (Optional)
                            </label>
                            <textarea name="special_requests" 
                                      rows="3" 
                                      placeholder="Wheelchair assistance, meal preferences, etc."
                                      class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent">{{ old('special_requests') }}</textarea>
                        </div>
                    </div>

                    <!-- Referral Code -->
                    <div class="bg-white rounded-xl shadow-lg p-6">
                        <h3 class="text-xl font-semibold text-slate-800 mb-4">
                            <i class="fas fa-gift mr-2"></i> Referral Code (Optional)
                        </h3>
                        <p class="text-slate-600 mb-4">Have a referral code? Enter it below to give your referrer a commission.</p>
                        
                        <div>
                            <input type="text" 
                                   name="referral_code" 
                                   value="{{ old('referral_code') }}" 
                                   placeholder="Enter referral code"
                                   class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent @error('referral_code') border-red-500 @enderror">
                            @error('referral_code')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <!-- Payment Method -->
                    <div class="bg-white rounded-xl shadow-lg p-6">
                        <h3 class="text-xl font-semibold text-slate-800 mb-6">
                            <i class="fas fa-credit-card mr-2"></i> Payment Method
                        </h3>

                        @forelse ($paymentMethods as $method)
                            @if($loop->first)
                                <div class="space-y-3">
                            @endif

                            <div class="relative">
                                <input type="radio"
                                       id="method_{{ $loop->index }}"
                                       name="payment_method"
                                       value="{{ $method->id }}"
                                       x-model="selectedPaymentMethod"
                                       class="sr-only peer"
                                       required>
                                <label for="method_{{ $loop->index }}"
                                       class="flex items-center p-4 bg-slate-50 border-2 border-slate-200 rounded-xl cursor-pointer hover:bg-slate-100 peer-checked:border-primary-500 peer-checked:bg-primary-50 transition-all duration-200">
                                    <div class="flex items-center space-x-4 flex-1">
                                        @if($method->img_url)
                                            <div class="w-12 h-12 bg-white rounded-xl flex items-center justify-center p-2 border border-slate-200">
                                                <img src="{{ $method->img_url }}" alt="{{ $method->name }}" class="w-full h-full object-contain">
                                            </div>
                                        @else
                                            <div class="w-12 h-12 bg-gradient-to-br from-primary-500 to-primary-600 rounded-xl flex items-center justify-center">
                                                @if(str_contains(strtolower($method->name), 'bitcoin') || str_contains(strtolower($method->name), 'btc'))
                                                    <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                                        <path d="M23.638 14.904c-1.602 6.43-8.113 10.34-14.542 8.736C2.67 22.05-1.244 15.525.362 9.105 1.962 2.67 8.475-1.243 14.9.358c6.43 1.605 10.342 8.115 8.738 14.546z"/>
                                                    </svg>
                                                @elseif(str_contains(strtolower($method->name), 'ethereum') || str_contains(strtolower($method->name), 'eth'))
                                                    <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                                        <path d="M11.944 17.97L4.58 13.62 11.943 24l7.37-10.38-7.372 4.35h.003zM12.056 0L4.69 12.223l7.365 4.354 7.365-4.35L12.056 0z"/>
                                                    </svg>
                                                @elseif(str_contains(strtolower($method->name), 'paypal'))
                                                    <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                                        <path d="M7.076 21.337H2.47a.641.641 0 0 1-.633-.74L4.944.901C5.026.382 5.474 0 5.998 0h7.46c2.57 0 4.578.543 5.69 1.81 1.01 1.15 1.304 2.42 1.012 4.287-.023.143-.047.288-.077.434-.983 4.237-4.053 6.862-8.44 6.862H9.82a.641.641 0 0 0-.633.74l-.744 4.71a.568.568 0 0 1-.563.493zm2.15-13.298a.641.641 0 0 0-.633.74l-.744 4.71a.568.568 0 0 1-.562.493H4.696a.641.641 0 0 1-.633-.74l.744-4.71A.641.641 0 0 1 5.44 8.04h3.786z"/>
                                                    </svg>
                                                @elseif(str_contains(strtolower($method->name), 'bank') || str_contains(strtolower($method->name), 'transfer'))
                                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                                    </svg>
                                                @elseif(str_contains(strtolower($method->name), 'card') || str_contains(strtolower($method->name), 'credit') || str_contains(strtolower($method->name), 'stripe'))
                                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                                                    </svg>
                                                @else
                                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                                                    </svg>
                                                @endif
                                            </div>
                                        @endif
                                        <div class="flex-1">
                                            <h4 class="font-semibold text-slate-900">{{ $method->name }}</h4>
                                            <p class="text-sm text-slate-600">
                                                @if($method->minimum && $method->maximum)
                                                    Min: ${{ number_format($method->minimum) }} - Max: ${{ number_format($method->maximum) }}
                                                @else
                                                    Fast and secure payment processing
                                                @endif
                                            </p>
                                            @if($method->duration)
                                                <p class="text-xs text-slate-500">Processing time: {{ $method->duration }}</p>
                                            @endif
                                        </div>
                                        <div class="w-5 h-5 border-2 border-slate-300 rounded-full peer-checked:border-primary-500 peer-checked:bg-primary-500 flex items-center justify-center">
                                            <div class="w-2 h-2 bg-white rounded-full opacity-0 peer-checked:opacity-100 transition-opacity"
                                                 :class="selectedPaymentMethod == {{ $method->id }} ? 'opacity-100' : 'opacity-0'"></div>
                                        </div>
                                    </div>
                                </label>
                            </div>

                            @if($loop->last)
                                </div>
                            @endif
                        @empty
                            <div class="bg-red-50 border border-red-200 rounded-xl p-6 text-center">
                                <div class="text-red-600 mb-2">
                                    <i class="fas fa-exclamation-triangle text-2xl"></i>
                                </div>
                                <h3 class="text-lg font-semibold text-red-800 mb-2">No Payment Methods Available</h3>
                                <p class="text-red-700">Please contact support to set up payment methods.</p>
                            </div>
                        @endforelse

                        @error('payment_method')
                            <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Terms & Conditions -->
                    <div class="bg-white rounded-xl shadow-lg p-6">
                        <label class="flex items-start space-x-3">
                            <input type="checkbox" 
                                   name="terms_accepted" 
                                   value="1" 
                                   required
                                   class="mt-1 text-primary-600 focus:ring-primary-500">
                            <div class="text-sm text-slate-600">
                                <p>I accept the <a href="#" class="text-primary-600 hover:text-primary-700">Terms and Conditions</a> and <a href="#" class="text-primary-600 hover:text-primary-700">Privacy Policy</a>.</p>
                                <p class="mt-2">I understand that flight bookings are subject to availability and airline policies.</p>
                            </div>
                        </label>
                        @error('terms_accepted')
                            <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <!-- Booking Summary -->
                <div class="lg:col-span-1">
                    <div class="bg-white rounded-xl shadow-lg p-6 sticky top-24">
                        <h3 class="text-xl font-semibold text-slate-800 mb-6">
                            <i class="fas fa-receipt mr-2"></i> Booking Summary
                        </h3>

                        <div class="space-y-4 mb-6">
                            <div class="flex justify-between">
                                <span class="text-slate-600">Flight Price</span>
                                <span class="font-medium">${{ number_format($flight->price, 2) }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-slate-600">Taxes & Fees</span>
                                <span class="font-medium">${{ number_format($flight->price * 0.1, 2) }}</span>
                            </div>
                            <div class="border-t border-slate-200 pt-4">
                                <div class="flex justify-between items-center">
                                    <span class="text-lg font-semibold text-slate-800">Total</span>
                                    <span class="text-2xl font-bold text-primary-600">${{ number_format($flight->price * 1.1, 2) }}</span>
                                </div>
                            </div>
                        </div>

                        <button type="submit" 
                                class="w-full bg-primary-600 hover:bg-primary-700 text-white font-semibold py-4 rounded-lg transition-colors transform hover:scale-105 shadow-lg">
                            <i class="fas fa-lock mr-2"></i> Secure Booking
                        </button>

                        <div class="mt-4 text-center">
                            <div class="flex items-center justify-center space-x-2 text-sm text-slate-500">
                                <i class="fas fa-shield-alt"></i>
                                <span>Secure SSL Encrypted</span>
                            </div>
                        </div>

                        <!-- Flight Details -->
                        <div class="mt-6 pt-6 border-t border-slate-200">
                            <h4 class="font-medium text-slate-800 mb-3">Flight Details</h4>
                            <div class="space-y-2 text-sm">
                                <div class="flex justify-between">
                                    <span class="text-slate-500">Airline:</span>
                                    <span>{{ $flight->airline }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-slate-500">Flight:</span>
                                    <span>{{ $flight->flight_number }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-slate-500">Duration:</span>
                                    <span>{{ $flight->duration }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-slate-500">Aircraft:</span>
                                    <span>{{ $flight->aircraft_type ?? 'Boeing 737' }}</span>
                                </div>
                            </div>
                        </div>

                        <!-- Support -->
                        <div class="mt-6 pt-6 border-t border-slate-200">
                            <div class="text-center">
                                <p class="text-sm text-slate-600 mb-2">Need help?</p>
                                <a href="#" class="text-primary-600 hover:text-primary-700 text-sm font-medium">
                                    <i class="fas fa-phone mr-1"></i> Contact Support
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</section>
@endsection

@push('scripts')
<script>
function bookingForm() {
    return {
        selectedPaymentMethod: null,
        
        init() {
            // Auto-select first payment method if only one is available
            const paymentMethods = document.querySelectorAll('input[name="payment_method"]');
            if (paymentMethods.length === 1) {
                this.selectedPaymentMethod = paymentMethods[0].value;
                paymentMethods[0].checked = true;
            }
        }
    }
}
</script>
@endpush