@extends('layouts.flight')

@section('title', 'Booking Details - ' . $settings->site_name)

@section('content')
<!-- Main Receipt Container -->
<section class="py-8 md:py-12 bg-gradient-to-br from-gray-50 via-blue-50/30 to-gray-50 min-h-screen">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">

        <!-- Back Button & Print Button -->
        <div class="mb-6 flex justify-between items-center no-print">
            <a href="{{ route('my.bookings') }}" class="text-blue-600 hover:text-blue-700 font-medium flex items-center">
                <i class="fas fa-arrow-left mr-2"></i>Back to My Bookings
            </a>
            <button onclick="window.print()" 
                    class="flex items-center space-x-2 bg-emerald-600 hover:bg-emerald-700 text-white font-semibold py-3 px-6 rounded-xl shadow-lg transition-all duration-200 hover:shadow-xl">
                <i class="fas fa-print text-lg"></i>
                <span>Print Receipt</span>
            </button>
        </div>

        <!-- Receipt Card -->
        <div class="bg-white rounded-2xl shadow-2xl overflow-hidden print-section" id="receipt">
            
            <!-- Header Section -->
            <div class="px-8 py-8 bg-gradient-to-br from-slate-50 to-white border-b-2 border-gray-200">
                <div class="flex justify-between items-start mb-6">
                    <!-- Logo/Brand -->
                    <div class="flex items-center space-x-3">
                        <div class="w-50 h-14 flex items-center justify-center">
                            <img src="{{ asset('storage/app/public/' . $settings->logo) }}" class="h-10 w-auto" alt="Logo">
                        </div>
                    </div>
                    
                    <!-- QR Code -->
                    <div class="text-center">
                        <div class="w-24 h-24 bg-white rounded-lg flex items-center justify-center shadow-lg p-2 border border-gray-200">
                            <img src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data={{ urlencode(route('booking.details', $booking->booking_reference)) }}" 
                                 alt="Booking QR Code" 
                                 class="w-full h-full object-contain">
                        </div>
                    </div>
                </div>

                <!-- Status Row -->
                <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-sm">
                    <div>
                        <p class="text-gray-500 mb-1 font-medium">Payment Status</p>
                        <span class="font-bold {{ $booking->payment_status === 'paid' ? 'text-emerald-600' : 'text-amber-600' }}">
                            {{ ucfirst($booking->payment_status) }}
                        </span>
                    </div>
                    <div>
                        <p class="text-gray-500 mb-1 font-medium">Booking Status</p>
                        <span class="font-bold {{ $booking->status === 'confirmed' ? 'text-emerald-600' : 'text-blue-600' }}">
                            {{ ucfirst($booking->status) }}
                        </span>
                    </div>
                    <div>
                        <p class="text-gray-500 mb-1 font-medium">Phone</p>
                        <span class="font-bold text-gray-800">{{ $booking->passenger_phone ?? 'N/A' }}</span>
                    </div>
                    <div>
                        <p class="text-gray-500 mb-1 font-medium">Email</p>
                        <span class="font-bold text-gray-800 text-xs">{{ Str::limit($booking->passenger_email, 20) }}</span>
                    </div>
                </div>
            </div>

            <!-- Pay With Section -->
            <div class="px-8 py-6 bg-gray-50 border-b border-gray-200">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-4">
                        <p class="text-gray-700 font-semibold">Pay With</p>
                        <div class="flex items-center bg-white rounded-lg px-4 py-2 shadow-sm border border-gray-200">
                            @if($booking->paymentMethod && $booking->paymentMethod->img_url)
                                <div class="w-8 h-8 mr-3 flex items-center justify-center">
                                    <img src="{{ $booking->paymentMethod->img_url }}" alt="{{ $booking->payment_method_display }}" class="w-full h-full object-contain">
                                </div>
                            @else
                                <i class="fas fa-university text-blue-600 mr-3 text-lg"></i>
                            @endif
                            <span class="font-semibold text-gray-800">{{ $booking->payment_method_display }}</span>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="text-gray-500 text-sm mb-1">Total Amount</p>
                        <p class="text-3xl font-bold text-gray-900">{{ $settings->currency }}{{ number_format($booking->price_paid, 2) }}</p>
                    </div>
                </div>
            </div>

            <!-- Booking Information Table -->
            <div class="px-8 py-6 bg-white border-b border-gray-200">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="border-b border-gray-200">
                                <th class="text-left py-3 px-4 text-sm font-semibold text-gray-700">Booking ID</th>
                                <th class="text-left py-3 px-4 text-sm font-semibold text-gray-700">Booking Reference</th>
                                <th class="text-left py-3 px-4 text-sm font-semibold text-gray-700">PNR</th>
                                <th class="text-left py-3 px-4 text-sm font-semibold text-gray-700">Booking Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="py-4 px-4 font-bold text-gray-900">{{ $booking->id }}</td>
                                <td class="py-4 px-4 font-bold text-gray-900">{{ $booking->booking_reference }}</td>
                                <td class="py-4 px-4 font-medium text-gray-700">{{ $booking->booking_reference }}</td>
                                <td class="py-4 px-4 font-medium text-gray-700">{{ $booking->created_at->format('Y-m-d') }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Travellers Section -->
            <div class="px-8 py-6 bg-white border-b border-gray-200">
                <h3 class="text-xl font-bold text-gray-800 mb-4 uppercase tracking-wide">Travellers</h3>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="bg-gray-50 border-b border-gray-200">
                                <th class="text-left py-3 px-4 text-sm font-semibold text-gray-700">No</th>
                                <th class="text-left py-3 px-4 text-sm font-semibold text-gray-700">SR</th>
                                <th class="text-left py-3 px-4 text-sm font-semibold text-gray-700">Name</th>
                                <th class="text-left py-3 px-4 text-sm font-semibold text-gray-700">Email</th>
                                <th class="text-left py-3 px-4 text-sm font-semibold text-gray-700">Phone</th>
                                @if($booking->seat_number)
                                <th class="text-left py-3 px-4 text-sm font-semibold text-gray-700">Seat</th>
                                @endif
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="border-b border-gray-100 hover:bg-gray-50 transition-colors">
                                <td class="py-4 px-4 font-semibold text-gray-900">1</td>
                                <td class="py-4 px-4 font-medium text-gray-700">{{ $booking->passenger_details['title'] ?? 'Mr' }}</td>
                                <td class="py-4 px-4 font-semibold text-gray-900">{{ $booking->passenger_name }}</td>
                                <td class="py-4 px-4 font-medium text-gray-700">{{ $booking->passenger_email }}</td>
                                <td class="py-4 px-4 font-medium text-gray-700">{{ $booking->passenger_phone ?? 'N/A' }}</td>
                                @if($booking->seat_number)
                                <td class="py-4 px-4 font-medium text-gray-700">{{ $booking->seat_number }}</td>
                                @endif
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Flights Section -->
            <div class="px-8 py-6 bg-white border-b border-gray-200">
                <h3 class="text-xl font-bold text-gray-800 mb-6 uppercase tracking-wide">Flights</h3>
                
                <div class="bg-gray-50 rounded-xl p-6 border border-gray-200">
                    <!-- Flight Header -->
                    <div class="flex items-center justify-between mb-6 pb-4 border-b border-gray-200">
                        <div class="flex items-center space-x-4">
                            <div class="w-16 h-16 bg-white rounded-lg flex items-center justify-center border border-gray-200 p-2">
                                @if($booking->flight->airline_logo)
                                    <img src="{{ asset('storage/app/public/' . $booking->flight->airline_logo) }}" alt="{{ $booking->flight->airline }}" class="w-full h-full object-contain">
                                @else
                                    <i class="fas fa-plane text-blue-600 text-2xl"></i>
                                @endif
                            </div>
                            <div>
                                <p class="text-sm text-gray-500">{{ $booking->flight->flight_type === 'oneway' ? 'Oneway' : 'Return' }}</p>
                                <p class="text-xl font-bold text-gray-900">{{ $booking->flight->airline }}</p>
                            </div>
                        </div>
                        <div class="text-right">
                            <p class="text-sm text-gray-500">Cabin Baggage: {{ $booking->flight->baggage_allowance ?? '45' }}</p>
                            <p class="text-sm text-gray-500">Baggage: {{ $booking->flight->checked_baggage ?? '32' }}</p>
                        </div>
                        <div class="text-gray-400">
                            <i class="fas fa-suitcase-rolling text-xl"></i>
                        </div>
                    </div>

                    <!-- Flight Timeline -->
                    <div class="space-y-6">
                        <!-- Departure -->
                        <div class="flex items-center space-x-4">
                            <div class="w-3 h-3 bg-blue-600 rounded-full ring-4 ring-blue-100"></div>
                            <div class="flex-1 grid grid-cols-4 gap-4">
                                <div>
                                    <p class="text-sm text-gray-500 mb-1"><i class="far fa-calendar mr-1"></i>{{ $booking->flight->departure_time->format('d-m-Y') }}</p>
                                    <p class="text-lg font-bold text-gray-900"><i class="far fa-clock mr-1"></i>{{ $booking->flight->departure_time->format('H:i') }}</p>
                                </div>
                                <div class="col-span-2">
                                    <p class="text-sm text-gray-500 mb-1">Depart From</p>
                                    <p class="font-bold text-gray-900">
                                        @if($booking->flight->originAirport)
                                            {{ $booking->flight->originAirport->iata_code }} ({{ $booking->flight->originAirport->name }})
                                        @else
                                            Unknown Airport
                                        @endif
                                    </p>
                                </div>
                                <div class="text-right">
                                    <p class="text-sm text-gray-500">Trip Duration</p>
                                    <p class="font-bold text-gray-900">{{ $booking->flight->duration }}</p>
                                </div>
                            </div>
                        </div>

                        <!-- Connection Line -->
                        <div class="flex items-center space-x-4">
                            <div class="w-3 h-12 border-l-2 border-dashed border-gray-300 ml-1.5"></div>
                        </div>

                        <!-- Arrival -->
                        <div class="flex items-center space-x-4">
                            <div class="w-3 h-3 bg-emerald-600 rounded-full ring-4 ring-emerald-100"></div>
                            <div class="flex-1 grid grid-cols-4 gap-4">
                                <div>
                                    <p class="text-sm text-gray-500 mb-1"><i class="far fa-calendar mr-1"></i>{{ $booking->flight->arrival_time->format('d-m-Y') }}</p>
                                    <p class="text-lg font-bold text-gray-900"><i class="far fa-clock mr-1"></i>{{ $booking->flight->arrival_time->format('H:i') }}</p>
                                </div>
                                <div class="col-span-3">
                                    <p class="text-sm text-gray-500 mb-1">Arrive At</p>
                                    <p class="font-bold text-gray-900">
                                        @if($booking->flight->destinationAirport)
                                            {{ $booking->flight->destinationAirport->iata_code }} ({{ $booking->flight->destinationAirport->name }})
                                        @else
                                            Unknown Airport
                                        @endif
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Fare Details Section -->
            <div class="px-8 py-6 bg-white border-b border-gray-200">
                <h3 class="text-xl font-bold text-gray-800 mb-4 uppercase tracking-wide">Fare Details</h3>
                <div class="space-y-3">
                    <div class="flex justify-between items-center py-2">
                        <span class="text-gray-700 font-medium">Ticket Fare</span>
                        <span class="text-lg font-bold text-gray-900">{{ $settings->currency }}{{ number_format($booking->price_paid, 2) }}</span>
                    </div>
                    @if($booking->commission_amount > 0)
                    <div class="flex justify-between items-center py-2 text-emerald-600">
                        <span class="font-medium flex items-center">
                            <i class="fas fa-tag mr-2"></i>Referral Discount
                        </span>
                        <span class="text-lg font-bold">-{{ $settings->currency }}{{ number_format($booking->commission_amount, 2) }}</span>
                    </div>
                    @endif
                    <div class="border-t border-gray-300 pt-3 mt-3">
                        <div class="flex justify-between items-center">
                            <span class="text-xl font-bold text-gray-900">Total Amount Paid</span>
                            <span class="text-2xl font-bold text-blue-600">{{ $settings->currency }}{{ number_format($booking->price_paid - ($booking->commission_amount ?? 0), 2) }}</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Customer & Contact Information -->
            <div class="px-8 py-6 bg-gray-50">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <h4 class="text-sm font-bold text-gray-600 mb-3 uppercase tracking-wide">Customer Details</h4>
                        <div class="space-y-2 text-sm">
                            <div class="flex justify-between">
                                <span class="text-gray-600">Email</span>
                                <span class="text-gray-900 font-semibold">{{ $booking->passenger_email }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Contact</span>
                                <span class="text-gray-900 font-semibold">{{ $booking->passenger_phone ?? 'N/A' }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Booking Date</span>
                                <span class="text-gray-900 font-semibold text-xs">{{ $booking->created_at->format('M d, Y H:i') }}</span>
                            </div>
                        </div>
                    </div>
                    <div>
                        <h4 class="text-sm font-bold text-gray-600 mb-3 uppercase tracking-wide">Support Information</h4>
                        <div class="space-y-2 text-sm">
                            <div class="flex items-start">
                                <i class="fas fa-phone text-blue-600 mr-2 mt-1"></i>
                                <div>
                                    <p class="text-gray-600">Phone Support</p>
                                    <p class="text-gray-900 font-semibold">{{ $settings->whatsapp ?? 'N/A' }}</p>
                                </div>
                            </div>
                            <div class="flex items-start">
                                <i class="fas fa-envelope text-blue-600 mr-2 mt-1"></i>
                                <div>
                                    <p class="text-gray-600">Email Support</p>
                                    <p class="text-gray-900 font-semibold text-xs">{{ $settings->contact_email ?? 'N/A' }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Footer Text -->
                <div class="border-t border-gray-300 pt-4 text-center">
                    <p class="text-xs text-gray-500 mb-2">Thank you for choosing {{ $settings->site_name }}. Have a great flight!</p>
                    <p class="text-xs text-gray-500">This is an official receipt. Please keep it for your records.</p>
                    <p class="text-xs text-gray-400 mt-2">Last updated on {{ $booking->updated_at->format('F d, Y \a\t H:i:s') }}</p>
                </div>
            </div>

        </div>

        <!-- Action Buttons -->
        <div class="mt-8 grid grid-cols-1 md:grid-cols-{{ $booking->payment_status !== 'paid' ? '3' : '2' }} gap-4 no-print">
            @if($booking->payment_status !== 'paid')
            <a href="{{ route('flights.booking.payment', $booking) }}" 
               class="bg-emerald-600 hover:bg-emerald-700 text-white font-semibold py-3 px-6 rounded-xl transition-all duration-200 text-center shadow-lg hover:shadow-xl flex items-center justify-center space-x-2">
                <i class="fas fa-credit-card"></i>
                <span>Complete Payment</span>
            </a>
            @endif
            
            <a href="mailto:{{ $booking->passenger_email }}?subject=Flight Booking Confirmation - {{ $booking->booking_reference }}" 
               class="bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-6 rounded-xl transition-all duration-200 text-center shadow-lg hover:shadow-xl flex items-center justify-center space-x-2">
                <i class="fas fa-envelope"></i>
                <span>Email Receipt</span>
            </a>
            
            <a href="{{ route('flights.search') }}" 
               class="bg-gray-600 hover:bg-gray-700 text-white font-semibold py-3 px-6 rounded-xl transition-all duration-200 text-center shadow-lg hover:shadow-xl flex items-center justify-center space-x-2">
                <i class="fas fa-plane"></i>
                <span>Book Another Flight</span>
            </a>
        </div>

        <!-- Information Cards -->
        <div class="mt-8 grid grid-cols-1 md:grid-cols-2 gap-6 no-print">
            <!-- Check-in Information -->
            <div class="bg-blue-50 border border-blue-200 rounded-xl p-6">
                <h4 class="font-bold text-blue-900 mb-3 flex items-center">
                    <i class="fas fa-plane-departure mr-2"></i> Check-in Information
                </h4>
                <ul class="space-y-2 text-sm text-blue-800">
                    <li class="flex items-start">
                        <i class="fas fa-check-circle mr-2 mt-0.5 text-blue-600"></i>
                        <span>Online check-in opens 24 hours before departure</span>
                    </li>
                    <li class="flex items-start">
                        <i class="fas fa-check-circle mr-2 mt-0.5 text-blue-600"></i>
                        <span>Arrive 2 hours early for domestic flights</span>
                    </li>
                    <li class="flex items-start">
                        <i class="fas fa-check-circle mr-2 mt-0.5 text-blue-600"></i>
                        <span>Arrive 3 hours early for international flights</span>
                    </li>
                </ul>
            </div>

            <!-- Baggage Information -->
            <div class="bg-emerald-50 border border-emerald-200 rounded-xl p-6">
                <h4 class="font-bold text-emerald-900 mb-3 flex items-center">
                    <i class="fas fa-suitcase mr-2"></i> Baggage Allowance
                </h4>
                <ul class="space-y-2 text-sm text-emerald-800">
                    <li class="flex items-start">
                        <i class="fas fa-check-circle mr-2 mt-0.5 text-emerald-600"></i>
                        <span>Carry-on: 1 bag up to 8kg (included)</span>
                    </li>
                    <li class="flex items-start">
                        <i class="fas fa-check-circle mr-2 mt-0.5 text-emerald-600"></i>
                        <span>Checked baggage: 1 bag up to 20kg (included)</span>
                    </li>
                    <li class="flex items-start">
                        <i class="fas fa-check-circle mr-2 mt-0.5 text-emerald-600"></i>
                        <span>Additional baggage fees may apply</span>
                    </li>
                </ul>
            </div>
        </div>

        @if($booking->payment_status !== 'paid')
        <!-- Payment Pending Notice -->
        <div class="mt-6 bg-amber-50 border-l-4 border-amber-500 rounded-r-xl p-6 no-print">
            <div class="flex items-center">
                <i class="fas fa-exclamation-triangle text-amber-600 text-2xl mr-4"></i>
                <div>
                    <p class="font-bold text-amber-900">Payment Pending</p>
                    <p class="text-sm text-amber-800">Your booking is confirmed but payment is still being processed. Please complete the payment to confirm your booking.</p>
                </div>
            </div>
        </div>
        @endif
    </div>
</section>
@endsection

@push('styles')
<style>
@media print {
    body {
        margin: 0;
        padding: 0;
        background: white;
    }
    
    body * {
        visibility: hidden;
    }
    
    .print-section, .print-section * {
        visibility: visible;
    }
    
    .print-section {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
        box-shadow: none !important;
        border-radius: 0 !important;
        margin: 0;
    }
    
    .no-print {
        display: none !important;
    }
    
    /* Print-specific styles */
    @page {
        margin: 1.5cm;
        size: A4;
    }
    
    /* Ensure colors print properly */
    * {
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
    }
    
    /* Prevent page breaks inside important sections */
    .print-section > div {
        page-break-inside: avoid;
    }

    /* Optimize spacing for print */
    .px-8 {
        padding-left: 1.5rem;
        padding-right: 1.5rem;
    }

    .py-6 {
        padding-top: 1rem;
        padding-bottom: 1rem;
    }
}

/* Screen-only animations */
@media screen {
    .print-section {
        animation: fadeIn 0.6s ease-out;
    }
    
    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
}
</style>
@endpush

@push('scripts')
<script>
// Auto-scroll to receipt on page load
document.addEventListener('DOMContentLoaded', function() {
    setTimeout(function() {
        const receipt = document.getElementById('receipt');
        if (receipt) {
            receipt.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }
    }, 300);
});
</script>
@endpush
