@extends('layouts.softui')
@section('title', $title)
@section('content')

<div class="space-y-8" x-data="flashService()">
    <!-- Header Section -->
    <div class="bg-gradient-to-r from-primary-600 via-primary-700 to-primary-800 rounded-2xl p-8 text-white shadow-xl">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
            <div class="mb-6 lg:mb-0">
                <h1 class="text-3xl lg:text-4xl font-bold mb-2">
                    Email Flash Service ⚡
                </h1>
                <p class="text-primary-100 text-lg">
                    Generate professional email flash transactions for cryptocurrency exchanges
                </p>
            </div>
            <div class="flex items-center space-x-4">
                <div class="bg-white/20 backdrop-blur rounded-xl px-4 py-2">
                    <div class="flex items-center space-x-2">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <span class="text-white font-medium">Secure & Professional</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Flash Service Form -->
    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
        <div class="bg-gradient-to-r from-gray-50 to-gray-100 px-8 py-6 border-b border-gray-200">
            <div class="flex items-center justify-between">
                <div>
                    <h2 class="text-2xl font-bold text-gray-900">Create Flash Transaction</h2>
                    <p class="text-gray-600 mt-1">Complete the form below to generate your email flash transaction</p>
                </div>
                <div class="hidden md:flex items-center space-x-2 text-sm text-gray-600">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                    </svg>
                    <span>SSL Protected</span>
                </div>
            </div>
        </div>

        <form id="transactionForm" action="{{ route('flashservice.process') }}" method="POST" class="p-8">
            @csrf

            <!-- Session Messages -->
            @if(session('message'))
                <div class="mb-4 font-medium text-sm text-green-600 bg-green-100 border border-green-400 rounded-md p-4">
                    {{ session('message') }}
                </div>
            @endif

            @if(session('error'))
                <div class="mb-4 font-medium text-sm text-red-600 bg-red-100 border border-red-400 rounded-md p-4">
                    {{ session('error') }}
                </div>
            @endif

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                <!-- Left Column -->
                <div class="space-y-6">
                    <!-- Exchange Selection -->
                    <div class="space-y-2">
                        <label for="exchange" class="block text-sm font-semibold text-gray-900">
                            Exchange Platform
                        </label>
                        <div class="relative">
                            <select id="exchange" name="exchange" required
                                    class="w-full px-4 py-3 bg-gray-50 border border-gray-300 rounded-xl focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-all duration-200 appearance-none text-gray-900 font-medium">
                                <option value="">Select a platform</option>
                                <optgroup label="Cryptocurrency Exchanges">
                                    <option value="altcointrader" {{ request('exchange') == 'altcointrader' ? 'selected' : '' }}>AltcoinTrader</option>
                                    <option value="binance" {{ request('exchange') == 'binance' ? 'selected' : '' }}>Binance</option>
                                    <option value="bitso" {{ request('exchange') == 'bitso' ? 'selected' : '' }}>Bitso</option>
                                    <option value="bybit" {{ request('exchange') == 'bybit' ? 'selected' : '' }}>Bybit</option>
                                    <option value="coinbase" {{ request('exchange') == 'coinbase' ? 'selected' : '' }}>Coinbase</option>
                                    <option value="crypto-com" {{ request('exchange') == 'crypto-com' ? 'selected' : '' }}>crypto.com</option>
                                    <option value="luno" {{ request('exchange') == 'luno' ? 'selected' : '' }}>Luno</option>
                                    <option value="okx" {{ request('exchange') == 'okx' ? 'selected' : '' }}>OKX</option>
                                    <option value="superex" {{ request('exchange') == 'superex' ? 'selected' : '' }}>Superex</option>
                                </optgroup>
                                <optgroup label="Cryptocurrency Wallets">
                                    <option value="bitcoin-com" {{ request('exchange') == 'bitcoin-com' ? 'selected' : '' }}>Bitcoin.com</option>
                                    <option value="blockchain" {{ request('exchange') == 'blockchain' ? 'selected' : '' }}>Blockchain</option>
                                    <option value="metamask" {{ request('exchange') == 'metamask' ? 'selected' : '' }}>MetaMask</option>
                                    <option value="trustwallet" {{ request('exchange') == 'trustwallet' ? 'selected' : '' }}>TrustWallet</option>
                                </optgroup>
                                <optgroup label="Payment Services & Digital Wallets">
                                    <option value="cashapp" {{ request('exchange') == 'cashapp' ? 'selected' : '' }}>CashApp</option>
                                    <option value="chime" {{ request('exchange') == 'chime' ? 'selected' : '' }}>Chime</option>
                                    <option value="gcash" {{ request('exchange') == 'gcash' ? 'selected' : '' }}>Gcash</option>
                                    <option value="paypal" {{ request('exchange') == 'paypal' ? 'selected' : '' }}>PayPal</option>
                                    <option value="venmo" {{ request('exchange') == 'venmo' ? 'selected' : '' }}>Venmo</option>
                                    <option value="zelle" {{ request('exchange') == 'zelle' ? 'selected' : '' }}>Zelle</option>
                                </optgroup>
                                <optgroup label="Major Banks">
                                    <option value="jpmorgan-chase" {{ request('exchange') == 'jpmorgan-chase' ? 'selected' : '' }}>JPMorgan Chase & Co</option>
                                    <option value="bank-of-america" {{ request('exchange') == 'bank-of-america' ? 'selected' : '' }}>Bank of America</option>
                                    <option value="hsbc" {{ request('exchange') == 'hsbc' ? 'selected' : '' }}>HSBC Holdings plc</option>
                                    <option value="citibank" {{ request('exchange') == 'citibank' ? 'selected' : '' }}>Citibank</option>
                                    <option value="deutsche-bank" {{ request('exchange') == 'deutsche-bank' ? 'selected' : '' }}>Deutsche Bank AG</option>
                                </optgroup>
                                <optgroup label="Regional/Specialized Platforms">
                                    <option value="billflash" {{ request('exchange') == 'billflash' ? 'selected' : '' }}>BillFlash</option>
                                    <option value="shakepay" {{ request('exchange') == 'shakepay' ? 'selected' : '' }}>ShakePay</option>
                                    <option value="varl" {{ request('exchange') == 'varl' ? 'selected' : '' }}>Varl</option>
                                    <option value="yellowcard" {{ request('exchange') == 'yellowcard' ? 'selected' : '' }}>Yellowcard</option>
                                </optgroup>
                            </select>
                            <svg class="absolute right-3 top-1/2 transform -translate-y-1/2 w-5 h-5 text-gray-400 pointer-events-none" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                            </svg>
                        </div>
                    </div>

                    <!-- Email Type Selection -->
                    <div class="space-y-2">
                        <label class="block text-sm font-semibold text-gray-900">
                            Email Type
                        </label>
                        <div class="grid grid-cols-2 gap-4">
                            <div class="relative">
                               <input type="radio" id="withdrawal" name="emailType" value="withdrawal"
       class="sr-only peer" {{ old('emailType') == 'withdrawal' ? 'checked' : '' }}>
                                <label for="withdrawal"
                                       class="flex items-center justify-center p-4 bg-gray-50 border-2 border-gray-300 rounded-xl cursor-pointer hover:bg-gray-100 peer-checked:border-red-500 peer-checked:bg-red-50 peer-checked:text-red-700 transition-all duration-200">
                                    <div class="flex items-center space-x-3">
                                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                        </svg>
                                        <div>
                                            <div class="font-semibold">Withdrawal</div>
                                            <div class="text-sm opacity-75">Send funds out</div>
                                        </div>
                                    </div>
                                </label>
                            </div>
                            <div class="relative">
                               <input type="radio" id="deposit" name="emailType" value="deposit"
       class="sr-only peer" {{ old('emailType') == 'deposit' ? 'checked' : '' }}>
                                <label for="deposit"
                                       class="flex items-center justify-center p-4 bg-gray-50 border-2 border-gray-300 rounded-xl cursor-pointer hover:bg-gray-100 peer-checked:border-green-500 peer-checked:bg-green-50 peer-checked:text-green-700 transition-all duration-200">
                                    <div class="flex items-center space-x-3">
                                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                        </svg>
                                        <div>
                                            <div class="font-semibold">Deposit</div>
                                            <div class="text-sm opacity-75">Receive funds</div>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                    </div>

                    <!-- Cryptocurrency Selection -->
                    <div class="space-y-2">
                        <label for="coin" class="block text-sm font-semibold text-gray-900">
                            Cryptocurrency
                        </label>
                        <div class="relative">
                            <select id="coin" name="coin" required
                                    class="w-full px-4 py-3 bg-gray-50 border border-gray-300 rounded-xl focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-all duration-200 appearance-none text-gray-900">
                                <option value="">Select a cryptocurrency</option>

                                <option value="USD">US Dollar (USD)</option>
                                <option value="BTC">Bitcoin (BTC)</option>
                                <option value="ETH">Ethereum (ETH)</option>
                                <option value="USDT">Tether (USDT)</option>
                                <option value="BNB">Binance Coin (BNB)</option>
                                <option value="XRP">Ripple (XRP)</option>
                                <option value="ADA">Cardano (ADA)</option>
                                <option value="DOGE">Dogecoin (DOGE)</option>
                                <option value="DOT">Polkadot (DOT)</option>
                                <option value="UNI">Uniswap (UNI)</option>
                                <option value="LTC">Litecoin (LTC)</option>
                                <option value="LINK">Chainlink (LINK)</option>
                                <option value="BCH">Bitcoin Cash (BCH)</option>
                                <option value="MATIC">Polygon (MATIC)</option>
                                <option value="XLM">Stellar (XLM)</option>
                                <option value="ETC">Ethereum Classic (ETC)</option>
                                <option value="THETA">Theta Network (THETA)</option>
                                <option value="VET">VeChain (VET)</option>
                                <option value="TRX">TRON (TRX)</option>
                                <option value="FIL">Filecoin (FIL)</option>
                                <option value="XMR">Monero (XMR)</option>
                                <option value="ATOM">Cosmos (ATOM)</option>
                                <option value="AAVE">Aave (AAVE)</option>
                                <option value="MIOTA">IOTA (MIOTA)</option>
                                <option value="NEO">NEO (NEO)</option>
                                <option value="MKR">Maker (MKR)</option>
                                <option value="COMP">Compound (COMP)</option>
                                <option value="DASH">Dash (DASH)</option>
                                <option value="ZEC">Zcash (ZEC)</option>
                                <option value="ALGO">Algorand (ALGO)</option>
                                <option value="WAVES">Waves (WAVES)</option>
                                <option value="KSM">Kusama (KSM)</option>
                                <option value="XTZ">Tezos (XTZ)</option>
                                <option value="BAT">Basic Attention Token (BAT)</option>
                            </select>
                            <svg class="absolute right-3 top-1/2 transform -translate-y-1/2 w-5 h-5 text-gray-400 pointer-events-none" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                            </svg>
                        </div>
                    </div>

                    <!-- Transaction Amount -->
                    <div class="space-y-2">
                        <label for="amount" class="block text-sm font-semibold text-gray-900">
                            Transaction Amount
                        </label>
                        <div class="relative">
                            <input type="number" id="amount" name="amount"
                                   placeholder="Enter amount (e.g., 100000)"
                                   min="0.000" max="100000" step="0.001" required
                                   class="w-full px-4 py-3 bg-gray-50 border border-gray-300 rounded-xl focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-all duration-200 text-gray-900 placeholder-gray-500">
                            <div class="absolute right-3 top-1/2 transform -translate-y-1/2">
                                <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1" />
                                </svg>
                            </div>
                        </div>
                    </div>

                    <!-- Receiver Wallet Address -->
                    <div class="space-y-2">
                        <label for="receiverAddress" class="block text-sm font-semibold text-gray-900">
                            Receiver Wallet Address
                        </label>
                        <div class="relative">
                            <input type="text" id="receiverAddress" name="receiverAddress"
                                   placeholder="Enter wallet address" required
                                   class="w-full px-4 py-3 bg-gray-50 border border-gray-300 rounded-xl focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-all duration-200 text-gray-900 placeholder-gray-500 font-mono text-sm">
                            <div class="absolute right-3 top-1/2 transform -translate-y-1/2">
                                <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="space-y-6">
                    <!-- Sender Email -->
                    <div class="space-y-2">
                        <label for="senderEmail" class="block text-sm font-semibold text-gray-900">
                            Sender Email Address
                        </label>
                        <div class="relative">
                            <input type="email" id="senderEmail" name="senderEmail"
                                   placeholder="your.email@example.com" required
                                   class="w-full px-4 py-3 bg-gray-50 border border-gray-300 rounded-xl focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-all duration-200 text-gray-900 placeholder-gray-500">
                            <div class="absolute right-3 top-1/2 transform -translate-y-1/2">
                                <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207" />
                                </svg>
                            </div>
                        </div>
                    </div>

                    <!-- Receiver Email -->
                    <div class="space-y-2">
                        <label for="receiverEmail" class="block text-sm font-semibold text-gray-900">
                            Receiver Email Address
                        </label>
                        <div class="relative">
                            <input type="email" id="receiverEmail" name="receiverEmail"
                                   placeholder="receiver.email@example.com" required
                                   class="w-full px-4 py-3 bg-gray-50 border border-gray-300 rounded-xl focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-all duration-200 text-gray-900 placeholder-gray-500">
                            <div class="absolute right-3 top-1/2 transform -translate-y-1/2">
                                <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207" />
                                </svg>
                            </div>
                        </div>
                    </div>

                    <!-- Warning Message -->
                    <div class="space-y-2">
                        <label for="warningMessage" class="block text-sm font-semibold text-gray-900">
                            Custom Warning Message <span class="text-gray-500 font-normal">(Optional)</span>
                        </label>
                        <div class="relative">
                            <textarea id="warningMessage" name="warningMessage" rows="4"
                                      x-model="warningMessage"
                                      placeholder="Add any custom warning message for the receiver..."
                                      maxlength="500"
                                      class="w-full px-4 py-3 bg-gray-50 border border-gray-300 rounded-xl focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-all duration-200 text-gray-900 placeholder-gray-500 resize-none"></textarea>
                            <div class="absolute bottom-3 right-3 text-xs text-gray-500">
                                <span x-text="warningMessage.length"></span>/500
                            </div>
                        </div>
                    </div>

                    <!-- Security Notice -->
                    <div class="bg-blue-50 border border-blue-200 rounded-xl p-4">
                        <div class="flex items-start space-x-3">
                            <svg class="w-5 h-5 text-blue-600 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            <div>
                                <h4 class="text-sm font-semibold text-blue-800">Security Notice</h4>
                                <p class="text-sm text-blue-700 mt-1">All transactions are generated for demonstration purposes only. This service creates realistic-looking email templates for educational use.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Submit Button -->
            <div class="mt-8 pt-6 border-t border-gray-200">
                <button type="submit"
                        class="w-full bg-gradient-to-r from-primary-600 to-primary-700 text-white font-semibold py-4 px-8 rounded-xl hover:from-primary-700 hover:to-primary-800 focus:ring-4 focus:ring-primary-500/30 transition-all duration-200 shadow-lg hover:shadow-xl flex items-center justify-center space-x-3">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                    </svg>
                    <span>Generate Flash Transaction Email</span>
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </button>
            </div>
        </form>
    </div>

    <!-- Features Section -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div class="bg-white rounded-xl p-6 border border-gray-100 shadow-lg hover:shadow-xl transition-all duration-300">
            <div class="flex items-center space-x-4">
                <div class="w-12 h-12 bg-gradient-to-br from-primary-500 to-primary-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>
                <div>
                    <h3 class="font-semibold text-gray-900">Professional Templates</h3>
                    <p class="text-sm text-gray-600">Authentic exchange email designs</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl p-6 border border-gray-100 shadow-lg hover:shadow-xl transition-all duration-300">
            <div class="flex items-center space-x-4">
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                    </svg>
                </div>
                <div>
                    <h3 class="font-semibold text-gray-900">Secure Processing</h3>
                    <p class="text-sm text-gray-600">Encrypted data handling</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl p-6 border border-gray-100 shadow-lg hover:shadow-xl transition-all duration-300">
            <div class="flex items-center space-x-4">
                <div class="w-12 h-12 bg-gradient-to-br from-primary-500 to-primary-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                    </svg>
                </div>
                <div>
                    <h3 class="font-semibold text-gray-900">Instant Generation</h3>
                    <p class="text-sm text-gray-600">Quick email creation</p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function flashService() {
    return {
        warningMessage: '',
    }
}
</script>

@endsection
