@extends('layouts.softui')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100 py-8">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">

        <!-- Back Navigation -->
        <div class="mb-6">
            <a href="{{ route('email.transactions') }}" class="inline-flex items-center text-primary-600 hover:text-primary-700 font-medium">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Back to Email Transactions
            </a>
        </div>

        <!-- Transaction Header -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-200 mb-8 overflow-hidden">
            <div class="bg-gradient-to-r from-primary-600 to-primary-700 px-8 py-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-white">Transaction #{{ str_pad($transaction->id, 6, '0', STR_PAD_LEFT) }}</h1>
                        <p class="text-primary-100 mt-1">{{ $transaction->created_at->format('F j, Y \a\t g:i A') }}</p>
                    </div>
                    <div class="text-right">
                        @if($transaction->status === 'sent')
                        <div class="inline-flex items-center px-4 py-2 rounded-xl bg-green-500 bg-opacity-20 border border-green-300">
                            <svg class="w-5 h-5 mr-2 text-green-100" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                            </svg>
                            <span class="text-green-100 font-semibold">Successfully Sent</span>
                        </div>
                        @elseif($transaction->status === 'pending')
                        <div class="inline-flex items-center px-4 py-2 rounded-xl bg-yellow-500 bg-opacity-20 border border-yellow-300">
                            <svg class="w-5 h-5 mr-2 text-yellow-100 animate-spin" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                            </svg>
                            <span class="text-yellow-100 font-semibold">Processing</span>
                        </div>
                        @else
                        <div class="inline-flex items-center px-4 py-2 rounded-xl bg-red-500 bg-opacity-20 border border-red-300">
                            <svg class="w-5 h-5 mr-2 text-red-100" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                            <span class="text-red-100 font-semibold">Failed</span>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Transaction Details -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-200 p-8">
                <h2 class="text-xl font-semibold text-gray-900 mb-6">Transaction Details</h2>

                <div class="space-y-6">
                    <!-- Transaction ID -->
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="text-sm font-medium text-gray-500">Transaction ID</p>
                            <p class="text-gray-900 font-mono text-sm">{{ $transaction->transaction_id }}</p>
                        </div>
                        <button onclick="copyToClipboard('{{ $transaction->transaction_id }}')" class="text-primary-600 hover:text-primary-700 p-2 rounded-lg hover:bg-primary-50 transition-colors">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                            </svg>
                        </button>
                    </div>

                    <!-- Exchange -->
                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-xl">
                        <div class="flex items-center">
                            <div class="w-12 h-12 bg-primary-100 rounded-xl flex items-center justify-center mr-4">
                                <span class="text-primary-600 font-bold">{{ strtoupper(substr($transaction->exchange_name, 0, 2)) }}</span>
                            </div>
                            <div>
                                <p class="font-semibold text-gray-900">{{ $transaction->exchange_name }}</p>
                                <p class="text-gray-500 text-sm">Exchange Platform</p>
                            </div>
                        </div>
                    </div>

                    <!-- Amount -->
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <p class="text-sm font-medium text-gray-500">Amount</p>
                            <p class="text-2xl font-bold text-gray-900">${{ number_format($transaction->amount, 2) }}</p>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-gray-500">Currency Pair</p>
                            <p class="text-lg font-semibold text-gray-900">{{ $transaction->coin_symbol }}/{{ $transaction->currency }}</p>
                        </div>
                    </div>

                    <!-- Transaction Fee -->
                    @if($transaction->transaction_fee > 0)
                    <div>
                        <p class="text-sm font-medium text-gray-500">Transaction Fee</p>
                        <p class="text-lg font-semibold text-gray-900">{{ $settings->currency }}{{ number_format($transaction->transaction_fee, 2) }}</p>
                    </div>
                    @endif

                    <!-- Email Template Used -->
                    @if($transaction->template_used)
                    <div>
                        <p class="text-sm font-medium text-gray-500">Email Template</p>
                        <div class="mt-2 p-3 bg-blue-50 rounded-lg border border-blue-200">
                            <p class="text-blue-800 font-medium">{{ ucwords(str_replace('-', ' ', $transaction->template_used)) }}</p>
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Recipient & Additional Info -->
            <div class="space-y-8">
                <!-- Recipient Information -->
                <div class="bg-white rounded-2xl shadow-sm border border-gray-200 p-8">
                    <h2 class="text-xl font-semibold text-gray-900 mb-6">Recipient Information</h2>

                    <div class="space-y-4">
                        <div>
                            <p class="text-sm font-medium text-gray-500">Email Address</p>
                            <div class="flex items-center justify-between mt-1">
                                <p class="text-gray-900 font-medium">{{ $transaction->receiver_email }}</p>
                                <button onclick="copyToClipboard('{{ $transaction->receiver_email }}')" class="text-primary-600 hover:text-primary-700 p-2 rounded-lg hover:bg-primary-50 transition-colors">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                                    </svg>
                                </button>
                            </div>
                        </div>

                        @if($transaction->sender_name)
                        <div>
                            <p class="text-sm font-medium text-gray-500">Sender Name</p>
                            <p class="text-gray-900 font-medium">{{ $transaction->sender_name }}</p>
                        </div>
                        @endif
                    </div>
                </div>

                <!-- Timeline -->
                <div class="bg-white rounded-2xl shadow-sm border border-gray-200 p-8">
                    <h2 class="text-xl font-semibold text-gray-900 mb-6">Timeline</h2>

                    <div class="space-y-4">
                        <div class="flex items-start">
                            <div class="w-8 h-8 bg-primary-100 rounded-full flex items-center justify-center mr-4 mt-1">
                                <svg class="w-4 h-4 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                                </svg>
                            </div>
                            <div class="flex-1">
                                <p class="font-medium text-gray-900">Transaction Created</p>
                                <p class="text-gray-500 text-sm">{{ $transaction->created_at->format('M j, Y \a\t g:i A') }}</p>
                            </div>
                        </div>

                        @if($transaction->status === 'sent' && $transaction->sent_at)
                        <div class="flex items-start">
                            <div class="w-8 h-8 bg-green-100 rounded-full flex items-center justify-center mr-4 mt-1">
                                <svg class="w-4 h-4 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                </svg>
                            </div>
                            <div class="flex-1">
                                <p class="font-medium text-gray-900">Email Sent Successfully</p>
                                <p class="text-gray-500 text-sm">{{ $transaction->sent_at->format('M j, Y \a\t g:i A') }}</p>
                            </div>
                        </div>
                        @elseif($transaction->status === 'failed' && $transaction->error_message)
                        <div class="flex items-start">
                            <div class="w-8 h-8 bg-red-100 rounded-full flex items-center justify-center mr-4 mt-1">
                                <svg class="w-4 h-4 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                </svg>
                            </div>
                            <div class="flex-1">
                                <p class="font-medium text-gray-900">Email Failed</p>
                                <p class="text-gray-500 text-sm">{{ $transaction->updated_at->format('M j, Y \a\t g:i A') }}</p>
                                @if($transaction->error_message)
                                <p class="text-red-600 text-sm mt-1">{{ $transaction->error_message }}</p>
                                @endif
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="mt-8 flex flex-col sm:flex-row gap-4">
            <a href="{{ route('flashservice') }}" class="inline-flex items-center justify-center px-6 py-3 bg-primary-600 text-white font-medium rounded-lg hover:bg-primary-700 transition-colors">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Send Another Email
            </a>

            @if($transaction->status === 'failed')
            <button onclick="retryTransaction()" class="inline-flex items-center justify-center px-6 py-3 bg-yellow-600 text-white font-medium rounded-lg hover:bg-yellow-700 transition-colors">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                </svg>
                Retry Transaction
            </button>
            @endif
        </div>
    </div>
</div>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        // Show success message
        const toast = document.createElement('div');
        toast.className = 'fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg z-50';
        toast.textContent = 'Copied to clipboard!';
        document.body.appendChild(toast);

        setTimeout(() => {
            document.body.removeChild(toast);
        }, 2000);
    });
}

function retryTransaction() {
    if(confirm('Are you sure you want to retry this transaction? This will create a new transaction with the same details.')) {
        // Redirect to flash service with pre-filled data
        const params = new URLSearchParams({
            exchange: '{{ $transaction->exchange_name }}',
            email: '{{ $transaction->receiver_email }}',
            amount: '{{ $transaction->amount }}',
            coin: '{{ $transaction->coin_symbol }}',
            currency: '{{ $transaction->currency }}',
            fee: '{{ $transaction->transaction_fee }}'
        });

        window.location.href = `{{ route('flashservice') }}?${params.toString()}`;
    }
}
</script>
@endsection
