@extends('layouts.softui')
@section('title', $title)
@section('content')

<div class="space-y-8" x-data="depositForm()">
    <!-- Header Section -->
    <div class="bg-gradient-to-r from-primary-600 via-primary-700 to-primary-800 rounded-2xl p-8 text-white shadow-xl">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
            <div class="mb-6 lg:mb-0">
                <h1 class="text-3xl lg:text-4xl font-bold mb-2">
                    Account Funding 💰
                </h1>
                <p class="text-primary-100 text-lg">
                    Add funds to your Email Flashing System account to start using our services
                </p>
            </div>
            <div class="flex items-center space-x-4">
                <div class="bg-white/20 backdrop-blur rounded-xl px-4 py-2">
                    <div class="flex items-center space-x-2">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                        </svg>
                        <span class="text-white font-medium">Secure Payments</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Error and Success Alerts -->
    @if ($errors->any())
        <div class="bg-red-50 border-l-4 border-red-400 p-6 rounded-xl shadow-md" x-data="{ show: true }" x-show="show" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform scale-95" x-transition:enter-end="opacity-100 transform scale-100">
            <div class="flex items-start justify-between">
                <div class="flex items-start">
                    <div class="flex-shrink-0">
                        <svg class="w-5 h-5 text-red-400 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-semibold text-red-800">
                            {{ trans('There were some problems with your input') }}
                        </h3>
                        <div class="mt-2">
                            <ul class="list-disc list-inside text-sm text-red-700 space-y-1">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
                <button @click="show = false" class="flex-shrink-0 ml-4 text-red-400 hover:text-red-600 transition-colors">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    @endif

    @if (session('message'))
        @php
            $status = session('status', 'error');
            $alertClasses = [
                'success' => 'bg-green-50 border-green-400 text-green-800',
                'error' => 'bg-red-50 border-red-400 text-red-800',
                'warning' => 'bg-yellow-50 border-yellow-400 text-yellow-800',
                'info' => 'bg-blue-50 border-blue-400 text-blue-800'
            ];
            $iconPaths = [
                'success' => 'M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z',
                'error' => 'M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z',
                'warning' => 'M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.268 16.5c-.77.833.192 2.5 1.732 2.5z',
                'info' => 'M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z'
            ];
            $currentClass = $alertClasses[$status] ?? $alertClasses['error'];
            $currentIcon = $iconPaths[$status] ?? $iconPaths['error'];
        @endphp
        <div class="{{ $currentClass }} border-l-4 p-6 rounded-xl shadow-md" x-data="{ show: true }" x-show="show" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform scale-95" x-transition:enter-end="opacity-100 transform scale-100">
            <div class="flex items-start justify-between">
                <div class="flex items-start">
                    <div class="flex-shrink-0">
                        <svg class="w-5 h-5 {{ str_contains($currentClass, 'green') ? 'text-green-400' : (str_contains($currentClass, 'red') ? 'text-red-400' : (str_contains($currentClass, 'yellow') ? 'text-yellow-400' : 'text-blue-400')) }} mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $currentIcon }}" />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-semibold">
                            {{ ucfirst($status) }}
                        </h3>
                        <p class="mt-1 text-sm">
                            {{ session('message') }}
                        </p>
                    </div>
                </div>
                <button @click="show = false" class="flex-shrink-0 ml-4 {{ str_contains($currentClass, 'green') ? 'text-green-400 hover:text-green-600' : (str_contains($currentClass, 'red') ? 'text-red-400 hover:text-red-600' : (str_contains($currentClass, 'yellow') ? 'text-yellow-400 hover:text-yellow-600' : 'text-blue-400 hover:text-blue-600')) }} transition-colors">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    @endif

    @if (session('success'))
        <div class="bg-green-50 border-l-4 border-green-400 text-green-800 p-6 rounded-xl shadow-md" x-data="{ show: true }" x-show="show" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform scale-95" x-transition:enter-end="opacity-100 transform scale-100">
            <div class="flex items-start justify-between">
                <div class="flex items-start">
                    <div class="flex-shrink-0">
                        <svg class="w-5 h-5 text-green-400 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-semibold">
                            Success
                        </h3>
                        <p class="mt-1 text-sm">
                            {{ session('success') }}
                        </p>
                    </div>
                </div>
                <button @click="show = false" class="flex-shrink-0 ml-4 text-green-400 hover:text-green-600 transition-colors">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    @endif

    @if (session('warning'))
        <div class="bg-yellow-50 border-l-4 border-yellow-400 text-yellow-800 p-6 rounded-xl shadow-md" x-data="{ show: true }" x-show="show" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform scale-95" x-transition:enter-end="opacity-100 transform scale-100">
            <div class="flex items-start justify-between">
                <div class="flex items-start">
                    <div class="flex-shrink-0">
                        <svg class="w-5 h-5 text-yellow-400 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.268 16.5c-.77.833.192 2.5 1.732 2.5z" />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-semibold">
                            Warning
                        </h3>
                        <p class="mt-1 text-sm">
                            {{ session('warning') }}
                        </p>
                    </div>
                </div>
                <button @click="show = false" class="flex-shrink-0 ml-4 text-yellow-400 hover:text-yellow-600 transition-colors">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    @endif

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Main Deposit Form -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
                <div class="bg-gradient-to-r from-gray-50 to-gray-100 px-8 py-6 border-b border-gray-200">
                    <div class="flex items-center justify-between">
                        <div>
                            <h2 class="text-2xl font-bold text-gray-900">Make a Deposit</h2>
                            <p class="text-gray-600 mt-1">Choose your deposit amount and payment method</p>
                        </div>
                        <div class="hidden md:flex items-center space-x-2 text-sm text-gray-600">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            <span>Instant Processing</span>
                        </div>
                    </div>
                </div>

                <form action="{{ route('newdeposit') }}" method="post" id="submitpaymentform" class="p-8">
                    @csrf
                    <div class="space-y-6">
                        <!-- Deposit Amount -->
                        <div class="space-y-2">
                            <label for="amount" class="block text-sm font-semibold text-gray-900">
                                Deposit Amount
                            </label>
                            <div class="relative">
                                <input type="number"
                                       id="amount"
                                       name="amount"
                                       x-model="amount"
                                       placeholder="Enter amount to deposit"
                                       min="{{ $moresettings->minamt }}"
                                       required
                                       class="w-full px-4 py-3 bg-gray-50 border border-gray-300 rounded-xl focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-all duration-200 text-gray-900 placeholder-gray-500 text-lg font-semibold">
                                <div class="absolute right-3 top-1/2 transform -translate-y-1/2">
                                    <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1" />
                                    </svg>
                                </div>
                            </div>
                            <p class="text-sm text-gray-600">
                                Minimum deposit: <span class="font-semibold text-primary-600">{{ $settings->currency }}{{ number_format($moresettings->minamt, 2) }}</span>
                            </p>
                        </div>

                        <!-- Quick Amount Buttons -->
                        <div class="space-y-2">
                            <label class="block text-sm font-semibold text-gray-900">Quick Amount Selection</label>
                            <div class="grid grid-cols-2 sm:grid-cols-4 gap-3">
                                @php
                                    $quickAmounts = [100, 500, 1000, 5000];
                                @endphp
                                @foreach($quickAmounts as $quickAmount)
                                <button type="button"
                                        @click="amount = {{ $quickAmount }}"
                                        class="px-4 py-2 bg-primary-50 text-primary-700 rounded-xl hover:bg-primary-100 transition-colors font-semibold text-sm border border-primary-200 hover:border-primary-300">
                                    {{ $settings->currency }}{{ number_format($quickAmount) }}
                                </button>
                                @endforeach
                            </div>
                        </div>

                        <!-- Payment Method Selection -->
                        <div class="space-y-2">
                            <label for="payment_method" class="block text-sm font-semibold text-gray-900">
                                Payment Method
                            </label>
                            @forelse ($dmethods as $method)
                                @if($loop->first)
                                    <div class="space-y-3">
                                @endif

                                <div class="relative">
                                    <input type="radio"
                                           id="method_{{ $loop->index }}"
                                           name="payment_method"
                                           value="{{ $method->name }}"
                                           x-model="selectedMethod"
                                           class="sr-only peer"
                                           required>
                                    <label for="method_{{ $loop->index }}"
                                           class="flex items-center p-4 bg-gray-50 border-2 border-gray-200 rounded-xl cursor-pointer hover:bg-gray-100 peer-checked:border-primary-500 peer-checked:bg-primary-50 transition-all duration-200">
                                        <div class="flex items-center space-x-4 flex-1">
                                            <div class="w-12 h-12 bg-gradient-to-br from-primary-500 to-primary-600 rounded-xl flex items-center justify-center">
                                                @if(str_contains(strtolower($method->name), 'bitcoin') || str_contains(strtolower($method->name), 'btc'))
                                                    <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                                        <path d="M23.638 14.904c-1.602 6.43-8.113 10.34-14.542 8.736C2.67 22.05-1.244 15.525.362 9.105 1.962 2.67 8.475-1.243 14.9.358c6.43 1.605 10.342 8.115 8.738 14.546z"/>
                                                    </svg>
                                                @elseif(str_contains(strtolower($method->name), 'ethereum') || str_contains(strtolower($method->name), 'eth'))
                                                    <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                                        <path d="M11.944 17.97L4.58 13.62 11.943 24l7.37-10.38-7.372 4.35h.003zM12.056 0L4.69 12.223l7.365 4.354 7.365-4.35L12.056 0z"/>
                                                    </svg>
                                                @else
                                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                                                    </svg>
                                                @endif
                                            </div>
                                            <div class="flex-1">
                                                <h3 class="font-semibold text-gray-900">{{ $method->name }}</h3>
                                                <p class="text-sm text-gray-600">Fast and secure payment processing</p>
                                            </div>
                                            <div class="w-5 h-5 border-2 border-gray-300 rounded-full peer-checked:border-primary-500 peer-checked:bg-primary-500 flex items-center justify-center">
                                                <div class="w-2 h-2 bg-white rounded-full opacity-0 peer-checked:opacity-100 transition-opacity"
                                                     :class="selectedMethod === '{{ $method->name }}' ? 'opacity-100' : 'opacity-0'"></div>
                                            </div>
                                        </div>
                                    </label>
                                </div>

                                @if($loop->last)
                                    </div>
                                @endif
                            @empty
                                <div class="bg-red-50 border border-red-200 rounded-xl p-6 text-center">
                                    <svg class="w-12 h-12 text-red-600 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16c-.77.833.192 2.5 1.732 2.5z" />
                                    </svg>
                                    <h3 class="text-lg font-semibold text-red-800 mb-2">No Payment Methods Available</h3>
                                    <p class="text-red-700">No payment methods are enabled at the moment. Please check back later or contact support.</p>
                                </div>
                            @endforelse
                        </div>

                        <!-- Security Notice -->
                        <div class="bg-blue-50 border border-blue-200 rounded-xl p-4">
                            <div class="flex items-start space-x-3">
                                <svg class="w-5 h-5 text-blue-600 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                <div>
                                    <h4 class="text-sm font-semibold text-blue-800">Security Notice</h4>
                                    <p class="text-sm text-blue-700 mt-1">All transactions are processed securely. Your funds will be credited to your account instantly upon confirmation.</p>
                                </div>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        @if (count($dmethods) > 0)
                        <div class="pt-4">
                            <button type="submit"
                                    :disabled="!amount || !selectedMethod"
                                    class="w-full bg-gradient-to-r from-primary-600 to-primary-700 text-white font-semibold py-4 px-8 rounded-xl hover:from-primary-700 hover:to-primary-800 focus:ring-4 focus:ring-primary-500/30 transition-all duration-200 shadow-lg hover:shadow-xl flex items-center justify-center space-x-3 disabled:opacity-50 disabled:cursor-not-allowed">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                                </svg>
                                <span>Proceed to Payment</span>
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                </svg>
                            </button>
                        </div>
                        <input type="hidden" id="lastchosen" value="0">
                        @endif
                    </div>
                </form>
            </div>
        </div>

        <!-- Sidebar Information -->
        <div class="space-y-6">
            <!-- Account Summary -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
                <div class="bg-gradient-to-r from-primary-500 to-primary-600 px-6 py-4">
                    <h3 class="text-lg font-semibold text-white">Account Summary</h3>
                </div>
                <div class="p-6 space-y-4">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center space-x-3">
                            <div class="w-10 h-10 bg-gradient-to-br from-primary-500 to-primary-600 rounded-lg flex items-center justify-center">
                                <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1" />
                                </svg>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-600">Total Deposits</p>
                                <p class="text-2xl font-bold text-gray-900">{{ $settings->currency }}{{ number_format($deposited, 2, '.', ',') }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="pt-4 border-t border-gray-200">
                        <a href="{{ route('accounthistory') }}"
                           class="inline-flex items-center text-primary-600 hover:text-primary-700 font-semibold text-sm transition-colors">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                            </svg>
                            View Deposit History
                            <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                            </svg>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Benefits Card -->
            <div class="bg-gradient-to-br from-green-50 to-green-100 border border-green-200 rounded-2xl p-6">
                <div class="flex items-center space-x-3 mb-4">
                    <div class="w-10 h-10 bg-green-500 rounded-lg flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-green-800">Why Add Funds?</h3>
                </div>
                <ul class="space-y-2 text-sm text-green-700">
                    <li class="flex items-start space-x-2">
                        <svg class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                        </svg>
                        <span>Access premium email flash services</span>
                    </li>
                    <li class="flex items-start space-x-2">
                        <svg class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                        </svg>
                        <span>Generate professional transaction emails</span>
                    </li>
                    <li class="flex items-start space-x-2">
                        <svg class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                        </svg>
                        <span>Instant fund crediting</span>
                    </li>
                    <li class="flex items-start space-x-2">
                        <svg class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                        </svg>
                        <span>24/7 secure payment processing</span>
                    </li>
                </ul>
            </div>

            <!-- Support Card -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                <div class="flex items-center space-x-3 mb-4">
                    <div class="w-10 h-10 bg-blue-500 rounded-lg flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192L5.636 18.364M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z" />
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">Need Help?</h3>
                </div>
                <p class="text-sm text-gray-600 mb-4">Our support team is available 24/7 to assist you with any deposit-related questions.</p>
                <a href="{{ route('support') }}"
                   class="inline-flex items-center text-blue-600 hover:text-blue-700 font-semibold text-sm transition-colors">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z" />
                    </svg>
                    Contact Support
                </a>
            </div>
        </div>
    </div>
</div>

<script>
function depositForm() {
    return {
        amount: '',
        selectedMethod: '',
    }
}
</script>

@section('scripts')
    @parent
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <!-- Bootstrap Notify -->
    <script src="{{ asset('dash2/libs/bootstrap-notify/bootstrap-notify.min.js') }} "></script>

    @include('user.script')

@endsection
@endsection
