@php
    if (Auth('admin')->User()->dashboard_style == 'light') {
        $text = 'dark';
        $bg = 'light';
    } else {
        $bg = 'dark';
        $text = 'light';
    }
@endphp
<div>
    <div class="main-panel">
        <div class="content ">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1 themes/purposeTheme/assets/">{{ $settings->site_name }} users list</h1>
                </div>
                <x-bootstrap-alerts />

                <div class="mb-5 row">
                    <div class="col-md-12 ">
                        <div class="card shadow p-4 ">
                            <div class="card-header">
                                <div class="row">
                                    <div class="col-6 d-flex pe-0">
                                        <div>
                                            <form>
                                                <div class="input-group">
                                                    <input wire:model.debounce.500ms='searchvalue'
                                                        class="form-control form-control-sm shadow-none search  themes/purposeTheme/assets/"
                                                        type="search" placeholder="name, username or email"
                                                        aria-label="search" />
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <div class="col-6">
                                        @if ($checkrecord)
                                            <div>
                                                <div class="d-flex">
                                                    <select wire:model='action'
                                                        class="form-control  themes/purposeTheme/assets/ form-select form-select-sm"
                                                        aria-label="Bulk actions">
                                                        <option value="Delete">Delete</option>
                                                        <option value="Clear">Clear Account</option>
                                                    </select>
                                                    <button class="btn btn-danger btn-sm ms-2"
                                                        wire:click='delsystemuser' type="button">Apply</button>
                                                    &nbsp;&nbsp;
                                                    {{-- <button class="btn btn-info btn-sm " data-toggle="modal"
                                                        data-target="#TradingModal" type="button">
                                                        <span class="fas fa-coins"
                                                            data-fa-transform="shrink-3 down-2"></span>
                                                        <span class="d-none d-sm-inline-block ms-1">Add ROI</span>
                                                    </button> --}}
                                                    &nbsp;&nbsp;
                                                    <button data-toggle="modal" data-target="#topupModal"
                                                        class="btn btn-info btn-sm " type="button">
                                                        <span class="fas fa-plus"
                                                            data-fa-transform="shrink-3 down-2"></span>
                                                        <span class="d-none d-sm-inline-block ms-1">Topup</span>
                                                    </button>
                                                </div>
                                            </div>
                                        @else
                                            <div>
                                                <button class="float-right btn btn-primary btn-sm" type="button"
                                                    data-toggle="modal" data-target="#adduser">
                                                    <span class="fas fa-user-plus"
                                                        data-fa-transform="shrink-3 down-2"></span>
                                                    <span class="d-none d-sm-inline-block ms-1">New User</span>
                                                </button>

                                                <a class="btn btn-info btn-sm " href="{{ route('emailservices') }}">
                                                    <span class="fas fa-envelope"
                                                        data-fa-transform="shrink-3 down-2"></span>
                                                    <span class="d-none d-sm-inline-block ms-1">Send Message</span>
                                                </a>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive" data-example-id="hoverable-table">
                                    <table class="table table-hover themes/purposeTheme/assets/">
                                        <thead>
                                            <tr>
                                                <th class="white-space-nowrap">
                                                    <input type="checkbox" wire:model='selectPage' />
                                                </th>
                                                <th>Client Name</th>
                                                <th>Username</th>
                                                <th>Email</th>
                                                <th>Phone</th>
                                                <th>Status</th>
                                                <th>Date registered</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id="userslisttbl">

                                            @forelse ($users as $user)
                                                <tr>
                                                    <td class="align-middle">
                                                        <input type="checkbox" wire:model='checkrecord'
                                                            value="{{ $user->id }}" />
                                                    </td>
                                                    <td>{{ $user->passenger_name }}</td>
                                                    <td>{{ $user->username }}</td>
                                                    <td>{{ $user->passenger_email }}</td>
                                                    <td>{{ $user->passenger_phone }}</td>
                                                    <td>
                                                        @if ($user->status == 'active')
                                                            <span class='badge badge-success'>{{ $user->status }}</span>
                                                        @else
                                                            <span class='badge badge-danger'>{{ $user->status }}</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        {{ $user->created_at->diffForHumans() }}
                                                    </td>
                                                    <td>
                                                        <a class='btn btn-secondary btn-sm'
                                                            href="{{ route('viewuser', $user->id) }}" role='button'>
                                                            Manage
                                                        </a>
                                                    </td>
                                                </tr>
                                            @empty
                                                <td colspan="9">
                                                    No Data Available
                                                </td>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="card-footer  py-2">
                                <div class="row flex-between-center">
                                    <div class="col-auto">
                                        <select wire:model='pagenum' class="form-control  themes/purposeTheme/assets/">
                                            <option>10</option>
                                            <option>20</option>
                                            <option>50</option>
                                            <option>100</option>
                                            <option>200</option>
                                        </select>
                                    </div>
                                    <div class="col-auto">
                                        <select wire:model='orderby' class="form-control  themes/purposeTheme/assets/">
                                            <option value="id">id</option>
                                            <option value="name">Name</option>
                                            <option value="email">Email</option>
                                            <option value="created_at">Sign up date</option>
                                        </select>
                                    </div>
                                    <div class="col-auto">
                                        <select wire:model='orderdirection'
                                            class="form-control  themes/purposeTheme/assets/">
                                            <option value="desc">Descending</option>
                                            <option value="asc">Ascending</option>
                                        </select>
                                    </div>
                                    <div class="col-auto">
                                        {!! $users->links() !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Modals --}}
    <!-- Modal -->
    <div class="modal fade" tabindex="-1" id="adduser" aria-labelledby="exampleModalLabel" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header ">
                    <h3 class="mb-2 d-inline themes/purposeTheme/assets/">Add User</h3>
                    <button type="button" class="close themes/purposeTheme/assets/" data-dismiss="modal"
                        aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body ">
                    <div>
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <form method="POST" action="{{ route('createuser') }}">
                            @csrf

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <h6 class="themes/purposeTheme/assets/">Username</h6>
                                    <input type="text" id="usernameinput"
                                        class="form-control  themes/purposeTheme/assets/" name="username"
                                        value="{{ old('username') }}" required>
                                    @error('username') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <h6 class="themes/purposeTheme/assets/">Full Name</h6>
                                    <input type="text" class="form-control  themes/purposeTheme/assets/"
                                        name="name" value="{{ old('name') }}" required>
                                    @error('name') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <h6 class="themes/purposeTheme/assets/">Email</h6>
                                    <input type="email" class="form-control  themes/purposeTheme/assets/"
                                        name="email" value="{{ old('email') }}" required>
                                    @error('email') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <h6 class="themes/purposeTheme/assets/">Phone Number</h6>
                                    <input type="text" class="form-control  themes/purposeTheme/assets/"
                                        name="phone" value="{{ old('phone') }}" required>
                                    @error('phone') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <h6 class="themes/purposeTheme/assets/">Date of Birth <span class="text-muted small">(Optional)</span></h6>
                                    <input type="date" class="form-control  themes/purposeTheme/assets/"
                                        name="passenger_dob" value="{{ old('passenger_dob') }}">
                                </div>
                                <div class="form-group col-md-6">
                                    <h6 class="themes/purposeTheme/assets/">Nationality <span class="text-muted small">(Optional)</span></h6>
                                    <input type="text" class="form-control  themes/purposeTheme/assets/"
                                        name="nationality" value="{{ old('nationality') }}" placeholder="e.g., American">
                                </div>
                                <div class="form-group col-md-12">
                                    <h6 class="themes/purposeTheme/assets/">Password</h6>
                                    <input type="password" class="form-control  themes/purposeTheme/assets/"
                                        name="password" required>
                                    @error('password') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                
                                <!-- Passport Information Section -->
                                <div class="col-md-12">
                                    <hr>
                                    <h6 class="themes/purposeTheme/assets/ mb-3">
                                        <i class="fas fa-passport"></i> Passport Information (Optional)
                                    </h6>
                                </div>
                                <div class="form-group col-md-6">
                                    <h6 class="themes/purposeTheme/assets/">Passport Number</h6>
                                    <input type="text" class="form-control  themes/purposeTheme/assets/"
                                        name="passport_number" value="{{ old('passport_number') }}" placeholder="e.g., A12345678">
                                </div>
                                <div class="form-group col-md-6">
                                    <h6 class="themes/purposeTheme/assets/">Issuing Country</h6>
                                    <input type="text" class="form-control  themes/purposeTheme/assets/"
                                        name="passport_country" value="{{ old('passport_country') }}" placeholder="e.g., United States">
                                </div>
                                <div class="form-group col-md-12">
                                    <h6 class="themes/purposeTheme/assets/">Passport Expiry Date</h6>
                                    <input type="date" class="form-control  themes/purposeTheme/assets/"
                                        name="passport_expiry" value="{{ old('passport_expiry') }}">
                                </div>
                            </div>
                            <button type="submit" class="px-4 btn btn-primary">Add User</button>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>
    {{-- End add user modal --}}




    <!-- Top Up Modal -->
    <div id="topupModal" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header ">
                    <h4 class="modal-title themes/purposeTheme/assets/">Credit/Debit Accounts.</strong></h4>
                    <button type="button" class="close themes/purposeTheme/assets/"
                        data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body ">
                    <form method="post" wire:submit.prevent='topup'>
                        <div class="form-group">
                            <input class="form-control  themes/purposeTheme/assets/" placeholder="Enter amount"
                                type="number" step="any" name="amount" wire:model.defer='topamount' required>
                            <small>{{ $topamount }}</small>
                        </div>
                        <div class="form-group">
                            <h5 class="themes/purposeTheme/assets/">Select where to Credit/Debit</h5>
                            <select class="form-control  themes/purposeTheme/assets/" wire:model.defer='topcolumn'
                                name="type" required>
                                <option value="" selected disabled>Select Column</option>
                                <option value="Bonus">Bonus</option>
                                <option value="balance">Account Balance</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <h5 class="themes/purposeTheme/assets/">Select credit to add, debit to subtract.</h5>
                            <select class="form-control  themes/purposeTheme/assets/" wire:model.defer='toptype'
                                name="t_type" required>
                                <option value="">Select type</option>
                                <option value="Credit">Credit</option>
                                <option value="Debit">Debit</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <input type="submit" class="btn " value="Save">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        window.addEventListener('user-created', event => {
            $('#adduser').modal('hide');
            location.reload(); // Reload to show new user
        });
        
        // Debug: Check if Livewire is working
        document.addEventListener('livewire:load', function () {
            console.log('Livewire loaded successfully');
        });
        
        // Listen for Livewire updates
        document.addEventListener('livewire:update', function () {
            console.log('Livewire component updated');
        });
    </script>
    @endpush
</div>
