<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta content="" name="author">
    <meta property="og:image" content="{{ asset('storage/app/public/' . $settings->logo) }}">

    <!-- Favicon -->
    <link rel="icon" href="{{ asset('storage/app/public/' . $settings->favicon) }}" sizes="any">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Alpine.js -->
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <!-- Heroicons -->
    <script src="https://unpkg.com/@heroicons/react@2.0.18/24/outline/index.js" type="module"></script>

    <!-- Page Title -->
    <title>@yield('title') | {{ $settings->site_name }}</title>
    <!-- Custom Styles with Professional Color System -->
    <style>
        :root {
            /* Professional Blue-Gray Color System */
            --primary-50: #f8fafc;
            --primary-100: #f1f5f9;
            --primary-200: #e2e8f0;
            --primary-300: #cbd5e1;
            --primary-400: #94a3b8;
            --primary-500: #64748b;
            --primary-600: #475569;
            --primary-700: #334155;
            --primary-800: #1e293b;
            --primary-900: #0f172a;
            --primary-950: #020617;

            /* Accent Colors */
            --accent-primary: #3b82f6;
            --accent-primary-dark: #2563eb;
            --accent-secondary: #06b6d4;

            /* Status Colors */
            --success: #10b981;
            --warning: #f59e0b;
            --error: #ef4444;
            --info: #06b6d4;

            /* Neutral Grays */
            --gray-50: #f9fafb;
            --gray-100: #f3f4f6;
            --gray-200: #e5e7eb;
            --gray-300: #d1d5db;
            --gray-400: #9ca3af;
            --gray-500: #6b7280;
            --gray-600: #4b5563;
            --gray-700: #374151;
            --gray-800: #1f2937;
            --gray-900: #111827;
        }

        .font-inter {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
        }

        .gradient-bg {
            background: linear-gradient(135deg, var(--primary-50) 0%, var(--primary-100) 100%);
            min-height: 100vh;
        }

        .card-elevated {
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.95);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--accent-primary) 0%, var(--accent-primary-dark) 100%);
            border: none;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            transform: translateY(-1px);
            box-shadow: 0 10px 20px rgba(59, 130, 246, 0.3);
        }

        .input-modern {
            border: 2px solid var(--gray-200);
            background: var(--gray-50);
            transition: all 0.3s ease;
        }

        .input-modern:focus {
            border-color: var(--accent-primary);
            background: white;
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        }

        .glass-nav {
            backdrop-filter: blur(16px);
            background: rgba(255, 255, 255, 0.9);
            border-bottom: 1px solid rgba(0, 0, 0, 0.1);
        }

        .brand-gradient {
            background: linear-gradient(135deg, var(--primary-700) 0%, var(--primary-800) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .floating-element {
            animation: floating 6s ease-in-out infinite;
        }

        @keyframes floating {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-10px) rotate(1deg); }
        }

        .fade-in {
            animation: fadeIn 0.8s ease-out forwards;
            opacity: 0;
        }

        @keyframes fadeIn {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .slide-up {
            animation: slideUp 0.6s ease-out forwards;
            opacity: 0;
            transform: translateY(20px);
        }

        @keyframes slideUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Mobile responsiveness */
        @media (max-width: 768px) {
            .mobile-padding {
                padding-left: 1rem;
                padding-right: 1rem;
            }
        }

        /* Dark mode support */
        @media (prefers-color-scheme: dark) {
            .gradient-bg {
                background: linear-gradient(135deg, var(--primary-900) 0%, var(--primary-950) 100%);
            }

            .card-elevated {
                background: rgba(30, 41, 59, 0.95);
                border: 1px solid rgba(255, 255, 255, 0.1);
            }

            .glass-nav {
                background: rgba(15, 23, 42, 0.9);
                border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            }
        }
    </style>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f8fafc',
                            100: '#f1f5f9',
                            200: '#e2e8f0',
                            300: '#cbd5e1',
                            400: '#94a3b8',
                            500: '#64748b',
                            600: '#475569',
                            700: '#334155',
                            800: '#1e293b',
                            900: '#0f172a',
                            950: '#020617'
                        },
                        accent: {
                            primary: '#3b82f6',
                            secondary: '#06b6d4'
                        }
                    },
                    fontFamily: {
                        'inter': ['Inter', 'sans-serif']
                    }
                }
            }
        }
    </script>
</head>

<body class="font-inter antialiased gradient-bg" x-data="{ mobileMenuOpen: false }">

    <!-- Modern Navigation Header -->
    <header class="glass-nav fixed w-full top-0 z-50" x-data="{ scrolled: false }"
            @scroll.window="scrolled = window.pageYOffset > 20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <!-- Brand Logo -->
                <div class="flex items-center space-x-3 fade-in">
                    <div class="flex-shrink-0">
                        @if($settings->logo)
                            <img src="{{ asset('storage/app/public/' . $settings->logo) }}"
                                 alt="{{ $settings->site_name }}"
                                 class="h-10 w-auto object-contain">
                        @else
                            <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                          d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                </svg>
                            </div>
                        @endif
                    </div>
                    <div class="brand-gradient">
                        <h1 class="text-xl font-bold text-primary-800">{{ $settings->site_name }}</h1>
                        <p class="text-xs text-primary-600 leading-none">Email Flashing System</p>
                    </div>
                </div>

                <!-- Desktop Navigation -->
                <nav class="hidden md:flex items-center space-x-6">
                    <a href="{{ route('login') }}"
                       class="text-primary-600 hover:text-primary-800 font-medium transition-colors duration-200 flex items-center space-x-1">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                  d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"/>
                        </svg>
                        <span>Sign In</span>
                    </a>
                    <a href="{{ route('register') }}"
                       class="bg-gradient-to-r from-blue-500 to-blue-600 text-white px-6 py-2 rounded-full font-medium hover:shadow-lg transform hover:-translate-y-0.5 transition-all duration-200 flex items-center space-x-1">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                  d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"/>
                        </svg>
                        <span>Get Started</span>
                    </a>
                </nav>

                <!-- Mobile Menu Button -->
                <div class="md:hidden">
                    <button @click="mobileMenuOpen = !mobileMenuOpen"
                            class="text-primary-600 hover:text-primary-800 focus:outline-none transition-colors duration-200">
                        <svg x-show="!mobileMenuOpen" class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                        </svg>
                        <svg x-show="mobileMenuOpen" class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile Menu -->
        <div x-show="mobileMenuOpen"
             x-transition:enter="transition ease-out duration-200"
             x-transition:enter-start="opacity-0 transform scale-95"
             x-transition:enter-end="opacity-100 transform scale-100"
             x-transition:leave="transition ease-in duration-75"
             x-transition:leave-start="opacity-100 transform scale-100"
             x-transition:leave-end="opacity-0 transform scale-95"
             class="md:hidden bg-white border-t border-gray-200 shadow-lg">
            <div class="px-4 py-6 space-y-4">
                <a href="{{ route('login') }}"
                   class="flex items-center space-x-3 text-primary-600 hover:text-primary-800 font-medium transition-colors duration-200 py-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                              d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"/>
                    </svg>
                    <span>Sign In</span>
                </a>
                <a href="{{ route('register') }}"
                   class="flex items-center justify-center space-x-2 bg-gradient-to-r from-blue-500 to-blue-600 text-white px-6 py-3 rounded-full font-medium hover:shadow-lg transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                              d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"/>
                    </svg>
                    <span>Get Started</span>
                </a>
            </div>
        </div>
    </header>

    <!-- Main Content Container -->
    <main class="relative min-h-screen pt-16">
        <!-- Background Decorations -->
        <div class="absolute inset-0 overflow-hidden pointer-events-none">
            <div class="absolute top-20 left-10 w-20 h-20 bg-blue-100 rounded-full opacity-50 floating-element"></div>
            <div class="absolute top-40 right-20 w-16 h-16 bg-blue-200 rounded-full opacity-40 floating-element" style="animation-delay: -2s;"></div>
            <div class="absolute bottom-32 left-20 w-12 h-12 bg-blue-300 rounded-full opacity-30 floating-element" style="animation-delay: -4s;"></div>
        </div>

        <!-- Content Area -->
        <div class="relative z-10 fade-in">
            @yield('content')
        </div>

        <!-- Google Translate Integration -->

    </main>

    <!-- Footer -->
    <footer class="relative z-10 bg-primary-800 text-white py-8 mt-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="space-y-4">
                    <h3 class="text-lg font-semibold">{{ $settings->site_name }}</h3>
                    <p class="text-primary-200 text-sm leading-relaxed">
                        Professional Email Flashing System for secure and reliable email communications.
                    </p>
                </div>
                <div class="space-y-4">
                    <h4 class="text-sm font-semibold text-primary-100">Quick Links</h4>
                    <div class="flex flex-col space-y-2">
                        <a href="{{ route('login') }}" class="text-primary-200 hover:text-white text-sm transition-colors duration-200">Sign In</a>
                        <a href="{{ route('register') }}" class="text-primary-200 hover:text-white text-sm transition-colors duration-200">Register</a>
                    </div>
                </div>
                <div class="space-y-4">
                    <h4 class="text-sm font-semibold text-primary-100">Security</h4>
                    <div class="flex items-center space-x-2 text-primary-200 text-sm">
                        <svg class="w-4 h-4 text-green-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"/>
                        </svg>
                        <span>SSL Encrypted</span>
                    </div>
                </div>
            </div>
            <div class="border-t border-primary-700 mt-8 pt-6 text-center text-primary-300 text-sm">
                <p>&copy; {{ date('Y') }} {{ $settings->site_name }}. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <!-- JAVASCRIPT -->



    <!-- Custom JavaScript -->
    <script>
        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Form validation enhancement
        document.addEventListener('DOMContentLoaded', function() {
            // Username field - no spaces allowed
            const usernameField = document.getElementById('username');
            if (usernameField) {
                usernameField.addEventListener('keypress', function(e) {
                    return e.which !== 32; // Prevent space character
                });

                usernameField.addEventListener('input', function(e) {
                    this.value = this.value.replace(/\s/g, ''); // Remove any spaces
                });
            }

            // Enhanced form validation feedback
            const forms = document.querySelectorAll('form');
            forms.forEach(form => {
                const inputs = form.querySelectorAll('input[required]');
                inputs.forEach(input => {
                    input.addEventListener('blur', function() {
                        if (this.value.trim() === '') {
                            this.classList.add('border-red-300', 'bg-red-50');
                            this.classList.remove('border-gray-200');
                        } else {
                            this.classList.remove('border-red-300', 'bg-red-50');
                            this.classList.add('border-green-300', 'bg-green-50');
                        }
                    });

                    input.addEventListener('input', function() {
                        if (this.value.trim() !== '') {
                            this.classList.remove('border-red-300', 'bg-red-50');
                            this.classList.add('border-green-300', 'bg-green-50');
                        }
                    });
                });
            });

            // Loading state for form submissions
            const submitButtons = document.querySelectorAll('button[type="submit"]');
            submitButtons.forEach(button => {
                button.closest('form').addEventListener('submit', function() {
                    button.disabled = true;
                    button.innerHTML = `
                        <svg class="animate-spin -ml-1 mr-2 h-4 w-4 text-white inline" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        Processing...
                    `;
                });
            });

            // Animation delays for staggered entrance
            const animatedElements = document.querySelectorAll('.fade-in, .slide-up');
            animatedElements.forEach((el, index) => {
                el.style.animationDelay = `${index * 0.1}s`;
            });
        });

        // Enhanced mobile experience
        let touchStartY = 0;
        document.addEventListener('touchstart', e => {
            touchStartY = e.touches[0].clientY;
        });

        document.addEventListener('touchmove', e => {
            const touchY = e.touches[0].clientY;
            const touchDiff = touchStartY - touchY;

            // Add subtle header shadow on scroll
            const header = document.querySelector('header');
            if (touchDiff > 10 && header) {
                header.classList.add('shadow-lg');
            } else if (touchDiff < -10 && header) {
                header.classList.remove('shadow-lg');
            }
        });

        // Keyboard navigation enhancement
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Tab') {
                document.body.classList.add('keyboard-navigation');
            }
        });

        document.addEventListener('mousedown', function() {
            document.body.classList.remove('keyboard-navigation');
        });
    </script>

    <!-- Performance optimization -->
    <script>
        // Lazy load images
        if ('loading' in HTMLImageElement.prototype) {
            const images = document.querySelectorAll('img[loading="lazy"]');
            images.forEach(img => {
                img.src = img.dataset.src;
            });
        } else {
            // Fallback for browsers that don't support lazy loading
            const script = document.createElement('script');
            script.src = 'https://polyfill.io/v3/polyfill.min.js?features=IntersectionObserver';
            document.head.appendChild(script);
        }
    </script>
</body>

</html>
