<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', $settings->site_name)</title>
  <link rel="apple-touch-icon" sizes="76x76" href="{{ asset('themes/softui/assets/img/apple-icon.png') }}">
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700" rel="stylesheet" />
     <link rel="icon" href="{{ asset('storage/app/public/' . $settings->favicon) }}" sizes="any">
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#eff6ff',
                            100: '#dbeafe',
                            500: '#3b82f6',
                            600: '#2563eb',
                            700: '#1d4ed8',
                            800: '#1e40af',
                            900: '#1e3a8a',
                        },
                        slate: {
                            50: '#f8fafc',
                            100: '#f1f5f9',
                            200: '#e2e8f0',
                            300: '#cbd5e1',
                            400: '#94a3b8',
                            500: '#64748b',
                            600: '#475569',
                            700: '#334155',
                            800: '#1e293b',
                            900: '#0f172a',
                        },
                        emerald: {
                            50: '#ecfdf5',
                            100: '#d1fae5',
                            500: '#10b981',
                            600: '#059669',
                            700: '#047857',
                        }
                    },
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                }
            }
        }
    </script>

    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    @stack('styles')
</head>
<body class="font-sans antialiased bg-slate-50">
    <!-- Navigation -->
    <nav class="bg-white shadow-lg sticky top-0 z-50" x-data="{ mobileMenuOpen: false }">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <!-- Logo -->
                <div class="flex items-center">
                    <a href="{{ route('home') }}" class="flex items-center space-x-2">
                       <img src="{{ asset('storage/app/public/' . $settings->logo) }}" class="h-10 w-auto" alt="Logo">
                    </a>
                </div>

                <!-- Desktop Navigation -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="{{ route('home') }}" class="text-slate-600 hover:text-primary-600 transition-colors">
                        <i class="fas fa-home mr-1"></i> Home
                    </a>
                    <a href="{{ route('flights.search') }}" class="text-slate-600 hover:text-primary-600 transition-colors">
                        <i class="fas fa-search mr-1"></i> Search Flights
                    </a>
                    <a href="{{ route('my.bookings') }}" class="text-slate-600 hover:text-primary-600 transition-colors">
                        <i class="fas fa-ticket-alt mr-1"></i> Track Flight
                    </a>
                    <a href="{{ route('about') }}" class="text-slate-600 hover:text-primary-600 transition-colors">
                        <i class="fas fa-info-circle mr-1"></i> About
                    </a>
                    <a href="{{ route('contact') }}" class="text-slate-600 hover:text-primary-600 transition-colors">
                        <i class="fas fa-envelope mr-1"></i> Contact
                    </a>
                    <a href="{{ route('faq') }}" class="text-slate-600 hover:text-primary-600 transition-colors">
                        <i class="fas fa-question-circle mr-1"></i> FAQ
                    </a>
                </div>

                <!-- User Menu -->
                <div class="hidden md:flex items-center space-x-4">
                    @auth
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" class="flex items-center space-x-2 text-slate-600 hover:text-primary-600">
                                <i class="fas fa-user-circle text-lg"></i>
                                <span>{{ Auth::user()->name }}</span>
                                <i class="fas fa-chevron-down text-xs"></i>
                            </button>
                            <div x-show="open" @click.away="open = false" 
                                 class="absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg py-1 z-50">
                                <a href="{{ route('dashboard') }}" class="block px-4 py-2 text-sm text-slate-700 hover:bg-slate-50">
                                    <i class="fas fa-home mr-2"></i> Dashboard
                                </a>
                                <a href="{{ route('profile') }}" class="block px-4 py-2 text-sm text-slate-700 hover:bg-slate-50">
                                    <i class="fas fa-user mr-2"></i> Profile
                                </a>
                                <a href="{{ route('my.bookings') }}" class="block px-4 py-2 text-sm text-slate-700 hover:bg-slate-50">
                                    <i class="fas fa-ticket-alt mr-2"></i> My Bookings
                                </a>
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <button type="submit" class="block w-full text-left px-4 py-2 text-sm text-slate-700 hover:bg-slate-50">
                                        <i class="fas fa-sign-out-alt mr-2"></i> Logout
                                    </button>
                                </form>
                            </div>
                        </div>
                    @else
                        <a href="{{ route('login') }}" class="text-slate-600 hover:text-primary-600 transition-colors">
                            <i class="fas fa-sign-in-alt mr-1"></i> Login
                        </a>
                        <a href="{{ route('register') }}" class="bg-primary-600 text-white px-4 py-2 rounded-md hover:bg-primary-700 transition-colors">
                            <i class="fas fa-user-plus mr-1"></i> Register
                        </a>
                    @endauth
                </div>

                <!-- Mobile menu button -->
                <div class="md:hidden">
                    <button @click="mobileMenuOpen = !mobileMenuOpen" class="text-slate-600 hover:text-primary-600">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile menu -->
        <div x-show="mobileMenuOpen" @click.away="mobileMenuOpen = false" class="md:hidden bg-white border-t">
            <div class="px-2 pt-2 pb-3 space-y-1">
                <a href="{{ route('home') }}" class="block px-3 py-2 text-slate-600 hover:text-primary-600">
                    <i class="fas fa-home mr-2"></i> Home
                </a>
                <a href="{{ route('flights.search') }}" class="block px-3 py-2 text-slate-600 hover:text-primary-600">
                    <i class="fas fa-search mr-2"></i> Search Flights
                </a>
                <a href="{{ route('my.bookings') }}" class="block px-3 py-2 text-slate-600 hover:text-primary-600">
                    <i class="fas fa-ticket-alt mr-2"></i> My Bookings
                </a>
                <a href="#" class="block px-3 py-2 text-slate-600 hover:text-primary-600">
                    <i class="fas fa-headset mr-2"></i> Support
                </a>
                @auth
                    <div class="border-t mt-2 pt-2">
                        <a href="{{ route('dashboard') }}" class="block px-3 py-2 text-slate-600 hover:text-primary-600">
                            <i class="fas fa-home mr-2"></i> Dashboard
                        </a>
                        <a href="{{ route('profile') }}" class="block px-3 py-2 text-slate-600 hover:text-primary-600">
                            <i class="fas fa-user mr-2"></i> Profile
                        </a>
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <button type="submit" class="block w-full text-left px-3 py-2 text-slate-600 hover:text-primary-600">
                                <i class="fas fa-sign-out-alt mr-2"></i> Logout
                            </button>
                        </form>
                    </div>
                @else
                    <div class="border-t mt-2 pt-2">
                        <a href="{{ route('login') }}" class="block px-3 py-2 text-slate-600 hover:text-primary-600">
                            <i class="fas fa-sign-in-alt mr-2"></i> Login
                        </a>
                        <a href="{{ route('register') }}" class="block px-3 py-2 text-slate-600 hover:text-primary-600">
                            <i class="fas fa-user-plus mr-2"></i> Register
                        </a>
                    </div>
                @endauth
            </div>
        </div>
    </nav>

    <!-- Flash Messages -->
    @if(session('success'))
        <div class="bg-emerald-100 border border-emerald-400 text-emerald-700 px-4 py-3 mx-4 mt-4 rounded" x-data="{ show: true }" x-show="show">
            <div class="flex justify-between items-center">
                <span><i class="fas fa-check-circle mr-2"></i>{{ session('success') }}</span>
                <button @click="show = false" class="text-emerald-700 hover:text-emerald-900">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
    @endif

    @if(session('error'))
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 mx-4 mt-4 rounded" x-data="{ show: true }" x-show="show">
            <div class="flex justify-between items-center">
                <span><i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}</span>
                <button @click="show = false" class="text-red-700 hover:text-red-900">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
    @endif

    <!-- Main Content -->
    <main>
        @yield('content')
    </main>

    <!-- Footer -->
    <footer class="bg-slate-800 text-white mt-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                <!-- Company Info -->
                <div>
                    <div class="flex items-center space-x-2 mb-4">
                        <i class="fas fa-plane text-primary-400 text-xl"></i>
                        <span class="font-bold text-lg">{{ $settings->site_name }}</span>
                    </div>
                    <p class="text-slate-300 mb-4">Your trusted partner for seamless flight bookings and travel experiences worldwide.</p>
                    <div class="flex space-x-4">
                        <a href="#" class="text-slate-400 hover:text-primary-400 transition-colors">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="#" class="text-slate-400 hover:text-primary-400 transition-colors">
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="#" class="text-slate-400 hover:text-primary-400 transition-colors">
                            <i class="fab fa-instagram"></i>
                        </a>
                        <a href="#" class="text-slate-400 hover:text-primary-400 transition-colors">
                            <i class="fab fa-linkedin-in"></i>
                        </a>
                    </div>
                </div>

                <!-- Quick Links -->
                <div>
                    <h3 class="font-semibold mb-4">Quick Links</h3>
                    <ul class="space-y-2">
                        <li><a href="{{ route('about') }}" class="text-slate-300 hover:text-primary-400 transition-colors">About Us</a></li>
                        <li><a href="{{ route('contact') }}" class="text-slate-300 hover:text-primary-400 transition-colors">Contact</a></li>
                        <li><a href="{{ route('faq') }}" class="text-slate-300 hover:text-primary-400 transition-colors">FAQ</a></li>
                        <li><a href="{{ route('terms') }}" class="text-slate-300 hover:text-primary-400 transition-colors">Terms of Service</a></li>
                    </ul>
                </div>

                <!-- Services -->
                <div>
                    <h3 class="font-semibold mb-4">Services</h3>
                    <ul class="space-y-2">
                        <li><a href="#" class="text-slate-300 hover:text-primary-400 transition-colors">Flight Booking</a></li>
                        <li><a href="{{ route('my.bookings') }}" class="text-slate-300 hover:text-primary-400 transition-colors">Flight Tracking</a></li>
                        <li><a href="{{ route('contact') }}" class="text-slate-300 hover:text-primary-400 transition-colors">24/7 Support</a></li>
                        {{-- <li><a href="#" class="text-slate-300 hover:text-primary-400 transition-colors">Mobile App</a></li> --}}
                    </ul>
                </div>

                <!-- Contact -->
                <div>
                    <h3 class="font-semibold mb-4">Contact Info</h3>
                    <ul class="space-y-2 text-slate-300">
                        <li><i class="fas fa-phone mr-2"></i> {{ $settings->whatsapp }}</li>
                        <li><i class="fas fa-envelope mr-2"></i> {{ $settings->contact_email }}</li>
                        <li><i class="fas fa-map-marker-alt mr-2"></i> 123 Aviation St, Sky City</li>
                        <li><i class="fas fa-clock mr-2"></i> 24/7 Customer Support</li>
                    </ul>
                </div>
            </div>

            <div class="border-t border-slate-700 mt-8 pt-8 text-center text-slate-400">
                <p>&copy; {{ date('Y') }} {{ $settings->site_name }}. All rights reserved.</p>
            </div>
        </div>
    </footer>

    @stack('scripts')
    @include('layouts.livechat')
</body>
</html>