<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <meta name="description" content="{{ $settings->site_name }} - Professional Email Flashing System">

  <title>{{ $settings->site_name }} - Professional Email Flashing System</title>

  <!-- Favicon -->
  <link rel="shortcut icon" type="image/x-icon" href="{{ asset('storage/app/public/' . $settings->favicon) }}">

  <!-- Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>

  <!-- Alpine.js -->
  <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>

  <!-- Custom Styles -->
  <style>
    :root {
      /* Professional Blue Color System */
      --primary-50: #f0f9ff;
      --primary-100: #e0f2fe;
      --primary-200: #bae6fd;
      --primary-300: #e2e8f0;
      --primary-400: #94a3b8;
      --primary-500: #64748b;
      --primary-600: #475569;
      --primary-700: #334155;
      --primary-800: #1e293b;
      --primary-900: #0f172a;
      --primary-950: #082f49;

      /* Neutral Grays */
      --gray-50: #f8fafc;
      --gray-100: #f1f5f9;
      --gray-200: #e2e8f0;
      --gray-300: #cbd5e1;
      --gray-400: #94a3b8;
      --gray-500: #64748b;
      --gray-600: #475569;
      --gray-700: #334155;
      --gray-800: #1e293b;
      --gray-900: #0f172a;
      --gray-950: #020617;

      /* Status Colors */
      --success: #10b981;
      --warning: #f59e0b;
      --error: #ef4444;
    }

    .font-inter { font-family: 'Inter', sans-serif; }

    .gradient-bg {
      background: linear-gradient(135deg, var(--primary-800) 0%, var(--primary-900) 50%, var(--primary-950) 100%);
    }

    .glass-effect {
      backdrop-filter: blur(16px);
      background: rgba(255, 255, 255, 0.1);
      border: 1px solid rgba(255, 255, 255, 0.2);
    }

    .card-shadow {
      box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    }

    .btn-primary {
      background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
      box-shadow: 0 4px 14px 0 rgba(59, 130, 246, 0.39);
    }

    .btn-primary:hover {
      background: linear-gradient(135deg, #1d4ed8 0%, #1e40af 100%);
      transform: translateY(-2px);
      box-shadow: 0 10px 25px 0 rgba(59, 130, 246, 0.5);
    }

    .animate-float {
      animation: float 6s ease-in-out infinite;
    }

    .animate-float-delay {
      animation: float 6s ease-in-out infinite;
      animation-delay: 2s;
    }

    @keyframes float {
      0%, 100% { transform: translateY(0px); }
      50% { transform: translateY(-20px); }
    }

    .fade-in {
      opacity: 0;
      transform: translateY(30px);
      transition: all 0.8s ease;
    }

    .fade-in.visible {
      opacity: 1;
      transform: translateY(0);
    }

    .scroll-smooth {
      scroll-behavior: smooth;
    }
  </style>

  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: {
            primary: {
              50: '#f0f9ff',
              100: '#e0f2fe',
              200: '#bae6fd',
              300: '#e2e8f0',
              400: '#94a3b8',
              500: '#64748b',
              600: '#475569',
              700: '#334155',
              800: '#1e293b',
              900: '#0f172a',
              950: '#082f49'
            }
          },
          fontFamily: {
            'inter': ['Inter', 'sans-serif'],
          }
        }
      }
    }
  </script>
</head>

<body class="font-inter antialiased bg-gray-50" x-data="{ mobileMenuOpen: false, scrolled: false }"
      @scroll.window="scrolled = window.scrollY > 20">

  <!-- Loading Screen -->
  <div id="loading" class="fixed inset-0 z-50 flex items-center justify-center gradient-bg">
    <div class="text-center">
      <div class="relative">
        <div class="w-20 h-20 border-4 border-white/20 border-t-white rounded-full animate-spin mx-auto mb-4"></div>
        <div class="absolute inset-0 w-20 h-20 border-4 border-transparent border-t-blue-400 rounded-full animate-spin mx-auto" style="animation-delay: 0.3s;"></div>
      </div>
      <h2 class="text-2xl font-bold text-white mb-2">{{ $settings->site_name }}</h2>
      <p class="text-white/80">Loading Email Flashing System...</p>
    </div>
  </div>

  <!-- Navigation -->
  <header class="fixed w-full top-0 z-40 transition-all duration-300"
       :class="scrolled ? 'bg-white/90 backdrop-blur-md shadow-lg' : 'bg-transparent'">
    <div class="container mx-auto px-6">
      <div class="flex items-center justify-between h-20">

        <!-- Logo -->
        <a href="/" class="flex items-center space-x-3">
          <img src="{{ asset('storage/app/public/' . $settings->logo) }}"
               alt="{{ $settings->site_name }}"
               class="h-10 w-auto">
          <div>
            <h1 class="text-xl font-bold"
                :class="scrolled ? 'text-gray-800' : 'text-white'">
              {{ $settings->site_name }}
            </h1>
            <p class="text-xs font-medium"
               :class="scrolled ? 'text-gray-600' : 'text-white/80'">
              Email Flash System
            </p>
          </div>
        </a>

        <!-- Desktop Navigation -->
        <nav class="hidden lg:flex items-center space-x-8">
          <a href="#home" class="nav-link font-medium transition-colors duration-200"
             :class="scrolled ? 'text-gray-700 hover:text-blue-600' : 'text-white hover:text-blue-300'">
            Home
          </a>
          <div x-data="{ open: false }" class="relative group">
            <button @click="open = !open" @click.away="open = false" class="nav-link font-medium transition-colors duration-200 flex items-center space-x-1"
                    :class="scrolled ? 'text-gray-700 hover:text-blue-600' : 'text-white hover:text-blue-300'">
              <span>Services</span>
              <svg class="w-4 h-4 transform transition-transform" :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
              </svg>
            </button>
            <div x-show="open" x-transition:enter="transition ease-out duration-200"
                 x-transition:enter-start="opacity-0 transform -translate-y-2"
                 x-transition:enter-end="opacity-100 transform translate-y-0"
                 x-transition:leave="transition ease-in duration-150"
                 x-transition:leave-start="opacity-100 transform translate-y-0"
                 x-transition:leave-end="opacity-0 transform -translate-y-2"
                 class="absolute left-0 mt-2 w-56 bg-white rounded-xl shadow-lg">
              <div class="py-3">
                <a href="{{ route('login') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">Flash Wallet</a>
                <a href="{{ route('login') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">Email History</a>
                <a href="{{ route('login') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">Pricing</a>
              </div>
            </div>
          </div>
          <a href="#features" class="nav-link font-medium transition-colors duration-200"
             :class="scrolled ? 'text-gray-700 hover:text-blue-600' : 'text-white hover:text-blue-300'">
            Features
          </a>
          <a href="#faq" class="nav-link font-medium transition-colors duration-200"
             :class="scrolled ? 'text-gray-700 hover:text-blue-600' : 'text-white hover:text-blue-300'">
            FAQ
          </a>
          <a href="#contact" class="nav-link font-medium transition-colors duration-200"
             :class="scrolled ? 'text-gray-700 hover:text-blue-600' : 'text-white hover:text-blue-300'">
            Contact
          </a>
        </nav>

        <!-- Auth Buttons & Mobile Menu Toggle -->
        <div class="flex items-center space-x-4">
          <div class="hidden lg:flex items-center space-x-4">
            <a href="{{ route('login') }}"
               class="font-medium text-sm transition-colors duration-200"
               :class="scrolled ? 'text-gray-700 hover:text-blue-600' : 'text-white hover:text-blue-300'">
              Sign In
            </a>
            <a href="{{ route('register') }}"
               class="px-5 py-2.5 text-sm font-semibold text-white bg-blue-600 rounded-full hover:bg-blue-700 transition-all duration-300 shadow-lg hover:shadow-xl">
              Get Started
            </a>
          </div>

          <!-- Mobile Menu Button -->
          <button @click="mobileMenuOpen = !mobileMenuOpen" class="lg:hidden" :class="scrolled ? 'text-gray-700' : 'text-white'">
            <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16m-7 6h7" />
            </svg>
          </button>
        </div>
      </div>
    </div>

    <!-- Mobile Menu -->
    <div x-show="mobileMenuOpen"
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 transform -translate-y-4"
         x-transition:enter-end="opacity-100 transform translate-y-0"
         x-transition:leave="transition ease-in duration-150"
         x-transition:leave-start="opacity-100 transform translate-y-0"
         x-transition:leave-end="opacity-0 transform -translate-y-4"
         @click.away="mobileMenuOpen = false"
         class="lg:hidden absolute top-full w-full bg-white shadow-lg rounded-b-xl">
      <div class="p-5">
        <nav class="flex flex-col space-y-4">
          <a href="#home" @click="mobileMenuOpen = false" class="nav-link text-gray-700 hover:text-blue-600">Home</a>
          <div x-data="{ open: false }">
            <button @click="open = !open" class="w-full text-left flex justify-between items-center nav-link text-gray-700 hover:text-blue-600">
              <span>Services</span>
              <svg class="w-4 h-4 transform transition-transform" :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
              </svg>
            </button>
            <div x-show="open" class="pl-4 mt-2 space-y-2">
              <a href="{{ route('login') }}" class="block text-sm text-gray-600 hover:text-blue-600">Flash Wallet</a>
              <a href="{{ route('login') }}" class="block text-sm text-gray-600 hover:text-blue-600">Email History</a>
              <a href="{{ route('login') }}" class="block text-sm text-gray-600 hover:text-blue-600">Pricing</a>
            </div>
          </div>
          <a href="#features" @click="mobileMenuOpen = false" class="nav-link text-gray-700 hover:text-blue-600">Features</a>
          <a href="#faq" @click="mobileMenuOpen = false" class="nav-link text-gray-700 hover:text-blue-600">FAQ</a>
          <a href="#contact" @click="mobileMenuOpen = false" class="nav-link text-gray-700 hover:text-blue-600">Contact</a>
        </nav>
        <div class="mt-6 pt-6 border-t border-gray-200">
          <div class="flex flex-col space-y-3">
            <a href="{{ route('login') }}" class="text-center w-full px-5 py-2.5 text-sm font-semibold text-gray-700 bg-gray-100 rounded-full hover:bg-gray-200">
              Sign In
            </a>
            <a href="{{ route('register') }}" class="text-center w-full px-5 py-2.5 text-sm font-semibold text-white bg-blue-600 rounded-full hover:bg-blue-700">
              Get Started
            </a>
          </div>
        </div>
      </div>
    </div>
  </header>

  <!-- Hero Section -->
  <main id="home" class="relative overflow-hidden gradient-bg pt-20">
    <div class="container mx-auto px-6 pt-24 pb-32 text-center">
      <div class="relative z-10">
        <h1 class="text-5xl md:text-7xl font-extrabold text-white leading-tight mb-6 fade-in">
          The Future of Secure <br class="hidden md:block"> Email Flashing
        </h1>
        <p class="max-w-3xl mx-auto text-lg md:text-xl text-white/80 mb-10 fade-in" style="transition-delay: 0.2s;">
          Experience the most advanced and reliable email flashing service. Built for speed, security, and seamless integration.
        </p>
        <div class="flex justify-center items-center space-x-4 fade-in" style="transition-delay: 0.4s;">
          <a href="{{ route('register') }}" class="btn-primary text-white font-semibold py-3 px-8 rounded-full transition-transform duration-300 ease-in-out transform hover:scale-105">
            Start Flashing Now
          </a>
          <a href="#features" class="bg-white/20 text-white font-semibold py-3 px-8 rounded-full backdrop-blur-sm border border-white/30 hover:bg-white/30 transition-all duration-300">
            Learn More
          </a>
        </div>
      </div>

      <!-- Background Shapes -->
      <div class="absolute inset-0 z-0 opacity-30">
        <div class="absolute top-1/4 left-1/4 w-64 h-64 bg-blue-400 rounded-full mix-blend-screen filter blur-3xl animate-float"></div>
        <div class="absolute bottom-1/4 right-1/4 w-72 h-72 bg-indigo-500 rounded-full mix-blend-screen filter blur-3xl animate-float-delay"></div>
      </div>
    </div>
    <div class="absolute bottom-0 left-0 w-full h-32 bg-gradient-to-t from-gray-50 to-transparent"></div>
  </main>

  <!-- Features Section -->
  <section id="features" class="py-24 bg-gray-50">
    <div class="container mx-auto px-6">
      <div class="text-center mb-16">
        <h2 class="text-4xl lg:text-5xl font-bold text-gray-800">Why Choose Us?</h2>
        <p class="text-lg text-gray-600 mt-4 max-w-2xl mx-auto">Our platform is engineered for performance, security, and ease of use.</p>
      </div>
      <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
        <!-- Feature 1 -->
        <div class="bg-white p-8 rounded-2xl shadow-lg hover:shadow-2xl transition-shadow duration-300 transform hover:-translate-y-2">
          <div class="flex items-center justify-center h-16 w-16 rounded-full bg-blue-100 text-blue-600 mb-6">
            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path></svg>
          </div>
          <h3 class="text-2xl font-bold text-gray-800 mb-3">Instant Delivery</h3>
          <p class="text-gray-600">Our robust infrastructure ensures your emails are flashed instantly, reaching the inbox without delay.</p>
        </div>
        <!-- Feature 2 -->
        <div class="bg-white p-8 rounded-2xl shadow-lg hover:shadow-2xl transition-shadow duration-300 transform hover:-translate-y-2">
          <div class="flex items-center justify-center h-16 w-16 rounded-full bg-blue-100 text-blue-600 mb-6">
            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path></svg>
          </div>
          <h3 class="text-2xl font-bold text-gray-800 mb-3">Total Anonymity</h3>
          <p class="text-gray-600">Your privacy is paramount. Send emails without leaving a trace, protected by end-to-end encryption.</p>
        </div>
        <!-- Feature 3 -->
        <div class="bg-white p-8 rounded-2xl shadow-lg hover:shadow-2xl transition-shadow duration-300 transform hover:-translate-y-2">
          <div class="flex items-center justify-center h-16 w-16 rounded-full bg-blue-100 text-blue-600 mb-6">
            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 10h.01M15 10h.01M9 14h.01M15 14h.01"></path></svg>
          </div>
          <h3 class="text-2xl font-bold text-gray-800 mb-3">User-Friendly Interface</h3>
          <p class="text-gray-600">Our dashboard is designed for simplicity. Manage your campaigns effortlessly, regardless of your technical skill.</p>
        </div>
      </div>
    </div>
  </section>

  <!-- FAQ Section -->
  <section id="faq" class="py-20 bg-white">
    <div class="container mx-auto px-6">
      <div class="text-center mb-16">
        <h2 class="text-4xl lg:text-5xl font-bold text-gray-800">Frequently Asked Questions</h2>
        <p class="text-lg text-gray-600 mt-4 max-w-2xl mx-auto">Have questions? We've got answers. Here are some of the most common queries from our users.</p>
      </div>
      <div class="max-w-3xl mx-auto" x-data="{ active: 1 }">
        <div class="border-b border-gray-200">
          <button @click="active = 1" class="w-full text-left py-6 focus:outline-none">
            <div class="flex justify-between items-center">
              <h3 class="text-xl font-semibold text-gray-800" :class="{ 'text-blue-600': active === 1 }">Do I need a subscription to use this website?</h3>
              <svg class="w-6 h-6 transform transition-transform" :class="{ 'rotate-180': active === 1 }" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
            </div>
          </button>
          <div x-show="active === 1" x-collapse class="pb-6">
            <p class="text-gray-600">Yes, a valid activation key is required to access all features. Once active, you can flash any wallet with no restrictions.</p>
          </div>
        </div>
        <div class="border-b border-gray-200">
          <button @click="active = 2" class="w-full text-left py-6 focus:outline-none">
            <div class="flex justify-between items-center">
              <h3 class="text-xl font-semibold text-gray-800" :class="{ 'text-blue-600': active === 2 }">Is my identity required to use the website?</h3>
              <svg class="w-6 h-6 transform transition-transform" :class="{ 'rotate-180': active === 2 }" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
            </div>
          </button>
          <div x-show="active === 2" x-collapse class="pb-6">
            <p class="text-gray-600">No identity or KYC is needed. We only ask for your email and a username. Your privacy is fully protected throughout your usage.</p>
          </div>
        </div>
        <div class="border-b border-gray-200">
          <button @click="active = 3" class="w-full text-left py-6 focus:outline-none">
            <div class="flex justify-between items-center">
              <h3 class="text-xl font-semibold text-gray-800" :class="{ 'text-blue-600': active === 3 }">How many mails can I send per day?</h3>
              <svg class="w-6 h-6 transform transition-transform" :class="{ 'rotate-180': active === 3 }" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
            </div>
          </button>
          <div x-show="active === 3" x-collapse class="pb-6">
            <p class="text-gray-600">There are no daily or hourly limits. You can send unlimited mails, even up to 10,000+ per day, depending on your activation duration.</p>
          </div>
        </div>
        <div class="border-b border-gray-200">
          <button @click="active = 4" class="w-full text-left py-6 focus:outline-none">
            <div class="flex justify-between items-center">
              <h3 class="text-xl font-semibold text-gray-800" :class="{ 'text-blue-600': active === 4 }">What if the wallet I need isn't listed?</h3>
              <svg class="w-6 h-6 transform transition-transform" :class="{ 'rotate-180': active === 4 }" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
            </div>
          </button>
          <div x-show="active === 4" x-collapse class="pb-6">
            <p class="text-gray-600">If a wallet or coin isn't available, you can send a request. We regularly add new wallets based on user demand to keep things flexible.</p>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- CTA Section -->
  <section id="contact" class="bg-gray-800">
    <div class="container mx-auto px-6 py-20 text-center">
      <h2 class="text-4xl font-bold text-white mb-4">Ready to Elevate Your Email Campaigns?</h2>
      <p class="text-lg text-gray-300 mb-8 max-w-2xl mx-auto">Join thousands of satisfied users and experience the power of professional email flashing today.</p>
      <a href="{{ route('register') }}" class="btn-primary text-white font-semibold py-4 px-10 rounded-full text-lg transition-transform duration-300 ease-in-out transform hover:scale-105">
        Get Started for Free
      </a>
    </div>
  </section>

  <!-- Footer -->
  <footer class="bg-gray-900 text-white">
    <div class="container mx-auto px-6 py-16">
      <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-12">
        <!-- About -->
        <div>
          <h3 class="text-xl font-bold mb-4">{{ $settings->site_name }}</h3>
          <p class="text-gray-400 leading-relaxed">The leading platform for secure and anonymous email flashing. Built for professionals who demand performance and privacy.</p>
        </div>
        <!-- Quick Links -->
        <div>
          <h3 class="text-lg font-semibold mb-4">Quick Links</h3>
          <ul class="space-y-3">
            <li><a href="#home" class="text-gray-400 hover:text-white transition-colors">Home</a></li>
            <li><a href="#features" class="text-gray-400 hover:text-white transition-colors">Features</a></li>
            <li><a href="#faq" class="text-gray-400 hover:text-white transition-colors">FAQ</a></li>
            <li><a href="{{ route('login') }}" class="text-gray-400 hover:text-white transition-colors">Login</a></li>
          </ul>
        </div>
        <!-- Services -->
        <div>
          <h3 class="text-lg font-semibold mb-4">Services</h3>
          <ul class="space-y-3">
            <li><a href="{{ route('login') }}" class="text-gray-400 hover:text-white transition-colors">Flash Wallet</a></li>
            <li><a href="{{ route('login') }}" class="text-gray-400 hover:text-white transition-colors">Email History</a></li>
            <li><a href="{{ route('login') }}" class="text-gray-400 hover:text-white transition-colors">Account</a></li>
          </ul>
        </div>
        <!-- Legal -->
        <div>
          <h3 class="text-lg font-semibold mb-4">Legal</h3>
          <ul class="space-y-3">
            <li><a href="#" class="text-gray-400 hover:text-white transition-colors">Terms of Service</a></li>
            <li><a href="#" class="text-gray-400 hover:text-white transition-colors">Privacy Policy</a></li>
          </ul>
        </div>
      </div>
      <div class="mt-16 pt-8 border-t border-gray-800 text-center text-gray-500">
        <p>&copy; {{ date('Y') }} {{ $settings->site_name }}. All rights reserved.</p>
      </div>
    </div>
  </footer>

  <script>
    document.addEventListener('DOMContentLoaded', () => {
      // Loading screen
      const loadingScreen = document.getElementById('loading');
      window.addEventListener('load', () => {
        loadingScreen.style.opacity = '0';
        setTimeout(() => {
          loadingScreen.style.display = 'none';
        }, 500);
      });

      // Fade-in animations
      const fadeInElements = document.querySelectorAll('.fade-in');
      const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
          if (entry.isIntersecting) {
            entry.target.classList.add('visible');
          }
        });
      }, { threshold: 0.1 });

      fadeInElements.forEach(el => {
        observer.observe(el);
      });
    });
  </script>

</body>
</html>
