@extends('layouts.flight')

@section('title', 'Frequently Asked Questions - ' . config('app.name'))

@section('content')
<!-- Hero Section -->
<section class="py-16 bg-gradient-to-br from-primary-600 to-primary-800 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            <h1 class="text-4xl md:text-6xl font-bold mb-6">FAQ</h1>
            <p class="text-xl text-primary-100 max-w-3xl mx-auto">
                Find quick answers to the most common questions about flight booking, payments, and travel policies.
            </p>
        </div>
    </div>
</section>

<!-- Search FAQ -->
<section class="py-8 bg-slate-50">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="relative" x-data="{ searchTerm: '' }">
            <input type="text" 
                   x-model="searchTerm"
                   placeholder="Search frequently asked questions..."
                   class="w-full px-6 py-4 pl-12 border border-slate-300 rounded-xl focus:ring-2 focus:ring-primary-500 focus:border-transparent text-lg">
            <i class="fas fa-search absolute left-4 top-1/2 transform -translate-y-1/2 text-slate-400"></i>
        </div>
    </div>
</section>

<!-- FAQ Categories -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-4 gap-8">
            <!-- Category Navigation -->
            <div class="lg:col-span-1">
                <div class="bg-slate-50 rounded-xl p-6 sticky top-24" x-data="{ activeCategory: 'booking' }">
                    <h3 class="text-lg font-semibold text-slate-800 mb-4">Categories</h3>
                    <nav class="space-y-2">
                        <button @click="activeCategory = 'booking'" 
                                :class="activeCategory === 'booking' ? 'bg-primary-600 text-white' : 'text-slate-600 hover:bg-slate-200'"
                                class="w-full text-left px-4 py-2 rounded-lg transition-colors">
                            <i class="fas fa-plane mr-2"></i> Booking
                        </button>
                        <button @click="activeCategory = 'payment'" 
                                :class="activeCategory === 'payment' ? 'bg-primary-600 text-white' : 'text-slate-600 hover:bg-slate-200'"
                                class="w-full text-left px-4 py-2 rounded-lg transition-colors">
                            <i class="fas fa-credit-card mr-2"></i> Payment
                        </button>
                        <button @click="activeCategory = 'changes'" 
                                :class="activeCategory === 'changes' ? 'bg-primary-600 text-white' : 'text-slate-600 hover:bg-slate-200'"
                                class="w-full text-left px-4 py-2 rounded-lg transition-colors">
                            <i class="fas fa-edit mr-2"></i> Changes & Cancellation
                        </button>
                        <button @click="activeCategory = 'travel'" 
                                :class="activeCategory === 'travel' ? 'bg-primary-600 text-white' : 'text-slate-600 hover:bg-slate-200'"
                                class="w-full text-left px-4 py-2 rounded-lg transition-colors">
                            <i class="fas fa-suitcase mr-2"></i> Travel Information
                        </button>
                        <button @click="activeCategory = 'account'" 
                                :class="activeCategory === 'account' ? 'bg-primary-600 text-white' : 'text-slate-600 hover:bg-slate-200'"
                                class="w-full text-left px-4 py-2 rounded-lg transition-colors">
                            <i class="fas fa-user mr-2"></i> Account
                        </button>
                    </nav>
                </div>
            </div>

            <!-- FAQ Content -->
            <div class="lg:col-span-3" x-data="faqData()">
                <!-- Booking FAQs -->
                <div x-show="activeCategory === 'booking'" class="space-y-4">
                    <h2 class="text-2xl font-bold text-slate-800 mb-6">Booking Questions</h2>
                    
                    <div class="bg-white border border-slate-200 rounded-lg" x-data="{ open: false }">
                        <button @click="open = !open" class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-slate-50">
                            <span class="font-medium text-slate-800">How do I book a flight?</span>
                            <i class="fas fa-chevron-down transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" x-transition class="px-6 pb-4">
                            <p class="text-slate-600">
                                Booking a flight is simple: 1) Enter your departure and destination cities, 2) Select your travel dates, 
                                3) Choose the number of passengers, 4) Browse available flights and select your preferred option, 
                                5) Enter passenger details, 6) Choose your payment method, and 7) Complete the booking.
                            </p>
                        </div>
                    </div>

                    <div class="bg-white border border-slate-200 rounded-lg" x-data="{ open: false }">
                        <button @click="open = !open" class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-slate-50">
                            <span class="font-medium text-slate-800">Can I book flights for someone else?</span>
                            <i class="fas fa-chevron-down transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" x-transition class="px-6 pb-4">
                            <p class="text-slate-600">
                                Yes, you can book flights for family members, friends, or colleagues. Just enter their personal details 
                                (name, date of birth, etc.) exactly as they appear on their government-issued ID during the booking process.
                            </p>
                        </div>
                    </div>

                    <div class="bg-white border border-slate-200 rounded-lg" x-data="{ open: false }">
                        <button @click="open = !open" class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-slate-50">
                            <span class="font-medium text-slate-800">How far in advance can I book a flight?</span>
                            <i class="fas fa-chevron-down transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" x-transition class="px-6 pb-4">
                            <p class="text-slate-600">
                                Most airlines allow bookings up to 330 days in advance. However, this can vary by airline and route. 
                                We recommend booking 2-8 weeks in advance for domestic flights and 2-3 months for international flights to get the best prices.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Payment FAQs -->
                <div x-show="activeCategory === 'payment'" class="space-y-4">
                    <h2 class="text-2xl font-bold text-slate-800 mb-6">Payment Questions</h2>
                    
                    <div class="bg-white border border-slate-200 rounded-lg" x-data="{ open: false }">
                        <button @click="open = !open" class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-slate-50">
                            <span class="font-medium text-slate-800">What payment methods do you accept?</span>
                            <i class="fas fa-chevron-down transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" x-transition class="px-6 pb-4">
                            <p class="text-slate-600">
                                We accept all major credit cards (Visa, Mastercard, American Express), PayPal, bank transfers, 
                                and cryptocurrency (Bitcoin). All transactions are processed through secure, encrypted channels.
                            </p>
                        </div>
                    </div>

                    <div class="bg-white border border-slate-200 rounded-lg" x-data="{ open: false }">
                        <button @click="open = !open" class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-slate-50">
                            <span class="font-medium text-slate-800">Is my payment information secure?</span>
                            <i class="fas fa-chevron-down transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" x-transition class="px-6 pb-4">
                            <p class="text-slate-600">
                                Absolutely. We use industry-standard SSL encryption and comply with PCI DSS standards. 
                                We never store your complete credit card information on our servers.
                            </p>
                        </div>
                    </div>

                    <div class="bg-white border border-slate-200 rounded-lg" x-data="{ open: false }">
                        <button @click="open = !open" class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-slate-50">
                            <span class="font-medium text-slate-800">When will I be charged for my booking?</span>
                            <i class="fas fa-chevron-down transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" x-transition class="px-6 pb-4">
                            <p class="text-slate-600">
                                Payment is processed immediately upon booking confirmation. For certain payment methods like bank transfers, 
                                your booking may be held for 24-48 hours until payment verification is complete.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Changes & Cancellation FAQs -->
                <div x-show="activeCategory === 'changes'" class="space-y-4">
                    <h2 class="text-2xl font-bold text-slate-800 mb-6">Changes & Cancellation</h2>
                    
                    <div class="bg-white border border-slate-200 rounded-lg" x-data="{ open: false }">
                        <button @click="open = !open" class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-slate-50">
                            <span class="font-medium text-slate-800">Can I cancel my booking?</span>
                            <i class="fas fa-chevron-down transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" x-transition class="px-6 pb-4">
                            <p class="text-slate-600">
                                Yes, you can cancel your booking through your account dashboard or by contacting our support team. 
                                Cancellation policies and fees depend on the airline and fare type you selected. Some tickets are non-refundable.
                            </p>
                        </div>
                    </div>

                    <div class="bg-white border border-slate-200 rounded-lg" x-data="{ open: false }">
                        <button @click="open = !open" class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-slate-50">
                            <span class="font-medium text-slate-800">How do I change my flight dates?</span>
                            <i class="fas fa-chevron-down transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" x-transition class="px-6 pb-4">
                            <p class="text-slate-600">
                                Flight date changes can be made through your booking dashboard or by contacting support. 
                                Change fees apply based on the airline's policy and fare type. You may need to pay fare differences if the new flight costs more.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Travel Information FAQs -->
                <div x-show="activeCategory === 'travel'" class="space-y-4">
                    <h2 class="text-2xl font-bold text-slate-800 mb-6">Travel Information</h2>
                    
                    <div class="bg-white border border-slate-200 rounded-lg" x-data="{ open: false }">
                        <button @click="open = !open" class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-slate-50">
                            <span class="font-medium text-slate-800">What documents do I need to travel?</span>
                            <i class="fas fa-chevron-down transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" x-transition class="px-6 pb-4">
                            <p class="text-slate-600">
                                For domestic flights, you need a government-issued photo ID. For international flights, you need a valid passport 
                                and may require a visa depending on your destination. Check with the embassy or consulate of your destination country.
                            </p>
                        </div>
                    </div>

                    <div class="bg-white border border-slate-200 rounded-lg" x-data="{ open: false }">
                        <button @click="open = !open" class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-slate-50">
                            <span class="font-medium text-slate-800">What's the baggage allowance?</span>
                            <i class="fas fa-chevron-down transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" x-transition class="px-6 pb-4">
                            <p class="text-slate-600">
                                Baggage allowances vary by airline and fare type. Generally, you're allowed one carry-on bag and one personal item. 
                                Checked baggage policies and fees vary. Check your airline's specific baggage policy for detailed information.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Account FAQs -->
                <div x-show="activeCategory === 'account'" class="space-y-4">
                    <h2 class="text-2xl font-bold text-slate-800 mb-6">Account Questions</h2>
                    
                    <div class="bg-white border border-slate-200 rounded-lg" x-data="{ open: false }">
                        <button @click="open = !open" class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-slate-50">
                            <span class="font-medium text-slate-800">Do I need to create an account to book?</span>
                            <i class="fas fa-chevron-down transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" x-transition class="px-6 pb-4">
                            <p class="text-slate-600">
                                No, you can book flights as a guest. However, creating an account allows you to easily manage your bookings, 
                                track flight status, and receive important updates about your travel.
                            </p>
                        </div>
                    </div>

                    <div class="bg-white border border-slate-200 rounded-lg" x-data="{ open: false }">
                        <button @click="open = !open" class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-slate-50">
                            <span class="font-medium text-slate-8000">How do I reset my password?</span>
                            <i class="fas fa-chevron-down transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" x-transition class="px-6 pb-4">
                            <p class="text-slate-600">
                                Click on "Forgot Password" on the login page, enter your email address, and we'll send you a link to reset your password. 
                                The link is valid for 24 hours for security reasons.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Still Have Questions -->
<section class="py-16 bg-primary-600 text-white">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl md:text-4xl font-bold mb-6">Still Have Questions?</h2>
        <p class="text-xl text-primary-100 mb-8">
            Our support team is available 24/7 to help you with any questions or concerns.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="{{ route('contact') }}" class="bg-white text-primary-600 font-semibold py-3 px-6 rounded-lg hover:bg-primary-50 transition-colors">
                <i class="fas fa-envelope mr-2"></i> Contact Support
            </a>
            <a href="#" class="bg-primary-700 text-white font-semibold py-3 px-6 rounded-lg hover:bg-primary-800 transition-colors">
                <i class="fas fa-comments mr-2"></i> Live Chat
            </a>
        </div>
    </div>
</section>
@endsection

@push('scripts')
<script>
function faqData() {
    return {
        activeCategory: 'booking'
    }
}
</script>
@endpush