@extends('layouts.flight')

@section('title', 'Contact Us - ' . config('app.name'))

@section('content')
<!-- Hero Section -->
<section class="py-16 bg-gradient-to-br from-primary-600 to-primary-800 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            <h1 class="text-4xl md:text-6xl font-bold mb-6">Get in Touch</h1>
            <p class="text-xl text-primary-100 max-w-3xl mx-auto">
                Have questions about your booking or need travel assistance? We're here to help 24/7.
            </p>
        </div>
    </div>
</section>

<!-- Contact Information -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Contact Form -->
            <div>
                <h2 class="text-3xl font-bold text-slate-800 mb-6">Send us a Message</h2>
                <form action="{{ route('enquiry') }}" method="POST" class="space-y-6" x-data="contactForm()">
                    @csrf
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="name" class="block text-sm font-medium text-slate-700 mb-2">Full Name *</label>
                            <input type="text" name="name" id="name" required
                                   class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
                                   placeholder="John Doe">
                        </div>
                        <div>
                            <label for="email" class="block text-sm font-medium text-slate-700 mb-2">Email Address *</label>
                            <input type="email" name="email" id="email" required
                                   class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
                                   placeholder="john@example.com">
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="phone" class="block text-sm font-medium text-slate-700 mb-2">Phone Number</label>
                            <input type="tel" name="phone" id="phone"
                                   class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
                                   placeholder="+1 (555) 123-4567">
                        </div>
                        <div>
                            <label for="subject" class="block text-sm font-medium text-slate-700 mb-2">Subject *</label>
                            <select name="subject" id="subject" required
                                    class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent">
                                <option value="">Select a subject</option>
                                <option value="booking">Booking Inquiry</option>
                                <option value="payment">Payment Issue</option>
                                <option value="cancellation">Cancellation Request</option>
                                <option value="refund">Refund Request</option>
                                <option value="technical">Technical Support</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                    </div>
                    
                    <div>
                        <label for="booking_reference" class="block text-sm font-medium text-slate-700 mb-2">Booking Reference (if applicable)</label>
                        <input type="text" name="booking_reference" id="booking_reference"
                               class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
                               placeholder="ABC123">
                    </div>
                    
                    <div>
                        <label for="message" class="block text-sm font-medium text-slate-700 mb-2">Message *</label>
                        <textarea name="message" id="message" rows="6" required
                                  class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent"
                                  placeholder="Please describe your inquiry or issue in detail..."></textarea>
                    </div>
                    
                    <button type="submit" 
                            class="w-full bg-primary-600 hover:bg-primary-700 text-white font-semibold py-4 px-6 rounded-lg transition-colors"
                            x-bind:disabled="isSubmitting"
                            x-text="isSubmitting ? 'Sending...' : 'Send Message'">
                    </button>
                </form>
            </div>

            <!-- Contact Information -->
            <div>
                <h2 class="text-3xl font-bold text-slate-800 mb-6">Contact Information</h2>
                <div class="space-y-8">
                    <!-- Customer Support -->
                    <div class="bg-slate-50 rounded-xl p-6">
                        <div class="flex items-center mb-4">
                            <div class="w-12 h-12 bg-primary-100 rounded-full flex items-center justify-center mr-4">
                                <i class="fas fa-headset text-primary-600 text-xl"></i>
                            </div>
                            <h3 class="text-xl font-semibold text-slate-800">24/7 Customer Support</h3>
                        </div>
                        <div class="space-y-2 text-slate-600">
                            <p><strong>Phone:</strong> {{ $settings->whatsapp }}</p>
                            <p><strong>Email:</strong> {{ $settings->email }}</p>
                            <p><strong>Live Chat:</strong> Available 24/7 on our website</p>
                        </div>
                    </div>

                    <!-- Emergency Support -->
                    <div class="bg-red-50 rounded-xl p-6">
                        <div class="flex items-center mb-4">
                            <div class="w-12 h-12 bg-red-100 rounded-full flex items-center justify-center mr-4">
                                <i class="fas fa-exclamation-triangle text-red-600 text-xl"></i>
                            </div>
                            <h3 class="text-xl font-semibold text-slate-800">Emergency Support</h3>
                        </div>
                        <div class="space-y-2 text-slate-600">
                            <p><strong>Emergency Hotline:</strong> {{ $settings->whatsapp }}</p>
                            <p><strong>For travelers in distress or urgent flight changes</strong></p>
                            <p>Available 24/7 for critical assistance</p>
                        </div>
                    </div>

                    <!-- Business Inquiries -->
                    <div class="bg-emerald-50 rounded-xl p-6">
                        <div class="flex items-center mb-4">
                            <div class="w-12 h-12 bg-emerald-100 rounded-full flex items-center justify-center mr-4">
                                <i class="fas fa-building text-emerald-600 text-xl"></i>
                            </div>
                            <h3 class="text-xl font-semibold text-slate-800">Business Inquiries</h3>
                        </div>
                        <div class="space-y-2 text-slate-600">
                            <p><strong>Email:</strong> {{ $settings->contact_email }}</p>
                            {{-- <p><strong>Partnerships:</strong> partnerships@{{ strtolower(config('app.name', 'flightbooking')) }}.com</p> --}}
                            <p>For airline partnerships and corporate accounts</p>
                        </div>
                    </div>

                    <!-- Office Address -->
                    <div class="bg-blue-50 rounded-xl p-6">
                        <div class="flex items-center mb-4">
                            <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mr-4">
                                <i class="fas fa-map-marker-alt text-blue-600 text-xl"></i>
                            </div>
                            <h3 class="text-xl font-semibold text-slate-800">Office Address</h3>
                        </div>
                        <div class="space-y-2 text-slate-600">
                            <p>123 Aviation Boulevard<br>
                            Sky Tower, Suite 1000<br>
                            New York, NY 10001<br>
                            United States</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Preview -->
<section class="py-16 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl md:text-4xl font-bold text-slate-800 mb-4">Frequently Asked Questions</h2>
            <p class="text-xl text-slate-600">Quick answers to common questions</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h3 class="text-lg font-semibold text-slate-800 mb-3">How can I cancel or change my booking?</h3>
                <p class="text-slate-600 mb-4">You can cancel or modify your booking through your account dashboard or by contacting our support team. Fees may apply based on the airline's policy.</p>
                <a href="{{ route('faq') }}" class="text-primary-600 hover:text-primary-700 font-medium">Learn more →</a>
            </div>

            <div class="bg-white rounded-xl shadow-lg p-6">
                <h3 class="text-lg font-semibold text-slate-800 mb-3">What payment methods do you accept?</h3>
                <p class="text-slate-600 mb-4">We accept all major credit cards, PayPal, bank transfers, and cryptocurrency. All payments are processed securely.</p>
                <a href="{{ route('faq') }}" class="text-primary-600 hover:text-primary-700 font-medium">Learn more →</a>
            </div>

            <div class="bg-white rounded-xl shadow-lg p-6">
                <h3 class="text-lg font-semibold text-slate-800 mb-3">How do I check in for my flight?</h3>
                <p class="text-slate-600 mb-4">Online check-in typically opens 24 hours before departure. You can check in through the airline's website or mobile app using your booking reference.</p>
                <a href="{{ route('faq') }}" class="text-primary-600 hover:text-primary-700 font-medium">Learn more →</a>
            </div>

            <div class="bg-white rounded-xl shadow-lg p-6">
                <h3 class="text-lg font-semibold text-slate-800 mb-3">Can I book flights for other people?</h3>
                <p class="text-slate-600 mb-4">Yes, you can book flights for family members or colleagues. Just enter their details during the booking process and ensure the information matches their ID.</p>
                <a href="{{ route('faq') }}" class="text-primary-600 hover:text-primary-700 font-medium">Learn more →</a>
            </div>
        </div>

        <div class="text-center mt-8">
            <a href="{{ route('faq') }}" class="bg-primary-600 hover:bg-primary-700 text-white font-semibold py-3 px-6 rounded-lg transition-colors">
                View All FAQs
            </a>
        </div>
    </div>
</section>

<!-- Response Time -->
<section class="py-12 bg-primary-600 text-white">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-2xl md:text-3xl font-bold mb-4">We Respond Quickly</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div>
                <div class="text-3xl font-bold text-primary-200">< 1 Hour</div>
                <div class="text-primary-100">Email Response</div>
            </div>
            <div>
                <div class="text-3xl font-bold text-primary-200">< 30 Sec</div>
                <div class="text-primary-100">Live Chat Response</div>
            </div>
            <div>
                <div class="text-3xl font-bold text-primary-200">24/7</div>
                <div class="text-primary-100">Phone Support</div>
            </div>
        </div>
    </div>
</section>
@endsection

@push('scripts')
<script>
function contactForm() {
    return {
        isSubmitting: false,
        
        async submitForm(event) {
            this.isSubmitting = true;
            // Form will submit normally, this is just for UI feedback
            setTimeout(() => {
                this.isSubmitting = false;
            }, 2000);
        }
    }
}
</script>
@endpush