@extends('layouts.flight')

@section('title', 'About Us - ' . config('app.name'))

@section('content')
<!-- Hero Section -->
<section class="py-20 bg-gradient-to-br from-primary-600 to-primary-800 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            <h1 class="text-4xl md:text-6xl font-bold mb-6">About {{$settings->site_name}}</h1>
            <p class="text-xl text-primary-100 max-w-3xl mx-auto">
                Your trusted partner for seamless flight bookings and exceptional travel experiences worldwide.
            </p>
        </div>
    </div>
</section>

<!-- Company Story -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
                <h2 class="text-3xl md:text-4xl font-bold text-slate-800 mb-6">Our Story</h2>
                <div class="space-y-4 text-slate-600">
                    <p class="text-lg leading-relaxed">
                        Founded with a vision to make air travel accessible and hassle-free, {{$settings->site_name}} has been connecting travelers with their dream destinations since 2020.
                    </p>
                    <p class="leading-relaxed">
                        We understand that booking a flight should be simple, secure, and stress-free. That's why we've built a platform that combines cutting-edge technology with personalized service to deliver an exceptional booking experience.
                    </p>
                    <p class="leading-relaxed">
                        From last-minute business trips to carefully planned family vacations, we're here to make your journey begin with confidence and ease.
                    </p>
                </div>
            </div>
            <div class="relative">
                <div class="bg-gradient-to-r from-primary-400 to-emerald-400 rounded-2xl p-8 text-white">
                    <div class="grid grid-cols-2 gap-6">
                        <div class="text-center">
                            <div class="text-3xl font-bold">1M+</div>
                            <div class="text-sm opacity-90">Happy Travelers</div>
                        </div>
                        <div class="text-center">
                            <div class="text-3xl font-bold">500+</div>
                            <div class="text-sm opacity-90">Airlines Partners</div>
                        </div>
                        <div class="text-center">
                            <div class="text-3xl font-bold">1000+</div>
                            <div class="text-sm opacity-90">Destinations</div>
                        </div>
                        <div class="text-center">
                            <div class="text-3xl font-bold">24/7</div>
                            <div class="text-sm opacity-90">Customer Support</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Our Values -->
<section class="py-16 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl md:text-4xl font-bold text-slate-800 mb-4">Our Values</h2>
            <p class="text-xl text-slate-600">The principles that guide everything we do</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="bg-white rounded-xl shadow-lg p-8 text-center hover:shadow-xl transition-shadow">
                <div class="w-16 h-16 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-heart text-primary-600 text-2xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-slate-800 mb-4">Customer First</h3>
                <p class="text-slate-600">
                    Every decision we make is centered around providing the best possible experience for our travelers.
                </p>
            </div>

            <div class="bg-white rounded-xl shadow-lg p-8 text-center hover:shadow-xl transition-shadow">
                <div class="w-16 h-16 bg-emerald-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-shield-alt text-emerald-600 text-2xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-slate-800 mb-4">Trust & Security</h3>
                <p class="text-slate-600">
                    Your personal information and payments are protected with industry-leading security measures.
                </p>
            </div>

            <div class="bg-white rounded-xl shadow-lg p-8 text-center hover:shadow-xl transition-shadow">
                <div class="w-16 h-16 bg-yellow-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-rocket text-yellow-600 text-2xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-slate-800 mb-4">Innovation</h3>
                <p class="text-slate-600">
                    We continuously improve our platform with the latest technology to serve you better.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Team Section -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl md:text-4xl font-bold text-slate-800 mb-4">Meet Our Team</h2>
            <p class="text-xl text-slate-600">The passionate people behind your travel experience</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="text-center">
                <div class="w-32 h-32 bg-gradient-to-r from-primary-400 to-primary-600 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-user text-white text-4xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-slate-800 mb-2">Sarah Johnson</h3>
                <p class="text-primary-600 font-medium mb-2">CEO & Founder</p>
                <p class="text-slate-600">15+ years in aviation industry with a passion for making travel accessible to everyone.</p>
            </div>

            <div class="text-center">
                <div class="w-32 h-32 bg-gradient-to-r from-emerald-400 to-emerald-600 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-user text-white text-4xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-slate-800 mb-2">Michael Chen</h3>
                <p class="text-emerald-600 font-medium mb-2">CTO</p>
                <p class="text-slate-600">Tech visionary dedicated to building seamless, user-friendly travel platforms.</p>
            </div>

            <div class="text-center">
                <div class="w-32 h-32 bg-gradient-to-r from-yellow-400 to-yellow-600 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-user text-white text-4xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-slate-800 mb-2">Emma Rodriguez</h3>
                <p class="text-yellow-600 font-medium mb-2">Head of Customer Success</p>
                <p class="text-slate-600">Ensuring every traveler receives exceptional support throughout their journey.</p>
            </div>
        </div>
    </div>
</section>

<!-- Mission Statement -->
<section class="py-16 bg-primary-600 text-white">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl md:text-4xl font-bold mb-6">Our Mission</h2>
        <p class="text-xl text-primary-100 leading-relaxed">
            To democratize air travel by providing an intuitive, secure, and comprehensive flight booking platform 
            that connects travelers with the world while delivering exceptional value and service at every touchpoint.
        </p>
    </div>
</section>

<!-- Call to Action -->
<section class="py-16 bg-slate-50">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl md:text-4xl font-bold text-slate-800 mb-6">Ready to Start Your Journey?</h2>
        <p class="text-xl text-slate-600 mb-8">
            Join millions of travelers who trust us with their flight bookings. Your next adventure is just a click away.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="{{ route('flights.search') }}" class="bg-primary-600 hover:bg-primary-700 text-white font-semibold py-4 px-8 rounded-lg transition-colors">
                <i class="fas fa-search mr-2"></i> Search Flights
            </a>
            <a href="{{ route('contact') }}" class="bg-white hover:bg-slate-50 text-primary-600 border border-primary-600 font-semibold py-4 px-8 rounded-lg transition-colors">
                <i class="fas fa-envelope mr-2"></i> Contact Us
            </a>
        </div>
    </div>
</section>
@endsection