<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>@yield('title')</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
        
        <!-- Tailwind CSS -->
        <script src="https://cdn.tailwindcss.com"></script>
        
        <!-- Alpine.js -->
        <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

        <style>
            :root {
                /* Primary Color Palette - Professional Blue Theme */
                --color-primary: #1e40af;
                --color-primary-light: #3b82f6;
                --color-primary-dark: #1e3a8a;
                --color-primary-50: #eff6ff;
                --color-primary-100: #dbeafe;
                
                /* Neutral Colors */
                --color-neutral-50: #f9fafb;
                --color-neutral-100: #f3f4f6;
                --color-neutral-200: #e5e7eb;
                --color-neutral-300: #d1d5db;
                --color-neutral-500: #6b7280;
                --color-neutral-600: #4b5563;
                --color-neutral-700: #374151;
                --color-neutral-800: #1f2937;
                --color-neutral-900: #111827;
                
                /* Spacing */
                --spacing-md: 1rem;
                --spacing-lg: 1.5rem;
                --spacing-xl: 2rem;
                --spacing-2xl: 3rem;
                
                /* Border Radius */
                --radius-lg: 0.75rem;
                --radius-xl: 1rem;
                
                /* Shadows */
                --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
                --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
                --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
            }

            * {
                box-sizing: border-box;
                margin: 0;
                padding: 0;
            }

            html, body {
                height: 100vh;
                margin: 0;
                font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
                -webkit-font-smoothing: antialiased;
                -moz-osx-font-smoothing: grayscale;
            }

            body {
                background: linear-gradient(135deg, var(--color-primary-50) 0%, var(--color-neutral-50) 100%);
                color: var(--color-neutral-900);
                display: flex;
                align-items: center;
                justify-content: center;
                padding: var(--spacing-lg);
            }

            .error-wrapper {
                width: 100%;
                max-width: 600px;
                text-align: center;
            }

            .error-card {
                background: white;
                border-radius: var(--radius-xl);
                box-shadow: var(--shadow-xl);
                padding: var(--spacing-2xl);
                animation: fadeInUp 0.6s ease-out;
            }

            @keyframes fadeInUp {
                from {
                    opacity: 0;
                    transform: translateY(20px);
                }
                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }

            .error-icon-wrapper {
                width: 100px;
                height: 100px;
                background: linear-gradient(135deg, var(--color-primary-50), var(--color-primary-100));
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 0 auto var(--spacing-xl);
                position: relative;
            }

            .error-icon-wrapper::before {
                content: '';
                position: absolute;
                width: 120%;
                height: 120%;
                background: var(--color-primary-50);
                border-radius: 50%;
                opacity: 0.5;
                animation: pulse 2s ease-in-out infinite;
            }

            @keyframes pulse {
                0%, 100% { transform: scale(1); opacity: 0.3; }
                50% { transform: scale(1.1); opacity: 0.5; }
            }

            .error-icon {
                width: 56px;
                height: 56px;
                position: relative;
                z-index: 1;
            }

            .error-title {
                font-size: clamp(1.75rem, 5vw, 2.5rem);
                font-weight: 700;
                color: var(--color-neutral-900);
                margin-bottom: var(--spacing-md);
                line-height: 1.2;
            }

            .divider {
                height: 3px;
                width: 80px;
                background: linear-gradient(90deg, var(--color-primary), var(--color-primary-light));
                border-radius: 2px;
                margin: var(--spacing-lg) auto;
            }

            .error-message {
                font-size: 1.125rem;
                color: var(--color-neutral-600);
                line-height: 1.7;
                margin-bottom: var(--spacing-xl);
            }

            .btn-group {
                display: flex;
                flex-wrap: wrap;
                gap: var(--spacing-md);
                justify-content: center;
                margin-top: var(--spacing-xl);
            }

            .btn {
                display: inline-flex;
                align-items: center;
                justify-content: center;
                gap: 0.5rem;
                padding: 0.875rem 1.75rem;
                font-size: 1rem;
                font-weight: 600;
                border-radius: var(--radius-lg);
                text-decoration: none;
                transition: all 0.2s ease;
                cursor: pointer;
                border: none;
                outline: none;
            }

            .btn-primary {
                background: linear-gradient(135deg, var(--color-primary), var(--color-primary-light));
                color: white;
                box-shadow: var(--shadow-md);
            }

            .btn-primary:hover {
                transform: translateY(-2px);
                box-shadow: var(--shadow-lg);
            }

            .btn-secondary {
                background: white;
                color: var(--color-neutral-700);
                border: 2px solid var(--color-neutral-200);
            }

            .btn-secondary:hover {
                background: var(--color-neutral-50);
                border-color: var(--color-neutral-300);
            }

            .btn:focus-visible {
                outline: 3px solid var(--color-primary-100);
                outline-offset: 2px;
            }

            .btn:disabled {
                opacity: 0.6;
                cursor: not-allowed;
            }

            .icon {
                width: 20px;
                height: 20px;
            }

            /* Mobile responsiveness */
            @media (max-width: 640px) {
                .error-card {
                    padding: var(--spacing-xl) var(--spacing-lg);
                }
                
                .btn-group {
                    flex-direction: column;
                    width: 100%;
                }
                
                .btn {
                    width: 100%;
                }

                .error-icon-wrapper {
                    width: 80px;
                    height: 80px;
                }

                .error-icon {
                    width: 44px;
                    height: 44px;
                }
            }

            /* Additional decorative elements */
            .error-card::before {
                content: '';
                position: absolute;
                top: 0;
                left: 0;
                right: 0;
                height: 4px;
                background: linear-gradient(90deg, var(--color-primary), var(--color-primary-light));
                border-radius: var(--radius-xl) var(--radius-xl) 0 0;
            }

            .error-card {
                position: relative;
                overflow: hidden;
            }
        </style>
    </head>
    <body>
        <div class="error-wrapper" x-data="{ loading: false }">
            <div class="error-card">
                <!-- Error Icon -->
                <div class="error-icon-wrapper">
                    <svg class="error-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" stroke="var(--color-primary)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M12 8V12" stroke="var(--color-primary)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M12 16H12.01" stroke="var(--color-primary)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>

                <!-- Error Title -->
                <h1 class="error-title">
                    @yield('title', 'Something Went Wrong')
                </h1>

                <!-- Divider -->
                <div class="divider"></div>

                <!-- Error Message -->
                <div class="error-message">
                    @yield('message')
                </div>

                <!-- Action Buttons -->
                <div class="btn-group">
                    <a href="{{ app('router')->has('home') ? route('home') : url('/') }}" 
                       class="btn btn-primary"
                       @click="loading = true"
                       :disabled="loading">
                        <svg class="icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M3 9L12 2L21 9V20C21 20.5304 20.7893 21.0391 20.4142 21.4142C20.0391 21.7893 19.5304 22 19 22H5C4.46957 22 3.96086 21.7893 3.58579 21.4142C3.21071 21.0391 3 20.5304 3 20V9Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M9 22V12H15V22" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        <span x-text="loading ? 'Loading...' : 'Go to Homepage'">Go to Homepage</span>
                    </a>

                    <button @click="history.back()" class="btn btn-secondary">
                        <svg class="icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M19 12H5M5 12L12 19M5 12L12 5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        Go Back
                    </button>
                </div>
            </div>
        </div>
    </body>
</html>
