<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Confirmation</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: #ffffff;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .success-icon {
            font-size: 48px;
            margin-bottom: 10px;
        }
        .content {
            padding: 30px 20px;
        }
        .booking-ref {
            background: #d4edda;
            border-left: 4px solid #10b981;
            padding: 15px;
            margin: 20px 0;
            font-size: 18px;
            font-weight: bold;
        }
        .flight-details {
            background: #f8f9fa;
            border-radius: 6px;
            padding: 20px;
            margin: 20px 0;
        }
        .flight-route {
            display: table;
            width: 100%;
            margin: 15px 0;
        }
        .airport {
            display: table-cell;
            width: 40%;
            vertical-align: middle;
        }
        .arrow {
            display: table-cell;
            width: 20%;
            text-align: center;
            vertical-align: middle;
            color: #10b981;
            font-size: 24px;
        }
        .airport-code {
            font-size: 24px;
            font-weight: bold;
            color: #333;
        }
        .airport-name {
            font-size: 14px;
            color: #666;
        }
        .info-row {
            padding: 10px 0;
            border-bottom: 1px solid #e0e0e0;
        }
        .info-row:last-child {
            border-bottom: none;
        }
        .info-label {
            font-weight: bold;
            color: #666;
            display: inline-block;
            width: 150px;
        }
        .payment-info {
            background: #fff3cd;
            border: 1px solid #ffc107;
            border-radius: 6px;
            padding: 15px;
            margin: 20px 0;
        }
        .button {
            display: inline-block;
            padding: 12px 30px;
            background: #10b981;
            color: #ffffff;
            text-decoration: none;
            border-radius: 6px;
            margin: 20px 0;
            font-weight: bold;
        }
        .footer {
            background: #f8f9fa;
            padding: 20px;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
        .checklist {
            background: #e7f6ec;
            border-radius: 6px;
            padding: 20px;
            margin: 20px 0;
        }
        .checklist ul {
            margin: 10px 0;
            padding-left: 20px;
        }
        .checklist li {
            margin: 8px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="success-icon">✓</div>
            <h1>{{ $settings->site_name }} - Payment Confirmed!</h1>
        </div>

        <div class="content">
            <p>Dear {{ $booking->passenger_name }},</p>
            
            <p>Great news! Your payment has been confirmed and your flight booking with {{ $settings->site_name }} is now complete.</p>

            <div class="booking-ref">
                ✈️ Booking Reference: {{ $booking->booking_reference }}
            </div>

            <div class="payment-info">
                <strong>💳 Payment Details</strong><br>
                <div style="margin-top: 10px;">
                    <strong>Amount Paid:</strong> {{ $settings->currency }}{{ number_format($booking->price_paid, 2) }}<br>
                    <strong>Payment Method:</strong> {{ $booking->paymentMethod->name ?? 'N/A' }}<br>
                    <strong>Payment Date:</strong> {{ now()->format('M d, Y H:i') }}
                </div>
            </div>

            <div class="flight-details">
                <h2 style="margin-top: 0;">Your Flight Details</h2>
                
                <div class="info-row">
                    <span class="info-label">Airline:</span>
                    {{ $booking->flight->airline }}
                </div>
                
                <div class="info-row">
                    <span class="info-label">Flight Number:</span>
                    {{ $booking->flight->flight_number }}
                </div>

                <div class="flight-route">
                    <div class="airport">
                        <div class="airport-code">{{ $booking->flight->originAirport->iata_code }}</div>
                        <div class="airport-name">{{ $booking->flight->originAirport->city }}</div>
                        <div style="font-size: 16px; margin-top: 5px;">
                            {{ $booking->flight->departure_time->format('H:i, M d, Y') }}
                        </div>
                    </div>
                    <div class="arrow">→</div>
                    <div class="airport" style="text-align: right;">
                        <div class="airport-code">{{ $booking->flight->destinationAirport->iata_code }}</div>
                        <div class="airport-name">{{ $booking->flight->destinationAirport->city }}</div>
                        <div style="font-size: 16px; margin-top: 5px;">
                            {{ $booking->flight->arrival_time->format('H:i, M d, Y') }}
                        </div>
                    </div>
                </div>

                @if($booking->flight->terminal)
                <div class="info-row">
                    <span class="info-label">Terminal:</span>
                    {{ $booking->flight->terminal }}
                </div>
                @endif

                @if($booking->flight->gate)
                <div class="info-row">
                    <span class="info-label">Gate:</span>
                    {{ $booking->flight->gate }}
                </div>
                @endif

                <div class="info-row">
                    <span class="info-label">Duration:</span>
                    {{ $booking->flight->duration }}
                </div>
            </div>

            <div class="checklist">
                <strong>📋 Pre-Flight Checklist:</strong>
                <ul>
                    <li>✓ Save your booking reference: <strong>{{ $booking->booking_reference }}</strong></li>
                    <li>✓ Arrive at least 2 hours before international flights (1 hour for domestic)</li>
                    <li>✓ Check your passport validity (6 months minimum for international travel)</li>
                    <li>✓ Review baggage allowance with your airline</li>
                    <li>✓ Complete online check-in 24 hours before departure</li>
                </ul>
            </div>

            <div style="text-align: center;">
                <a href="{{ route('flights.booking.success', $booking) }}" class="button">View Booking Details</a>
            </div>

            <p style="text-align: center; color: #666; font-size: 14px; margin-top: 30px;">
                Have a wonderful trip! If you have any questions, please contact our support team.
            </p>
        </div>

        <div class="footer">
            <p>This is an automated email. Please do not reply to this message.</p>
            @if($settings->contact_email)
            <p>For support, contact us at: <a href="mailto:{{ $settings->contact_email }}" style="color: #10b981;">{{ $settings->contact_email }}</a></p>
            @endif
            {{-- @if($settings->whatsapp)
            <p>WhatsApp: {{ $settings->whatsapp }}</p>
            @endif --}}
            <p>&copy; {{ date('Y') }} {{ $settings->site_name }}. All rights reserved.</p>
            @if($settings->site_address)
            <p style="font-size: 11px; color: #999;">{{ $settings->site_address }}</p>
            @endif
        </div>
    </div>
</body>
</html>
