
<!-- Modern Professional Success Alert Component -->
@if (Session::has('success'))
<div x-data="{ show: true }"
     x-show="show"
     x-transition:enter="transition ease-out duration-300 transform"
     x-transition:enter-start="translate-y-[-100%] opacity-0"
     x-transition:enter-end="translate-y-0 opacity-100"
     x-transition:leave="transition ease-in duration-200 transform"
     x-transition:leave-start="translate-y-0 opacity-100"
     x-transition:leave-end="translate-y-[-100%] opacity-0"
     class="fixed top-4 left-1/2 transform -translate-x-1/2 z-50 w-full max-w-md mx-auto px-4">

    <div class="bg-white border border-gray-200 rounded-2xl shadow-xl backdrop-blur-sm">
        <!-- Success Banner -->
        <div class="bg-gradient-to-r from-var(--primary-color) to-var(--secondary-color) rounded-t-2xl px-6 py-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-3">
                    <!-- Success Icon -->
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M5 13l4 4L19 7"></path>
                            </svg>
                        </div>
                    </div>

                    <!-- Success Label -->
                    <div>
                        <h3 class="text-white font-semibold text-sm tracking-wide">SUCCESS</h3>
                    </div>
                </div>

                <!-- Close Button -->
                <button @click="show = false"
                        class="text-white hover:text-gray-200 transition-colors duration-200 focus:outline-none focus:ring-2 focus:ring-white focus:ring-opacity-50 rounded-lg p-1"
                        aria-label="Close notification">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
        </div>

        <!-- Message Content -->
        <div class="px-6 py-5">
            <div class="flex items-start space-x-4">
                <!-- Large Success Icon -->
                <div class="flex-shrink-0 mt-1">
                    <div class="w-10 h-10 bg-gradient-to-br from-var(--primary-color) to-var(--secondary-color) rounded-xl flex items-center justify-center">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>

                <!-- Message Text -->
                <div class="flex-1 min-w-0">
                    <p class="text-gray-800 font-medium text-base leading-relaxed">
                        {{ Session::get('success') }}
                    </p>
                    <p class="text-gray-500 text-sm mt-2 font-medium">
                        Operation completed successfully
                    </p>
                </div>
            </div>

            <!-- Progress Indicator -->
            <div class="mt-4">
                <div class="w-full bg-gray-100 rounded-full h-1.5 overflow-hidden">
                    <div class="h-full bg-gradient-to-r from-var(--primary-color) to-var(--secondary-color) rounded-full transform transition-transform duration-300 ease-out scale-x-100"></div>
                </div>
            </div>
        </div>

        <!-- Action Footer -->
        <div class="bg-gray-50 rounded-b-2xl px-6 py-4 border-t border-gray-100">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-2">
                    <div class="w-2 h-2 bg-var(--primary-color) rounded-full animate-pulse"></div>
                    <span class="text-gray-600 text-sm font-medium">Email Flashing System</span>
                </div>

                <!-- Auto-dismiss countdown -->
                <div x-data="{ countdown: 5 }" x-init="
                    let timer = setInterval(() => {
                        countdown--;
                        if (countdown <= 0) {
                            clearInterval(timer);
                            show = false;
                        }
                    }, 1000)
                " class="flex items-center space-x-2 text-gray-500 text-sm">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <span x-text="`Auto-close in ${countdown}s`" class="font-medium"></span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Toast-style Alternative (Smaller Version) -->
<div x-data="{ showToast: true }"
     x-show="showToast"
     x-transition:enter="transition ease-out duration-300 transform"
     x-transition:enter-start="translate-x-full opacity-0"
     x-transition:enter-end="translate-x-0 opacity-100"
     x-transition:leave="transition ease-in duration-200 transform"
     x-transition:leave-start="translate-x-0 opacity-100"
     x-transition:leave-end="translate-x-full opacity-0"
     class="fixed top-6 right-6 z-50 max-w-sm w-full sm:w-auto hidden lg:block">

    <div class="bg-white border border-gray-200 rounded-xl shadow-lg backdrop-blur-sm">
        <div class="flex items-center p-4 space-x-3">
            <!-- Toast Icon -->
            <div class="flex-shrink-0">
                <div class="w-8 h-8 bg-gradient-to-br from-var(--primary-color) to-var(--secondary-color) rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M5 13l4 4L19 7"></path>
                    </svg>
                </div>
            </div>

            <!-- Toast Content -->
            <div class="flex-1 min-w-0">
                <p class="text-gray-800 font-semibold text-sm">Success!</p>
                <p class="text-gray-600 text-xs mt-1 truncate">{{ Str::limit(Session::get('success'), 40) }}</p>
            </div>

            <!-- Toast Close -->
            <button @click="showToast = false"
                    class="flex-shrink-0 text-gray-400 hover:text-gray-600 transition-colors duration-200 focus:outline-none focus:ring-2 focus:ring-var(--primary-color) focus:ring-opacity-50 rounded-lg p-1">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>

        <!-- Toast Progress Bar -->
        <div class="h-1 bg-gray-100 rounded-b-xl overflow-hidden">
            <div x-data="{ width: 100 }" x-init="
                let progress = setInterval(() => {
                    width -= 2;
                    if (width <= 0) {
                        clearInterval(progress);
                        showToast = false;
                    }
                }, 100)
            " :style="`width: ${width}%`"
            class="h-full bg-gradient-to-r from-var(--primary-color) to-var(--secondary-color) transition-all duration-100 ease-linear"></div>
        </div>
    </div>
</div>
@endif

<!-- Custom Styles for Success Alert -->
<style>
/* Enhanced Success Alert Animations */
@keyframes slideInDown {
    from {
        transform: translate(-50%, -100%);
        opacity: 0;
    }
    to {
        transform: translate(-50%, 0);
        opacity: 1;
    }
}

@keyframes slideOutUp {
    from {
        transform: translate(-50%, 0);
        opacity: 1;
    }
    to {
        transform: translate(-50%, -100%);
        opacity: 0;
    }
}

@keyframes slideInRight {
    from {
        transform: translateX(100%);
        opacity: 0;
    }
    to {
        transform: translateX(0);
        opacity: 1;
    }
}

@keyframes slideOutRight {
    from {
        transform: translateX(0);
        opacity: 1;
    }
    to {
        transform: translateX(100%);
        opacity: 0;
    }
}

/* Professional Success Pulse */
@keyframes successPulse {
    0%, 100% {
        transform: scale(1);
        opacity: 1;
    }
    50% {
        transform: scale(1.05);
        opacity: 0.9;
    }
}

.success-pulse {
    animation: successPulse 2s ease-in-out infinite;
}

/* Mobile Responsive Adjustments */
@media (max-width: 640px) {
    .fixed.top-4.left-1\/2 {
        top: 1rem;
        left: 1rem;
        right: 1rem;
        transform: none;
        max-width: none;
    }
}
</style>
