<!-- Modern Professional Danger Alert Component -->
@if (Session::has('message'))
<div x-data="{ show: true }"
     x-show="show"
     x-transition:enter="transition ease-out duration-300 transform"
     x-transition:enter-start="translate-y-[-100%] opacity-0"
     x-transition:enter-end="translate-y-0 opacity-100"
     x-transition:leave="transition ease-in duration-200 transform"
     x-transition:leave-start="translate-y-0 opacity-100"
     x-transition:leave-end="translate-y-[-100%] opacity-0"
     class="fixed top-4 left-1/2 transform -translate-x-1/2 z-50 w-full max-w-md mx-auto px-4">

    <div class="bg-white border-2 border-red-100 rounded-2xl shadow-xl backdrop-blur-sm">
        <!-- Error Banner -->
        <div class="bg-gradient-to-r from-red-500 to-red-600 rounded-t-2xl px-6 py-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-3">
                    <!-- Error Icon -->
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                            </svg>
                        </div>
                    </div>

                    <!-- Error Label -->
                    <div>
                        <h3 class="text-white font-semibold text-sm tracking-wide">ATTENTION REQUIRED</h3>
                    </div>
                </div>

                <!-- Close Button -->
                <button @click="show = false"
                        class="text-white hover:text-red-100 transition-colors duration-200 focus:outline-none focus:ring-2 focus:ring-white focus:ring-opacity-50 rounded-lg p-1"
                        aria-label="Close notification">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
        </div>

        <!-- Message Content -->
        <div class="px-6 py-5">
            <div class="flex items-start space-x-4">
                <!-- Large Error Icon -->
                <div class="flex-shrink-0 mt-1">
                    <div class="w-10 h-10 bg-gradient-to-br from-red-500 to-red-600 rounded-xl flex items-center justify-center">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>

                <!-- Message Text -->
                <div class="flex-1 min-w-0">
                    <p class="text-gray-800 font-medium text-base leading-relaxed">
                        {{ Session::get('message') }}
                    </p>
                    <p class="text-gray-500 text-sm mt-2 font-medium">
                        Please review the information and try again
                    </p>
                </div>
            </div>

            <!-- Action Suggestions -->
            <div class="mt-4 p-4 bg-red-50 rounded-xl border border-red-100">
                <div class="flex items-start space-x-3">
                    <div class="flex-shrink-0">
                        <svg class="w-5 h-5 text-red-500 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div class="flex-1">
                        <h4 class="text-red-800 font-semibold text-sm">Quick Help</h4>
                        <ul class="text-red-700 text-sm mt-1 space-y-1">
                            <li>• Double-check all required fields</li>
                            <li>• Verify your account information</li>
                            <li>• Contact support if the issue persists</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Footer -->
        <div class="bg-gray-50 rounded-b-2xl px-6 py-4 border-t border-gray-100">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-2">
                    <div class="w-2 h-2 bg-red-500 rounded-full animate-pulse"></div>
                    <span class="text-gray-600 text-sm font-medium">Email Flashing System</span>
                </div>

                <!-- Manual dismiss option -->
                <button @click="show = false"
                        class="inline-flex items-center px-3 py-1.5 bg-var(--primary-color) text-white text-sm font-medium rounded-lg hover:bg-opacity-90 transition-all duration-200 focus:outline-none focus:ring-2 focus:ring-var(--primary-color) focus:ring-opacity-50">
                    <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                    Dismiss
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Toast-style Alternative (Smaller Version) -->
<div x-data="{ showToast: true }"
     x-show="showToast"
     x-transition:enter="transition ease-out duration-300 transform"
     x-transition:enter-start="translate-x-full opacity-0"
     x-transition:enter-end="translate-x-0 opacity-100"
     x-transition:leave="transition ease-in duration-200 transform"
     x-transition:leave-start="translate-x-0 opacity-100"
     x-transition:leave-end="translate-x-full opacity-0"
     class="fixed top-6 right-6 z-50 max-w-sm w-full sm:w-auto hidden lg:block">

    <div class="bg-white border-2 border-red-100 rounded-xl shadow-lg backdrop-blur-sm">
        <div class="flex items-center p-4 space-x-3">
            <!-- Toast Icon -->
            <div class="flex-shrink-0">
                <div class="w-8 h-8 bg-gradient-to-br from-red-500 to-red-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                    </svg>
                </div>
            </div>

            <!-- Toast Content -->
            <div class="flex-1 min-w-0">
                <p class="text-gray-800 font-semibold text-sm">Action Required</p>
                <p class="text-gray-600 text-xs mt-1 truncate">{{ Str::limit(Session::get('message'), 35) }}</p>
            </div>

            <!-- Toast Close -->
            <button @click="showToast = false"
                    class="flex-shrink-0 text-gray-400 hover:text-gray-600 transition-colors duration-200 focus:outline-none focus:ring-2 focus:ring-red-500 focus:ring-opacity-50 rounded-lg p-1">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>

        <!-- Toast Action Bar -->
        <div class="px-4 pb-4">
            <button @click="showToast = false"
                    class="w-full inline-flex items-center justify-center px-3 py-2 bg-var(--primary-color) text-white text-xs font-medium rounded-lg hover:bg-opacity-90 transition-all duration-200 focus:outline-none focus:ring-2 focus:ring-var(--primary-color) focus:ring-opacity-50">
                <svg class="w-3 h-3 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                Got it
            </button>
        </div>
    </div>
</div>
@endif

<!-- Custom Styles for Danger Alert -->
<style>
/* Enhanced Danger Alert Animations */
@keyframes dangerPulse {
    0%, 100% {
        transform: scale(1);
        opacity: 1;
    }
    50% {
        transform: scale(1.02);
        opacity: 0.95;
    }
}

@keyframes warningShake {
    0%, 100% {
        transform: translateX(0);
    }
    10%, 30%, 50%, 70%, 90% {
        transform: translateX(-2px);
    }
    20%, 40%, 60%, 80% {
        transform: translateX(2px);
    }
}

.danger-pulse {
    animation: dangerPulse 2.5s ease-in-out infinite;
}

.warning-shake {
    animation: warningShake 0.6s ease-in-out;
}

/* Professional Error Styling */
.error-border {
    border-image: linear-gradient(45deg, #ef4444, #dc2626) 1;
}

/* Enhanced Focus States */
.focus-error:focus {
    box-shadow: 0 0 0 3px rgba(239, 68, 68, 0.2);
}

/* Mobile Responsive Adjustments */
@media (max-width: 640px) {
    .fixed.top-4.left-1\/2 {
        top: 1rem;
        left: 1rem;
        right: 1rem;
        transform: none;
        max-width: none;
    }

    .hidden.lg\\:block {
        display: none !important;
    }
}

/* High Contrast Mode Support */
@media (prefers-contrast: high) {
    .bg-red-500 {
        background-color: #dc2626 !important;
    }

    .border-red-100 {
        border-color: #ef4444 !important;
    }
}

/* Reduced Motion Support */
@media (prefers-reduced-motion: reduce) {
    .danger-pulse,
    .warning-shake {
        animation: none;
    }

    [x-transition] {
        transition: none !important;
    }
}
</style>
