{{-- Bootstrap Error Alert Component for Admin Panel --}}
@if (Session::has('error') || Session::has('message') || $errors->any())
<div class="alert alert-danger alert-dismissible fade show" role="alert" id="error-alert">
    <div class="d-flex align-items-start">
        <div class="flex-shrink-0 me-3">
            <i class="fas fa-exclamation-triangle fa-lg text-danger"></i>
        </div>
        <div class="flex-grow-1">
            <strong class="fw-bold">Error!</strong>
            <div class="mt-1">
                @if (Session::has('error'))
                    <div>{{ Session::get('error') }}</div>
                @endif

                @if (Session::has('message'))
                    <div>{{ Session::get('message') }}</div>
                @endif

                @if ($errors->any())
                    @if ($errors->count() > 1)
                        <ul class="mb-0 mt-2">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    @else
                        <div>{{ $errors->first() }}</div>
                    @endif
                @endif
            </div>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
</div>

<script>
    // Auto-hide error alert after 8 seconds (longer for errors)
    setTimeout(function() {
        var alert = document.getElementById('error-alert');
        if (alert) {
            var bootstrapAlert = new bootstrap.Alert(alert);
            bootstrapAlert.close();
        }
    }, 8000);
</script>
@endif
