{{-- Comprehensive Bootstrap Alert Component for Admin Panel --}}
{{-- Compatible with Bootstrap 4 & 5 --}}

{{-- Success Alert --}}
@if (Session::has('success'))
<div class="alert alert-success alert-dismissible fade show mb-3" role="alert">
    <div class="d-flex align-items-center">
        <div class="mr-3">
            <i class="fas fa-check-circle fa-lg text-success"></i>
        </div>
        <div class="flex-grow-1">
            <strong>Success!</strong>
            <span class="ml-2">{{ Session::get('success') }}</span>
        </div>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
</div>
@endif

{{-- Error Alert --}}
@if (Session::has('error') || Session::has('message') || $errors->any())
<div class="alert alert-danger alert-dismissible fade show mb-3" role="alert">
    <div class="d-flex align-items-start">
        <div class="mr-3">
            <i class="fas fa-exclamation-triangle fa-lg text-danger"></i>
        </div>
        <div class="flex-grow-1">
            <strong>Error!</strong>
            <div class="mt-1">
                @if (Session::has('error'))
                    <div>{{ Session::get('error') }}</div>
                @endif

                @if (Session::has('message'))
                    <div>{{ Session::get('message') }}</div>
                @endif

                @if ($errors->any())
                    @if ($errors->count() > 1)
                        <ul class="mb-0 mt-2">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    @else
                        <div>{{ $errors->first() }}</div>
                    @endif
                @endif
            </div>
        </div>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
</div>
@endif

{{-- Warning Alert --}}
@if (Session::has('warning'))
<div class="alert alert-warning alert-dismissible fade show mb-3" role="alert">
    <div class="d-flex align-items-center">
        <div class="mr-3">
            <i class="fas fa-exclamation-circle fa-lg text-warning"></i>
        </div>
        <div class="flex-grow-1">
            <strong>Warning!</strong>
            <span class="ml-2">{{ Session::get('warning') }}</span>
        </div>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
</div>
@endif

{{-- Info Alert --}}
@if (Session::has('info'))
<div class="alert alert-info alert-dismissible fade show mb-3" role="alert">
    <div class="d-flex align-items-center">
        <div class="mr-3">
            <i class="fas fa-info-circle fa-lg text-info"></i>
        </div>
        <div class="flex-grow-1">
            <strong>Info!</strong>
            <span class="ml-2">{{ Session::get('info') }}</span>
        </div>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
</div>
@endif

{{-- Auto-hide alerts after specified time --}}
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Function to auto-hide alerts
        function autoHideAlert(selector, delay) {
            setTimeout(function() {
                var alertElement = document.querySelector(selector);
                if (alertElement) {
                    // For Bootstrap 4 compatibility
                    if (typeof bootstrap !== 'undefined' && bootstrap.Alert) {
                        var alert = new bootstrap.Alert(alertElement);
                        alert.close();
                    } else if (typeof $ !== 'undefined' && $.fn.alert) {
                        $(alertElement).alert('close');
                    } else {
                        // Fallback manual hide
                        alertElement.style.display = 'none';
                    }
                }
            }, delay);
        }

        // Auto-hide different alert types with different timings
        autoHideAlert('.alert-success', 5000);  // Success: 5 seconds
        autoHideAlert('.alert-info', 5000);     // Info: 5 seconds
        autoHideAlert('.alert-warning', 6000);  // Warning: 6 seconds
        autoHideAlert('.alert-danger', 8000);   // Error: 8 seconds (longer for errors)
    });
</script>

{{-- Additional CSS for better appearance --}}
<style>
    .alert {
        border-radius: 8px;
        border: none;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }

    .alert-success {
        background-color: #d4edda;
        color: #155724;
    }

    .alert-danger {
        background-color: #f8d7da;
        color: #721c24;
    }

    .alert-warning {
        background-color: #fff3cd;
        color: #856404;
    }

    .alert-info {
        background-color: #d1ecf1;
        color: #0c5460;
    }

    .alert .fas {
        margin-top: 2px;
    }
</style>
