<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content ">
            <div class="panel-header bg-{{ $gradient }}-gradient">
                <div class="py-5 page-inner">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div>
                            <h2 class="pb-2 text-white fw-bold">Flight {{ $flight->flight_number }}</h2>
                            <h5 class="mb-2 text-white op-7">{{ $flight->originAirport->city }} to {{ $flight->destinationAirport->city }}</h5>
                        </div>
                        <div class="py-2 ml-md-auto py-md-0">
                            <a href="{{ route('admin.flights.index') }}" class="mr-2 btn btn-secondary btn-border">
                                <i class="fas fa-arrow-left"></i> Back
                            </a>
                            <a href="{{ route('admin.flights.edit', $flight) }}" class="btn btn-warning btn-border">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                        </div>
                    </div>
                </div>
            </div>
             <div class="page-inner mt--5">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                
                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Validation Error!</strong> Please check the form for errors.
                        <ul class="mb-0 mt-2">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
            </div>
            
            <div class="page-inner mt--5">
                <div class="row">
                    <!-- Flight Details -->
                    <div class="col-md-8">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-plane"></i> Flight Details
                                    <span class="badge badge-{{ $flight->status == 'scheduled' ? 'primary' : ($flight->status == 'boarding' ? 'warning' : ($flight->status == 'departed' || $flight->status == 'airborne' ? 'success' : ($flight->status == 'delayed' ? 'info' : ($flight->status == 'landed' ? 'secondary' : 'danger')))) }} ml-2">
                                        {{ ucfirst($flight->status) }}
                                    </span>
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h5><i class="fas fa-plane-departure"></i> Departure</h5>
                                        <p><strong>{{ $flight->originAirport->name }}</strong></p>
                                        <p class="text-muted">{{ $flight->originAirport->city }}, {{ $flight->originAirport->country }}</p>
                                        <p><strong>{{ $flight->departure_time->format('M j, Y H:i') }}</strong></p>
                                        @if($flight->terminal)
                                            <p>Terminal: <strong>{{ $flight->terminal }}</strong></p>
                                        @endif
                                        @if($flight->gate)
                                            <p>Gate: <strong>{{ $flight->gate }}</strong></p>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <h5><i class="fas fa-plane-arrival"></i> Arrival</h5>
                                        <p><strong>{{ $flight->destinationAirport->name }}</strong></p>
                                        <p class="text-muted">{{ $flight->destinationAirport->city }}, {{ $flight->destinationAirport->country }}</p>
                                        <p><strong>{{ $flight->arrival_time->format('M j, Y H:i') }}</strong></p>
                                        <p>Duration: <strong>{{ $flight->departure_time->diffForHumans($flight->arrival_time, true) }}</strong></p>
                                    </div>
                                </div>
                                
                                <hr>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>Flight Information</h6>
                                        <p>Airline: <strong>{{ $flight->airline }}</strong></p>
                                        <p>Flight Number: <strong>{{ $flight->flight_number }}</strong></p>
                                        @if($flight->aircraft_type)
                                            <p>Aircraft: <strong>{{ $flight->aircraft_type }}</strong></p>
                                        @endif
                                        <p>Price: <strong>${{ number_format($flight->price, 2) }}</strong></p>
                                    </div>
                                    <div class="col-md-6">
                                        <h6>Capacity</h6>
                                        <p>Total Seats: <strong>{{ $flight->seats_total }}</strong></p>
                                        <p>Available: <strong>{{ $flight->seats_available }}</strong></p>
                                        <p>Booked: <strong>{{ $flight->seats_total - $flight->seats_available }}</strong></p>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: {{ ($flight->seats_total - $flight->seats_available) / $flight->seats_total * 100 }}%"></div>
                                        </div>
                                        <small class="text-muted">{{ round(($flight->seats_total - $flight->seats_available) / $flight->seats_total * 100) }}% booked</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Bookings -->
                        @if($flight->bookings->count() > 0)
                            <div class="card shadow-lg mt-4">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-users"></i> Bookings
                                        <span class="badge badge-primary">{{ $flight->bookings->count() }}</span>
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>Reference</th>
                                                    <th>Passenger</th>
                                                    <th>Seat</th>
                                                    <th>Status</th>
                                                    <th>Payment</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($flight->bookings as $booking)
                                                    <tr>
                                                        <td><strong>{{ $booking->booking_reference }}</strong></td>
                                                        <td>
                                                            {{ $booking->passenger_name }}
                                                            @if($booking->user)
                                                                <br><small class="text-muted">{{ $booking->user->email }}</small>
                                                            @else
                                                                <br><small class="text-muted">{{ $booking->passenger_email }}</small>
                                                            @endif
                                                        </td>
                                                        <td>{{ $booking->seat_number ?: 'TBA' }}</td>
                                                        <td>
                                                            <span class="badge badge-{{ $booking->status == 'confirmed' ? 'success' : ($booking->status == 'checked_in' ? 'info' : ($booking->status == 'cancelled' ? 'danger' : 'secondary')) }}">
                                                                {{ ucfirst($booking->status) }}
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <span class="badge badge-{{ $booking->payment_status == 'paid' ? 'success' : ($booking->payment_status == 'pending' ? 'warning' : 'danger') }}">
                                                                {{ ucfirst($booking->payment_status) }}
                                                            </span>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>

                    <!-- Tracking -->
                    <div class="col-md-4">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-map-marked-alt"></i> Flight Tracking
                                </h4>
                            </div>
                            <div class="card-body">
                                @if($flight->tracking_lat && $flight->tracking_lng)
                                    <p><strong>Current Position:</strong></p>
                                    <p>Latitude: {{ $flight->tracking_lat }}</p>
                                    <p>Longitude: {{ $flight->tracking_lng }}</p>
                                    
                                    @if($flight->altitude)
                                        <p>Altitude: <strong>{{ number_format($flight->altitude) }} ft</strong></p>
                                    @endif
                                    
                                    @if($flight->speed)
                                        <p>Speed: <strong>{{ $flight->speed }} knots</strong></p>
                                    @endif
                                    
                                    @if($flight->last_position_updated_at)
                                        <p><small class="text-muted">Updated: {{ $flight->last_position_updated_at->diffForHumans() }}</small></p>
                                    @endif

                                    <!-- Quick Update Form -->
                                    <hr>
                                    <form id="tracking-form">
                                        @csrf
                                        <h6>Update Position</h6>
                                        <div class="form-group">
                                            <input type="number" class="form-control form-control-sm" id="lat" placeholder="Latitude" step="0.000001" value="{{ $flight->tracking_lat }}">
                                        </div>
                                        <div class="form-group">
                                            <input type="number" class="form-control form-control-sm" id="lng" placeholder="Longitude" step="0.000001" value="{{ $flight->tracking_lng }}">
                                        </div>
                                        <div class="form-group">
                                            <input type="number" class="form-control form-control-sm" id="altitude" placeholder="Altitude (ft)" value="{{ $flight->altitude }}">
                                        </div>
                                        <div class="form-group">
                                            <input type="number" class="form-control form-control-sm" id="speed" placeholder="Speed (knots)" value="{{ $flight->speed }}">
                                        </div>
                                        <button type="button" class="btn btn-primary btn-sm" onclick="updatePosition()">
                                            <i class="fas fa-map-pin"></i> Update Position
                                        </button>
                                    </form>
                                @else
                                    <p class="text-muted">No tracking data available.</p>
                                    <a href="{{ route('admin.flights.edit', $flight) }}" class="btn btn-primary btn-sm">
                                        <i class="fas fa-edit"></i> Add Tracking Info
                                    </a>
                                @endif
                            </div>
                        </div>

                        <!-- Status Update -->
                        <div class="card shadow-lg mt-4">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-info-circle"></i> Quick Status Update
                                </h4>
                            </div>
                            <div class="card-body">
                                <form id="status-form">
                                    @csrf
                                    <div class="form-group">
                                        <label>Status</label>
                                        <select class="form-control" id="status">
                                            <option value="scheduled" {{ $flight->status == 'scheduled' ? 'selected' : '' }}>Scheduled</option>
                                            <option value="boarding" {{ $flight->status == 'boarding' ? 'selected' : '' }}>Boarding</option>
                                            <option value="departed" {{ $flight->status == 'departed' ? 'selected' : '' }}>Departed</option>
                                            <option value="airborne" {{ $flight->status == 'airborne' ? 'selected' : '' }}>Airborne</option>
                                            <option value="delayed" {{ $flight->status == 'delayed' ? 'selected' : '' }}>Delayed</option>
                                            <option value="landed" {{ $flight->status == 'landed' ? 'selected' : '' }}>Landed</option>
                                            <option value="cancelled" {{ $flight->status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Terminal</label>
                                        <input type="text" class="form-control" id="terminal" value="{{ $flight->terminal }}">
                                    </div>
                                    <div class="form-group">
                                        <label>Gate</label>
                                        <input type="text" class="form-control" id="gate" value="{{ $flight->gate }}">
                                    </div>
                                    <button type="button" class="btn btn-success btn-sm" onclick="updateStatus()">
                                        <i class="fas fa-save"></i> Update Status
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        function updatePosition() {
            const lat = document.getElementById('lat').value;
            const lng = document.getElementById('lng').value;
            const altitude = document.getElementById('altitude').value;
            const speed = document.getElementById('speed').value;

            fetch('{{ route("admin.flights.update-position", $flight) }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('[name="_token"]').value
                },
                body: JSON.stringify({ lat, lng, altitude, speed })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Position updated successfully!');
                    location.reload();
                } else {
                    alert('Error updating position');
                }
            });
        }

        function updateStatus() {
            const status = document.getElementById('status').value;
            const terminal = document.getElementById('terminal').value;
            const gate = document.getElementById('gate').value;

            fetch('{{ route("admin.flights.update-status", $flight) }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('[name="_token"]').value
                },
                body: JSON.stringify({ status, terminal, gate })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Status updated successfully!');
                    location.reload();
                } else {
                    alert('Error updating status');
                }
            });
        }
    </script>
    @endpush
@endsection