<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content ">
            <div class="panel-header bg-{{ $gradient }}-gradient">
                <div class="py-5 page-inner">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div>
                            <h2 class="pb-2 text-white fw-bold">Flight Management</h2>
                            <h5 class="mb-2 text-white op-7">Manage flights, schedules, and tracking</h5>
                        </div>
                        <div class="py-2 ml-md-auto py-md-0">
                            <a href="{{ route('admin.flights.create') }}" class="mr-2 btn btn-success btn-border">
                                <i class="fas fa-plus"></i> Add Flight
                            </a>
                            <a href="{{ route('admin.airports.index') }}" class="btn btn-info btn-border">
                                <i class="fas fa-map-marker-alt"></i> Airports
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="page-inner mt--5">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                
                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Validation Error!</strong> Please check the form for errors.
                        <ul class="mb-0 mt-2">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
            </div>
            
            <div class="page-inner mt--5">
                <!-- Flight Filters -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-filter"></i> Filter Flights
                                </h4>
                            </div>
                            <div class="card-body">
                                <form method="GET" action="{{ route('admin.flights.index') }}">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Status</label>
                                                <select name="status" class="form-control">
                                                    <option value="">All Statuses</option>
                                                    <option value="scheduled" {{ request('status') == 'scheduled' ? 'selected' : '' }}>Scheduled</option>
                                                    <option value="boarding" {{ request('status') == 'boarding' ? 'selected' : '' }}>Boarding</option>
                                                    <option value="departed" {{ request('status') == 'departed' ? 'selected' : '' }}>Departed</option>
                                                    <option value="airborne" {{ request('status') == 'airborne' ? 'selected' : '' }}>Airborne</option>
                                                    <option value="delayed" {{ request('status') == 'delayed' ? 'selected' : '' }}>Delayed</option>
                                                    <option value="landed" {{ request('status') == 'landed' ? 'selected' : '' }}>Landed</option>
                                                    <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>From Date</label>
                                                <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>To Date</label>
                                                <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Search</label>
                                                <input type="text" name="search" class="form-control" placeholder="Flight number or airline" value="{{ request('search') }}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-search"></i> Filter
                                            </button>
                                            <a href="{{ route('admin.flights.index') }}" class="btn btn-secondary">
                                                <i class="fas fa-times"></i> Clear
                                            </a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Flights Table -->
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-plane"></i> Flights 
                                    <span class="badge badge-primary">{{ $flights->total() }}</span>
                                </h4>
                            </div>
                            <div class="card-body">
                                @if($flights->count() > 0)
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Flight</th>
                                                    <th>Route</th>
                                                    <th>Departure</th>
                                                    <th>Arrival</th>
                                                    <th>Status</th>
                                                    <th>Gate</th>
                                                    <th>Seats</th>
                                                    <th>Price</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($flights as $flight)
                                                    <tr>
                                                        <td>
                                                            <strong>{{ $flight->airline }}</strong><br>
                                                            <small class="text-muted">{{ $flight->flight_number }}</small>
                                                        </td>
                                                        <td>
                                                            <strong>{{ $flight->originAirport->iata_code }}</strong> 
                                                            <i class="fas fa-arrow-right text-muted"></i> 
                                                            <strong>{{ $flight->destinationAirport->iata_code }}</strong><br>
                                                            <small class="text-muted">
                                                                {{ $flight->originAirport->city }} → {{ $flight->destinationAirport->city }}
                                                            </small>
                                                        </td>
                                                        <td>
                                                            <strong>{{ $flight->departure_time->format('H:i') }}</strong><br>
                                                            <small class="text-muted">{{ $flight->departure_time->format('M j') }}</small>
                                                        </td>
                                                        <td>
                                                            <strong>{{ $flight->arrival_time->format('H:i') }}</strong><br>
                                                            <small class="text-muted">{{ $flight->arrival_time->format('M j') }}</small>
                                                        </td>
                                                        <td>
                                                            <span class="badge badge-{{ $flight->status == 'scheduled' ? 'primary' : ($flight->status == 'boarding' ? 'warning' : ($flight->status == 'departed' || $flight->status == 'airborne' ? 'success' : ($flight->status == 'delayed' ? 'info' : ($flight->status == 'landed' ? 'secondary' : 'danger')))) }}">
                                                                {{ ucfirst($flight->status) }}
                                                            </span>
                                                        </td>
                                                        <td>
                                                            @if($flight->terminal || $flight->gate)
                                                                <small>
                                                                    @if($flight->terminal)
                                                                        T{{ $flight->terminal }}
                                                                    @endif
                                                                    @if($flight->gate)
                                                                        <br>Gate {{ $flight->gate }}
                                                                    @endif
                                                                </small>
                                                            @else
                                                                <span class="text-muted">TBA</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <strong>{{ $flight->seats_available }}</strong> / {{ $flight->seats_total }}<br>
                                                            <small class="text-muted">
                                                                {{ round(($flight->seats_total - $flight->seats_available) / $flight->seats_total * 100) }}% booked
                                                            </small>
                                                        </td>
                                                        <td>
                                                            <strong>${{ number_format($flight->price, 2) }}</strong>
                                                        </td>
                                                        <td>
                                                            <div class="btn-group">
                                                                <a href="{{ route('admin.flights.show', $flight) }}" class="btn btn-sm btn-info" title="View">
                                                                    <i class="fas fa-eye"></i>
                                                                </a>
                                                                <a href="{{ route('admin.flights.edit', $flight) }}" class="btn btn-sm btn-warning" title="Edit">
                                                                    <i class="fas fa-edit"></i>
                                                                </a>
                                                                @if(!$flight->bookings()->where('status', '!=', 'cancelled')->count())
                                                                    <form method="POST" action="{{ route('admin.flights.destroy', $flight) }}" style="display: inline;" onsubmit="return confirm('Are you sure?')">
                                                                        @csrf
                                                                        @method('DELETE')
                                                                        <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                                                            <i class="fas fa-trash"></i>
                                                                        </button>
                                                                    </form>
                                                                @endif
                                                            </div>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>

                                    <!-- Pagination -->
                                    <div class="d-flex justify-content-center">
                                        {{ $flights->links() }}
                                    </div>
                                @else
                                    <div class="text-center py-5">
                                        <i class="fas fa-plane-slash fa-3x text-muted mb-3"></i>
                                        <h4>No flights found</h4>
                                        <p class="text-muted">Start by adding your first flight.</p>
                                        <a href="{{ route('admin.flights.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Add Flight
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        // Auto-refresh every 30 seconds for real-time updates
        setTimeout(function(){
            location.reload();
        }, 30000);
    </script>
    @endpush
@endsection