<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content ">
            <div class="panel-header bg-{{ $gradient }}-gradient">
                <div class="py-5 page-inner">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div>
                            <h2 class="pb-2 text-white fw-bold">Edit Flight</h2>
                            <h5 class="mb-2 text-white op-7">Update flight {{ $flight->flight_number }} details</h5>
                        </div>
                        <div class="py-2 ml-md-auto py-md-0">
                            <a href="{{ route('admin.flights.index') }}" class="btn btn-secondary btn-border">
                                <i class="fas fa-arrow-left"></i> Back to Flights
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="page-inner mt--5">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                
                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Validation Error!</strong> Please check the form for errors.
                        <ul class="mb-0 mt-2">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
            </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-plane"></i> Flight Details
                                </h4>
                            </div>
                            <div class="card-body">
                                <form method="POST" action="{{ route('admin.flights.update', $flight) }}" enctype="multipart/form-data">
                                    @csrf
                                    @method('PUT')
                                    
                                    <!-- Flight Information -->
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="airline">Airline <span class="text-danger">*</span></label>
                                                <input type="text" 
                                                       id="airline"
                                                       name="airline" 
                                                       class="form-control @error('airline') is-invalid @enderror" 
                                                       value="{{ old('airline', $flight->airline) }}" 
                                                       placeholder="e.g., American Airlines"
                                                       required>
                                                @error('airline')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="airline_logo">Airline Logo (Optional)</label>
                                                @if($flight->airline_logo)
                                                    <div class="mb-2">
                                                        <img src="{{ asset('storage/app/public/' . $flight->airline_logo) }}" 
                                                             alt="{{ $flight->airline }}" 
                                                             class="img-thumbnail" 
                                                             style="max-width: 100px; max-height: 100px; object-fit: contain;">
                                                        <small class="d-block text-muted">Current logo</small>
                                                    </div>
                                                @endif
                                                <input type="file" 
                                                       id="airline_logo"
                                                       name="airline_logo" 
                                                       class="form-control @error('airline_logo') is-invalid @enderror" 
                                                       accept="image/*">
                                                <small class="form-text text-muted">Upload new logo to replace current one. If not provided, existing logo will be retained.</small>
                                                @error('airline_logo')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="flight_number">Flight Number <span class="text-danger">*</span></label>
                                                <input type="text" 
                                                       id="flight_number"
                                                       name="flight_number" 
                                                       class="form-control @error('flight_number') is-invalid @enderror" 
                                                       value="{{ old('flight_number', $flight->flight_number) }}" 
                                                       placeholder="e.g., AA1234"
                                                       required>
                                                @error('flight_number')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Route Information -->
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="origin_airport_id">Origin Airport <span class="text-danger">*</span></label>
                                                <select name="origin_airport_id" 
                                                        id="origin_airport_id"
                                                        class="form-control @error('origin_airport_id') is-invalid @enderror" 
                                                        required>
                                                    <option value="">Select Origin Airport</option>
                                                    @foreach($airports as $airport)
                                                        <option value="{{ $airport->id }}" 
                                                            {{ old('origin_airport_id', $flight->origin_airport_id) == $airport->id ? 'selected' : '' }}
                                                            {{ $flight->destination_airport_id == $airport->id ? 'disabled' : '' }}>
                                                            {{ $airport->iata_code }} - {{ $airport->name }} ({{ $airport->city }})
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('origin_airport_id')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="destination_airport_id">Destination Airport <span class="text-danger">*</span></label>
                                                <select name="destination_airport_id" 
                                                        id="destination_airport_id"
                                                        class="form-control @error('destination_airport_id') is-invalid @enderror" 
                                                        required>
                                                    <option value="">Select Destination Airport</option>
                                                    @foreach($airports as $airport)
                                                        <option value="{{ $airport->id }}" 
                                                            {{ old('destination_airport_id', $flight->destination_airport_id) == $airport->id ? 'selected' : '' }}
                                                            {{ $flight->origin_airport_id == $airport->id ? 'disabled' : '' }}>
                                                            {{ $airport->iata_code }} - {{ $airport->name }} ({{ $airport->city }})
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('destination_airport_id')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Schedule Information -->
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="departure_time">Departure Time <span class="text-danger">*</span></label>
                                                <input type="datetime-local" 
                                                       id="departure_time"
                                                       name="departure_time" 
                                                       class="form-control @error('departure_time') is-invalid @enderror" 
                                                       value="{{ old('departure_time', $flight->departure_time->format('Y-m-d\TH:i')) }}" 
                                                       required>
                                                @error('departure_time')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="arrival_time">Arrival Time <span class="text-danger">*</span></label>
                                                <input type="datetime-local" 
                                                       id="arrival_time"
                                                       name="arrival_time" 
                                                       class="form-control @error('arrival_time') is-invalid @enderror" 
                                                       value="{{ old('arrival_time', $flight->arrival_time->format('Y-m-d\TH:i')) }}" 
                                                       required>
                                                @error('arrival_time')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Status -->
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="status">Flight Status <span class="text-danger">*</span></label>
                                                <select name="status" 
                                                        id="status"
                                                        class="form-control @error('status') is-invalid @enderror" 
                                                        required>
                                                    <option value="scheduled" {{ old('status', $flight->status) == 'scheduled' ? 'selected' : '' }}>Scheduled</option>
                                                    <option value="boarding" {{ old('status', $flight->status) == 'boarding' ? 'selected' : '' }}>Boarding</option>
                                                    <option value="departed" {{ old('status', $flight->status) == 'departed' ? 'selected' : '' }}>Departed</option>
                                                    <option value="airborne" {{ old('status', $flight->status) == 'airborne' ? 'selected' : '' }}>Airborne</option>
                                                    <option value="delayed" {{ old('status', $flight->status) == 'delayed' ? 'selected' : '' }}>Delayed</option>
                                                    <option value="landed" {{ old('status', $flight->status) == 'landed' ? 'selected' : '' }}>Landed</option>
                                                    <option value="cancelled" {{ old('status', $flight->status) == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                                </select>
                                                @error('status')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Terminal & Gate -->
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="terminal">Terminal</label>
                                                <input type="text" 
                                                       id="terminal"
                                                       name="terminal" 
                                                       class="form-control @error('terminal') is-invalid @enderror" 
                                                       value="{{ old('terminal', $flight->terminal) }}" 
                                                       placeholder="e.g., 1, A, B">
                                                @error('terminal')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="gate">Gate</label>
                                                <input type="text" 
                                                       id="gate"
                                                       name="gate" 
                                                       class="form-control @error('gate') is-invalid @enderror" 
                                                       value="{{ old('gate', $flight->gate) }}" 
                                                       placeholder="e.g., A12, B5">
                                                @error('gate')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="aircraft_type">Aircraft Type</label>
                                                <input type="text" 
                                                       id="aircraft_type"
                                                       name="aircraft_type" 
                                                       class="form-control @error('aircraft_type') is-invalid @enderror" 
                                                       value="{{ old('aircraft_type', $flight->aircraft_type) }}" 
                                                       placeholder="e.g., Boeing 737-800">
                                                @error('aircraft_type')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Capacity & Pricing -->
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="seats_total">Total Seats <span class="text-danger">*</span></label>
                                                <input type="number" 
                                                       id="seats_total"
                                                       name="seats_total" 
                                                       class="form-control @error('seats_total') is-invalid @enderror" 
                                                       value="{{ old('seats_total', $flight->seats_total) }}" 
                                                       min="1" 
                                                       max="1000"
                                                       required>
                                                <small class="form-text text-muted">Available: {{ $flight->seats_available }} seats</small>
                                                @error('seats_total')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="price">Base Price <span class="text-danger">*</span></label>
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text">$</span>
                                                    </div>
                                                    <input type="number" 
                                                           id="price"
                                                           name="price" 
                                                           class="form-control @error('price') is-invalid @enderror" 
                                                           value="{{ old('price', $flight->price) }}" 
                                                           min="0" 
                                                           step="0.01"
                                                           required>
                                                </div>
                                                @error('price')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Tracking Info (Optional) -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <h5 class="mt-3 mb-3">Real-time Tracking (Optional)</h5>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="tracking_lat">Latitude</label>
                                                <input type="number" 
                                                       id="tracking_lat"
                                                       name="tracking_lat" 
                                                       class="form-control @error('tracking_lat') is-invalid @enderror" 
                                                       value="{{ old('tracking_lat', $flight->tracking_lat) }}" 
                                                       step="0.000001"
                                                       min="-90"
                                                       max="90"
                                                       placeholder="e.g., 40.7128">
                                                @error('tracking_lat')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="tracking_lng">Longitude</label>
                                                <input type="number" 
                                                       id="tracking_lng"
                                                       name="tracking_lng" 
                                                       class="form-control @error('tracking_lng') is-invalid @enderror" 
                                                       value="{{ old('tracking_lng', $flight->tracking_lng) }}" 
                                                       step="0.000001"
                                                       min="-180"
                                                       max="180"
                                                       placeholder="e.g., -74.0060">
                                                @error('tracking_lng')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="altitude">Altitude (feet)</label>
                                                <input type="number" 
                                                       id="altitude"
                                                       name="altitude" 
                                                       class="form-control @error('altitude') is-invalid @enderror" 
                                                       value="{{ old('altitude', $flight->altitude) }}" 
                                                       min="0"
                                                       max="60000"
                                                       placeholder="e.g., 35000">
                                                @error('altitude')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="speed">Speed (knots)</label>
                                                <input type="number" 
                                                       id="speed"
                                                       name="speed" 
                                                       class="form-control @error('speed') is-invalid @enderror" 
                                                       value="{{ old('speed', $flight->speed) }}" 
                                                       min="0"
                                                       max="1000"
                                                       placeholder="e.g., 450">
                                                @error('speed')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Submit Buttons -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-primary">
                                                    <i class="fas fa-save"></i> Update Flight
                                                </button>
                                                <a href="{{ route('admin.flights.index') }}" class="btn btn-secondary ml-2">
                                                    <i class="fas fa-times"></i> Cancel
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        // Validate departure/arrival time
        document.getElementById('departure_time').addEventListener('change', function() {
            const departureTime = new Date(this.value);
            const arrivalInput = document.getElementById('arrival_time');
            
            // Set minimum arrival time to departure time + 30 minutes
            const minArrival = new Date(departureTime.getTime() + 30 * 60000);
            arrivalInput.min = minArrival.toISOString().slice(0, 16);
            
            // Clear arrival time if it's before new minimum
            if (arrivalInput.value && new Date(arrivalInput.value) <= departureTime) {
                arrivalInput.value = '';
            }
        });

        // Prevent same origin/destination selection
        document.getElementById('origin_airport_id').addEventListener('change', function() {
            const originId = this.value;
            const destinationSelect = document.getElementById('destination_airport_id');
            
            Array.from(destinationSelect.options).forEach(option => {
                option.disabled = option.value === originId;
            });
        });

        document.getElementById('destination_airport_id').addEventListener('change', function() {
            const destinationId = this.value;
            const originSelect = document.getElementById('origin_airport_id');
            
            Array.from(originSelect.options).forEach(option => {
                option.disabled = option.value === destinationId;
            });
        });
    </script>
    @endpush
@endsection
