<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content ">
            <div class="panel-header bg-{{ $gradient }}-gradient">
                <div class="py-5 page-inner">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div>
                            <h2 class="pb-2 text-white fw-bold">Add New Flight</h2>
                            <h5 class="mb-2 text-white op-7">Create a new flight schedule</h5>
                        </div>
                        <div class="py-2 ml-md-auto py-md-0">
                            <a href="{{ route('admin.flights.index') }}" class="btn btn-secondary btn-border">
                                <i class="fas fa-arrow-left"></i> Back to Flights
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="page-inner mt--5">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                
                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Validation Error!</strong> Please check the form for errors.
                        <ul class="mb-0 mt-2">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
            </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-plane"></i> Flight Details
                                </h4>
                            </div>
                            <div class="card-body">
                                <form method="POST" action="{{ route('admin.flights.store') }}" enctype="multipart/form-data">
                                    @csrf
                                    
                                    <!-- Flight Information -->
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="airline">Airline <span class="text-danger">*</span></label>
                                                <input type="text" 
                                                       id="airline"
                                                       name="airline" 
                                                       class="form-control @error('airline') is-invalid @enderror" 
                                                       value="{{ old('airline') }}" 
                                                       placeholder="e.g., American Airlines"
                                                       required>
                                                @error('airline')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="airline_logo">Airline Logo (Optional)</label>
                                                <input type="file" 
                                                       id="airline_logo"
                                                       name="airline_logo" 
                                                       class="form-control @error('airline_logo') is-invalid @enderror" 
                                                       accept="image/*">
                                                <small class="form-text text-muted">Upload airline logo (JPG, PNG, GIF, SVG). Max size: 2MB. If not provided, a default icon will be used.</small>
                                                @error('airline_logo')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="flight_number">Flight Number <span class="text-danger">*</span></label>
                                                <input type="text" 
                                                       id="flight_number"
                                                       name="flight_number" 
                                                       class="form-control @error('flight_number') is-invalid @enderror" 
                                                       value="{{ old('flight_number') }}" 
                                                       placeholder="e.g., AA1234"
                                                       required>
                                                @error('flight_number')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Route Information -->
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="origin_airport_id">Origin Airport <span class="text-danger">*</span></label>
                                                <select name="origin_airport_id" 
                                                        id="origin_airport_id"
                                                        class="form-control @error('origin_airport_id') is-invalid @enderror" 
                                                        required>
                                                    <option value="">Select Origin Airport</option>
                                                    @foreach($airports as $airport)
                                                        <option value="{{ $airport->id }}" {{ old('origin_airport_id') == $airport->id ? 'selected' : '' }}>
                                                            {{ $airport->iata_code }} - {{ $airport->name }} ({{ $airport->city }})
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('origin_airport_id')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="destination_airport_id">Destination Airport <span class="text-danger">*</span></label>
                                                <select name="destination_airport_id" 
                                                        id="destination_airport_id"
                                                        class="form-control @error('destination_airport_id') is-invalid @enderror" 
                                                        required>
                                                    <option value="">Select Destination Airport</option>
                                                    @foreach($airports as $airport)
                                                        <option value="{{ $airport->id }}" {{ old('destination_airport_id') == $airport->id ? 'selected' : '' }}>
                                                            {{ $airport->iata_code }} - {{ $airport->name }} ({{ $airport->city }})
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('destination_airport_id')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Schedule Information -->
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="departure_time">Departure Time <span class="text-danger">*</span></label>
                                                <input type="time" 
                                                       id="departure_time"
                                                       name="departure_time" 
                                                       class="form-control @error('departure_time') is-invalid @enderror" 
                                                       value="{{ old('departure_time', '09:00') }}" 
                                                       required>
                                                <small class="form-text text-muted">Time of departure (e.g., 09:00 AM)</small>
                                                @error('departure_time')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="arrival_time">Arrival Time <span class="text-danger">*</span></label>
                                                <input type="time" 
                                                       id="arrival_time"
                                                       name="arrival_time" 
                                                       class="form-control @error('arrival_time') is-invalid @enderror" 
                                                       value="{{ old('arrival_time', '11:00') }}" 
                                                       required>
                                                <small class="form-text text-muted">Time of arrival (e.g., 11:00 AM)</small>
                                                @error('arrival_time')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Flight Schedule Generation -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="card bg-light mb-3">
                                                <div class="card-body">
                                                    <h5 class="card-title"><i class="fas fa-calendar-alt"></i> Flight Schedule Generation</h5>
                                                    <p class="text-muted">Generate multiple flight instances for different dates</p>
                                                    
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label for="start_date">Start Date <span class="text-danger">*</span></label>
                                                                <input type="date" 
                                                                       id="start_date"
                                                                       name="start_date" 
                                                                       class="form-control @error('start_date') is-invalid @enderror" 
                                                                       value="{{ old('start_date', date('Y-m-d')) }}" 
                                                                       min="{{ date('Y-m-d') }}"
                                                                       required>
                                                                @error('start_date')
                                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label for="end_date">End Date <span class="text-danger">*</span></label>
                                                                <input type="date" 
                                                                       id="end_date"
                                                                       name="end_date" 
                                                                       class="form-control @error('end_date') is-invalid @enderror" 
                                                                       value="{{ old('end_date', date('Y-m-d', strtotime('+30 days'))) }}" 
                                                                       min="{{ date('Y-m-d') }}"
                                                                       required>
                                                                @error('end_date')
                                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label for="frequency">Frequency <span class="text-danger">*</span></label>
                                                                <select name="frequency" 
                                                                        id="frequency"
                                                                        class="form-control @error('frequency') is-invalid @enderror" 
                                                                        required>
                                                                    <option value="daily" {{ old('frequency', 'daily') == 'daily' ? 'selected' : '' }}>Daily</option>
                                                                    <option value="every_other_day" {{ old('frequency') == 'every_other_day' ? 'selected' : '' }}>Every Other Day</option>
                                                                    <option value="weekdays" {{ old('frequency') == 'weekdays' ? 'selected' : '' }}>Weekdays Only (Mon-Fri)</option>
                                                                    <option value="weekends" {{ old('frequency') == 'weekends' ? 'selected' : '' }}>Weekends Only (Sat-Sun)</option>
                                                                    <option value="weekly" {{ old('frequency') == 'weekly' ? 'selected' : '' }}>Weekly (Same Day)</option>
                                                                </select>
                                                                @error('frequency')
                                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="alert alert-info mb-0">
                                                        <i class="fas fa-info-circle"></i>
                                                        <strong>Note:</strong> This will create multiple flight instances with the same flight details but different dates, 
                                                        making them available for booking on various days.
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Terminal & Gate -->
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="terminal">Terminal</label>
                                                <input type="text" 
                                                       id="terminal"
                                                       name="terminal" 
                                                       class="form-control @error('terminal') is-invalid @enderror" 
                                                       value="{{ old('terminal') }}" 
                                                       placeholder="e.g., 1, A, B">
                                                @error('terminal')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="gate">Gate</label>
                                                <input type="text" 
                                                       id="gate"
                                                       name="gate" 
                                                       class="form-control @error('gate') is-invalid @enderror" 
                                                       value="{{ old('gate') }}" 
                                                       placeholder="e.g., A12, B5">
                                                @error('gate')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="aircraft_type">Aircraft Type</label>
                                                <input type="text" 
                                                       id="aircraft_type"
                                                       name="aircraft_type" 
                                                       class="form-control @error('aircraft_type') is-invalid @enderror" 
                                                       value="{{ old('aircraft_type') }}" 
                                                       placeholder="e.g., Boeing 737-800">
                                                @error('aircraft_type')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Capacity & Pricing -->
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="seats_total">Total Seats <span class="text-danger">*</span></label>
                                                <input type="number" 
                                                       id="seats_total"
                                                       name="seats_total" 
                                                       class="form-control @error('seats_total') is-invalid @enderror" 
                                                       value="{{ old('seats_total') }}" 
                                                       min="1" 
                                                       max="1000"
                                                       required>
                                                @error('seats_total')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="price">Base Price <span class="text-danger">*</span></label>
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text">$</span>
                                                    </div>
                                                    <input type="number" 
                                                           id="price"
                                                           name="price" 
                                                           class="form-control @error('price') is-invalid @enderror" 
                                                           value="{{ old('price') }}" 
                                                           min="0" 
                                                           step="0.01"
                                                           required>
                                                </div>
                                                @error('price')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Submit Buttons -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-primary">
                                                    <i class="fas fa-save"></i> Create Flight
                                                </button>
                                                <a href="{{ route('admin.flights.index') }}" class="btn btn-secondary ml-2">
                                                    <i class="fas fa-times"></i> Cancel
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        // Validate departure/arrival time
        document.getElementById('departure_time').addEventListener('change', function() {
            const departureTime = this.value;
            const arrivalInput = document.getElementById('arrival_time');
            
            // Clear arrival time if it's before departure time
            if (arrivalInput.value && arrivalInput.value <= departureTime) {
                alert('Arrival time must be after departure time');
            }
        });
        
        // Validate date range
        document.getElementById('start_date').addEventListener('change', function() {
            const startDate = this.value;
            const endDateInput = document.getElementById('end_date');
            
            // Set minimum end date to start date
            endDateInput.min = startDate;
            
            // Clear end date if it's before new start date
            if (endDateInput.value && endDateInput.value < startDate) {
                endDateInput.value = '';
            }
        });

        // Prevent same origin/destination selection
        document.getElementById('origin_airport_id').addEventListener('change', function() {
            const originId = this.value;
            const destinationSelect = document.getElementById('destination_airport_id');
            
            Array.from(destinationSelect.options).forEach(option => {
                option.disabled = option.value === originId;
            });
        });

        document.getElementById('destination_airport_id').addEventListener('change', function() {
            const destinationId = this.value;
            const originSelect = document.getElementById('origin_airport_id');
            
            Array.from(originSelect.options).forEach(option => {
                option.disabled = option.value === destinationId;
            });
        });
    </script>
    @endpush
@endsection