<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')

    <div class="main-panel">
        <div class="content">
            <div class="panel-header bg-{{ $gradient }}-gradient">
                <div class="py-5 page-inner">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div>
                            <h2 class="pb-2 text-white fw-bold">Pending Payment Approvals</h2>
                            <h5 class="mb-2 text-white op-7">Review and approve manual payment submissions</h5>
                        </div>
                        <div class="py-2 ml-md-auto py-md-0">
                            <a href="{{ route('admin.bookings.index') }}" class="btn btn-secondary btn-border">
                                <i class="fas fa-arrow-left"></i> All Bookings
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            @if(session('success'))
                <div class="page-inner mt--5">
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="page-inner mt--5">
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
            @endif

            <div class="page-inner mt--5">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-clock"></i> Pending Payments
                                    <span class="badge badge-warning">{{ $bookings->total() }}</span>
                                </h4>
                            </div>
                            <div class="card-body">
                                @if($bookings->count() > 0)
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Booking Ref</th>
                                                    <th>Passenger</th>
                                                    <th>Flight Details</th>
                                                    <th>Amount</th>
                                                    <th>Payment Method</th>
                                                    <th>Payment Proof</th>
                                                    <th>Submitted</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($bookings as $booking)
                                                    <tr>
                                                        <td>
                                                            <strong>{{ $booking->booking_reference }}</strong>
                                                        </td>
                                                        <td>
                                                            <strong>{{ $booking->passenger_name }}</strong><br>
                                                            <small class="text-muted">{{ $booking->passenger_email }}</small><br>
                                                            <small class="text-muted">{{ $booking->passenger_phone }}</small>
                                                        </td>
                                                        <td>
                                                            <strong>{{ $booking->flight->airline }} {{ $booking->flight->flight_number }}</strong><br>
                                                            <small>{{ $booking->flight->originAirport->iata_code }} → {{ $booking->flight->destinationAirport->iata_code }}</small><br>
                                                            <small class="text-muted">{{ $booking->flight->departure_time->format('M d, Y H:i') }}</small>
                                                        </td>
                                                        <td>
                                                            <strong class="text-success"{{{ $settings->currency }}}}</strong>
                                                        </td>
                                                        <td>
                                                            @if($booking->paymentMethod)
                                                                <span class="badge badge-info">{{ $booking->paymentMethod->name }}</span>
                                                            @else
                                                                <span class="badge badge-secondary">N/A</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            @if($booking->payment_proof)
                                                                <a href="{{ asset('storage/app/public/' . $booking->payment_proof) }}" 
                                                                   target="_blank" 
                                                                   class="btn btn-sm btn-primary">
                                                                    <i class="fas fa-file-image"></i> View Proof
                                                                </a>
                                                            @else
                                                                <span class="text-muted">No proof uploaded</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <small>{{ $booking->created_at->diffForHumans() }}</small><br>
                                                            <small class="text-muted">{{ $booking->created_at->format('M d, H:i') }}</small>
                                                        </td>
                                                        <td>
                                                            <div class="btn-group-vertical">
                                                                <button type="button" 
                                                                        class="mb-1 btn btn-sm btn-success" 
                                                                        data-toggle="modal" 
                                                                        data-target="#approveModal{{ $booking->id }}">
                                                                    <i class="fas fa-check"></i> Approve
                                                                </button>
                                                                <button type="button" 
                                                                        class="mb-1 btn btn-sm btn-danger" 
                                                                        data-toggle="modal" 
                                                                        data-target="#rejectModal{{ $booking->id }}">
                                                                    <i class="fas fa-times"></i> Reject
                                                                </button>
                                                                <a href="{{ route('admin.bookings.show', $booking) }}" 
                                                                   class="btn btn-sm btn-info">
                                                                    <i class="fas fa-eye"></i> Details
                                                                </a>
                                                            </div>

                                                            <!-- Approve Modal -->
                                                            <div class="modal fade" id="approveModal{{ $booking->id }}" tabindex="-1" role="dialog">
                                                                <div class="modal-dialog" role="document">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h5 class="modal-title">Approve Payment</h5>
                                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                <span aria-hidden="true">&times;</span>
                                                                            </button>
                                                                        </div>
                                                                        <form method="POST" action="{{ route('admin.bookings.approve-payment', $booking) }}">
                                                                            @csrf
                                                                            <div class="modal-body">
                                                                                <p>Are you sure you want to approve this payment?</p>
                                                                                <div class="alert alert-info">
                                                                                    <strong>Booking:</strong> {{ $booking->booking_reference }}<br>
                                                                                    <strong>Passenger:</strong> {{ $booking->passenger_name }}<br>
                                                                                    <strong>Amount:</strong> ${{ number_format($booking->price_paid, 2) }}<br>
                                                                                    <strong>Flight:</strong> {{ $booking->flight->flight_number }}
                                                                                </div>
                                                                                <p class="text-success">
                                                                                    <i class="fas fa-check-circle"></i> The booking will be confirmed and a confirmation email will be sent to the passenger.
                                                                                </p>
                                                                            </div>
                                                                            <div class="modal-footer">
                                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                                                <button type="submit" class="btn btn-success">
                                                                                    <i class="fas fa-check"></i> Approve Payment
                                                                                </button>
                                                                            </div>
                                                                        </form>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <!-- Reject Modal -->
                                                            <div class="modal fade" id="rejectModal{{ $booking->id }}" tabindex="-1" role="dialog">
                                                                <div class="modal-dialog" role="document">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h5 class="modal-title">Reject Payment</h5>
                                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                <span aria-hidden="true">&times;</span>
                                                                            </button>
                                                                        </div>
                                                                        <form method="POST" action="{{ route('admin.bookings.reject-payment', $booking) }}">
                                                                            @csrf
                                                                            <div class="modal-body">
                                                                                <p>Please provide a reason for rejecting this payment:</p>
                                                                                <div class="alert alert-warning">
                                                                                    <strong>Booking:</strong> {{ $booking->booking_reference }}<br>
                                                                                    <strong>Passenger:</strong> {{ $booking->passenger_name }}<br>
                                                                                    <strong>Amount:</strong>{{{ $settings->currency }}}{{ number_format($booking->price_paid, 2) }}
                                                                                </div>
                                                                                <div class="form-group">
                                                                                    <label for="rejection_reason{{ $booking->id }}">Rejection Reason <span class="text-danger">*</span></label>
                                                                                    <textarea class="form-control" 
                                                                                              id="rejection_reason{{ $booking->id }}" 
                                                                                              name="rejection_reason" 
                                                                                              rows="4" 
                                                                                              placeholder="e.g., Payment proof is unclear, Amount doesn't match, Invalid payment method..."
                                                                                              required></textarea>
                                                                                </div>
                                                                                <p class="text-danger">
                                                                                    <i class="fas fa-exclamation-triangle"></i> The passenger will be notified with this reason.
                                                                                </p>
                                                                            </div>
                                                                            <div class="modal-footer">
                                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                                                <button type="submit" class="btn btn-danger">
                                                                                    <i class="fas fa-times"></i> Reject Payment
                                                                                </button>
                                                                            </div>
                                                                        </form>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                    <!-- Pagination -->
                                    <div class="mt-3 d-flex justify-content-center">
                                        {{ $bookings->links() }}
                                    </div>
                                @else
                                    <div class="py-5 text-center">
                                        <i class="fas fa-check-circle fa-3x text-success mb-3"></i>
                                        <h4>No Pending Payments</h4>
                                        <p class="text-muted">All payments have been processed. Great job!</p>
                                        <a href="{{ route('admin.bookings.index') }}" class="btn btn-primary">
                                            <i class="fas fa-list"></i> View All Bookings
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
