@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')

    <div class="main-panel">
        <div class="content bg-light">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1 text-dark"><i class="fas fa-ticket-alt"></i> Flight Bookings</h1>
                </div>

                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                <!-- Statistics Cards -->
                <div class="row mb-4">
                    <div class="col-md-3">
                        <div class="card card-stats card-primary">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-5">
                                        <div class="icon-big text-center">
                                            <i class="fas fa-ticket-alt"></i>
                                        </div>
                                    </div>
                                    <div class="col-7 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Total Bookings</p>
                                            <h4 class="card-title">{{ $stats['total'] }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="card card-stats card-warning">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-5">
                                        <div class="icon-big text-center">
                                            <i class="fas fa-clock"></i>
                                        </div>
                                    </div>
                                    <div class="col-7 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Pending</p>
                                            <h4 class="card-title">{{ $stats['pending'] }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="card card-stats card-success">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-5">
                                        <div class="icon-big text-center">
                                            <i class="fas fa-check-circle"></i>
                                        </div>
                                    </div>
                                    <div class="col-7 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Confirmed</p>
                                            <h4 class="card-title">{{ $stats['paid'] }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                        <div class="card card-stats card-info">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-5">
                                        <div class="icon-big text-center">
                                            <i class="fas fa-dollar-sign"></i>
                                        </div>
                                    </div>
                                    <div class="col-7 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Total Revenue</p>
                                            <h4 class="card-title">${{ number_format($stats['revenue'], 2) }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Filters -->
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Filter Bookings</h4>
                    </div>
                    <div class="card-body">
                        <form method="GET" action="{{ route('admin.bookings.index') }}">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Payment Status</label>
                                        <select name="payment_status" class="form-control">
                                            <option value="">All Payments</option>
                                            <option value="pending" {{ request('payment_status') === 'pending' ? 'selected' : '' }}>Pending</option>
                                            <option value="paid" {{ request('payment_status') === 'paid' ? 'selected' : '' }}>Paid</option>
                                            <option value="failed" {{ request('payment_status') === 'failed' ? 'selected' : '' }}>Failed</option>
                                            <option value="refunded" {{ request('payment_status') === 'refunded' ? 'selected' : '' }}>Refunded</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Booking Status</label>
                                        <select name="status" class="form-control">
                                            <option value="">All Statuses</option>
                                            <option value="confirmed" {{ request('status') === 'confirmed' ? 'selected' : '' }}>Confirmed</option>
                                            <option value="cancelled" {{ request('status') === 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                            <option value="checked_in" {{ request('status') === 'checked_in' ? 'selected' : '' }}>Checked In</option>
                                            <option value="completed" {{ request('status') === 'completed' ? 'selected' : '' }}>Completed</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Date From</label>
                                        <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Date To</label>
                                        <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Search</label>
                                        <input type="text" name="search" class="form-control" placeholder="Booking reference, passenger name, or email..." value="{{ request('search') }}">
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <div>
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-search"></i> Filter
                                            </button>
                                            <a href="{{ route('admin.bookings.index') }}" class="btn btn-secondary">
                                                <i class="fas fa-times"></i> Clear
                                            </a>
                                            <a href="{{ route('admin.bookings.export') }}{{ request()->getQueryString() ? '?' . request()->getQueryString() : '' }}" class="btn btn-success">
                                                <i class="fas fa-file-excel"></i> Export CSV
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Bookings Table -->
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">All Flight Bookings</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Booking Ref</th>
                                        <th>Passenger</th>
                                        <th>Flight</th>
                                        <th>Route</th>
                                        <th>Date</th>
                                        <th>Price</th>
                                        <th>Payment</th>
                                        <th>Status</th>
                                        <th>Booked</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($bookings as $booking)
                                        <tr>
                                            <td>
                                                <strong>{{ $booking->booking_reference }}</strong>
                                            </td>
                                            <td>
                                                {{ $booking->passenger_name }}<br>
                                                <small class="text-muted">{{ $booking->passenger_email }}</small>
                                            </td>
                                            <td>
                                                <strong>{{ $booking->flight->airline }}</strong><br>
                                                <small>{{ $booking->flight->flight_number }}</small>
                                            </td>
                                            <td>
                                                {{ $booking->flight->originAirport->iata_code }} → {{ $booking->flight->destinationAirport->iata_code }}
                                            </td>
                                            <td>{{ $booking->flight->departure_time->format('M d, Y') }}</td>
                                            <td>${{ number_format($booking->price_paid, 2) }}</td>
                                            <td>
                                                @if($booking->payment_status === 'pending')
                                                    <span class="badge badge-warning">Pending</span>
                                                @elseif($booking->payment_status === 'paid')
                                                    <span class="badge badge-success">Paid</span>
                                                @elseif($booking->payment_status === 'failed')
                                                    <span class="badge badge-danger">Failed</span>
                                                @elseif($booking->payment_status === 'refunded')
                                                    <span class="badge badge-info">Refunded</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($booking->status === 'confirmed')
                                                    <span class="badge badge-success">Confirmed</span>
                                                @elseif($booking->status === 'cancelled')
                                                    <span class="badge badge-danger">Cancelled</span>
                                                @elseif($booking->status === 'checked_in')
                                                    <span class="badge badge-primary">Checked In</span>
                                                @elseif($booking->status === 'completed')
                                                    <span class="badge badge-secondary">Completed</span>
                                                @endif
                                            </td>
                                            <td>{{ $booking->created_at->format('M d, H:i') }}</td>
                                            <td>
                                                <a href="{{ route('admin.bookings.show', $booking) }}" class="btn btn-sm btn-info" title="View Details">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($booking->status !== 'cancelled')
                                                    <form action="{{ route('admin.bookings.cancel', $booking) }}" method="POST" style="display:inline;">
                                                        @csrf
                                                        <button type="submit" class="btn btn-sm btn-danger" 
                                                                onclick="return confirm('Are you sure you want to cancel this booking?')" 
                                                                title="Cancel Booking">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="10" class="text-center">No bookings found</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="mt-3">
                            {{ $bookings->appends(request()->query())->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>

       
    </div>
@endsection
