<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content ">
            <div class="panel-header bg-{{ $gradient }}-gradient">
                <div class="py-5 page-inner">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div>
                            <h2 class="pb-2 text-white fw-bold">{{ $airport->name }}</h2>
                            <h5 class="mb-2 text-white op-7">{{ $airport->city }}, {{ $airport->country }}</h5>
                        </div>
                        <div class="py-2 ml-md-auto py-md-0">
                            <a href="{{ route('admin.airports.edit', $airport) }}" class="mr-2 btn btn-warning btn-border">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                            <a href="{{ route('admin.airports.index') }}" class="btn btn-secondary btn-border">
                                <i class="fas fa-arrow-left"></i> Back to Airports
                            </a>
                        </div>
                    </div>
                </div>
            </div>
           <div class="page-inner mt--5">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                
                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Validation Error!</strong> Please check the form for errors.
                        <ul class="mb-0 mt-2">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
            </div>
            
            <div class="page-inner mt--5">
                <div class="row">
                    <div class="col-md-8">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-info-circle"></i> Airport Details
                                </h4>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tbody>
                                        <tr>
                                            <th width="200">IATA Code</th>
                                            <td><strong class="badge badge-primary">{{ $airport->iata_code }}</strong></td>
                                        </tr>
                                        @if($airport->icao_code)
                                            <tr>
                                                <th>ICAO Code</th>
                                                <td><strong class="badge badge-info">{{ $airport->icao_code }}</strong></td>
                                            </tr>
                                        @endif
                                        <tr>
                                            <th>Airport Name</th>
                                            <td>{{ $airport->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>City</th>
                                            <td>{{ $airport->city }}</td>
                                        </tr>
                                        <tr>
                                            <th>Country</th>
                                            <td>{{ $airport->country }}</td>
                                        </tr>
                                        <tr>
                                            <th>Timezone</th>
                                            <td>{{ $airport->timezone }}</td>
                                        </tr>
                                        @if($airport->latitude && $airport->longitude)
                                            <tr>
                                                <th>Coordinates</th>
                                                <td>
                                                    {{ $airport->latitude }}, {{ $airport->longitude }}
                                                    <a href="https://www.google.com/maps?q={{ $airport->latitude }},{{ $airport->longitude }}" 
                                                       target="_blank" 
                                                       class="ml-2 btn btn-sm btn-outline-primary">
                                                        <i class="fas fa-map-marker-alt"></i> View on Map
                                                    </a>
                                                </td>
                                            </tr>
                                        @endif
                                        <tr>
                                            <th>Status</th>
                                            <td>
                                                <span class="badge badge-{{ $airport->active ? 'success' : 'secondary' }} badge-lg">
                                                    {{ $airport->active ? 'Active' : 'Inactive' }}
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Created At</th>
                                            <td>{{ $airport->created_at->format('M d, Y H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>Last Updated</th>
                                            <td>{{ $airport->updated_at->format('M d, Y H:i') }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-chart-pie"></i> Statistics
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="mb-4">
                                    <h5 class="text-center mb-3">Departing Flights</h5>
                                    <h2 class="text-center text-primary">{{ $airport->originFlights->count() }}</h2>
                                </div>
                                <hr>
                                <div class="mb-4">
                                    <h5 class="text-center mb-3">Arriving Flights</h5>
                                    <h2 class="text-center text-success">{{ $airport->destinationFlights->count() }}</h2>
                                </div>
                                <hr>
                                <div>
                                    <h5 class="text-center mb-3">Total Flights</h5>
                                    <h2 class="text-center text-info">{{ $airport->originFlights->count() + $airport->destinationFlights->count() }}</h2>
                                </div>
                            </div>
                        </div>

                        <div class="mt-3 card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-cog"></i> Actions
                                </h4>
                            </div>
                            <div class="card-body">
                                <a href="{{ route('admin.airports.edit', $airport) }}" class="mb-2 btn btn-warning btn-block">
                                    <i class="fas fa-edit"></i> Edit Airport
                                </a>
                                <a href="{{ route('admin.flights.index') }}?origin={{ $airport->iata_code }}" class="mb-2 btn btn-info btn-block">
                                    <i class="fas fa-plane-departure"></i> View Departing Flights
                                </a>
                                <a href="{{ route('admin.flights.index') }}?destination={{ $airport->iata_code }}" class="mb-2 btn btn-success btn-block">
                                    <i class="fas fa-plane-arrival"></i> View Arriving Flights
                                </a>
                                <form method="POST" action="{{ route('admin.airports.destroy', $airport) }}" onsubmit="return confirm('Are you sure you want to delete this airport? This action cannot be undone.')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-block" {{ ($airport->originFlights->count() > 0 || $airport->destinationFlights->count() > 0) ? 'disabled' : '' }}>
                                        <i class="fas fa-trash"></i> Delete Airport
                                    </button>
                                </form>
                                @if($airport->originFlights->count() > 0 || $airport->destinationFlights->count() > 0)
                                    <small class="mt-2 text-danger d-block">
                                        <i class="fas fa-exclamation-triangle"></i> Cannot delete airport with associated flights
                                    </small>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                @if($airport->originFlights->count() > 0 || $airport->destinationFlights->count() > 0)
                    <div class="mt-3 row">
                        <div class="col-md-12">
                            <div class="card shadow-lg">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-plane"></i> Associated Flights
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <ul class="nav nav-pills nav-secondary nav-pills-no-bd" role="tablist">
                                        <li class="nav-item">
                                            <a class="nav-link active show" data-toggle="pill" href="#departing" role="tab">
                                                <i class="fas fa-plane-departure"></i> Departing ({{ $airport->originFlights->count() }})
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-toggle="pill" href="#arriving" role="tab">
                                                <i class="fas fa-plane-arrival"></i> Arriving ({{ $airport->destinationFlights->count() }})
                                            </a>
                                        </li>
                                    </ul>
                                    <div class="mt-3 tab-content">
                                        <div class="tab-pane fade show active" id="departing" role="tabpanel">
                                            @if($airport->originFlights->count() > 0)
                                                <div class="table-responsive">
                                                    <table class="table table-hover">
                                                        <thead>
                                                            <tr>
                                                                <th>Flight Number</th>
                                                                <th>Destination</th>
                                                                <th>Departure</th>
                                                                <th>Price</th>
                                                                <th>Status</th>
                                                                <th>Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @foreach($airport->originFlights->take(10) as $flight)
                                                                <tr>
                                                                    <td><strong>{{ $flight->flight_number }}</strong></td>
                                                                    <td>{{ $flight->destinationAirport->name }} ({{ $flight->destinationAirport->iata_code }})</td>
                                                                    <td>{{ \Carbon\Carbon::parse($flight->departure_time)->format('M d, Y H:i') }}</td>
                                                                    <td>${{ number_format($flight->base_price, 2) }}</td>
                                                                    <td>
                                                                        <span class="badge badge-{{ $flight->status == 'scheduled' ? 'success' : ($flight->status == 'cancelled' ? 'danger' : 'warning') }}">
                                                                            {{ ucfirst($flight->status) }}
                                                                        </span>
                                                                    </td>
                                                                    <td>
                                                                        <a href="{{ route('admin.flights.show', $flight) }}" class="btn btn-sm btn-info">
                                                                            <i class="fas fa-eye"></i>
                                                                        </a>
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                                @if($airport->originFlights->count() > 10)
                                                    <div class="text-center">
                                                        <a href="{{ route('admin.flights.index') }}?origin={{ $airport->iata_code }}" class="btn btn-primary">
                                                            View All {{ $airport->originFlights->count() }} Departing Flights
                                                        </a>
                                                    </div>
                                                @endif
                                            @else
                                                <div class="py-3 text-center">
                                                    <p class="text-muted">No departing flights</p>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="tab-pane fade" id="arriving" role="tabpanel">
                                            @if($airport->destinationFlights->count() > 0)
                                                <div class="table-responsive">
                                                    <table class="table table-hover">
                                                        <thead>
                                                            <tr>
                                                                <th>Flight Number</th>
                                                                <th>Origin</th>
                                                                <th>Arrival</th>
                                                                <th>Price</th>
                                                                <th>Status</th>
                                                                <th>Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @foreach($airport->destinationFlights->take(10) as $flight)
                                                                <tr>
                                                                    <td><strong>{{ $flight->flight_number }}</strong></td>
                                                                    <td>{{ $flight->originAirport->name }} ({{ $flight->originAirport->iata_code }})</td>
                                                                    <td>{{ \Carbon\Carbon::parse($flight->arrival_time)->format('M d, Y H:i') }}</td>
                                                                    <td>${{ number_format($flight->base_price, 2) }}</td>
                                                                    <td>
                                                                        <span class="badge badge-{{ $flight->status == 'scheduled' ? 'success' : ($flight->status == 'cancelled' ? 'danger' : 'warning') }}">
                                                                            {{ ucfirst($flight->status) }}
                                                                        </span>
                                                                    </td>
                                                                    <td>
                                                                        <a href="{{ route('admin.flights.show', $flight) }}" class="btn btn-sm btn-info">
                                                                            <i class="fas fa-eye"></i>
                                                                        </a>
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                                @if($airport->destinationFlights->count() > 10)
                                                    <div class="text-center">
                                                        <a href="{{ route('admin.flights.index') }}?destination={{ $airport->iata_code }}" class="btn btn-primary">
                                                            View All {{ $airport->destinationFlights->count() }} Arriving Flights
                                                        </a>
                                                    </div>
                                                @endif
                                            @else
                                                <div class="py-3 text-center">
                                                    <p class="text-muted">No arriving flights</p>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection
