<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content ">
            <div class="panel-header bg-{{ $gradient }}-gradient">
                <div class="py-5 page-inner">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div>
                            <h2 class="pb-2 text-white fw-bold">Airports Management</h2>
                            <h5 class="mb-2 text-white op-7">Manage airport information</h5>
                        </div>
                        <div class="py-2 ml-md-auto py-md-0">
                            <a href="{{ route('admin.flights.index') }}" class="mr-2 btn btn-info btn-border">
                                <i class="fas fa-plane"></i> Flights
                            </a>
                            <a href="{{ route('admin.airports.create') }}" class="btn btn-success btn-border">
                                <i class="fas fa-plus"></i> Add Airport
                            </a>
                        </div>
                    </div>
                </div>
            </div>
             <div class="page-inner mt--5">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                
                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Validation Error!</strong> Please check the form for errors.
                        <ul class="mb-0 mt-2">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
            </div>
            
            <div class="page-inner mt--5">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-map-marker-alt"></i> Airports 
                                    <span class="badge badge-primary">{{ $airports->total() }}</span>
                                </h4>
                            </div>
                            <div class="card-body">
                                @if($airports->count() > 0)
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Code</th>
                                                    <th>Airport Name</th>
                                                    <th>Location</th>
                                                    <th>Timezone</th>
                                                    <th>Status</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($airports as $airport)
                                                    <tr>
                                                        <td>
                                                            <strong>{{ $airport->iata_code }}</strong>
                                                            @if($airport->icao_code)
                                                                <br><small class="text-muted">{{ $airport->icao_code }}</small>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <strong>{{ $airport->name }}</strong>
                                                        </td>
                                                        <td>
                                                            {{ $airport->city }}, {{ $airport->country }}
                                                            @if($airport->latitude && $airport->longitude)
                                                                <br><small class="text-muted">{{ $airport->latitude }}, {{ $airport->longitude }}</small>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <small>{{ $airport->timezone }}</small>
                                                        </td>
                                                        <td>
                                                            <span class="badge badge-{{ $airport->active ? 'success' : 'secondary' }}">
                                                                {{ $airport->active ? 'Active' : 'Inactive' }}
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <div class="btn-group">
                                                                <a href="{{ route('admin.airports.show', $airport) }}" class="btn btn-sm btn-info" title="View">
                                                                    <i class="fas fa-eye"></i>
                                                                </a>
                                                                <a href="{{ route('admin.airports.edit', $airport) }}" class="btn btn-sm btn-warning" title="Edit">
                                                                    <i class="fas fa-edit"></i>
                                                                </a>
                                                                <form method="POST" action="{{ route('admin.airports.destroy', $airport) }}" style="display: inline;" onsubmit="return confirm('Are you sure?')">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                                                        <i class="fas fa-trash"></i>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                    <!-- Pagination -->
                                    <div class="d-flex justify-content-center">
                                        {{ $airports->links() }}
                                    </div>
                                @else
                                    <div class="text-center py-5">
                                        <i class="fas fa-map-marker-alt fa-3x text-muted mb-3"></i>
                                        <h4>No airports found</h4>
                                        <p class="text-muted">Start by adding airport information.</p>
                                        <a href="{{ route('admin.airports.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Add Airport
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection