<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content ">
            <div class="panel-header bg-{{ $gradient }}-gradient">
                <div class="py-5 page-inner">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div>
                            <h2 class="pb-2 text-white fw-bold">Edit Airport</h2>
                            <h5 class="mb-2 text-white op-7">{{ $airport->name }} ({{ $airport->iata_code }})</h5>
                        </div>
                        <div class="py-2 ml-md-auto py-md-0">
                            <a href="{{ route('admin.airports.show', $airport) }}" class="mr-2 btn btn-info btn-border">
                                <i class="fas fa-eye"></i> View
                            </a>
                            <a href="{{ route('admin.airports.index') }}" class="btn btn-secondary btn-border">
                                <i class="fas fa-arrow-left"></i> Back to Airports
                            </a>
                        </div>
                    </div>
                </div>
            </div>
              <div class="page-inner mt--5">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                
                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Validation Error!</strong> Please check the form for errors.
                        <ul class="mb-0 mt-2">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
            </div>
            
            <div class="page-inner mt--5">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card shadow-lg">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-edit"></i> Update Airport Information
                                </h4>
                            </div>
                            <form method="POST" action="{{ route('admin.airports.update', $airport) }}">
                                @csrf
                                @method('PUT')
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="iata_code">IATA Code <span class="text-danger">*</span></label>
                                                <input type="text" 
                                                       class="form-control @error('iata_code') is-invalid @enderror" 
                                                       id="iata_code" 
                                                       name="iata_code" 
                                                       value="{{ old('iata_code', $airport->iata_code) }}"
                                                       placeholder="e.g., JFK"
                                                       maxlength="3"
                                                       style="text-transform: uppercase;"
                                                       required>
                                                <small class="form-text text-muted">3-letter airport code (e.g., JFK, LAX, LHR)</small>
                                                @error('iata_code')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="icao_code">ICAO Code</label>
                                                <input type="text" 
                                                       class="form-control @error('icao_code') is-invalid @enderror" 
                                                       id="icao_code" 
                                                       name="icao_code" 
                                                       value="{{ old('icao_code', $airport->icao_code) }}"
                                                       placeholder="e.g., KJFK"
                                                       maxlength="4"
                                                       style="text-transform: uppercase;">
                                                <small class="form-text text-muted">4-letter code (optional)</small>
                                                @error('icao_code')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for="name">Airport Name <span class="text-danger">*</span></label>
                                        <input type="text" 
                                               class="form-control @error('name') is-invalid @enderror" 
                                               id="name" 
                                               name="name" 
                                               value="{{ old('name', $airport->name) }}"
                                               placeholder="e.g., John F. Kennedy International Airport"
                                               required>
                                        @error('name')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="city">City <span class="text-danger">*</span></label>
                                                <input type="text" 
                                                       class="form-control @error('city') is-invalid @enderror" 
                                                       id="city" 
                                                       name="city" 
                                                       value="{{ old('city', $airport->city) }}"
                                                       placeholder="e.g., New York"
                                                       required>
                                                @error('city')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="country">Country <span class="text-danger">*</span></label>
                                                <input type="text" 
                                                       class="form-control @error('country') is-invalid @enderror" 
                                                       id="country" 
                                                       name="country" 
                                                       value="{{ old('country', $airport->country) }}"
                                                       placeholder="e.g., United States"
                                                       required>
                                                @error('country')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for="timezone">Timezone <span class="text-danger">*</span></label>
                                        <input type="text" 
                                               class="form-control @error('timezone') is-invalid @enderror" 
                                               id="timezone" 
                                               name="timezone" 
                                               value="{{ old('timezone', $airport->timezone) }}"
                                               placeholder="e.g., America/New_York"
                                               required>
                                        <small class="form-text text-muted">Use IANA timezone format (e.g., America/New_York, Europe/London)</small>
                                        @error('timezone')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="latitude">Latitude</label>
                                                <input type="number" 
                                                       class="form-control @error('latitude') is-invalid @enderror" 
                                                       id="latitude" 
                                                       name="latitude" 
                                                       value="{{ old('latitude', $airport->latitude) }}"
                                                       step="0.000001"
                                                       min="-90"
                                                       max="90"
                                                       placeholder="e.g., 40.6413">
                                                <small class="form-text text-muted">Between -90 and 90</small>
                                                @error('latitude')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="longitude">Longitude</label>
                                                <input type="number" 
                                                       class="form-control @error('longitude') is-invalid @enderror" 
                                                       id="longitude" 
                                                       name="longitude" 
                                                       value="{{ old('longitude', $airport->longitude) }}"
                                                       step="0.000001"
                                                       min="-180"
                                                       max="180"
                                                       placeholder="e.g., -73.7781">
                                                <small class="form-text text-muted">Between -180 and 180</small>
                                                @error('longitude')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" 
                                                   class="custom-control-input" 
                                                   id="active" 
                                                   name="active" 
                                                   value="1"
                                                   {{ old('active', $airport->active) ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="active">
                                                Active (Airport is available for booking)
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="card-footer text-right">
                                    <a href="{{ route('admin.airports.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-times"></i> Cancel
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save"></i> Update Airport
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
