<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
    $bg = 'light';
} else {
    $text = 'light';
    $bg = 'dark';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content ">
            <div class="page-inner">

                <!-- Alert Messages Section -->
                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fa fa-exclamation-triangle mr-2"></i>
                            <div>
                                <strong>Validation Error!</strong>
                                <ul class="mb-0 mt-2">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fa fa-check-circle mr-2"></i>
                            <div>
                                <strong>Success!</strong>
                                <p class="mb-0 mt-1">{{ session('success') }}</p>
                            </div>
                        </div>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fa fa-times-circle mr-2"></i>
                            <div>
                                <strong>Error!</strong>
                                <p class="mb-0 mt-1">{{ session('error') }}</p>
                            </div>
                        </div>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if (session('message'))
                    @php
                        $status = session('status', 'info');
                        $alertClass = [
                            'success' => 'alert-success',
                            'error' => 'alert-danger',
                            'warning' => 'alert-warning',
                            'info' => 'alert-info'
                        ][$status] ?? 'alert-info';

                        $iconClass = [
                            'success' => 'fa-check-circle',
                            'error' => 'fa-times-circle',
                            'warning' => 'fa-exclamation-triangle',
                            'info' => 'fa-info-circle'
                        ][$status] ?? 'fa-info-circle';
                    @endphp
                    <div class="alert {{ $alertClass }} alert-dismissible fade show" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fa {{ $iconClass }} mr-2"></i>
                            <div>
                                <strong>{{ ucfirst($status) }}!</strong>
                                <p class="mb-0 mt-1">{{ session('message') }}</p>
                            </div>
                        </div>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if (session('warning'))
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fa fa-exclamation-triangle mr-2"></i>
                            <div>
                                <strong>Warning!</strong>
                                <p class="mb-0 mt-1">{{ session('warning') }}</p>
                            </div>
                        </div>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if (session('info'))
                    <div class="alert alert-info alert-dismissible fade show" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fa fa-info-circle mr-2"></i>
                            <div>
                                <strong>Information!</strong>
                                <p class="mb-0 mt-1">{{ session('info') }}</p>
                            </div>
                        </div>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                <!-- Beginning of  Dashboard Stats  -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="p-3 card ">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-12 ">
                                        <h1 class="d-inline text-primary">{{ $user->name }}</h1><span></span>
                                        <div class="d-inline">
                                            <div class="float-right btn-group">
                                                <a class="btn btn-primary btn-sm" href="{{ route('manageusers') }}"> <i
                                                        class="fa fa-arrow-left"></i> back</a> &nbsp;
                                                <button type="button" class="btn btn-secondary dropdown-toggle btn-sm"
                                                    data-toggle="dropdown" data-display="static" aria-haspopup="true"
                                                    aria-expanded="false">
                                                    Actions
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-lg-right">
                                                    <a class="dropdown-item"
                                                        href="{{ route('loginactivity', $user->id) }}">Login Activity</a>
                                                    @if ($user->status == null || $user->status == 'blocked')
                                                        <a class="dropdown-item"
                                                            href="{{ url('admin/dashboard/uunblock') }}/{{ $user->id }}">Unblock</a>
                                                    @else
                                                        <a class="dropdown-item"
                                                            href="{{ url('admin/dashboard/uublock') }}/{{ $user->id }}">Block</a>
                                                    @endif
                                                    @if ($user->email_verified_at)
                                                    @else
                                                        <a href="{{ url('admin/dashboard/email-verify') }}/{{ $user->id }}"
                                                            class="dropdown-item">Verify Email</a>
                                                    @endif
                                                    <a href="#" data-toggle="modal" data-target="#topupModal"
                                                        class="dropdown-item">Credit/Debit</a>


                                                    <a href="#" data-toggle="modal" data-target="#resetpswdModal"
                                                        class="dropdown-item">Reset Password</a>
                                                    <a href="#" data-toggle="modal" data-target="#clearacctModal"
                                                        class="dropdown-item">Clear Account</a>
                                                    <a href="#" data-toggle="modal" data-target="#edituser"
                                                        class="dropdown-item">Edit</a>
                                                    <a href="{{ route('showusers', $user->id) }}" class="dropdown-item">Add
                                                        Referral</a>
                                                    <a href="#" data-toggle="modal"
                                                        data-target="#sendmailtooneuserModal" class="dropdown-item">Send
                                                        Email</a>
                                                    <a href="#" data-toggle="modal" data-target="#switchuserModal"
                                                        class="dropdown-item text-success">Login as {{ $user->name }}</a>
                                                    <a href="#" data-toggle="modal" data-target="#deleteModal"
                                                        class="dropdown-item text-danger">Delete {{ $user->name }}</a>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="p-3 mt-4 border rounded row ">
                                    {{-- <div class="col-md-3">
                                        <h5 class="text-bold">Account Balance</h5>
                                        <p>{{ $settings->currency }}{{ number_format($user->account_bal, 2, '.', ',') }}
                                        </p>
                                    </div> --}}
                                    <div class="col-md-3">
                                        <h5>Total Bookings</h5>
                                        <p class="text-primary font-weight-bold">{{ $stats['total'] }}</p>
                                    </div>
                                    <div class="col-md-3">
                                        <h5>Confirmed Bookings</h5>
                                        <p class="text-success font-weight-bold">{{ $stats['confirmed'] }}</p>
                                    </div>
                                    <div class="col-md-3">
                                        <h5>Pending Payment</h5>
                                        <p class="text-warning font-weight-bold">{{ $stats['pending'] }}</p>
                                    </div>
                                    <div class="col-md-3">
                                        <h5>Completed Trips</h5>
                                        <p class="text-info font-weight-bold">{{ $stats['completed'] }}</p>
                                    </div>
                                    <div class="col-md-3">
                                        <h5>Cancelled Bookings</h5>
                                        <p class="text-danger font-weight-bold">{{ $stats['cancelled'] }}</p>
                                    </div>
                                    <div class="col-md-3">
                                        <h5>Total Spent</h5>
                                        <p class="text-success font-weight-bold">{{ $settings->currency }}{{ number_format($stats['total_spent'], 2) }}</p>
                                    </div>
                                    <div class="col-md-3">
                                        <h5>User Account Status</h5>
                                        @if ($user->status == 'blocked')
                                            <span class="badge badge-danger">Blocked</span>
                                        @else
                                            <span class="badge badge-success">Active</span>
                                        @endif
                                    </div>
                                    <div class="col-md-3">
                                        <h5>Email Verified</h5>
                                        @if ($user->email_verified_at)
                                            <span class="badge badge-success">Verified</span>
                                        @else
                                            <span class="badge badge-danger">Not Verified</span>
                                        @endif
                                    </div>
                                    <div class="col-md-3">
                                        <h5>Join Date</h5>
                                        <p>{{ \Carbon\Carbon::parse($user->created_at)->format('M j, Y') }}</p>
                                    </div>
                                </div>
                                <div class="mt-3 row ">
                                    <div class="col-md-12">
                                        <h5>USER INFORMATION</h5>
                                    </div>
                                </div>
                                <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Fullname</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5>{{ $user->passenger_namee }}</h5>
                                    </div>
                                </div>
                                <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Email Address</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5>{{ $user->passenger_email }}</h5>
                                    </div>
                                </div>
                                <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Mobile Number</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5>{{ $user->passenger_phone }}</h5>
                                    </div>
                                </div>
                                <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Date of birth</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5>{{ $user->passenger_dob }}</h5>
                                    </div>
                                </div>
                                <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Nationality</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5>{{ $user->passenger_country }}</h5>
                                    </div>
                                </div>



                                 <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Passport Number</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5>{{ $user->passport_number }}</h5>
                                    </div>
                                </div>
                                {{-- <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Wallet Address</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5>
                                            @if ($user->wallet_address)
                                                {{ $user->wallet_address }}
                                            @else
                                                Not added yet!
                                            @endif
                                        </h5>
                                    </div>
                                </div> --}}
                                <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Registered</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5>{{ \Carbon\Carbon::parse($user->created_at)->toDayDateTimeString() }}</h5>
                                    </div>
                                </div>

                                <!-- User Flight Bookings Section -->
                                <div class="mt-4 row">
                                    <div class="col-md-12">
                                        <h5>{{ $user->name }}'S FLIGHT BOOKINGS</h5>
                                    </div>
                                </div>

                                @if($bookings->count() > 0)
                                <div class="table-responsive mt-3">
                                    <table class="table table-hover">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Booking Ref</th>
                                                <th>Flight Details</th>
                                                <th>Route</th>
                                                <th>Passenger</th>
                                                <th>Amount</th>
                                                <th>Payment</th>
                                                <th>Status</th>
                                                <th>Date</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($bookings as $booking)
                                                <tr>
                                                    <td>
                                                        <strong class="text-primary">{{ $booking->booking_reference }}</strong>
                                                        <br>
                                                        <small class="text-muted">#{{ $booking->id }}</small>
                                                    </td>
                                                    <td>
                                                        <strong>{{ $booking->flight->airline }}</strong>
                                                        <br>
                                                        <small class="text-muted">{{ $booking->flight->flight_number }}</small>
                                                        @if($booking->seat_number)
                                                        <br>
                                                        <small class="badge badge-info">Seat {{ $booking->seat_number }}</small>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <strong>{{ $booking->flight->originAirport->iata_code }}</strong>
                                                        <i class="fas fa-arrow-right text-muted mx-1"></i>
                                                        <strong>{{ $booking->flight->destinationAirport->iata_code }}</strong>
                                                        <br>
                                                        <small class="text-muted">
                                                            {{ $booking->flight->departure_time->format('M j, g:i A') }}
                                                        </small>
                                                    </td>
                                                    <td>
                                                        {{ $booking->passenger_name }}
                                                        <br>
                                                        <small class="text-muted">{{ $booking->passenger_email }}</small>
                                                    </td>
                                                    <td>
                                                        <strong>{{ $settings->currency }}{{ number_format($booking->price_paid, 2) }}</strong>
                                                    </td>
                                                    <td>
                                                        @if ($booking->payment_status == 'paid')
                                                            <span class="badge badge-success">
                                                                <i class="fas fa-check"></i> Paid
                                                            </span>
                                                        @elseif ($booking->payment_status == 'pending')
                                                            <span class="badge badge-warning">
                                                                <i class="fas fa-clock"></i> Pending
                                                            </span>
                                                        @elseif ($booking->payment_status == 'refunded')
                                                            <span class="badge badge-info">
                                                                <i class="fas fa-undo"></i> Refunded
                                                            </span>
                                                        @else
                                                            <span class="badge badge-danger">
                                                                <i class="fas fa-times"></i> Failed
                                                            </span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if ($booking->status == 'confirmed')
                                                            <span class="badge badge-success">
                                                                <i class="fas fa-check-circle"></i> Confirmed
                                                            </span>
                                                        @elseif ($booking->status == 'cancelled')
                                                            <span class="badge badge-danger">
                                                                <i class="fas fa-times-circle"></i> Cancelled
                                                            </span>
                                                        @elseif ($booking->status == 'checked_in')
                                                            <span class="badge badge-primary">
                                                                <i class="fas fa-plane"></i> Checked In
                                                            </span>
                                                        @else
                                                            <span class="badge badge-secondary">
                                                                <i class="fas fa-flag-checkered"></i> Completed
                                                            </span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        {{ \Carbon\Carbon::parse($booking->created_at)->format('M j, Y') }}
                                                        <br>
                                                        <small class="text-muted">{{ \Carbon\Carbon::parse($booking->created_at)->format('g:i A') }}</small>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group" role="group">
                                                            <a href="{{ route('admin.bookings.show', $booking->id) }}"
                                                               class="btn btn-info btn-sm" title="View Details">
                                                                <i class="fa fa-eye"></i>
                                                            </a>
                                                            @if($booking->payment_status === 'pending')
                                                            <form action="{{ route('admin.bookings.approve-payment', $booking->id) }}"
                                                                  method="POST" style="display: inline;">
                                                                @csrf
                                                                <button type="submit" class="btn btn-success btn-sm"
                                                                        title="Approve Payment"
                                                                        onclick="return confirm('Approve this booking payment?')">
                                                                    <i class="fa fa-check"></i>
                                                                </button>
                                                            </form>
                                                            @endif
                                                            @if($booking->status === 'confirmed' && $booking->payment_status === 'paid')
                                                            <form action="{{ route('admin.bookings.cancel', $booking->id) }}"
                                                                  method="POST" style="display: inline;">
                                                                @csrf
                                                                <button type="submit" class="btn btn-danger btn-sm"
                                                                        title="Cancel Booking"
                                                                        onclick="return confirm('Cancel this booking?')">
                                                                    <i class="fa fa-times"></i>
                                                                </button>
                                                            </form>
                                                            @endif
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @else
                                <div class="text-center py-5">
                                    <i class="fas fa-plane fa-3x text-muted mb-3"></i>
                                    <h5 class="text-muted">No Flight Bookings Found</h5>
                                    <p class="text-muted">{{ $user->name }} hasn't made any flight bookings yet.</p>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @include('admin.Users.users_actions')
    @endsection
